/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
     fl_ut.c
     file utilities
*/

#include <stdio.h>
#include <io.h>
#include "refs.h"
#include "l_menu.h"

#include <stdlib.h>
#include <string.h>
#include <conio.h>
#if defined(__EMX__)
  #include <sys/types.h>
  #include <dirent.h>
#endif
#if defined(__EMX__)
  #include <fnmatch.h>
#endif
#if defined(__DJGPP__)
  #include <dos.h>
  #include <dir.h>
  #include <dirent.h>
  #include <unistd.h>
#endif

#include "str_fun.h"
#include "fl_ut.h"
#include "abbruch.h"
#include "keycodes.h"

 FILE * dir_kat;
 char dir_kat_name[120] = "DIR_KAT.$$1";
 extern char fehlermeldung[250];
 extern config_set one_config_set;


int datei_suchen(const char * suchpfad, char * dateiname)
{
   int vor;
   vor = 0;
   return datei_suchen_default(suchpfad, dateiname, &vor);
}

int datei_suchen_default(const char * suchpfad, char * dateiname, int * vorgabe)
{

#if defined(__EMX__)
   DIR * dirp;
   struct dirent * direntp;
   char verzeichnis[PFAD_LEN+1];
   char muster[PFAD_LEN+1];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];
#endif
#if defined(__DJGPP__)
   struct find_t fi;
   char verzeichnis[PFAD_LEN+1];
   char muster[PFAD_LEN+1];
   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char fname[MAXFILE];
   char ext[MAXEXT];
#endif

   char zahl_st[30];
   char zeile[120];
   char outbu[250];

   int endpos,ok;
   long datei_kenn;
   long u_grenze, o_grenze;
   long lauf;
   long n_dateien;
   n_dateien = 0;
#if defined(__EMX__)
    dir_kat_schreiben();
    _splitpath(suchpfad,drive,dir,fname,ext);
    strcpy(verzeichnis,"");
    strcat(verzeichnis,drive);
    strcat(verzeichnis,dir);
    strcpy(muster,"");
    strcat(muster,fname);
    strcat(muster,ext);
    if (strlen(verzeichnis)==0)
    {
       getcwd(verzeichnis,PFAD_LEN);
    }

    dirp = opendir(verzeichnis);
    if (dirp!=NULL)
    {
       for(;;)
       {
          direntp = readdir(dirp);
          if (direntp==NULL) break;
          if ((direntp->d_attr & (A_HIDDEN|A_SYSTEM|A_LABEL|A_DIR))==0
             && (fnmatch(muster,direntp->d_name,
                 _FNM_IGNORECASE|_FNM_DOS)==0))
          {
             fprintf(dir_kat,"%s\n",direntp->d_name);
             n_dateien++;
          }
       }
    }
    dir_kat_schliessen();
    closedir(dirp);
#endif
#if defined(__DJGPP__)
    dir_kat_schreiben();
    fnsplit(suchpfad,drive,dir,fname,ext);
    strcpy(verzeichnis,"");
    strcat(verzeichnis,drive);
    strcat(verzeichnis,dir);
    strcpy(muster,"");
    strcat(muster,drive);
    strcat(muster,dir);
    strcat(muster,fname);
    strcat(muster,ext);
    if (strlen(verzeichnis)==0)
    {
       getcwd(verzeichnis,PFAD_LEN);
    }
    if ( !_dos_findfirst(muster,_A_NORMAL,&fi) )
    {
       do
       {
            fprintf(dir_kat,"%s\n",fi.name);
            n_dateien++;
       } while (!_dos_findnext(&fi));
    }
    dir_kat_schliessen();

#endif

   if (n_dateien==0)
   {
      strcpy(dateiname,"");
      sprintf(outbu,"No files [%s] found\n",suchpfad);
      wrtxt(outbu);
      remove(dir_kat_name);
      return 0;

   }
   if (n_dateien > 1 && n_dateien <= KAT_SORTIER_N)
   {
       dateikatalog_sortieren();
   }

   dir_kat_lesen();
   sprintf(outbu,"\n[%s] File selection\n",suchpfad);
   wrtxt(outbu);
   u_grenze=0;
   o_grenze=0;
   for(lauf=1;lauf<=n_dateien;lauf++)
   {
      if(fgets(zeile,120-1,dir_kat)==NULL)
      {
        sprintf(fehlermeldung,"Unexpected error: Reading of directory");
        beenden(fehlermeldung,2);
        // exit(1);
      }
      endpos=strlen(zeile)-1;           /*\n durch \0 ersetzen*/
      zeile[endpos]='\0';

      upper(zeile); /* eingefuegt am 15.11.1998 */

      sprintf(outbu,"%4li: %-13s",lauf,zeile);
      wrtxt(outbu);
      if ((lauf%4==0)&&(lauf!=n_dateien)) wrtxt("\n");
      // if ((lauf%84==0) || (lauf==n_dateien))
      if ((lauf%((one_config_set.sl-3)*4)==0) || (lauf==n_dateien))
      {
         if (lauf==n_dateien)
           wrtxt("\n\n\n");
         else
           wrtxt("\n\n");
         u_grenze = o_grenze+1;
         o_grenze = lauf;
         do
         {
            int zahl_taste;
            sc_gotoxy(1,one_config_set.sl);
            sprintf(outbu,"Please enter file number, range: %li..%li",u_grenze,o_grenze);
            wrtxt(outbu);

            info_zeile(outbu);
            sc_gotoxy(1,one_config_set.sl-1);
            wrtxt("File number........");

            if (* vorgabe==0)
            {
               strcpy(zahl_st,"");
            } else
            {
               if ( (* vorgabe >= u_grenze) && (* vorgabe <= o_grenze))
               {
                 sprintf(zahl_st,"%i",* vorgabe);
                 zahl_st[4]='\0';
               }
               else
               {
                 strcpy(zahl_st,"");
               }
            }
            do
            {

               zahl_taste = e_zle(
                                    1+strlen("File number........"),
                                    one_config_set.sl-1,
                                    zahl_st,
                                    4,
                                    4,
                                    0
                                  );

            } while (zahl_taste!=ENTER_KEY && zahl_taste!=ESC_KEY);
            sc_gotoxy(1,one_config_set.sl-1); sc_clreol();
            sc_gotoxy(1,one_config_set.sl); sc_clreol();
            if (zahl_taste==ESC_KEY || strlen(zahl_st)==0)
            {
               strcpy(zahl_st,"");
               sc_gotoxy(1,one_config_set.sl-2);
               wrtxt("No file selected...");
               sc_gotoxy(1,one_config_set.sl-1);
               // wrtxt("\n");
               break;
            }
            else
            {
               sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
               string_in_long(zahl_st,&datei_kenn,&ok);
               *vorgabe = (int) datei_kenn;
            }
         } while ((!ok) ||(datei_kenn < u_grenze) || (datei_kenn > o_grenze));
           if (strcmp(zahl_st,"")) break;
              /*Eine richtige Zahl eingelesen?*/
      }
   }
   dir_kat_schliessen();
   if (!strcmp(zahl_st,""))  /* Keine richige Zahl eingelesen? */
   {
      strcpy(dateiname,"");
      remove(dir_kat_name);
      return 0;
   }

   dir_kat_lesen();
   for (lauf=1;lauf<=n_dateien;lauf++)
   {
      if(fgets(zeile,120-1,dir_kat)==NULL)
      {
        sprintf(fehlermeldung,"Unexpected error: Reading of directory");
        beenden(fehlermeldung,2);
        // exit(1);
      }
      upper(zeile); /* eingefuegt am 15.11.1998 */

      if (lauf==datei_kenn)
      {
        break;
      }
   }
   dir_kat_schliessen();
   strncpy(dateiname,zeile,13);
   dateiname[13]='\0';
   endpos=strlen(dateiname)-1;           /*\n durch \0 ersetzen*/
   dateiname[endpos]='\0';
   sc_gotoxy(1,one_config_set.sl-2);
   sprintf(outbu,"%s selected...",dateiname);
   wrtxt(outbu);
   sc_gotoxy(1,one_config_set.sl-1);
   remove(dir_kat_name);
   return 1;
}

int dir_kat_schreiben(void)
{
  if ((dir_kat=fopen(dir_kat_name,"w"))==NULL)
  {
    return 0;
  }
  else return 1;
}


int dir_kat_lesen(void)
{
  if ((dir_kat=fopen(dir_kat_name,"r"))==NULL)
  {
    return 0;
  }
  else return 1;
}

void dir_kat_schliessen(void)
{
  fclose(dir_kat);
  /* printf("Katalog geschlossen...\n"); */
}


int isfile(const char * test_datei_name)
{
  FILE * test_datei;
  if ((test_datei=fopen(test_datei_name,"rb"))==0)
  {
    return 0;
  }
  else fclose(test_datei);
  return 1;
}



void programmpfad(const char * programm, char * pfad)
{
#if defined(__EMX__)
    char s[_MAX_PATH];
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char file[_MAX_FNAME];
    char ext[_MAX_EXT];
    strncpy(s,programm,_MAX_PATH);
    _splitpath(s,drive,dir,file,ext);
    _makepath(pfad,drive,dir,"","");
#endif
#if defined(__DJGPP__)
    char s[MAXPATH];
    char drive[MAXDRIVE];
    char dir[MAXDIR];
    char file[MAXFILE];
    char ext[MAXEXT];
    strncpy(s,programm,MAXPATH);
    fnsplit(s,drive,dir,file,ext);
    fnmerge(pfad,drive,dir,"","");
#endif
}


/*
    '0' wenn dirname nicht existiert, '1' wenn dirname existiert
*/

int isdirectory(char *dirname)
{
   DIR *dir;

   if ((dir = opendir(dirname)) == NULL)
      return 0;
   else
   {
     if (closedir(dir) != 0)
     {
       /*
       sprintf(fehlermeldung,"ERROR: calling 'closedir()' failed");
       beenden(fehlermeldung,2);
       */
      return 0;
     }
   }
   return 1;
}
/*
   Wurde nach der letzten Lesaktion das Dateiende erreicht?
   -> modifiziertes feof(FILE* stream) fuer Datenbankdateien
*/

int iseof(FILE * datei)
{
   long curpos, endpos;
   curpos = ftell(datei);
   fseek(datei,0L,SEEK_END);
   endpos=ftell(datei);
   fseek(datei,curpos,SEEK_SET);
   if ((curpos-endpos)==0L)
      return 1;
   else return 0;
}


long filesize(char * datname)
{
   FILE * fp;
   long curpos, length;

   if ((fp = fopen(datname,"rb"))==NULL)
        return -1;
   curpos = ftell(fp);
   fseek(fp, 0L, SEEK_END);
   length = ftell(fp);
   fseek(fp, curpos, SEEK_SET);
   fclose(fp);
   return length;
}


int dateikatalog_sortieren(void)
{
  char * zeile;
  int lauf;
  int anzahl_dateien;


  d_katalogstapel_rec * sortierstapel;

  anzahl_dateien = 0;
  lauf = 0;

  if ((zeile = (char *) malloc((120+1) * sizeof(char)))==NULL)
  {
     return 0;
  }
  if ((sortierstapel = (d_katalogstapel_rec *)
      malloc ((KAT_SORTIER_N + 2) * sizeof(d_katalogstapel_rec))) == NULL)
  {
      free(zeile);
      return 0;
  }



  dir_kat_lesen();

  while (fgets(zeile,KATDATEINAME_LEN + 3,dir_kat)!=NULL)
  {
     lauf++;
     rtrim(zeile,'\n');
     if (strlen(zeile) > KATDATEINAME_LEN)
     {
        dir_kat_schliessen();
        free(zeile);
        free(sortierstapel);
        return 0;
     }
     // strncpy(sortierstapel[lauf].dname,zeile,KATDATEINAME_LEN);
     strcpy(sortierstapel[lauf].dname,zeile);
     if (lauf > KAT_SORTIER_N)
     {
        break;
     }
  }
  dir_kat_schliessen();
  anzahl_dateien = lauf;


  {
      int i, j, h;
      d_katalogstapel_rec v;

      for (h=1;h<=anzahl_dateien/9;h=3*h+1);
      for(; h>0; h/=3)
        for (i=h+1;i <= anzahl_dateien ; i+=1)
        {
           v = sortierstapel[i]; j = i;
           while(j>h && strcmp(sortierstapel[j-h].dname,v.dname) > 0)
           {  sortierstapel[j] = sortierstapel[j-h], j -= h; }
           sortierstapel[j] = v;
        }
  }

  dir_kat_schreiben();
  for (lauf=1;lauf <= anzahl_dateien;lauf++)
  {
     fprintf(dir_kat,"%s\n",sortierstapel[lauf].dname);
     // printf("%s\n",sortierstapel[lauf].dname);
  }
  dir_kat_schliessen();

  free(zeile);
  free(sortierstapel);
  return 1;
}

int slash_to_backslash(char * zle)
{
   int laenge,i;
   laenge = strlen(zle);
   for (i=0;i<laenge;i++)
   {
      if (zle[i]=='/')
      {
          zle[i]='\\';
      }
   }
   return 1;
}
