/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   re_fun.c
*/

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "refs.h"
#include "abstr.h"
#include "abbruch.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "re_fun.h"
#include "str_refs.h"
#include "src_fun.h"
#include "l_menu.h"

 extern char fehlermeldung[250];

 extern journal_rec one_journal_rec;
 extern buch_rec one_buch_rec;
 extern refspix_rec ix01rec;

 extern config_set one_config_set;

 extern char wrtxtbu[WRTXTBU_LEN];
 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];


void j1_rec_zeigen(char * au_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   int taste;

   long i, j, n_zeilen;
   if (!auedstring_ok(au_zeile,ex_au_zeile))
       return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *ARTICLE IN A JOURNAL* ",one_journal_rec.kennziffer);
   aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": ",SHOWREC_LEN);

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.kuerzel)>=1)
   {
      show_quell(one_journal_rec.kuerzel,showrec);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
      strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
      if (strlen(one_journal_rec.monat) > 0)
      {
         strlimcat(showrec,"/",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.monat,SHOWREC_LEN);
         if (strlen(one_journal_rec.tag) > 0)
         {
            strlimcat(showrec,"/",SHOWREC_LEN);
            strlimcat(showrec,one_journal_rec.tag,SHOWREC_LEN);
         }
      }
      strlimcat(showrec,"; ",SHOWREC_LEN);
   }


   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      if (strlen(one_journal_rec.issue_nummer)>0)
      {
         strlimcat(showrec,"(",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.issue_nummer,SHOWREC_LEN);
         strlimcat(showrec,")",SHOWREC_LEN);
      }
      strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.seite_bis)>=1)
   {
      strlimcat(showrec,"-",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   for (i=1;i<=n_zeilen;i++)
   {
      if ((j % (one_config_set.sl-3))==0)
      {
        wrtxt("\n");
        taste = lotus_menu(
           "NextPage$Show the next page@"
           "Cancel$Finish viewing of record"
                          );
        if (taste==0 || taste==2)
        {
           sc_gotoxy(1,one_config_set.sl-2);
           break;
        }
        j++;
      }
      j++;
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");

   }
   wrtxt("\n");
}



void b2_rec_zeigen(char * au_zeile, char * ed_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   int taste;

   long i, j, n_zeilen;
   if (!auedstring_ok(au_zeile,ex_au_zeile))
       return;
   if (!auedstring_ok(ed_zeile,ex_au_zeile))
       return;
   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';

   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *CHAPTER/ARTICLE IN A BOOK* ",one_journal_rec.kennziffer);
   aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": ",SHOWREC_LEN);

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". In: ",SHOWREC_LEN);
      else
         strlimcat(showrec," In: ",SHOWREC_LEN);
   }
   aued_zeile_zeigen(ed_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": editor(s). ",SHOWREC_LEN);

   if (strlen(one_buch_rec.titel_bu)>=1)
   {
      strlimcat(showrec,one_buch_rec.titel_bu,SHOWREC_LEN);
      if (!satzzeichen(showrec))
        strlimcat(showrec,". ",SHOWREC_LEN);
      else
        strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.isbn)>0)
   {
     strlimcat(showrec,"(ISBN: ",SHOWREC_LEN);
     strlimcat(showrec,one_buch_rec.isbn,SHOWREC_LEN);
     strlimcat(showrec,") ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,"(",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      strlimcat(showrec,". ed) ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.publ_ort)>=1)
   {
       strlimcat(showrec,one_buch_rec.publ_ort,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.verlag)>=1)
   {
       strlimcat(showrec,one_buch_rec.verlag,SHOWREC_LEN);
       strlimcat(showrec,", ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
       strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
       strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"-",SHOWREC_LEN);
       strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   /* 19.3.1997 */
   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }


   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }


   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   for (i=1;i<=n_zeilen;i++)
   {
      // if ((j % 22)==0)
      if ((j % (one_config_set.sl-3))==0)
      {
        wrtxt("\n");
        taste = lotus_menu(
           "NextPage$Show the next page@"
           "Cancel$Finish viewing of record"
                          );
        if (taste==0 || taste==2)
        {
           sc_gotoxy(1,one_config_set.sl-2);
           break;
        }
        j++;
      }
      j++;
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
   }
   wrtxt("\n");
}


void b1_rec_zeigen(char * ed_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   int taste;

   long i, j, n_zeilen;
   if (!auedstring_ok(ed_zeile,ex_au_zeile))
       return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';

   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *BOOK* ",one_journal_rec.kennziffer);

   aued_zeile_zeigen(ed_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": editor(s). ",SHOWREC_LEN);

   if (strlen(one_buch_rec.titel_bu)>=1)
   {
      strlimcat(showrec,one_buch_rec.titel_bu,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.isbn)>0)
   {
     strlimcat(showrec,"(ISBN: ",SHOWREC_LEN);
     strlimcat(showrec,one_buch_rec.isbn,SHOWREC_LEN);
     strlimcat(showrec,") ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,"(",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      strlimcat(showrec,". ed) ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.publ_ort)>=1)
   {
       strlimcat(showrec,one_buch_rec.publ_ort,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.verlag)>=1)
   {
       strlimcat(showrec,one_buch_rec.verlag,SHOWREC_LEN);
       strlimcat(showrec,", ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
       strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
       strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1  ||
        strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"(",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
       strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"-",SHOWREC_LEN);
       strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   /* 19.3.1997 */
   if (strlen(one_journal_rec.seite_von)>=1 ||
            strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,") ",SHOWREC_LEN);
   }


   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }



   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   for (i=1;i<=n_zeilen;i++)
   {
      // if ((j % 22)==0)
      if ((j % (one_config_set.sl-3))==0)
      {
        wrtxt("\n");
        taste = lotus_menu(
           "NextPage$Show the next page@"
           "Cancel$Finish viewing of record"
                          );
        if (taste==0 || taste==2)
        {
           sc_gotoxy(1,one_config_set.sl-2);
           break;
        }
        j++;
      }
      j++;
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
   }
   wrtxt("\n");
}


void aued_zeile_zeigen(char * zeile, char * ex_au_zeile, char * showrec)
{
   int i,anz_autoren;
   char a_name[AUNAME_LEN+12];
   char v_name[AUNAME_LEN+12];

   anz_autoren=countitem(zeile,";");
   for (i=1;i<=anz_autoren;i++)
   {
      strcpy(ex_au_zeile,"");
      extractitem(i,zeile,";",ex_au_zeile);
      trim(ex_au_zeile,' ');
      ex_au_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
      extractitem(1,ex_au_zeile,",",a_name);
      trim(a_name,' ');
      a_name[AUNAME_LEN]= '\0';
      extractitem(2,ex_au_zeile,",",v_name);
      trim(v_name,' ');
      v_name[AUVORNAMEN_LEN] = '\0';
      strlimcat(showrec,a_name,SHOWREC_LEN);
      strlimcat(showrec," ",SHOWREC_LEN);
      strlimcat(showrec,v_name,SHOWREC_LEN);
      if (i<anz_autoren) strlimcat(showrec,", ",SHOWREC_LEN);
   }

}

int auedstring_ok(char * au_zeile, char * ex_au_zeile)
{
  int i, anz_autoren;
  char a_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];
  char v_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];

  anz_autoren = countitem(au_zeile,";");

  if (anz_autoren > MAX_N_AUTHORS)
  {
     sprintf(wrtxtbu,"\n[List of authors/editors contains > %i items]>",MAX_N_AUTHORS);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     return 0;
  }
  if (strlen(au_zeile)==0)
  {
     sprintf(wrtxtbu,"\n[%s: No authors/editors entered]>",ix01rec.kennziffer);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     return 0;
  }
  for (i=1;i<=anz_autoren;i++)
  {
      strcpy(ex_au_zeile,"");
      extractitem(i,au_zeile,";",ex_au_zeile);
      trim(ex_au_zeile,' ');
      ex_au_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
      extractitem(1,ex_au_zeile,",",a_name);
      trim(a_name,' ');
      if (strlen(a_name) > AUNAME_LEN)
      {
        sprintf(wrtxtbu,"\n[%s: Authors/Editors no %i: name too long, 1..%i allowed]>",
           ix01rec.kennziffer,i,AUNAME_LEN);
        wrtxt(wrtxtbu);
        tastelesen();
        sc_gotoxy(1,one_config_set.sl-1);
        return 0;
      }
      a_name[AUNAME_LEN]= '\0';
      if (strlen(a_name) < 1)
      {
        sprintf(wrtxtbu,"\n[%s: Authors/Editors no %i: No name?]>",ix01rec.kennziffer,i);
        wrtxt(wrtxtbu);
        tastelesen();
        sc_gotoxy(1,one_config_set.sl-1);
        return 0;
      }

      extractitem(2,ex_au_zeile,",",v_name);
      trim(v_name,' ');
      if (strlen(v_name) > AUVORNAMEN_LEN)
      {
        sprintf(wrtxtbu,"\n[%s: Authors/Editors no %i: too many first names, 1..%i allowed]>",
           ix01rec.kennziffer,i,AUVORNAMEN_LEN);
        wrtxt(wrtxtbu);
        tastelesen();
        sc_gotoxy(1,one_config_set.sl-1);
        return 0;
      }


      v_name[AUVORNAMEN_LEN] = '\0';
      if (strlen(v_name) < 1)
      {
        sprintf(wrtxtbu,"\n[%s: Authors/Editors no %i: No first name?]>",ix01rec.kennziffer,i);
        wrtxt(wrtxtbu);
        tastelesen();
        sc_gotoxy(1,one_config_set.sl-1);
        return 0;
      }
  }
   return anz_autoren;
}

int descstring_ok(char * desc_zeile, char * ex_au_zeile)
{
  int i, anz_desc;
  anz_desc = countitem(desc_zeile,",");
  if (anz_desc > MAX_N_DESC)
  {
     sprintf(wrtxtbu,"\n[List of keywords contains > %i items]>",MAX_N_DESC);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     return -1;
  }

  if (strlen(desc_zeile)==0)
  {
     sprintf(wrtxtbu,"\n[%s: No keywords entered]>",ix01rec.kennziffer);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     return -1;
  }

  for (i=1;i<=anz_desc;i++)
  {
      strcpy(ex_au_zeile,"");
      extractitem(i,desc_zeile,",",ex_au_zeile);
      trim(ex_au_zeile,' ');
      if (strlen(ex_au_zeile) > KEYWORDS_LEN)
      {
        sprintf(wrtxtbu,"\n[%s: keword %i too long: 1..%i characters allowed]>",
           ix01rec.kennziffer,i,KEYWORDS_LEN);
        wrtxt(wrtxtbu);
        tastelesen();
        sc_gotoxy(1,one_config_set.sl-1);
        return -1;
      }
  }
  return anz_desc;
}



void text_zeigen(const char * txt)
{
   int i, n_zeilen, taste;
   char zeile[SCREENLINE_LEN + 256];
   cls_line("");
   // n_zeilen=countitem(txt,"@");
   n_zeilen=countitem(txt,"\n");
   taste = 200;
   for (i=1;i<=n_zeilen;i++)
   {
      /* if ((i % 22)==0) kann die folgende Zeilen ersetzen */
      // if ((i==22) || ((i % 21)==0 && i > 21))
      if ((i==(one_config_set.sl-3)) || ((i % (one_config_set.sl-4))==0 &&
         i > one_config_set.sl-4))
      {
        wrtxt("\n");
        taste = lotus_menu(
           "@NextPage$Show the next page or the remaining text"
           "@Cancel$Finish viewing the current text"
                          );
        if (taste==0 || taste==2)
        {
            break;
        }
        sc_gotoxy(1,one_config_set.sl-2);
      }
      // extractitem(i,txt,"@",zeile);
      extractitem(i,txt,"\n",zeile);
      wrtxt(zeile);
      wrtxt("\n");
   }
   // if ((i % 22)!=0) wrtxt("\n");
   if (taste!=0 && taste !=2) wrtxt("\n");

}


#define ISFILEERROR "FILE %s not found, please read REFERENCES Version 3.6 documents"

void dateien_identifizieren(void)
{
   if (!isfile(journal_pix_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,journal_pix_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(journal_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,journal_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(book_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,book_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(autorjl_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,autorjl_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(autorbu_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,autorbu_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(quell_pix_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,quell_pix_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(quell_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,quell_name);
      beenden(fehlermeldung,1);
   }

   if (!isfile(stichw_pix_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,stichw_pix_name);
      beenden(fehlermeldung,1);
   }
   if (!isfile(stichw_name))
   {
      sprintf(fehlermeldung,ISFILEERROR,stichw_name);
      beenden(fehlermeldung,1);
   }
}



#undef ISFILEERROR
