/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   vtxt.c view text files
*/

#include <stdio.h>
#include <signal.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "keycodes.h"
#include "cfg_fun.h"
#include "l_menu.h"
#include "abbruch.h"
#include "str_fun.h"
#include "vtxt.h"

#define EINDATEI_LEN 150
#define PROMPT_LEN 150

#define FINDZEILE_LEN 32768
#define BEDZEILE_LEN 256

static char * findzeile;                      /* in dieser Zeile wird gesucht */
static char bedzeile[BEDZEILE_LEN + 3];       /* enthaelt den String, nach dem
                                                 gesucht wird*/

#define VTXTMENU "@NextPage$Show the next page of text file\
@Rewind$Go back to the beginning of this file\
@EnterLine$Jump: `#' go to line #; `+#' go # lines forward; `-#' go # lines back\
@Go+|-Lines$Go forward/back # lines (+#/-#), change step width with `EnterLine'\
@Find$Search (case sensitive!) string in all lines in text file, list lines\
@Quit$Finish viewing current text"


 static FILE * fpeindatei;
 static char eindatei_name[EINDATEI_LEN];
 extern char wrtxtbu[WRTXTBU_LEN];
 static char inbu[WRTXTBU_LEN];
 static char inbutemp[WRTXTBU_LEN];

 extern char fehlermeldung[250];
 extern config_set one_config_set;

 static long flaenge;
 static long fposition, fposition_alt;
 static int  flaenge_bestimmt;


 static void eingabedatei_lesen(void);
 static void eingabedatei_schliessen(void);
 static int eingabedatei_zeigen(void);
 static long groesse_bestimmen(void);
 static void springen(int scode);
 static int vtxt_suchen(void);

int vtxt_main(char * dname)
{
  int wert = 0;

  if ((findzeile = (char *) malloc((FINDZEILE_LEN + 3) * sizeof(char)))==NULL)
  {
      sprintf(fehlermeldung,
        "'View Text': unable to allocate SEARCH-BUFFER");
      beenden(fehlermeldung,2);
  }

  fposition = 1;
  fposition_alt = 1;
  strcpy(inbu,"");
  flaenge_bestimmt = 0;

  strcpy(eindatei_name, dname);
  eingabedatei_lesen();
  strcpy(bedzeile,"");
  wert = 'R';
  do
  {
     wert = eingabedatei_zeigen();
     if (wert=='F')
     {
         wert = vtxt_suchen();
     }

     if (wert=='G')
     {
          springen(1); /* EnterLine */
     }
     if (wert=='g')
     {
          springen(2); /* Go+|-Lines */
     }
     else if (wert=='R')
     {
         rewind(fpeindatei);
         fposition = 1;
     }
 } while (wert!='Q');
 wrtxt("\n");
 eingabedatei_schliessen();
 free(findzeile);
 return 0;

}

static void eingabedatei_lesen(void)
{
   if ((fpeindatei=fopen(eindatei_name,"r"))==NULL)
   {
       wrtxt("\nCannot read input file \n");
       exit (1);
   }
}

static void eingabedatei_schliessen(void)
{
   fclose(fpeindatei);
}

static int eingabedatei_zeigen(void)
{
    int zeichen;
    int bzle;
    int bsp;
    static int menupos;
    int taste;
    taste = 0;
    sc_clrscr();
    bzle=1;
    bsp=1;
    if (menupos==6) menupos=1;
    strcpy(wrtxtbu,"");
    do
    {

      if (bzle==1)
      {
         fposition_alt = fposition;
      }
      zeichen=fgetc(fpeindatei);
      if (zeichen!=EOF)
      {
       if (zeichen=='\t')
       {
          zeichen=' ';
       }
       if (zeichen=='\n')
       {
         fposition++;
       }
       if (bsp <= 78)
       {
          if ( zeichen!='\n' )
          {
            wrtxtbu[bsp-1]=zeichen;
            wrtxtbu[bsp]='\0';
            bsp++;
          }
          if ( zeichen=='\n' )
          {
            wrtxt(wrtxtbu);
            wrtxt("\n");
            strcpy(wrtxtbu,"");
            bsp=1;
            bzle++;
          }
       }
       else
       {
          if (zeichen!='\n')
          {
             wrtxtbu[bsp-1]=zeichen;
             wrtxtbu[bsp]='\0';
          }
          wrtxt(wrtxtbu);
          wrtxt("\n");
          strcpy(wrtxtbu,"");
          bzle++;
          bsp=1;
       }
      }
      else
      {
         if (strlen(wrtxtbu)!=0)
         {
            wrtxt(wrtxtbu);
         }
         wrtxt("<");
      }
      if (bzle>=one_config_set.sl-2)
      {
        sc_gotoxy(1,one_config_set.sl-1);
        bzle=1;
        taste = lotus_menu_default(&menupos,VTXTMENU);

        if (taste==6 || taste==0)
        {
           sc_gotoxy(1,one_config_set.sl);
           sc_clreol();
           sc_gotoxy(1,one_config_set.sl-1);
           return 'Q';
        }
        if (taste==5 || taste==0)
        {
           sc_gotoxy(1,one_config_set.sl);
           sc_clreol();
           sc_gotoxy(1,one_config_set.sl-1);
           return 'F';
        }
        if (taste==4)
        {
           sc_gotoxy(1,one_config_set.sl);
           sc_clreol();
           sc_gotoxy(1,one_config_set.sl-1);
           sc_clreol();
           return 'g';
        }
        if (taste==3)
        {
           sc_gotoxy(1,one_config_set.sl);
           sc_clreol();
           sc_gotoxy(1,one_config_set.sl-1);
           sc_clreol();
           return 'G';
        }
        sc_clrscr();
        if (taste==2)
        {
           return 'R';
        }
      }
    } while (zeichen!=EOF);
       sc_gotoxy(1,one_config_set.sl-1);
       taste = lotus_menu_default(&menupos,VTXTMENU);

    if (taste==6 || taste==0)
    {
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       return 'Q';
    }
    if (taste==5 || taste==0)
    {
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       return 'F';
    }
    if (taste==4)
    {
        sc_gotoxy(1,one_config_set.sl);
        sc_clreol();
        sc_gotoxy(1,one_config_set.sl-1);
        sc_clreol();
        return 'g';
    }
    if (taste==3)
    {
        sc_gotoxy(1,one_config_set.sl);
        sc_clreol();
        sc_gotoxy(1,one_config_set.sl-1);
        sc_clreol();
        return 'G';
    }
    sc_clrscr();
    if (taste==2)
    {
       return 'R';
    }
    else return 'R';
}



static long groesse_bestimmen(void)
{
  long i;
  int c;

  i = 1;

  rewind(fpeindatei);

  while((c=fgetc(fpeindatei))!=EOF)
  {
      if (c=='\n')
      {
          i++;
      }
  }
  flaenge_bestimmt=1;
  return i;
}


/*
 * scode 1 EnterLine
 * scode 2 Go+|-Lines
 */

static void springen(int scode)
{
   long neuepos;
   long differenz;
   int taste;
   int ok;
   int c;
   neuepos = 1;

   if (!flaenge_bestimmt)
   {
      sc_gotoxy(1,one_config_set.sl-1);
      wrtxt("\nDetermining size of text file...");
      flaenge = groesse_bestimmen();
      sc_gotoxy(1,one_config_set.sl);sc_clreol();
      sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
   }
   if (scode==1 || strlen(inbu)==0 ||
         (scode==2 && (inbu[0]!='+' && inbu[0]!='-')))
   {

      sprintf(wrtxtbu,"\nLine: 1..%li, first line of screen: %li; "
                         "enter #, +# or -# (#: line no)",
          flaenge-1,fposition_alt);

      /* allgemeiner festlegen */
      wrtxtbu[78]='\0';
      wrtxt(wrtxtbu);
      sc_gotoxy(1,one_config_set.sl-1);
      strcpy(wrtxtbu,"New line...........");
      wrtxt(wrtxtbu);
      do
      {
        if (strlen(inbu)==0)
        {
           if (scode==1)
           {
             sprintf(inbu,"%li",fposition_alt);
           }
           else
           {
             sprintf(inbu,"-%i",one_config_set.sl-3);
           }
        }  /* anfang neu */
        else if (scode==2 && inbu[0]!='+' && inbu[0]!='-')
        {
             sprintf(inbu,"-%i",one_config_set.sl-3);
        }  /* ende neu */
        taste = e_zle (
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  inbu,
                  8,
                  40,
                  0
                  );
      } while (taste != ENTER_KEY && taste != ESC_KEY);
   }

   rtrim(inbu,'\n');
   ltrim(inbu,' ');
   ltrim(inbu,'0'); /* added Oct. 99 */
   strcpy(inbutemp,inbu);
   if (inbu[0]=='+')
   {
      ltrim(inbutemp,'+');
      ltrim(inbutemp,' ');
      string_in_long(inbutemp,&differenz,&ok);
      if (ok) neuepos = fposition_alt+differenz;
   }
   else if (inbu[0]=='-')
   {
      ltrim(inbutemp,'-');
      ltrim(inbutemp,' ');
      string_in_long(inbutemp,&differenz,&ok);
      if (ok) neuepos = fposition_alt-differenz;
   }
   else string_in_long(inbu,&neuepos,&ok);

   if (ok==0 || taste==ESC_KEY)
   {
      neuepos = fposition_alt;
   }
   else if (neuepos < 1)
   {
      neuepos = 1;
   }

   else if (neuepos >= flaenge)
   {
      neuepos = flaenge-1;
   }
   rewind(fpeindatei);
   fposition = 1;
   for(;;)
   {
      if (fposition > neuepos - 1) break;
      c = fgetc(fpeindatei);
      if (c=='\n') fposition++;
   }
}

static int vtxt_suchen(void)
{
   int taste, weitertaste;

   int was_gefunden;
   int zeichen;
   int ssp; /* Suchspalte */
   long i;



   was_gefunden=0;
   ssp=1;

   sc_gotoxy(1,one_config_set.sl-1);
   wrtxt("\nPlease enter string to be searched (`case sensitive') in file");
   sc_gotoxy(1,one_config_set.sl-1);
   strcpy(wrtxtbu,"Search string......");
   wrtxt(wrtxtbu);
   do
   {

     taste = e_zle
               (1+strlen(wrtxtbu),
               one_config_set.sl-1,
               bedzeile,
               80-strlen(wrtxtbu)-3,
               BEDZEILE_LEN,
               0);
      if (taste==ENTER_KEY && strlen(bedzeile)==0)
      {
        taste = 0;
        continue;
      }
   } while (taste != ENTER_KEY && taste != ESC_KEY);
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
   if (taste==ESC_KEY)
   {
      return 'R';
   }
   strcpy(findzeile,"");

   rewind(fpeindatei);
   fposition = 1;
   fposition_alt = 1;
   sc_clrscr();
   i = 1;
   do
   {
       zeichen = fgetc(fpeindatei);
       if (zeichen=='\t')
       {
          zeichen=' ';
       }
       if (zeichen=='\n')
       {
         fposition++;
       }
       if (ssp <= FINDZEILE_LEN)
       {
          if ( zeichen!=EOF )
          {
            findzeile[ssp-1]=zeichen;
            findzeile[ssp]='\0';
            ssp++;
          }
          else /* eigentl. unnoetig... */
          {
            findzeile[ssp-1]=' ';
            findzeile[ssp]='\0';
            ssp++;
          }
          if ( zeichen=='\n' || zeichen==EOF)
          {
             if (locate_substring(bedzeile,findzeile)>-1)
             {
                rtrim(findzeile,'\n');
                if (strlen(findzeile)>68)
                {
                   findzeile[68-3] = '\0';
                   strcat(findzeile,"...");
                }
                if (zeichen=='\n')
                {
                  sprintf(wrtxtbu,"%-6li: %s\n",fposition-1, findzeile);
                }
                else
                {
                  sprintf(wrtxtbu,"%-6li: %s\n",fposition, findzeile);
                }
                wrtxt(wrtxtbu);
                was_gefunden = 1;
                i++;
             }
             strcpy(findzeile,"");
             ssp=1;
          }
       }
       else
       {
             if (zeichen!='\n' && zeichen != EOF) continue;

             if (locate_substring(bedzeile,findzeile)>-1)
             {
                rtrim(findzeile,'\n');
                if (strlen(findzeile)>68)
                {
                   findzeile[68-3] = '\0';
                   strcat(findzeile,"...");
                }
                if (zeichen=='\n')
                {
                  sprintf(wrtxtbu,"%-6li: %s\n",fposition-1, findzeile);
                }
                else
                {
                  sprintf(wrtxtbu,"%-6li: %s\n",fposition, findzeile);
                }

                wrtxt(wrtxtbu);
                was_gefunden = 1;
                i++;
             }
             strcpy(findzeile,"");
             ssp=1;
       }
       if (i>=one_config_set.sl-2)
       {
           sc_gotoxy(1,one_config_set.sl-1);
           weitertaste = lotus_menu("@NextHits$Proceed searching"
                                    "@Cancel$Stop searching");
           if (weitertaste==0 ||weitertaste==2)
           {
              break;
           }
           else
           {
              sc_clrscr();
              i=1;
              continue;
           }
       }
   } while (zeichen!=EOF);
   sc_gotoxy(1,one_config_set.sl-1);
   if (!was_gefunden)
   {
      wrtxt("\n[Search string not found, please press any key]>");
      tastelesen();
      sc_gotoxy(1,one_config_set.sl-1);
   }
   rewind(fpeindatei);
   fposition = 1;
   fposition_alt = 1;
   if (was_gefunden) return 'G'; else return 'R';
}
