/*************************************************
 **																							**
 **		SoftC.h                                   **
 **                                             **
 **					SoftC common toolkit header					**
 **																							**
 **					Copyright (C) 1988, 1989 by 				**
 **								Kim Schumann									**
 **								16820 3rd St NE								**
 **								Ham Lake, MN 55304						**
 **								(612) 434-6968								**
 **																							**
 **							All rights reserved.						**
 **						Proprietary information.					**
 **		Use requires license from Kim Schumann,		**
 **					or an authorized distributor.				**
 *************************************************/



/**********
 *
 *	Function Return Codes
 *
 **********/




#define SC_FILENGTH		8			/* WARNING - file length is incorrect */
#define SC_MEMOFLD		7			/* WARNING - memo fields not supported */
#define SC_FLDROUND		6			/* WARNING - numeric field rounded */
#define SC_FLDTRUNC		5			/* WARNING - data field truncated */
#define SC_NOFIND			4			/* WARNING - could not find key in index file */
#define SC_END				3			/* WARNING - no more keys */
#define SC_EMPTY			2			/* WARNING - file is empty */
#define SC_DELREC			1			/* WARNING - record read is marked deleted */
#define SC_SUCCESS		0			/* successful function return code */
#define SC_WRTFAIL		-1		/* ERROR - file write failure */
#define SC_RDFAIL			-2		/* ERROR - file read failure */
#define SC_MEMERR			-3		/* ERROR - memory allocation error */
#define SC_BADFLD			-4		/* ERROR - bad user specified field description */
#define SC_NODBF			-5		/* ERROR - file not in .DBF format */
#define SC_SKFAIL			-6		/* ERROR - file pointer reposition failed */
#define SC_NOFILE			-7		/* ERROR - file not found */
#define SC_FILBAD			-8		/* ERROR - file corrupted */
#define SC_BADEXPR		-9		/* ERROR - bad user specified key expression */
#define SC_NONDX			-10		/* ERROR - file not in .NDX format */
#define SC_NOHNDL			-11		/* ERROR - no handles available */
#define SC_NOPGS			-12		/* ERROR - no index pages loaded */
#define SC_BADPG			-13		/* ERROR - index page was not loaded */
#define SC_CLOSFAIL		-14		/* ERROR - file close failure */
#define SC_BADCMD			-15		/* ERROR - invalid command */
#define SC_BADHNDL		-16		/* ERROR - invalid handle number */
#define SC_BADFNAME		-17		/* ERROR - invalid filename */
#define SC_BADDATE		-18		/* ERROR - invalid date */
#define SC_BADTIME		-19		/* ERROR - invalid time */
#define SC_NODBT			-20		/* ERROR - file not in .DBT format */
#define SC_DBFVERS		-21		/* ERROR - invalid dBaseIII version */
#define SC_DBFHLEN		-22		/* ERROR - file header length error */
#define SC_DBFDATE		-23		/* ERROR - last file change date in error */
#define SC_NULLPARM		-24		/* ERROR - parameter address NULL */
#define SC_BADKEYT		-25		/* ERROR - invalid key type */
#define SC_KEYLEN			-26		/* ERROR - invalid key length */
#define SC_ITEMLEN		-27		/* ERROR - item length incorrect */
#define SC_BADROOT		-28		/* ERROR - invalid root page */
#define SC_MAXKEYS		-29		/* ERROR - bad maximum number of keys per page */

#define SC_MAXWARN	8
#define SC_MAXERR		-29




/**********
 *
 *	Common SoftC Prototypes
 *
 **********/




signed short int scinit( signed char );
signed short int scterm( void );
signed char *scvers( void );




/**********
 *
 *	Error Handling Prototypes
 *
 **********/




void sceclr( void );
signed char *scemsg( void );



/**********
 *
 *	dBase III Defines
 *
 **********/




/* scrput definitions */
#define SC_UPDATE 1									/* update current record */
#define SC_ADD 2										/* add new record */

/* scrcopy & scrclear definitions */
#define SC_INPUT 1									/* input buffer */
#define SC_OUTPUT 2									/* output buffer */

/* sckfind definitions */
#define SC_FIRST 1									/* find first key */
#define SC_EXACT 2									/* find exact key (uses record number) */




/**********
 *
 *	dBase III Type Definitions
 *
 **********/




typedef struct {	/* database field description */
	signed char name[11];	/* field name */
	signed char type;				/* field type
													 * 'c' or 'C' - character
													 * 'd' or 'D' - date
													 * 'l' or 'L' - logical
													 *							't' or 'T' - true
													 *							'f' or 'F' - false
													 *							'y' or 'Y' - yes
													 *							'n' or 'N' - no
													 *							'?'				 - uninitialized
													 * 'n' or 'N' - numeric */
	unsigned char len;			/* field width */
	unsigned char decpl;		/* decimal count */
} SC_FIELD;




/**********
 *
 *	dBase III .DBF File Manipulator Prototypes
 *
 **********/




signed short int scdclose( signed char );
signed short int scdcreate( signed char *, signed char, SC_FIELD * );
signed short int scdinfo( signed char, signed char * );
signed short int scdopen( signed char *, signed char * );
signed short int scdsize( signed char, signed long int * );




/**********
 *
 *	dBase III .DBF Field Manipulator Prototypes
 *
 **********/




signed short int scdfget( signed char, signed char, void * );
signed short int scdfgets( signed char, signed char, char * );
signed short int scdfinfo( signed char, signed char *, SC_FIELD * );
signed short int scdfnam2no( signed char, signed char *, signed char * );
signed short int scdfput( signed char, signed char, void * );
signed short int scdfputs( signed char, signed char, char * );




/**********
 *
 *	dBase III .DBF Record Manipulator Prototypes
 *
 **********/




signed short int scdrclear( signed char, signed short );
signed short int scdrcopy( signed char, signed short );
signed short int scdrdel( signed char, signed long int );
signed short int scdrget( signed char, signed long int );
signed short int scdrinfo( signed char, signed short *, signed char *, void **, void ** );
signed short int scdrput( signed char, signed short, signed long int * );
signed short int scdrundel( signed char, signed long int );




/**********
 *
 *	dBase III .NDX File Manipulators Prototypes
 *
 **********/




signed short int sciclose( signed char );
signed short int scicreate( signed char *, signed char, signed char *, signed char );
signed short int sciexpr( signed char, signed char * );
signed short int sciinfo( signed char, signed char *, signed char *, signed char *, signed short int * );
signed short int sciopen( signed char *, signed char * );




/**********
 *
 *	dBase III .NDX Key Manipulator Prototypes
 *
 **********/




signed short int scikadd( signed char, signed char *, signed long int );
signed short int scikcur( signed char, signed char *, signed long int * );
signed short int scikdel( signed char, signed char *, signed long int );
signed short int scikfirst( signed char, signed char *, signed long int * );
signed short int scikfind( signed char, signed char, signed char *, signed long int * );
signed short int sciklast( signed char, signed char *, signed long int * );
signed short int scikmake( signed char, signed char, void ** );
signed short int sciknext( signed char, signed char *, signed long int * );
signed short int scikprev( signed char, signed char *, signed long int * );




/**********
 *
 *	dBase III .NDX Page Manipulator Prototypes
 *
 **********/




signed short int scipinfo( signed char, signed char *);
signed short int scipnum( signed char, signed char * );




/**********
 *
 *	Calendar Definitions
 *
 **********/




/* sccdxlat */
#define SC_2DBASE 1					/* convert from "mm/dd/[yy]yy" to "yyyymmdd" */
#define SC_2ASCII	8					/* convert from "yyyymmdd" to "mm/dd/yy" */
#define SC_2ASCIIL 10				/* convert from "yyyymmdd" to "mm/dd/yyyy" */




/**********
 *
 *  Calendar Prototypes
 *
 **********/




signed short int sccday( signed char, signed char * );
signed short int sccddiff( signed char *, signed char *, signed long * );
signed short int sccdn2s( signed int, signed int, signed int, signed char * );
signed short int sccds2l( signed char *, signed long * );
signed short int sccds2n( signed char *, signed int *, signed int *,
		signed int * );
signed short int sccdvalid( signed char * );
signed short int sccdxlat( signed char, signed char *, signed char * );
signed short int sccleap( signed char * );
signed short int sccleapi( signed int );
signed short int sccmonth( signed char, signed char * );




