* Program..: Report.PRG
* Author...: Karen A. Robinson
* Date.....: October 1, 1985
* Version..: dBASE III, any version
* Note(s)..: USEs Referral.DBF and Recruit.DBF to generate a
*            custom report of student referrals by recruiter.
*            Simulates a report produced by the REPORT FORM.
*
CLEAR
SET TALK OFF
* ---Open work areas.
SELECT 2
USE Referral INDEX Code
SELECT 1
USE Recruit
SET DEVICE TO PRINT
* ---Print all recruiters and their respective referrals.
DO WHILE .NOT. EOF()
* ---Initialize memory variables for the page headings.
   STORE  1 TO m_pagctr
   STORE 90 TO m_line
   * ---Calculate column positions so that the name and address
   * ---of the recruiter will be centered.
   STORE 40 - LEN(TRIM(Name))/2    TO m_1
   STORE 40 - LEN(TRIM(Address))/2 TO m_2
   STORE 40 - ((LEN(TRIM(City)) + LEN(State) + LEN(Zip) + 4)/2);
         TO m_3
   * --Find the first referral from Recruit.DBF.
   SELECT Referral
   SEEK Recruit->Ref_code
   * ---Test for the existence of a referral.
   * ---If one is not found, then get the next recruiter
   * ---and start the process over.
   IF EOF()
      SELECT Recruit
      SKIP
      LOOP
   ENDIF

   * ---The first referral has been found.  The following
   * ---prints all the records from Referral.DBF that have
   * ---the same Ref_code as the Ref_code in Recruit.DBF.
   DO WHILE Ref_code = Recruit->Ref_code .AND. .NOT. EOF()
      * ---Test for a new page.  If the line count exceeds
      * ---56, a new page is required.
      IF m_line > 56
         * ---Print page and column headings.
         @  1, 28 SAY 'STUDENT REFERRAL REPORT'
         @  1, 65 SAY 'Page ' + STR(m_pagctr,3)
         @  2, 65 SAY 'Date    '
         @  2, 72 SAY DATE()
         @  4,m_1 SAY Recruit->Name
         @  5,m_2 SAY Recruit->Address
         @  6,m_3 SAY TRIM(Recruit->City) + ', ' +;
                      Recruit->State + ' ' + Recruit->Zip
         @  9,14 SAY 'Level'
         @  9,23 SAY 'Center'
         @  9,43 SAY 'Student Name'
         * ---Increment page and line counts.
         STORE 11 TO m_line
         STORE m_pagctr + 1 TO m_pagctr
      ENDIF
      * ---Print a referral, a record from the Referral
      * ---database file.
      @ m_line,14 SAY Level
      @ m_line,23 SAY Center
      @ m_line,43 SAY Name
      * ---Increment the line counter.
      STORE m_line + 1 TO m_line
      * ---Get the next Referral for the current
      * ---recruiter.
      SKIP
   ENDDO
   * ---Get the next recruiter.
   SELECT Recruit
   SKIP
ENDDO
* ---Restore the environment and return.
EJECT
SET DEVICE TO SCREEN
CLOSE DATABASES
RETURN
* EOP Report.PRG