* Program ...: Label2.PRG
* Author ....: Christopher White
* Date ......: August 1, 1985
* Version....: dBASE III, any version
* Note(s)....: Prints one across shipping type labels within a
*              box.
*
PARAMETERS filename, indx, condition, printer
SET TALK OFF
* ---User definition area.
* ---Define label spacing parameters.
between   = 2
lmargin   = 3
box_h     = 5
box_w     = 55
* ---Define print line expressions.
exp01 = [TRIM( "SHIP TO: " + Shipto + "COMPANY: " + Company )]
exp02 = [TRIM( "COMPANY: " + Company )]
nexp  = 2
* ---Define box characters.
spec_char = "|"
box_line  = "+" + SUBSTR(;
            "----------------------------"+;
            "----------------------------"+;
            "----------------------------",;
            1, box_w - 2) +;
            "+"
* ---Label print area.
* ---Set up database file and FILTER.
USE &filename
IF "" <> indx
   SET INDEX TO &indx
ENDIF
SET FILTER TO &condition
GO TOP
IF printer = "Y"
   SET PRINT ON
   SET CONSOLE OFF
ENDIF
* ---Print labels.
DO WHILE .NOT. EOF()
   * ---Print heading line.
   ? SPACE( lmargin )  + box_line
   * ---Print Detail lines.
   linecnt = "01"
   DO WHILE VAL( linecnt ) <= nexp
      expanded = exp&linecnt
      ? SPACE( lmargin ) + spec_char + &expanded;
             + SPACE( ( box_w - 2 );
             - LEN( &expanded ) ) + spec_char
      linecnt = SUBSTR( STR( VAL( linecnt ) + 101 ,3) , 2, 2 )
   ENDDO
   * ---Printing trailing lines.
   pline = 1
   DO WHILE pline < ( box_h - nexp )
      ? SPACE( lmargin ) + spec_char;
             + SPACE( box_w - 2 ) + spec_char
      pline = pline + 1
   ENDDO
   * ---Print footing line.
   ? SPACE( lmargin ) + box_line
   * ---Skip lines between labels.
   pline = 1
   DO WHILE pline < ( box_h - nexp )
      ?
      pline = pline + 1
   ENDDO
   SKIP
ENDDO
IF printer = "Y"
   * ---Flush print buffer.
   ?  
   SET PRINT OFF
   SET CONSOLE ON
ENDIF
CLOSE DATABASES
RETURN
* EOP Label2.PRG