program Calendar; { 1st version }

{ ========================================================================= }
{                                                                           }
{              ANNUAL CALENDAR FOR THE XIX, XX AND XXI CENTURIES            }
{                                                                           }
{ --->  Prints or saves in disk a calendar of a given year (from 1800 to    }
{       2099).                                                              }
{                                                                           }
{       Usage:  [C:\] CALENDAR [year] [target] [option1] [option2]          }
{                                                                           }
{               where                                                       }
{                       year = integer in interval [1800, 2099] or [0, 99]  }
{                                                                           }
{                       target = P (printer) or D (disk)                    }
{                                                                           }
{                       option1 = B (bold) or N (normal), if target = P;    }
{                       option1 = file_name, if target = D                  }
{                                                                           }
{                       option2 = M, to include user messages               }
{                                                                           }
{       Examples: [C:\] CALENDAR 1992                                       }
{                 [C:\] CALENDAR 2001 D c:\texts\2001.doc                   }
{                 [C:\] CALENDAR 1822 P N                                   }
{                 [C:\] CALENDAR 1993 D calendar.txt m                      }
{                                                                           }
{       (C) 1989, 1992 by Lenimar N. Andrade - CCENDM03@BRUFPB.BITNET       }
{                                                                           }
{ ========================================================================= }

uses
  Printer, Draw;

{ ------------------------------------------------------------------------- }

type
  StrMatrix1    = array[1..6, 1..7] of string[85];
  StrMatrix2    = array[0..60] of string[85];
  IntegerMatrix = array[1..12] of integer;
  BooleanMatrix = array[0..60] of boolean;

var
  i, j, k, year, QuantMessages,         { I'm sorry for the }
           esp1, esp2, cod: integer;    { fact this program }
  mat1, mat2, mat3: StrMatrix1;         { owns   too   many }
  msg: StrMatrix2;                      { global variables. }
  auxiliar, name: string[90];           { I still  hope  in }
  overwrite, mens, target,              { the future rewri- }
                   LetterType: char;    { te it.            }
  arq: text;

const
  mold: array[1..6] of char = (#201, #205, #187, #186, #188, #200);
  QuantDaysInMonth: IntegerMatrix =
                  (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

{ ------------------------------------------------------------------------- }

function Cal(day, month, year: integer): integer;

{ Are furnished as parameters the day, month and year and is returned the day
  of week associated to day/month/year: -5 = saturday, 1 = sunday, 0 = monday,
  -1 = tuesday, -2 = wednsday, -3 = thursday, -4 = friday. }

var
  a, b, c, d, sum: integer;
  AnoBissexto: boolean; { tells whether february has 29 days or not }

begin
  if (year < 100) then year := year + 1900;
  if (year < 1800) or (year > 2099) then Exit;
  if ((year mod 4 = 0) and (year mod 100 <> 0)) or (year mod 400 = 0) then
    AnoBissexto := true
  else
    AnoBissexto := false;
  case month of
     1 : if AnoBissexto then d := 0 else d := 1;
     2 : if AnoBissexto then d := 3 else d := 4;
     3 : d := 4;
     4 : d := 0;
     5 : d := 2;
     6 : d := 5;
     7 : d := 0;
     8 : d := 3;
     9 : d := 6;
    10 : d := 1;
    11 : d := 4;
    12 : d := 6;
  end;
  a := year mod 100;
  b := a div 4;
  c := day;
  sum := a + b + c + d;
  if (year >= 2000) then sum := sum + 6;
  if (year <= 1899) then sum := sum + 2;
  case (sum mod 7) of
    0 : Cal := -5; { saturday  }
    1 : Cal :=  1; { sunday    }
    2 : Cal :=  0; { monday    }
    3 : Cal := -1; { tuesday   }
    4 : Cal := -2; { wednesday }
    5 : Cal := -3; { thursday  }
    6 : Cal := -4; { friday    }
  end;
end;

{ ------------------------------------------------------------------------- }

procedure Bold; { Warning: it depends on printer's type }

begin
  Write(Lst, #27, 'E')
end;

{ ------------------------------------------------------------------------- }

procedure NotBold; { Warning: it depends on printer's type }

begin
  Write(Lst, #27, 'F')
end;

{ ------------------------------------------------------------------------- }

procedure PrintsYear(n: integer);

var
  alg1, alg2, alg3, alg4, i: integer;
  DrawnYear: array[1..14] of string[90];
  aux: string;

begin
  alg4 := n mod 10;
  n := n div 10;
  alg3 := n mod 10;
  n := n div 10;
  alg2 := n mod 10;
  n := n div 10;
  alg1 := n mod 10;

  if (target = 'D') then
    Writeln(arq, messages[6])
  else
    Writeln(Lst, messages[6]);
  for i := 1 to 14 do
    DrawnYear[i] := '*        ' + number[alg1,i] + '       ' + number[alg2,i]
      + '       ' + number[alg3,i] + '       ' + number[alg4,i] + '        *';

    for i := 1 to 14 do
      if (target = 'D') then
        Writeln(arq, DrawnYear[i])
      else
        Writeln(Lst, DrawnYear[i]);
    if (target = 'D') then
      Writeln(arq, messages[6])
    else
      Writeln(Lst, messages[6]);
end;

{ ------------------------------------------------------------------------- }

procedure FormatsMonth(var m: StrMatrix1; QuantDias, DiaDaSemana: integer);

var
  cont: integer;
  aux: array[1..6, 1..7] of integer;

begin
  for i := 1 to 6 do
    for j := 1 to 7 do
      if (i = j) and (i = 1) then
        aux[i,j] := DiaDaSemana
      else
        if i = 1 then
          aux[i, j] := 1 + aux[i, j - 1]
        else
          aux[i, j] := 7 + aux[i - 1, j];

  for i := 1 to 6 do
    for j := 1 to 7 do
      if (aux[i, j] <= 0) or (aux[i, j] > QuantDias) then
        m[i,j] := '   '
      else
        Str(aux[i, j]:3, m[i, j]);
end;

{ ------------------------------------------------------------------------- }

procedure FormatsCalendar(var line: StrMatrix2; var impressao: BooleanMatrix);

var
  i, j, k, blanks: integer;

begin
  for k := 1 to 4 do begin
    line[13*(k - 1)] := messages[2];
    line[13*(k - 1) + 1] := messages[1];
    line[13*(k - 1) + 2] := messages[2];
    line[13*(k - 1) + 3] := months[k];
    line[13*(k - 1) + 4] := messages[3];
    line[13*(k - 1) + 5] := messages[4];
    line[13*(k - 1) + 6] := messages[3];
    FormatsMonth(mat1, QuantDaysInMonth[3*(k - 1) + 1],
                                                Cal(1, 3*(k - 1) + 1, year));
    FormatsMonth(mat2, QuantDaysInMonth[3*(k - 1) + 2],
                                                Cal(1, 3*(k - 1) + 2, year));
    FormatsMonth(mat3, QuantDaysInMonth[3*(k - 1) + 3],
                                                Cal(1, 3*(k - 1) + 3, year));
    for i := 1 to 6 do
    begin
      auxiliar := '* ';
      for j := 1 to 7 do
        auxiliar := auxiliar + mat1[i, j];
      auxiliar := auxiliar + '   * ';
      for j := 1 to 7 do
        auxiliar := auxiliar + mat2[i, j];
        auxiliar := auxiliar + '   * ';
      for j := 1 to 7 do
        auxiliar := auxiliar + mat3[i, j];
      auxiliar := auxiliar + '   *';
      line[i + 6 + 13*(k - 1)] := auxiliar;
    end;
    blanks := 0;
    for j := 1 to 7 do
      if (mat1[6,j] = '   ') then blanks := blanks + 1;
    for j := 1 to 7 do
      if (mat2[6,j] = '   ') then blanks := blanks + 1;
    for j := 1 to 7 do
      if (mat3[6,j] = '   ') then blanks := blanks + 1;
    if (blanks = 21) then impressao[i + 6 + 13*(k - 1)] := false;
  end;
  line[52] := messages[2];
  line[53] := messages[1];
  line[54] := messages[5];
  line[55] := messages[1];
end;

{ ------------------------------------------------------------------------- }

procedure PrintsCalendar;

var
  line: StrMatrix2;
  impressao: BooleanMatrix;

begin

  if (LetterType = 'B') then Bold;

  if (year < 100) then year := year + 1900;
  if (year < 1800) or (year > 2099) then Halt;
  if ((year mod 4 = 0) and (year mod 100 <> 0)) or (year mod 400 = 0) then
    QuantDaysInMonth[2] := 29;

  for i := 1 to 95 do
    if (target = 'D') then
      Writeln(arq, figure[i])
    else
      Writeln(Lst, figure[i]);

  if (mens = 'Y') then
  begin
    if (target = 'D') then
      Writeln(arq, messages[6])
    else
      Writeln(Lst, messages[6]);
    for i := 1 to QuantMessages do
    begin
      esp1 := (77 - Length(msg[i])) div 2;
      if (target = 'D') then
        Write(arq,'*', ' ':esp1, msg[i])
      else
        Write(Lst, '*', ' ':esp1, msg[i]);
      esp2 := 77 - esp1 - Length(msg[i]);
      if (target = 'D') then
        Writeln(arq,' ':esp2, '*')
      else
        Writeln(Lst, ' ':esp2, '*');
    end;
    if (target = 'D') then
    begin
      Writeln(arq, messages[6]);
      Writeln(arq, messages[1]);
    end
    else
    begin
      Writeln(Lst, messages[6]);
      Writeln(Lst, messages[1]);
    end;
  end;

  for i := 0 to 60 do
    impressao[i] := true;

  PrintsYear(year);
  FormatsCalendar(line, impressao);
  for i := 1 to 55 do
    if impressao[i] then
      if (target = 'D') then
        Writeln(arq, line[i])
      else
        Writeln(Lst, line[i]);

  if (target = 'D') then
    Writeln(arq)
  else
    Writeln(Lst);

  if (LetterType = 'B') then NotBold;
end;

{ ------------------------------------------------------------------------- }

begin                                                        { Main program }
  LetterType := 'N';

  Writeln;
  Write(mold[1]);
  for i := 1 to 63 do Write(mold[2]);
  Writeln(mold[3]);
  Writeln(mold[4],
   '       ANNUAL CALENDAR FOR THE XIX, XX AND XXI CENTURIES       ', mold[4]);
  Write(mold[6]);
  for i := 1 to 63 do Write(mold[2]);
  Writeln(mold[5]);

  if (ParamCount >= 1) then
  begin
    Val(ParamStr(1), year, cod);
    if (cod <> 0) then Halt;
  end
  else
  begin
    Writeln;
    Write(#16, ' Which year do you want the calendar? ');
    Readln(year);
  end;

  if (ParamCount >= 2) then
  begin
    auxiliar := ParamStr(2);
    target := UpCase(auxiliar[1]);
  end
  else
  begin
    Writeln;
    Write(#16, ' Which is calendar''s target, (P)rinter or (D)isk? (P/D) ');
    Readln(target);
    target := UpCase(target);
  end;

  if (target = 'D') then
  begin
    if (ParamCount < 3) then
    begin
      Writeln;
      Write('  File name? (Including drive or path) ');
      Readln(name);
    end
    else
      name := ParamStr(3);
    Assign(arq, name);
    {$I-}
    Reset(arq);
    {$I+}
    if (IOResult = 0) then
    begin
      Close(arq);
      Writeln;
      Write('  File already exists. Overwrites? (Y/N) ');
      Readln(overwrite);
      if (UpCase(overwrite) <> 'Y') then Halt;
    end;
    Rewrite(arq);
  end
  else
  begin
    if (ParamCount >= 3) then
    begin
      auxiliar := ParamStr(3);
      LetterType := UpCase(auxiliar[1]);
    end
    else
    begin
      Writeln;
      Write('  Do you want (N)ormal or (B)olded letters? (N/B) ');
      Readln(LetterType);
    end
  end;

  mens := 'N';
  if (ParamCount >= 4) then
  begin
    auxiliar := ParamStr(4);
    if UpCase(auxiliar[1]) = 'M' then mens := 'Y'
  end
  else
    if (ParamCount < 3) then
    begin
      Writeln;
      Write(#16, ' Do you want to include some message in the calendar? (Y/N) ');
      Readln(mens); mens := UpCase(mens);
    end;

  if (mens = 'Y') then
  begin
    Writeln;
    Write('  How many rows has your message? ');
    Readln(QuantMessages);
    Writeln;
    for i := 1 to QuantMessages do
    begin
      Write('  Row ', i, ' : ');
      Readln(msg[i]);
    end;
  end;

  Writeln;
  if (target = 'D') then
    Write('Press [ENTER] to continue. ')
  else
    Write('Verify if the printer is ready and press [ENTER] to continue. ');
  Readln;
  Writeln;
  if (target = 'D') then
    Writeln('Saving file... ')
  else
    Writeln('Printing... ');

  PrintsCalendar;

  if (target = 'D') then Close(arq);
end.

{ ======================== END OF "CALENDAR.PAS " =========================== }