/*
 * Copyright (C) 2003 by Andrew Ziem.  All rights reserved.
 * http://chesire.freeservers.com
 * http://cday.sourceforge.net
 * 
 */

#ifndef __MAYA_H__
#define __MAYA_H__
 
/* -- includes ------------------------------------------------------- */ 
  
#include <string.h>
#ifdef __MINGW32__
#include <basetsd.h>
#endif
#include <stdio.h>
  
/* -- structures ----------------------------------------------------- */ 
  
#ifndef __MINGW32__
typedef unsigned long UINT32;	/* try basetsd.h */
#endif	/*  */
typedef struct 
{
  int baktun;			/* 1 to 13, 144000 days */
   int katun;			/* 0 to 19, 7200 days */
   int tun;			/* 0 to 19, 360 days */
   int unial;			/* 0 to 17, 20 days */
   int kin;			/* 0 to 19, each one day */
 }
 MAYALONGCOUNT;

/* -- definitions ---------------------------------------------------- */ 
  
/* #define MAYA_FIRST_JDN    584285 */
#define MAYA_FIRST_JDN    584283  
#define MAYA_FULL_ERA     13 * 144000
  
/* -- prototypes ----------------------------------------------------- */ 
extern char *MayaTzolkinDays[];
extern char *MayaHaabMonths[];
extern char *SdnToMayaLongcountStr (UINT32 JDN, char *retstr);
extern int SdnToTzolkin13 (UINT32 JDN);
extern int SdnToTzolkin20 (UINT32 JDN);
extern void SdnToHaab (UINT32 JDN, int *pMonth, int *pDay);

#endif	/* __MAYA_H__ */
