/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (c) 2003 by Andrew Ziem.  All rights reserved.
 *  http://chesire.freeservers.com
 *  http://cday.sourceforge.net
 *
 *     SHIRE.C - Shire (Tolkein) calendar
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/*
 *
 * ACKNOWLEDGEMENTS
 * Translated from Tom Braun's Shire Perl module (Shire.pm).
 */


/* Uncomment here to test */
/* #define TEST_SHIRE */

#include "shire.h"

/* Found in Yellowskin of Tuckborough.  Described in Appendix D. */
char *shire_days_archaic[] =
  { "", "Sterrendei", "Sunnendei", "Monendei", "Trewesdei",
  "Hevenesdei", "Meresdei", "Highdei"
};

/* Used in War of the Rings.  Described in LOTD Appendix D. */
char *shire_days_modern[] =
  { "", "Sterday", "Sunday", "Monday", "Trewsday", "Hevensday",
  "Mersday", "Highday"
};


char *shire_months[] =
  { "", "Afteryule", "Solmath", "Rethe", "Astron", "Thrimidge",
  "Forelithe", "Afterlithe", "Wedmath", "Halimath",
  "Winterfilth", "Blotmath", "Foreyule"
};


/*
char *shire_holidays[]=
{" ", "Yule", "1 Lithe", "Midyear's day", "2 Lithe", "1 Yule" };
*/

char *shire_holidays[] =
  { " ", "2 Yule", "1 Lithe", "Midyear's day", "Overlithe", "2 Lithe",
  "1 Yule"
};

/*
 * greg_daynum is day of year (0 to 355)
 */
struct shire_tm *
shire_date (int greg_year, int greg_month, int greg_day, int greg_daynum)
{
  int ourleap;
  int leap;
  int year;
  static struct shire_tm shire_tm1;
  static struct shire_tm *my_shire_tm;

  my_shire_tm = &shire_tm1;	/* fix me: this seems sloppy */

  my_shire_tm->sh_yday = greg_daynum;
  year = greg_year - 1900;
  my_shire_tm->sh_year = year + SHIRE_YEAR;
  /* printf("sh_year = %i\n", my_shire_tm->sh_year); */
  my_shire_tm->sh_holiday = 0;

  ourleap = 0;
  if ((0 == year % 4) && (0 == year % 100))
    ourleap = 1;
  if (0 == year % 400)
    ourleap = 1;

  leap = 0;
  year = my_shire_tm->sh_year % 400;
  if (300 == year)
    {
      if ((!ourleap && 365 == my_shire_tm->sh_yday)
	  || (ourleap && 366 == my_shire_tm->sh_yday))
	{
	  my_shire_tm->sh_yday = 1;
	  my_shire_tm->sh_year++;
	}
    }
  else if ((year > 300) && (year < 364))
    {
      if ((!ourleap && 365 == my_shire_tm->sh_yday)
	  || (ourleap && 366 == my_shire_tm->sh_yday))
	{
	  my_shire_tm->sh_yday = 1;
	  my_shire_tm->sh_year++;
	}
    }
  else if (164 == year)
    {
      my_shire_tm->sh_yday++;
    }
  else if (((year > 64) && (year < 100)) || ((year > 164) && (year < 200)))
    {
      if (1 == my_shire_tm->sh_yday)
	{
	  my_shire_tm->sh_year--;
	  if ((0 == my_shire_tm->sh_year % 4)
	      && (0 != my_shire_tm->sh_year % 100))
	    leap = 1;
	  if (0 == my_shire_tm->sh_year % 400)
	    leap = 1;
	  if (leap)
	    my_shire_tm->sh_yday = 366;
	  else
	    my_shire_tm->sh_yday = 365;
	}
      else
	{
	  my_shire_tm->sh_yday--;
	}
    }
  else if ((100 == year) || (200 == year))
    {
      if (1 == my_shire_tm->sh_yday)
	{
	  --my_shire_tm->sh_year;
	  my_shire_tm->sh_yday = 365;
	}
      else
	my_shire_tm->sh_yday--;
    }

  if ((0 == my_shire_tm->sh_year % 4) && (0 != my_shire_tm->sh_year % 100))
    leap = 1;
  if (0 == my_shire_tm->sh_year % 400)
    leap = 1;
  if (leap && my_shire_tm->sh_yday > 365)
    ++my_shire_tm->sh_year;
  else if (my_shire_tm->sh_yday > 355 && !leap)
    my_shire_tm->sh_year++;

  if (leap)
    {
      if (174 == my_shire_tm->sh_yday)
	{
	  my_shire_tm->sh_holiday = 4;	/* Overlithe */
	}
    }

  if (!my_shire_tm->sh_holiday)
    {
      switch (my_shire_tm->sh_yday)
	{

	case 356:
	  my_shire_tm->sh_holiday = 1;	/* Yule */
	  break;
	case 172:
	  my_shire_tm->sh_holiday = 2;	/* Lithe */
	  break;
	case 173:
	  my_shire_tm->sh_holiday = 3;	/* Midyyear's day */
	  break;
	case 174:
	  my_shire_tm->sh_holiday = 5;	/*2 Lithe */
	  break;
	case 355:
	  my_shire_tm->sh_holiday = 6;	/* 1 Yule */
	  break;
	}

    }

  /* figure day of the week */

  if (my_shire_tm->sh_yday > 172)
    {
      my_shire_tm->sh_yday--;
    }

  if (3 == my_shire_tm->sh_holiday || 4 == my_shire_tm->sh_holiday)
    {
      my_shire_tm->sh_wday = 0;
    }
  else
    {
      my_shire_tm->sh_wday = ((my_shire_tm->sh_yday + 2) % 7) + 1;
    }

  /* figure month and day of month */

  if (my_shire_tm->sh_holiday)
    {
      /* holidays are excluded from months/dom */
      my_shire_tm->sh_mon = 0;
      my_shire_tm->sh_mday = 0;
    }
  else
    {
      --my_shire_tm->sh_yday;	/* 2 Yule */
      if (my_shire_tm->sh_yday > 172)
	{
	  my_shire_tm->sh_yday -= 2;	/* Lithe and 2 Lithe */
	}
      my_shire_tm->sh_yday += 9;
      if (my_shire_tm->sh_yday > 361)
	{
	  my_shire_tm->sh_yday -= 362;
	}
      my_shire_tm->sh_mday = (my_shire_tm->sh_yday % 30) + 1;
      my_shire_tm->sh_mon = (my_shire_tm->sh_yday / 30) + 1;
    }

  return (my_shire_tm);

}

#ifdef TEST_SHIRE
int
main ()
{
  struct shire_tm *my_shire_tm;
  struct tm *my_tm;
  time_t t;


  tzset ();
  t = time (NULL);
  my_tm = localtime (&t);

  my_shire_tm =
    shire_date (my_tm->tm_year + 1900, my_tm->tm_mon + 1, my_tm->tm_mday,
		my_tm->tm_yday);

  if (my_shire_tm->sh_holiday)
    {
      printf ("holiday = %i\n", my_shire_tm->sh_holiday);
    }

  printf ("shire: year = %i, month = %i, day = %i\n", my_shire_tm->sh_year,
	  my_shire_tm->sh_mon, my_shire_tm->sh_mday);

  printf ("shire: %s %i %s %i\n", shire_days_archaic[my_shire_tm->sh_wday],
	  my_shire_tm->sh_mday, shire_months[my_shire_tm->sh_mon],
	  my_shire_tm->sh_year);


}

#endif
