#include "help.h"
#include <fstream.h>
#include "calendar.h"
#include "mouser.h"
#include <graphics.h>
#include <string.h> // for strcat

calendar::calendar (int m, int y, bstring hm, Mcursor & mouse) :
	the_data(hm), the_days(33), buttons(40), the_mouse (mouse)
	{
	maxx = getmaxx();
	maxy = getmaxy();

	home = hm;

	the_color = BLUE;
	the_add = 0;

	bstring temp_data = "DATA";
	bstring new_home = hm + temp_data;
	credit_icon.init (10,maxy-40,new_home.return_string());

	total_buttons = 0;
	the_search = 0;
	month = m;
	day = 0;
	year = y;
	if (maxy > 400)
		spacing = 50;
	else
		spacing = 0;
	}

calendar::~calendar()
	{
	}

void calendar::search ()
	{
	Gstring	search_string;

	setcolor (WHITE);
	settextjustify (LEFT_TEXT, TOP_TEXT);

	Panel textpanel;
	textpanel.init (maxx-190,220,180,65, IN, THICK);
	textpanel.show();

	gprintxy (maxx-180,230,"Enter text to");
	gprintxy (maxx-180,240,"search for:");

	search_string.init (maxx-180,265,18,1); // uppercase only
	search_string.show();
	search_string.get_input();

	the_string = search_string.getstring();

	if (the_string.length())
		the_search = 1;
	else
		clear_search();
	}


int calendar::show (int mode)
	{
	show_display();
	int result = loop (mode);

	return result;
	}

int calendar::loop (int mode)
	{
	int prepare = 1;
	int exit = 0;

	while (!exit)
		{
		if (prepare)
			display (mode);

		mouser 	read_mouse (buttons, total_buttons, the_mouse,
				num_days+2);

		if (prepare)
			read_mouse.show();

		prepare = 0;

		char keypress;
		char option = read_mouse.get (keypress);

		if (option < num_days && option >= 0)
			{
			if (the_days[option+1] || the_add)
				{
				day = option + 1;
				exit = 1;
				}
			}

		if ((option == -1 && keypress == 27) || option == num_days+2)
			exit = -1;

		if (option == num_days)
			{
			month++;
			prepare = 1;
			}

		if (option == num_days+1)
			{
			month--;
			prepare = 1;
			}

		if (option == num_days+3)
			{
			jump_to_date();
			prepare = 1;
			}

		if (option == num_days+4)
			credit();

		if (option == num_days+5)
			{
			search();

			if (the_search)
				exit = -1;
			}

		if (option == num_days+7)
			{
			calendar_help ();
			prepare = 1;
			}

		if (option == num_days+6)
			{
			add ();

			if (the_add)
				exit = -1;
			else
				{
				prepare = 1;
				gr_clear ();
				show_display();
				}
			}

		if (month > 12)
			{
			month = 1;
			year++;
			prepare = 1;
			}
		if (month < 1)
			{
			month = 12;
			year--;
			prepare = 1;
			}
		}
	return (exit);
	}

void calendar::display (int mode)
	{
	clear_calendar();

	if (mode)
		find_days ();

	show_titles ();
	if (the_color == BLUE)
		set_buttons ();
	if (the_color == LIGHTBLUE)
		set_buttons (1);
	show_tiles ();
	}

void calendar::calendar_help ()
	{
	clear_calendar ();

	bstring temp_filename = "IMPRO.HL1";
	bstring help_location = home + temp_filename;

	help the_help (the_mouse, help_location);

	the_help.show ();
	}


void calendar::set_buttons (int add_mode)
	{
	num_days = manip.DaysInMonth (month, year);

	char	button_info[4];

	int go_h = maxx/2 - 114;
	go_h += manip.DayOfWeek(char(1),char(month),year) * 34;
	int go_v = 140 + spacing;

	for (int ctr = 1; ctr <= num_days; ctr++)
		{
		button_info[0] = '\0';

		if (ctr < 10)
			strcat (button_info, " ");
		else
			button_info[0] = char((ctr/10)+48);

		button_info[1] = char ((ctr%10)+48);
		button_info[2] = '\0';

		buttons[ctr-1].init (go_h, go_v, button_info, TEXT);

		if (manip.DayOfWeek ((char) ctr, (char) month, year) == 6)
			{
			go_v += 36;
			go_h = maxx/2 - 148;
			}
		go_h += 34;
		}

	// set other buttons
	buttons [num_days].init (10,160, " Next Month ", TEXT);
	buttons [num_days+1].init (10,190, " Last Month ", TEXT);
	buttons [num_days+2].init ((maxx-75),(maxy-30)," EXIT ",TEXT);
	buttons [num_days+3].init (10,220, " Go To Date ", TEXT);
	total_buttons = num_days+4;

	if (!add_mode)
		{
		buttons [num_days+4].init ((maxx-75),(maxy-60)," Info ",TEXT);
		buttons [num_days+5].init ((maxx-95),190, " Search ", TEXT);
		buttons [num_days+6].init ((maxx-95),160, "  Add   ",TEXT);
		buttons [num_days+7].init ((maxx-75),(maxy-90), " Help ",TEXT);
		total_buttons = num_days+8;
		}
	}

void calendar::add ()
	{
	the_color = LIGHTBLUE;

	gr_clear ();

	write3d (20,"ADD/EDIT AN EVENT");
	write3d (40,"At this time you need to pick the date your event will start on.");
	write3d (60,"To do this use the NEXT MONTH button to move forward a month, the LAST MONTH");
	write3d (70,"button to move back a month, or the GO TO DATE button to move to a specific");
	write3d (80,"month and year.");
	write3d (90,"When the calendar is displaying the correct month and year click the day");
	write3d (100,"on the calendar that you want the event to start on.");

	the_add = 1;

	loop ();

	if (!day)
		the_add = 0;

	the_color = BLUE;
	}

void calendar::jump_to_date ()
	{
	Gstring	g_month;
	Gstring g_year;

	setcolor (WHITE);
	settextjustify (LEFT_TEXT, TOP_TEXT);

	Panel textpanel;
	textpanel.init (10,maxy-220,150,90, IN, THICK);
	textpanel.show();
	gprintxy (20,maxy-190,"Month: ");
	g_month.init (90,maxy-190,2,0);
	g_month.show();
	g_month.get_input();
	int month_num = 0;
	bstring month_string;
	month_string = g_month.getstring();
	if (strlen(month_string) == 2)
		month_num = ((month_string[0]-48) * 10) + month_string[1] -48;
	else
		month_num = month_string[0] - 48;
	if (month_num < 1 || month_num > 12)
		{
		clear_date();
		return;
		}

	setcolor (WHITE);
	settextjustify (LEFT_TEXT, TOP_TEXT);

	gprintxy (20,maxy-160,"Year: ");
	g_year.init (90,maxy-160,4,0);
	g_year.show();
	g_year.get_input();
	int year_num = 0;
	bstring	year_string;
	year_string = g_year.getstring();
	if (strlen(year_string) != 4)
		{
		clear_date();
		return;
		}
	else
		{
		year_num = (year_string[0]-48) * 1000 + (year_string[1]-48) * 100 +
			(year_string[2]-48) * 10 + (year_string[3]-48);
		}

	clear_date();

	if (!year_string || year_num < 1900)
		return;

	month = month_num;
	year = year_num;
	}

void calendar::clear_calendar()
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,the_color);
	bar (130,90+(spacing*the_add),maxx-130,maxy);
	setcolor (BLUE);
// left
	line (maxx-77,maxy-32,maxx-77,maxy-9);
// top
	line (maxx-77,maxy-32,maxx-16,maxy-32);
// bottom
	line (maxx-77,maxy-9,maxx-16,maxy-9);
// right
	line (maxx-16,maxy-32,maxx-16,maxy-9);
	}

void calendar::clear_search ()
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,the_color);
	bar (maxx-190,220,maxx-10,285);
	}

void calendar::clear_date ()
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,the_color);
	bar (10,maxy-220,160,maxy-130);
	}


void calendar::find_days ()
	{
	the_days[0] = 1;
	long int loc = 0;

	for (int ctr = 1; ctr < 33; ctr++)
		the_days [ctr] = 0;

	do
		{
		loc = the_data.realquickfind (month, 0, year, ++loc);

		if (loc && the_data.occur_level > the_days [the_data.real_day])
			the_days [the_data.real_day] = the_data.occur_level;
		}
	while (loc);

	}

void calendar::write3d (int y,char *text)
	{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(BLACK);
	outtextxy(getmaxx()/2,y,text);
	setcolor(WHITE);
	outtextxy((getmaxx()/2)-1,y-1,text);
	}

void calendar::show_display ()
	{
	Bevel	info_panel;

	gr_clear();

	the_mouse.hide();

	info_panel.init(0,0,maxx,80,THICK);
	info_panel.show();

	info_panel.show();

	settextjustify (LEFT_TEXT, TOP_TEXT);
	setcolor (WHITE);
	moveto (10,10);
	outtext ("The calendar display works like a stoplight:");
	setcolor (RED);
	moveto (10,30);
	outtext ("A red box ");
	setcolor (WHITE);
	outtext ("indicates a very important event.");
	setcolor (YELLOW);
	moveto (10,40);
	outtext ("A yellow box ");
	setcolor (WHITE);
	outtext ("indicates an important event.");
	setcolor (LIGHTGREEN);
	moveto (10,50);
	outtext ("A green box ");
	setcolor (WHITE);
	outtext ("indicates a non-essential event.");
	setcolor (BLACK);
	moveto (10,60);
	outtext ("An empty (black) box ");
	setcolor (WHITE);
	outtext ("indicates no event has been scheduled.");

	credit_icon.show (22);
	}

void calendar::credit ()
	{
	for (int i = 0; i < 22; i++)
		{
		credit_icon.show (i+1);
		delay (200);
		}
	}

void calendar::show_titles ()
	{
//	char	*these_days[] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
	vector<bstring>	these_days(7);
	these_days[0] = "Sun";
	these_days[1] = "Mon";
	these_days[2] = "Tue";
	these_days[3] = "Wed";
	these_days[4] = "Thu";
	these_days[5] = "Fri";
	these_days[6] = "Sat";

	settextjustify (CENTER_TEXT, TOP_TEXT);
	setcolor (CYAN);
	gprintxy (maxx/2,90+spacing,"%s %d",manip.MonthName ((char)month),year);
	setcolor (BROWN);
	settextjustify (LEFT_TEXT, TOP_TEXT);

	for (int ctr = 0; ctr < 7; ctr++)
		{
		int x1 = maxx/2-115+(ctr * 34);
		outtextxy (x1,110+spacing,these_days[ctr]);
		}

	gifford	df;
	date	d;
	getdate (&d);

	bstring the_string = "Today is ";
	the_string += df.DayName (df.DayOfWeek (d.da_day, d.da_mon, d.da_year));
	the_string += " ";
	the_string += df.pretty_date (d.da_mon, d.da_day, d.da_year);

	write3d (maxy-20,the_string.return_string());
	}


void calendar::show_tiles ()
	{
	int x1, x2, y1, y2;
	int liner = 0;

	setcolor (WHITE);
	setlinestyle (SOLID_LINE, 0xFFFF, 1);

	for (int ctr = 1; ctr <= num_days; ctr++)
		{
		int this_color = BLACK;

		if (the_days[0] && the_days [ctr] == 3)
			this_color = RED;
		if (the_days[0] && the_days [ctr] == 2)
			this_color = YELLOW;
		if (the_days[0] && the_days [ctr] == 1)
			this_color = LIGHTGREEN;

		setfillstyle (SOLID_FILL, this_color);

		x1 = maxx/2-119+(manip.DayOfWeek ((char) ctr, (char) month,
			 year) * 34);
		x2 = maxx/2-119+((manip.DayOfWeek ((char) ctr, (char) month,
			 year)+1)*34);
		y1 = 130 + spacing + (liner * 36);
		y2 = 130 + spacing + ((liner+1) * 36);

		bar3d (x1,y1,x2,y2,0,0);

		if (manip.DayOfWeek ((char) ctr, (char) month, year) == 6)
			liner++;

		}
	}

void calendar::gr_clear (void)
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,the_color);
	bar (0,0,maxx,maxy);
	}