#include "grafmess.h"
#include "gifford.h"
#include <ctype.h> // for tolower
#include "mouser.h"

grafmess::grafmess (Mcursor & mouse) : buttons (7), the_mouse (mouse)
	{
	day = 0;
	}

grafmess::~grafmess()
	{
	}

/* void grafmess::init (Mcursor & mouse)
	{
	the_mouse = mouse;
	} */

int grafmess::num_buttons (int how_many)
	{
	int exit = 0;

	buttons [0].init ((getmaxx()-75),(getmaxy()-30)," DONE ",TEXT);

	for (int i = 1; i <= how_many; i++)
		{
		char destination[5];
		for (int j = 0; j < 2; j++)
			destination[j] = ' ';
		destination[2] = char(i+48);
		for (int k = 3; k < 5; k++)
			destination[k] = ' ';
		destination[5] = '\0';

		buttons[i].init (10,30+(80*(i-1)),destination,TEXT);
		}

	mouser 	read_mouse (buttons, how_many+1, the_mouse);
	read_mouse.show();


	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		keypress = tolower (keypress);


		if ((option == -1 && keypress == 27) || option == 0)
			exit = -1;
		if (option > 0)
			exit = option;
		if (option == -1 && (keypress-48) >= 1 && (keypress-48) <= how_many)
			exit = keypress-48;
		}
	return exit;
	}

int grafmess::remove_graphics (int how_many)
	{
	Bevel question;
	question.init(8,getmaxy()-70,323,60,THICK);


	int num;

	if (how_many > 1)
		{
		clear_bottom();
		question.show();

		Gtext which;
		which.init(25,getmaxy()-45,"Which item do you wish to delete?",0,7,1);
		which.show();
		num = num_buttons(how_many);
		if (num == -1)
			{
			clear_bottom();
			return num;
			}
		}
	else
		{
		num = 1;
		}

	clear_bottom();

	question.show();

	Gtext sure;
	sure.init(19,getmaxy()-60,"Are you sure you want to delete this?",0,7,1);
	sure.show();

	buttons[0].init(76,getmaxy()-40," Yes ",TEXT);
	buttons[1].init(154,getmaxy()-40," No ",TEXT);

	mouser 	read_mouse (buttons, 2, the_mouse, 0);
	read_mouse.show();

	int exit = 0;

	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		keypress = tolower (keypress);

		if (option == 0)
			{
			clear_bottom();
			return num;
			}
		if (option == 1)
			exit = 1;
		if (option == -1 && keypress == 'y')
			{
			clear_bottom();
			return num;
			}
		if (option == -1 && keypress == 'n')
			exit = 1;
		}
	clear_bottom();

	return (-1);
	}

void grafmess::write3d (int y,char *text)
	{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(BLACK);
	outtextxy(getmaxx()/2,y,text);
	setcolor(WHITE);
	outtextxy((getmaxx()/2)-1,y-1,text);
	}


void grafmess::no_match ()
	{
	Bevel saver;

	saver.init (122, 185, 396, 100, THICK);
	saver.show ();

	write3d (205,"All your records were checked, but no match");
	write3d (215,"was found.");

	buttons[0].init(getmaxx()/2-20,245," OK ",TEXT);

	mouser 	read_mouse (buttons, 1, the_mouse, 0);
	read_mouse.show();

	int exit = 0;

	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if (option == 0)
			exit = 1;
		}
	}


int grafmess::edit_graphics (int how_many)
	{
	Bevel question;
	question.init(8,getmaxy()-70,323,60,THICK);

	int num;

	if (how_many > 1)
		{
		clear_bottom();
		question.show();

		Gtext which;
		which.init(25,getmaxy()-45,"Which item do you wish to edit?",0,7,1);
		which.show();
		num = num_buttons(how_many);
		}
	else
		num = 1;

	clear_bottom();

	return num;
	}


void grafmess::clear_bottom ()
	{
	the_mouse.hide ();

	setfillstyle (SOLID_FILL, BLACK);
	bar (0,getmaxy()-70,getmaxx(),getmaxy());

	the_mouse.show ();
	}


int grafmess::bottom_buttons (int more, int noupdate)
	{
	if (noupdate > 1)
		noupdate = 1;

	int exit = 0;
	int tb = 5 - noupdate;

	if (!noupdate)
		buttons [4].init ((getmaxx()-147),(getmaxy()-60), " DONE & UPDATE ",TEXT);

	buttons [3].init ((getmaxx()-75),(getmaxy()-30)," DONE ",TEXT);
	buttons [0].init (10,(getmaxy()-30)," Edit ",TEXT);
	buttons [1].init (80,(getmaxy()-30)," Delete ",TEXT);
	buttons [2].init ((getmaxx()-147),(getmaxy()-30), " Help ",TEXT);

	int outline;

	if (more == 1 || more == 3)
			buttons [tb++].init (getmaxx()/2-60,(getmaxy()-30),"     More      ",TEXT);

	outline = tb - 1;

	if (more == 2 || more == 3)
			buttons [tb++].init (getmaxx()/2-60,(getmaxy()-60),"  Back a Page  ",TEXT);


	mouser  read_mouse (buttons, tb, the_mouse, outline);
	read_mouse.show();

//	the_mouse.arm ();
//	the_mouse.show ();


	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		if ((option == -1 && keypress == 27) || option == 3)
			exit = 1; // exit

		if (option == 0)
			exit = 2; // edit

		if (option == 1)
			exit = 3; // delete

		if (option == 2)
			exit = 7; // help

		if (!noupdate && option == 4)
			exit = 4; // exit & update

		if (more == 1 && option == (tb-1))
			exit = 5; // more

		if (more == 2 && option == (tb-1))
			exit = 6; // back a page

		if (more == 3)
			{
			if (option == (tb-2))
				exit = 5; // more
			if (option == (tb-1))
				exit = 6; // back a page
			}

	}

	return exit;
	}

void grafmess::show_panels_set (int m, int d, int y)
	{
	month = m;
	day = d;
	year = y;
	}

void grafmess::show_panels(int panel_num, data the_data, int calendar_mode)
	{
	the_mouse.hide ();

	assert (day);

	Panel	test_panel;

	test_panel.init (70,5+(80*panel_num),getmaxx()-80,75,OUT,THICK);
	test_panel.show ();


	switch (the_data.occur_level)
		{
		case 1:
			setcolor (LIGHTGREEN);
			break;
		case 2:
			setcolor (YELLOW);
			break;
		case 3:
			setcolor (RED);
			break;
		}
	settextjustify (LEFT_TEXT, CENTER_TEXT);

	gifford	       date_functions;

	unsigned short t_date = date_functions.ConvertJulian (day, month, year);
	unsigned short f_date = date_functions.ConvertJulian (the_data.next_day,
				the_data.next_month, the_data.next_year);
	unsigned short r_date = date_functions.ConvertJulian (the_data.real_day,
				the_data.real_month, the_data.real_year);


	bstring the_level;

	if (calendar_mode)
		f_date = r_date;

	if (r_date > t_date && r_date > f_date)
		{
		the_level = "Warning for a";
		setcolor (MAGENTA);
		}
	else
		the_level = "A";

	switch (the_data.occur_level)
		{
		case 1:
			the_level += " nonessential event";
			break;
		case 2:
			the_level += "n important event";
			break;
		case 3:
			the_level += " very important event";
			break;
		}


	if (t_date > r_date)
		the_level += " you missed";

	the_mouse.hide ();

	if (r_date > t_date && r_date > f_date)
		{
		unsigned short calc_julian = r_date - t_date;

		gprintxy (85,15+(80*panel_num),"%s on %s %d, %d (in %d days)",
			the_level.return_string(),date_functions.MonthName(the_data.real_month),
			the_data.real_day,the_data.real_year, calc_julian);
		}
	else
		gprintxy (85,15+(80*panel_num),"%s sheduled for %s %d, %d",
			the_level.return_string(),date_functions.MonthName(the_data.real_month),
			the_data.real_day,the_data.real_year);



	setcolor (BLACK);

	for (int j = 0; j < the_data.note.length(); j++)
		{
		gprintxy (85, 35+(10*j)+(80*panel_num),"%s",the_data.note[j].return_string());
		}

	}


