/* this class is by jeff goke.  jjgoke@cs.csbsju.edu

	STRIPPED DOWN VERSION!  */

#include <assert.h>
#include "mouser.h"
#include <conio.h>

mouser::mouser (const vector<Button> & the_buttons, const int & the_number, Mcursor & mouse, int def) : buttons(the_number), the_mouse (mouse)
	{
	the_default = def;
	buttons = the_buttons;
	num_buttons = the_number;
	}

mouser::~mouser()
	{
	}

void mouser::init  (const vector<Button> & the_buttons, const int & the_number, int def)
	{
	the_default = def;
	buttons = the_buttons;
	num_buttons = the_number;
	}


void mouser::show (void)
	{
	the_mouse.hide();

	for (int i = 0; i < num_buttons; i++)
		buttons[i].show();

	if (the_default >= 0)
		buttons[the_default].outline(WHITE, 2);

	the_mouse.show ();
	}


int mouser::get (char & keypress)
	{
	assert (the_default < num_buttons);

	int option = -1;

	the_mouse.show();

	while (!check_buttons(option) && !kbhit());

	if (kbhit())
		{
		keypress = getch();

		if (the_default >= 0 && keypress == 13)
			option = the_default;

		flushkeys();
		}

	return option;
	}


int mouser::check_buttons(int & option)
	{
	if (!the_mouse.LBP())
		return 0;

	for (int ctr = 0;ctr < num_buttons;ctr++)
		{
		if(buttons[ctr].hit())
			{
			buttons[ctr].press();
			while (the_mouse.LBP() && buttons[ctr].hit());
				buttons[ctr].show();

			if (buttons[ctr].hit())
				{
				option = ctr;
				return 1;
				}
			}
		}
	return 0;
	}

