/*  *************  FICHICI 1.0
 *  fichici.c   Checks the specified pathname for a file with the
 *              current date.
 *                        ******************************
 *                        **   (c) Dave Vernest       **
 *                        **  Arts Computing Office   **
 *                        **  University of Waterloo  **
 *                        **      June 23, 1993       **
 *                        ******************************
 *              Compiled in Borland Turbo C 2.0
 *
 *              SYNTAX:
 *                       fichici <PATHNAME>
 * SYSTEM DOCS:
 *      First the system date is obtained. Then files in the specified
 *      path are accessed one by one, and their dates compared
 *      with the system date.
 *      If there is a match, ERRORLEVEL returns 0.
 *      Otherwise,           ERRORLEVEL returns 1.
 */
 #include <dir.h>       /* ref by findfirst */
 #include <io.h>        /* ref by getftime */
 #include <dos.h>       /* ref by getdate */
 #include <sys\stat.h>  /* ref by bit ops */

/* function prototypes */
void error_checking(int argc,char **argv);
void user_help();
void sysdate(struct date *sys_info);
int  compare_dates(struct date sys_info, struct ffblk file_info);

int main(int argc,char **argv)   {
    struct date sys_info;       /* holds system dates */
    struct ffblk file_info;     /* holds file info */
    char pathname[50];          /* directory being searched */
    int filegone=0,             /* returns 0 if not eof */
	found=0,                /* returns 0 if a file with today's
				      date is found */
	errorlevel=0;           /* returns 0 if a file is found, 1 if not */

   error_checking(argc,argv);

   sysdate(&sys_info);          /* gets system date */

   strupr(argv[1]);             /* convert pathname to upper-case */
   filegone=findfirst(argv[1],&file_info,0);  /* finds first file */

   found=compare_dates(sys_info,file_info);

   while (!filegone)   {
	if (found==0) {
			break;      /* if found, break out of loop */
	}

	 filegone=findnext(&file_info);
	found=compare_dates(sys_info,file_info);
   }

   if (found==0) {
		return (errorlevel=0);
	}
	    else {
		return (errorlevel=1);
   }
}     /* end main */


void error_checking(int argc,char **argv) {
	char *drive="",
	     *dir="",
	     *name="",
	     *ext="";
	int path_test;

	if (!(argc==2)) {
		user_help();
		exit(1);
	}
/* fnsplit return flags defined in dir.h
 * #define WILDCARDS 0x01
 * #define EXTENSION 0x02
 * #define FILENAME  0x04
 * #define DIRECTORY 0x08
 * #define DRIVE     0x10
 */
	path_test=fnsplit(argv[1],drive,dir,name,ext);
	if (!(path_test & DRIVE)) {
			printf("ERROR: Pathname must include drive.\n");
			exit(1);
	}

	if ( !(path_test & FILENAME)  &&
	     !(path_test & WILDCARDS)) {
			printf("ERROR: Pathname must include filename or wildcards\n");
			exit(1);
	}

	}
void user_help() {

char *help;

help= "*************  FICHICI 1.0          FILEDATE CHECKING UTILITY\n"
"								    \n"
"			  ******************************	    \n"
"			  **   (c) Dave Vernest       **            \n"
"			  **  Arts Computing Office   **            \n"
"			  **  University of Waterloo  **            \n"
"			  **      June 23, 1993       **            \n"
"			  ******************************            \n"
"                                                                   \n"
"SYNTAX                                                             \n"
"	fichici PATHNAME                                            \n"
"\n"
"	ex. fichici C:\USER\TMP\*.*                                 \n"
"                                                                   \n"
"DESCRIPTION                                                        \n"
"	This is a file that searches the specified pathname for files\n"
"	matching the current system date. This utility is designed to be\n"
"	used in a DOS batch file, hence the returning errorcodes. \n"
"                                                                 \n"
"	Files in the specified path are accessed one by one, and their\n"
"	dates compared with the system date.                            \n"
"	If there is a match, ERRORLEVEL returns 0.                      \n"
"	Otherwise,           ERRORLEVEL returns 1.                      \n";
system("cls");
printf("%s",help);
}

int compare_dates(struct date sys_info, struct ffblk file_info) {
   int file_day,
       file_month,  /* date info for files */
       file_year;

   /* Values for converted from bit form to integer form:
    * for file_year below
    * 111111100000000 --mask for year comparison (0xfe00)
    * 000100000000000 --for year 1988
    * 000100000000000 --result
    * 0001000 (/512)  --chops off low-order bits (shift)
    */
   file_day  =(0x001f & file_info.ff_fdate)/1;
   file_month=(0x01e0 & file_info.ff_fdate)/32;
   file_year=((0xfe00 & file_info.ff_fdate)/512) + 1980;
   /* ff_fdate measures years since 1980, therefore 1980 must be added
    * to get a full year value
    */
   return !(((sys_info.da_day==file_day) &&     /* returns 0 if file date */
	     (sys_info.da_mon==file_month) &&   /* matches system date */
	     (sys_info.da_year==file_year)));
}

void sysdate(struct date *tmp_info) {
	getdate(tmp_info);
}
