lcd %1 %2 %3
if errorlevel 11 goto bad_parameter
if errorlevel 10 goto cant_rename
if errorlevel 9 goto bad_environment
if errorlevel 8 goto out_of_memory
if errorlevel 7 goto user_abort
if errorlevel 6 goto no_parms
if errorlevel 5 goto cant_create
if errorlevel 4 goto database_error
if errorlevel 3 goto scan_failed
if errorlevel 2 goto cant_change
if errorlevel 1 goto success_floppy
if errorlevel 0 goto success

:cant_rename
    echo.
    echo LCDTEST: unable to rename directory
    goto exit

:bad_parameter
    echo.
    echo LCDTEST: an invalid parameter was specified
    goto exit

:cant_change
    echo.
    echo LCDTEST: unable to change to drive or directory
    goto exit

:scan_failed
    echo.
    echo LCDTEST: scan of hard drive(s) failed
    goto exit

:database_error
    echo.
    echo LCDTEST: database error
    goto exit

:cant_create
    echo.
    echo LCDTEST: unable to create/remove directory
    goto exit

:no_parms
    echo.
    echo LCDTEST: no parameters were specified
    goto exit

:user_abort
    echo.
    echo LCDTEST: user aborted the program with the ESC key
    goto exit

:bad_environment
    echo.
    echo LCDTEST: environment variable in wrong format
    goto exit

:out_of_memory
    echo.
    echo LCDTEST: not enough memory to load database
    goto exit

:success_floppy
    echo.
    echo LCDTEST: successful completion - ignoring floppy drive
    goto exit

:success
    echo.
    echo LCDTEST: successful completion

:exit
