;************************************************************************
;*                                                                      *
;*      LIST (C) 1997 RonSoft.                                          *
;*                                                                      *
;*      A utility that shows the Creation date, File size and Real      *
;*      filesize of a file or directory. Real filesize is what it       *
;*      occupies on Your disk. It also shows how much that are          *
;*      wasted.                                                         *
;*      Usage:                                                          *
;*      List [filename].                                                *
;*                                                                      *
;*      Ronald Nordberg                                                 *
;*      Silvervgen 3                                                   *
;*      907 50 Ume                                                     *
;*      Sweden                                                          *
;*      christine.martinson@swipnet.se                                  *
;*      http://home2.swipnet.se/~w-20064                                *
;*                                                                      *
;************************************************************************

                                        ;some euqates for readability
video           equ     10h             ;video irq
kbd             equ     16h             ;keyboard irq
msdos           equ     21h             ;MSDOS irq

setpos          equ     02h             ;set cursor position
getpos          equ     03h             ;get cursor position
getmode         equ     0fh             ;get current video mode

reset           equ     0dh             ;disk reset
dfopen          equ     0fh             ;open disk file
dfclose         equ     10h             ;close disk file
searchf         equ     11h             ;search first
searchn         equ     12h             ;search next
seqread         equ     14h             ;sequential disk read
seqwrite        equ     15h             ;     "       "  write
getdisk         equ     19h             ;get current disk
setdta          equ     1ah             ;set disk transfer area address
break           equ     33h             ;get/set break flag
getdiskdata     equ     36h             ;get free disk data
setdir          equ     3bh             ;set current directory
createf         equ     3ch             ;create file with handle
openf           equ     3dh             ;open file with handle
closef          equ     3eh             ;close file with handle
readf           equ     3fh             ;read from file with handle
writef          equ     40h             ;write to file with handle
unlink          equ     41h             ;UNLINK(delete file)
allocmem        equ     48h             ;allocate memory
freemem         equ     49h             ;free memory
changebs        equ     4ah             ;change block size
findfirst       equ     4eh             ;find first file
findnext        equ     4fh             ;find next file
exit            equ     4c00h           ;msdos exit

[BITS 16]
[ORG     100h]
[SEGMENT .text]
s1:
        mov     ax,cs                   ;get code segment
        mov     ds,ax                   ;use it now
        mov     [comseg],ds

        mov     si,0080h                ;DOS command line page 0
        lodsb                           ;load size of command line
        cmp     al,0                    ;anything on command line ?
        jbe     default                 ;noo, make default
        cbw                             ;extend AL to AX
        xchg    bx,ax                   ;swap size to bx for indexing
        mov     byte [bx+si],0          ;null terminate command line
        call    parse                   ;parse command line
        jmp     main                    ;go on with main
default:
        mov     word [arglen],3         ;gonna use wildcard
        mov     si,wcard                ;get wildcard
        mov     di,inbuff               ;command line buffer
        mov     cx,3                    ;three chars
        repe    movsb                   ;copy it over
        mov     al,0                    ;null terminate
        stosb
        jmp     main
usage:
        mov     bx,utext                ;the usage hint text
        jmp     errout                  ;show it

;*************************** main here ***********************
main:
        mov     ah,getdisk              ;get current disk
        int     msdos                   ;drive now in AL
        mov     dl,al                   ;copy there for get disk data
        add     dl,1                    ;add one ???
        mov     ah,getdiskdata          ;get disk data
        int     msdos
        cmp     ax,0xffff               ;succesfull ?
        jne     diskok                  ;yeahh
        mov     bx,errt2                ;noo, let us know
        jmp     errout
diskok:
        mul     cx                      ;bytes/sector * sectors/cluster
        cwb                             ;make it DWORD
        mov     [csize],eax             ;save for calculating filesize
        mov     dword [tsize],0
        mov     dword [files],0
        mov     dword [fsize],0
        
        mov     ah,setdta               ;set our DTA-area
        mov     dx,mydta                ;our DTA structure
        int     msdos
        
        mov     ah,findfirst            ;see if the files out there
        mov     cx,0fh                  ;all files
        mov     dx,inbuff               ;filname or *.*
        int     msdos                   ;do the stuff
        jc      usage                   ;did'nt work, let us know
        mov     bx,text1                ;the "header" text
        call    write
        jmp     fileok                  ;all ok, must check first file
fscan:                                  ;found something
        mov     dx,inbuff               ;filename or *.*
        mov     ah,findnext             ;the function
        int     msdos                   ;call dos
        jc      total                   ;no more files, quit
fileok:
        cmp     byte [inbuff],'*'       ;using wildcard ?
        je      flist                   ;yeahh, just show it

        mov     cx,[arglen]             ;length of our arg
        mov     si,inbuff               ;command line
        mov     di,mydta+30             ;current DTA entry
equal:  cmpsb                           ;are we equal ?
        jnz     fscan                   ;noo
flist:
        call    showdate                ;show the stuff

        mov     ds,[comseg]             ;has been destroyed
        add     dword [files],1
        cmp     byte [inbuff],'*'       ;using wildcard ?
        jne     quit                    ;noo, skip
        jmp     fscan                   ;yeahh, show it all
total:
        mov     ds,[comseg]             ;show total/real and lost bytes
        mov     bx,text2
        call    write
        mov     edx,[files]
        call    bindec
        mov     si,numbuff
        call    strip
        mov     bx,si
        call    write
        mov     bx,text3
        call    write
        mov     edx,[fsize]
        call    bindec
        mov     si,numbuff
        call    strip
        mov     bx,si
        call    write
        mov     bx,text4
        call    write
        mov     bx,text5
        call    write
        mov     edx,[tsize]
        call    bindec
        mov     si,numbuff
        call    strip
        mov     bx,si
        call    write
        mov     bx,text6
        call    write
        mov     bx,text7
        call    write
        mov     edx,[tsize]
        sub     dword edx,[fsize]
        call    bindec
        mov     si,numbuff
        call    strip
        mov     bx,si
        
;*************************** errorexit ***********************
errout: call    write                   ;show errormessage
quit:
        xor     eax,eax                 ;better do this
        mov     ax,exit                 ;MS-DOS successful exit
        int     msdos                   ;back to the operating system

;*************************************************************
;       Shows date stuff. Input DX
;*************************************************************
showdate:
        mov     di,outline             ;output buffer
        mov     al,32                  ;spaces
        mov     cx,80                  ;80 of them
        repe    stosb                  ;fill it

        mov     si,mydta+30            ;get filname
        mov     di,outline             ;output buffer
scopy:  lodsb                          ;load AL
        cmp     al,0                   ;end of filename ?
        je      cpdone                 ;yeahh
        stosb                          ;no, copy char
        jmp     scopy                  ;go on
cpdone:
        mov     word dx,[mydta+18h]    ;get creation date
        and     dx,1111111000000000B   ;mask year
        ror     dx,9                   ;rol it in
        add     dx,1980                ;add 1980
        call    bindec                 ;make ascii decimal
        mov     si,numbuff             ;number buffer
        add     si,8                   ;just use 2 digits
        mov     di,outline             ;output buffer
        add     di,16                  ;offset in buffer
        mov     cx,2                   ;2 digits
        repe    movsb                  ;copy it over
        mov     al,'-'                 ;copy a -
        stosb
        
        mov     word dx,[mydta+18h]
        and     dx,0000000111100000B    ;mask out month
        ror     dx,5                    ;rol it in
        call    bindec
        mov     si,numbuff
        add     si,8
        mov     di,outline
        add     di,19
        mov     cx,2
        repe    movsb
        mov     al,'-'
        stosb
        
        mov     word dx,[mydta+18h]
        and     dx,0000000000011111B   ;mask out day
        call    bindec
        mov     si,numbuff
        add     si,8
        mov     di,outline
        add     di,22
        mov     cx,2
        repe    movsb

        mov     dword edx,[mydta+1ah]   ;get file size
        cmp     edx,0                   ;zero byte ?
        jne     nzero                   ;noo
        mov     di,outline
        add     di,37
        mov     byte [di],'0'
        jmp     zdone
nzero:
        call    bindec
        mov     si,numbuff
        call    strip
        mov     si,numbuff
        mov     di,outline
        add     di,28
        mov     cx,10
        repe    movsb
zdone:
        mov     dword edx,[mydta+1ah]   ;get file size
        add     [fsize],edx             ;add to total files size
        mov     ecx,[csize]             ;get cluster byte size
slop:   sub     edx,[csize]             ;subtract from cluster size
        jbe     subok                   ;<= clustersize ?
        add     ecx,[csize]             ;no, add clustersize
        jmp     slop
subok:  add     [tsize],ecx             ;add to total size
        mov     edx,ecx
        call    bindec
        mov     si,numbuff
        call    strip
        mov     si,numbuff
        mov     di,outline
        add     di,42
        mov     cx,10
        repe    movsb
        
        mov     al,0                    ;null terminate output buffer
        stosb
        mov     bx,outline              ;get buffer
        call    write                   ;write it
        mov     bx,lfeed                ;CR and LF
        call    write                   ;write
        ret

;***********************************************************************
; Convert binary 32 bit number to ascii decimal using succesive
; subraction.  Input edx, output numbuff.
;************************************************************************
bindec:
        mov     esi,divtab      ;pointer subtract values
        mov     edi,numbuff     ;output buffer
        mov     cx,10           ;10 digits
sublop: xor     al,al           ;clear counter
sblop:  cmp     edx,[esi]       ;number < subractor ?
        jb      tolow           ;yeah
        sub     edx,[esi]       ;noo, subtract
        add     al,1            ;incrase times subtracted
        jmp     sblop           ;subtract again
tolow:
        add     al,30h          ;make ascii
        stosb                   ;store in buffer
        add     si,4            ;next subtractor
        loop    sublop          ;do it
        mov     al,0
        stosb
        ret

;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*       OR writes out data,BX and size,CX if called at lwrite.          *
;*************************************************************************
write:  pusha
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop:  lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      lwrite                   ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
lwrite: mov     dx,bx                   ;text address in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,writef               ;MS-DOS writefile with handle is 040
        int     msdos                   ;write buffer to standard output
        popa
        ret                             ;done

;***********************************************************************
;       Change leading zeroes in buffer at SI to SPACES
;***********************************************************************
strip:
        lodsb                           ;load byte
        cmp     al,'0'                  ;any leading zeroes ?
        jne     nozero                  ;noo
        mov     byte [si-1],32
        jmp     strip                   ;yeahh, check next
nozero: dec     si                      ;adjust that back one byte
        ret

;*************************************************************************
;*      My kind of command line parsing. It just checks if theres
;*      any blankspaces between the options. The parameters ends up
;*      in the inbuff separated by 0:s, binary zeroes.
;*************************************************************************
parse:
        mov     di,inbuff               ;our buffer
dump:   cmp     byte [si],32            ;any leading spaces ?
        jne     par                     ;noo
        inc     si                      ;yeahh, check next
        jmp     dump
par:    mov     cx,0                    ;clear lenght of arg counter
copy1:  lodsb                           ;load byte SI to AL
        cmp     al,0                    ;0 ?(end of line)
        je      done                    ;yeahh
        cmp     al,32                   ;SPACE ?
        je      cop2                    ;yeah
        cmp     al,'a'                  ;big letter ?
        jb      cop1                    ;yeahh
        add     al,'A'-'a'              ;noo, make it big
cop1:   stosb                           ;noo, move AL to DI, incrase DI
        jmp     copy1                   ;go on
cop2:   mov     byte [di],0             ;null terminate
        add     cx,1
        inc     di                      ;dump that byte(SPACE)
        jmp     copy1                   ;back
done:   mov     byte [di],0             ;null terminate
        mov     [arglen],cx
        ret                             ;return

[SECTION .data]
divtab          dd 1000000000      ;subtractor values
                dd  100000000
                dd   10000000
                dd    1000000
                dd     100000
                dd      10000           
                dd       1000
                dd        100
                dd         10
                dd          1

utext:          db      "List (C) 1997 RonSoft",13,10
                db      "Usage:",13,10
                db      "List [file]",13,10,0
text1:          db      "Filename:       Date:        Filesize:    Real size:",13,10,0
text2:          db      13,10,"Totally ",0
text3:          db      " files occupying ",0
text4:          db      " Bytes",13,10,0
text5:          db      "Total disk space used: ",0
text6:          db      " Bytes",13,10,0
text7:          db      "Bytes lost: ",0
errt1:          db      "File not found.",13,10,0
errt2:          db      "Could not examine disk.",13,10,0
wcard:          db      "*.*",0
lfeed:          db      13,10,0

[SECTION .bss]
csize           resd 1
tsize           resd 1
fsize           resd 1
files           resd 1
inbuff          resw 64         ;128 byte command line buffer
mydta           resw 64         ;use 128 bytes as DTA
outline         resw 40         ;80 chars output line
numbuff         resw 6          ;word ascii number buffer
filehandle      resw 1
filesize        resw 1
address         resw 1
arglen          resw 1
comseg          resw 1

s2:

        END     
