#include "ntui.h"
#include <assert.h>

static BOOL CALLBACK cancelDlgProc(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  BOOL ret = FALSE;
  switch (uMsg)
  {
    case WM_INITDIALOG:
      statDlgPlaceSubDlg(hWnd);
      SendMessage(GetDlgItem(hWnd, IDC_CONTINUE), BM_SETCHECK, BST_CHECKED, 0);
      ret = TRUE;
      break;
    case WM_COMMAND:
      if (HIWORD(wp) == BN_CLICKED)
      {
        int id = GetDlgCtrlID((HWND) lp);
        switch (id)
        {
          case IDOK:
            {
              EXECMODE ret;
              if (SendMessage(GetDlgItem(hWnd, IDC_CONTINUE), BM_GETCHECK, 0, 0) == BST_CHECKED)
              {
                ret = EXECMODE_NORMAL;
              } else if (SendMessage(GetDlgItem(hWnd, IDC_COMPLETE), BM_GETCHECK, 0, 0) == BST_CHECKED)
              {
                ret = EXECMODE_CANCEL;
              } else if (SendMessage(GetDlgItem(hWnd, IDC_STOP), BM_GETCHECK, 0, 0) == BST_CHECKED)
              {
                ret = EXECMODE_ABORT;
              } else
                assert(0);
              EndDialog(hWnd, (int) ret);
            }
            break;
        }
      }
      break;
  }
  return ret;
}

EXECMODE cancelDlgExec(void)
{
  return (EXECMODE) DialogBox(0, MAKEINTRESOURCE(IDD_CANCEL), 0, cancelDlgProc);
}
