#include "syncdir.h"
#include <assert.h>
#include <string.h>

typedef struct tagFT
{
  FILETABLE   ft;      /* must be first entry    */
  UINT32      allocCt; /* # of entries allocated */
  UINT32      entryCt; /* # of entries in table  */
  UINT32      entryNo; /* last entry retrieved   */
  FILEINFO  **inf;     /* info table             */
} FT;

FILETABLE *fileTableAlloc(const char *name)
{
  FT *tbl = MALLOC(FT);
  if (tbl)
  {
    memset(tbl, 0, sizeof(*tbl));
    strcpy(tbl->ft.name, name);
    tbl->entryNo = UINT32_MAX;
  } else
    longjmp(jmpbuf, SYNCDIR_ERROR_MEMORY);
  return (FILETABLE *) tbl;
}

void fileTableFree(FILETABLE *tbl)
{
  FT *ft = (FT *) tbl;
  UINT32 ii;
  for (ii = 0; ii < ft->entryCt; ii++)
    free(ft->inf[ii]);
  free(ft->inf);
  free(ft);
}

BOOL fileTableAdd(FILETABLE *tbl, FILEINFO *inf)
{
  FT *ft = (FT *) tbl;
  if (ft->entryCt == ft->allocCt)
  {
    FILEINFO **tmp = REALLOC(FILEINFO *, ft->inf, ft->allocCt + 32);    
    if (!tmp)
    {
      longjmp(jmpbuf, SYNCDIR_ERROR_MEMORY);
      return FALSE;
    } else
    {
      ft->allocCt += 32;
      ft->inf     = tmp;
    }
  }
  ft->inf[ft->entryCt++] = inf;
  inf->owner    = tbl;
  tbl->entryCt++;
  return TRUE;
}

static void sort(FT *tbl)
{
  UINT32 m;
  for (m = tbl->entryCt / 2; m; m /= 2)
  {
    UINT32 ii;
    for (ii = 0; ii + m < tbl->entryCt; ii++)
    {
      UINT32 jj;
      for (jj = ii; (fileInfoNameCompare(tbl->inf[jj], tbl->inf[jj+m], FALSE) > 0); jj -= m)
      {
        FILEINFO *tmp = tbl->inf[jj];
        tbl->inf[jj] = tbl->inf[jj+m];
        tbl->inf[jj+m] = tmp;
        if (jj < m) /* since jj cannot become negative, i need this test! */
          break;
      }
    }
  }
}

FILEINFO *fileTableGetFirst(FILETABLE *tbl)
{
  FT *ft = (FT *) tbl;
  if (ft->entryNo == UINT32_MAX)
    sort(ft);
  ft->entryNo = 0;
  return (ft->entryNo < ft->entryCt)
    ? ft->inf[ft->entryNo]
    : 0;
}

FILEINFO *fileTableGetNext(FILETABLE *tbl)
{
  FT *ft = (FT *) tbl;
  return (ft->entryNo+1 < ft->entryCt)
    ? ft->inf[++ft->entryNo]
    : 0;
}

FILEINFO *fileInfoAlloc(FILETABLE *owner, const char *name)
{
  FILEINFO *inf = VMALLOC(FILEINFO, strlen(name));
  if (inf)
  {
    memset(inf, 0, sizeof(*inf));
    strcpy(inf->name, name);
    inf->nameSz = strlen(name);
  } else
    longjmp(jmpbuf, SYNCDIR_ERROR_MEMORY);
  return inf;
}

void fileInfoFree(FILEINFO *inf)
{
  if (inf->refCt)
    inf->refCt--;
  else
    free(inf);
}

BOOL fileInfoIsDirectory(const FILEINFO *inf)
{
  return inf->isDir;
}

BOOL fileInfoSetAction(FILEINFO *inf, ACTION act)
{
  inf->action = act;
  fileInfoUpdateStats(inf);
  return TRUE;
}

FILEINFO *fileInfoDup(FILEINFO *r)
{
  r->refCt++;
  return r;
}
