# Makefile for Borland C++
.AUTODEPEND

#		*Translator Definitions*
CC = bcc +WCD.CFG
TASM = TASM
TLIB = tlib
TLINK = tlink
LIBPATH = C:\BC4\LIB
INCLUDEPATH = C:\BC4\INCLUDE;..\C3PO


#		*Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#		*List Macros*


EXE_dependencies =  \
 display.obj \
 dosdir.obj \
 match.obj \
 stack.obj \
 wcd.obj \
 wfixpath.obj \
 command.obj \
 error.obj \
 intset.obj \
 nameset.obj \
 text.obj \
 wcdstack.obj \
 wcddir.obj

#		*Explicit Rules*
wcd.exe: wcd.cfg $(EXE_dependencies)
  $(TLINK) /v/x/c/P-/L$(LIBPATH) @&&|
c0l.obj+
display.obj+
dosdir.obj+
match.obj+
stack.obj+
wcd.obj+
wfixpath.obj+
command.obj+
error.obj+
intset.obj+
nameset.obj+
text.obj+
wcdstack.obj+
wcddir.obj
wcd
		# no map file
emu.lib+
mathl.lib+
cl.lib
|


#		*Individual File Dependencies*
display.obj: wcd.cfg display.c 

dosdir.obj: wcd.cfg dosdir.c 

match.obj: wcd.cfg match.c 

stack.obj: wcd.cfg stack.c 

wcd.obj: wcd.cfg wcd.c 

wfixpath.obj: wcd.cfg wfixpath.c 

wcddir.obj: wcd.cfg wcddir.c 

command.obj: wcd.cfg ..\c3po\command.c 
	$(CC) -c ..\c3po\command.c

error.obj: wcd.cfg ..\c3po\error.c 
	$(CC) -c ..\c3po\error.c

intset.obj: wcd.cfg ..\c3po\intset.c 
	$(CC) -c ..\c3po\intset.c

nameset.obj: wcd.cfg ..\c3po\nameset.c 
	$(CC) -c ..\c3po\nameset.c

text.obj: wcd.cfg ..\c3po\text.c 
	$(CC) -c ..\c3po\text.c

wcdstack.obj: wcd.cfg ..\c3po\wcdstack.c 
	$(CC) -c ..\c3po\wcdstack.c

#		*Compiler Configuration File*
wcd.cfg: wcd.mak
  copy &&|
-ml
-v
-vi-
-wpro
-weas
-wpre
-I$(INCLUDEPATH)
-L$(LIBPATH)
-DDOSWILD;WCD_USECONIO
| wcd.cfg


