%title 'An ix86 instruction decoder by me, (c) 1998 Henrik Nebrin'

        ideal
        p386
        nowarn  brk

ifdef Clib
        include 'C.inc'
else
_wordsize       equ     2
        include 'proc.inc'
endif
        include '__dislib.inc'

macro   getbyte
ifdef Clib
        call    near ptr __dis_getbyte
else
        call    (__dis_input_t ptr __dis_gs:si).getbyte
endif
endm    getbyte

; Info from: Pentium(r) Processor Family Developer's Manual 
; Volume 3: Architecture and Programming Manual by intel 
;
; A   Direct address; the instruction has no modR/M byte; the address of   
;     the operand is encoded in the instruction; no base register, index   
;     register or scaling factor can be applied; e.g., far JMP (EA).       
; C   The reg field of the modR/M byte selects a control register;         
;     e.g., MOV (0F20,0F22).                                               
; D   The reg field of the modR/M byte selects a debug register;           
;     e.g., MOV (0F21,0F23).                                               
; E   A modR/M byte follows the opcode and specifies the operand. The      
;     operand is either a general register or a memory address. If it is a 
;     memory address, the address is computed from a segment register and  
;     any of the following values; a base register, an index register,     
;     a scaling factor, a displacement.                                    
; F   Flags Register.                                                      
; G   The reg field of the modR/M byte selects a general register;         
;     e.g., AX (000)                                                       
; I   Immediate data. The value of the operand is encoded in subsequent    
;     bytes of the instruction.                                            
; J   The instruction contains a relative offset to be added to the        
;     instruction pointer register; e.g., JMP short, LOOP.                 
; M   The modR/M byte may refer only to memory; e.g., BOUND, LES, LDS, LSS 
;     LFS, LGS, CMPXCHG8B.                                                 
; O   The instruction has no modR/M byte; the offset of the operand is     
;     coded as a word or a double word (depending on the address size      
;     attribute) in the instruction. No base register, index register,     
;     or scaling factor can be applied; e.g., MOV (A0-A3).                 
; P   reg field of modR/M byte selects a packed quadword MMX register      
; Q   modR/M byte follows opcode and specifies operand; operand is either  
;     an MMX register or a memory address; if it is a memory address, the  
;     address is computed from a segment register and any of the following 
;     values: a base register, an index register, a scaling factor,        
;     a displacement                                                       
; R   The mod field of the modR/M byte may refer only to a general         
;     register; e.g., MOV (0F20-0F24, 0F26).                               
; S   The reg field of the modR/M byte selects a segment register;         
;     e.g., MOV (8C, 8E).                                                  
; T   The reg field of the modR/M byte selects a test register;            
;     e.g., MOV (0F24-0F26).                                               
; X   Memory addressed by the DS:SI register pair;                         
;     e.g., MOVS, CMPS, OUTS, LODS.                                        
; Y   Memory addressed by the ES:DI register pair;                         
;     e.g., MOVS, CMPS, INS, STOS, SCAS.                                   
; a   Two one-word operands in memory or two double-word operands in       
;     memory, depending on operand size attribute (used only by BOUND).    
; b   Byte (regardless of operand size attribute).                         
; c   Byte or word, depending on operand size attribute.                   
; d   Double word (regardless of operand size attribute).                  
; p   Thirty-two bit or 48-bit pointer, depending on operand size          
;     attribute.                                                           
; q   Quad word (regardless of operand size attribute).                    
; s   Six-byte pseudo-descriptor.                                          
; v   Word or double word, depending on operand size attribute.            
; w   Word (regardless of operand size attribute).                         
;

enum ?????????????? {
  bmode                                 ;always a byte
  dmode                                 ;always a dword
  qmode                                 ;always a qword
  vmode                                 ;word or dword
  wmode                                 ;always a word
  tmode                                 ;always a tbyte
  amode                                 ;two words or two dwords in memory
  omode                                 ;jmp word/dword ptr [X] (offset)
  osmode                                ;jmp dword/fword ptr [X] (seg:ofs)
  smode                                 ;sgdt [XXXX]
  $eAX=0                                ;ax or eax depending on opsize
  $eCX
  $eDX
  $eBX
  $eSP
  $eBP
  $eSI
  $eDI
  $al
  $cl
  $dl
  $bl
  $ah
  $ch
  $dh
  $bh
  $es
  $cs
  $ss
  $ds
  $fs
  $gs
  $dx
  $ax
 }

        startconst
        align   word
label   opcodes1 word
  dw    op0000,op0001,op0002,op0003,op0004,op0005,op0006,op0007
  dw    op0008,op0009,op000A,op000B,op000C,op000D,op000E,op000F
  dw    op0010,op0011,op0012,op0013,op0014,op0015,op0016,op0017
  dw    op0018,op0019,op001A,op001B,op001C,op001D,op001E,op001F
  dw    op0020,op0021,op0022,op0023,op0024,op0025,op0026,op0027
  dw    op0028,op0029,op002A,op002B,op002C,op002D,op002E,op002F
  dw    op0030,op0031,op0032,op0033,op0034,op0035,op0036,op0037
  dw    op0038,op0039,op003A,op003B,op003C,op003D,op003E,op003F
  dw    op0040,op0041,op0042,op0043,op0044,op0045,op0046,op0047
  dw    op0048,op0049,op004A,op004B,op004C,op004D,op004E,op004F
  dw    op0050,op0051,op0052,op0053,op0054,op0055,op0056,op0057
  dw    op0058,op0059,op005A,op005B,op005C,op005D,op005E,op005F
  dw    op0060,op0061,op0062,op0063,op0064,op0065,op0066,op0067
  dw    op0068,op0069,op006A,op006B,op006C,op006D,op006E,op006F
  dw    op0070,op0071,op0072,op0073,op0074,op0075,op0076,op0077
  dw    op0078,op0079,op007A,op007B,op007C,op007D,op007E,op007F
  dw    op0080,op0081,op0082,op0083,op0084,op0085,op0086,op0087
  dw    op0088,op0089,op008A,op008B,op008C,op008D,op008E,op008F
  dw    op0090,op0091,op0092,op0093,op0094,op0095,op0096,op0097
  dw    op0098,op0099,op009A,op009B,op009C,op009D,op009E,op009F
  dw    op00A0,op00A1,op00A2,op00A3,op00A4,op00A5,op00A6,op00A7
  dw    op00A8,op00A9,op00AA,op00AB,op00AC,op00AD,op00AE,op00AF
  dw    op00B0,op00B1,op00B2,op00B3,op00B4,op00B5,op00B6,op00B7
  dw    op00B8,op00B9,op00BA,op00BB,op00BC,op00BD,op00BE,op00BF
  dw    op00C0,op00C1,op00C2,op00C3,op00C4,op00C5,op00C6,op00C7
  dw    op00C8,op00C9,op00CA,op00CB,op00CC,op00CD,op00CE,op00CF
  dw    op00D0,op00D1,op00D2,op00D3,op00D4,op00D5,op00D6,op00D7
  dw    op00D8,op00D9,op00DA,op00DB,op00DC,op00DD,op00DE,op00DF
  dw    op00E0,op00E1,op00E2,op00E3,op00E4,op00E5,op00E6,op00E7
  dw    op00E8,op00E9,op00EA,op00EB,op00EC,op00ED,op00EE,op00EF
  dw    op00F0,op00F1,op00F2,op00F3,op00F4,op00F5,op00F6,op00F7
  dw    op00F8,op00F9,op00FA,op00FB,op00FC,op00FD,op00FE,op00FF
label   opcodes2 word
  dw    op0F00,op0F01,op0F02,op0F03,op0F04,op0F05,op0F06,op0F07
  dw    op0F08,op0F09,op0F0A,op0F0B,op0F0C,op0F0D,op0F0E,op0F0F
  dw    op0F10,op0F11,op0F12,op0F13,op0F14,op0F15,op0F16,op0F17
  dw    op0F18,op0F19,op0F1A,op0F1B,op0F1C,op0F1D,op0F1E,op0F1F
  dw    op0F20,op0F21,op0F22,op0F23,op0F24,op0F25,op0F26,op0F27
  dw    op0F28,op0F29,op0F2A,op0F2B,op0F2C,op0F2D,op0F2E,op0F2F
  dw    op0F30,op0F31,op0F32,op0F33,op0F34,op0F35,op0F36,op0F37
  dw    op0F38,op0F39,op0F3A,op0F3B,op0F3C,op0F3D,op0F3E,op0F3F
  dw    op0F40,op0F41,op0F42,op0F43,op0F44,op0F45,op0F46,op0F47
  dw    op0F48,op0F49,op0F4A,op0F4B,op0F4C,op0F4D,op0F4E,op0F4F
  dw    op0F50,op0F51,op0F52,op0F53,op0F54,op0F55,op0F56,op0F57
  dw    op0F58,op0F59,op0F5A,op0F5B,op0F5C,op0F5D,op0F5E,op0F5F
  dw    op0F60,op0F61,op0F62,op0F63,op0F64,op0F65,op0F66,op0F67
  dw    op0F68,op0F69,op0F6A,op0F6B,op0F6C,op0F6D,op0F6E,op0F6F
  dw    op0F70,op0F71,op0F72,op0F73,op0F74,op0F75,op0F76,op0F77
  dw    op0F78,op0F79,op0F7A,op0F7B,op0F7C,op0F7D,op0F7E,op0F7F
  dw    op0F80,op0F81,op0F82,op0F83,op0F84,op0F85,op0F86,op0F87
  dw    op0F88,op0F89,op0F8A,op0F8B,op0F8C,op0F8D,op0F8E,op0F8F
  dw    op0F90,op0F91,op0F92,op0F93,op0F94,op0F95,op0F96,op0F97
  dw    op0F98,op0F99,op0F9A,op0F9B,op0F9C,op0F9D,op0F9E,op0F9F
  dw    op0FA0,op0FA1,op0FA2,op0FA3,op0FA4,op0FA5,op0FA6,op0FA7
  dw    op0FA8,op0FA9,op0FAA,op0FAB,op0FAC,op0FAD,op0FAE,op0FAF
  dw    op0FB0,op0FB1,op0FB2,op0FB3,op0FB4,op0FB5,op0FB6,op0FB7
  dw    op0FB8,op0FB9,op0FBA,op0FBB,op0FBC,op0FBD,op0FBE,op0FBF
  dw    op0FC0,op0FC1,op0FC2,op0FC3,op0FC4,op0FC5,op0FC6,op0FC7
  dw    op0FC8,op0FC9,op0FCA,op0FCB,op0FCC,op0FCD,op0FCE,op0FCF
  dw    op0FD0,op0FD1,op0FD2,op0FD3,op0FD4,op0FD5,op0FD6,op0FD7
  dw    op0FD8,op0FD9,op0FDA,op0FDB,op0FDC,op0FDD,op0FDE,op0FDF
  dw    op0FE0,op0FE1,op0FE2,op0FE3,op0FE4,op0FE5,op0FE6,op0FE7
  dw    op0FE8,op0FE9,op0FEA,op0FEB,op0FEC,op0FED,op0FEE,op0FEF
  dw    op0FF0,op0FF1,op0FF2,op0FF3,op0FF4,op0FF5,op0FF6,op0FF7
  dw    op0FF8,op0FF9,op0FFA,op0FFB,op0FFC,op0FFD,op0FFE,op0FFF
jmp0080 dw      op0080_000,op0080_001,op0080_010,op0080_011,\
                op0080_100,op0080_101,op0080_110,op0080_111
jmp0081 dw      op0081_000,op0081_001,op0081_010,op0081_011,\
                op0081_100,op0081_101,op0081_110,op0081_111
jmp0082 dw      op0082_000,op0082_001,op0082_010,op0082_011,\
                op0082_100,op0082_101,op0082_110,op0082_111
jmp0083 dw      op0083_000,op0083_001,op0083_010,op0083_011,\
                op0083_100,op0083_101,op0083_110,op0083_111
jmp00C0 dw      op00C0_000,op00C0_001,op00C0_010,op00C0_011,\
                op00C0_100,op00C0_101,op00C0_110,op00C0_111
jmp00C1 dw      op00C1_000,op00C1_001,op00C1_010,op00C1_011,\
                op00C1_100,op00C1_101,op00C1_110,op00C1_111
jmp00D0 dw      op00D0_000,op00D0_001,op00D0_010,op00D0_011,\
                op00D0_100,op00D0_101,op00D0_110,op00D0_111
jmp00D1 dw      op00D1_000,op00D1_001,op00D1_010,op00D1_011,\
                op00D1_100,op00D1_101,op00D1_110,op00D1_111
jmp00D2 dw      op00D2_000,op00D2_001,op00D2_010,op00D2_011,\
                op00D2_100,op00D2_101,op00D2_110,op00D2_111
jmp00D3 dw      op00D3_000,op00D3_001,op00D3_010,op00D3_011,\
                op00D3_100,op00D3_101,op00D3_110,op00D3_111
jmp00F6 dw      op00F6_000,op00F6_001,op00F6_010,op00F6_011,\
                op00F6_100,op00F6_101,op00F6_110,op00F6_111
jmp00F7 dw      op00F7_000,op00F7_001,op00F7_010,op00F7_011,\
                op00F7_100,op00F7_101,op00F7_110,op00F7_111
jmp00FE dw      op00FE_000,op00FE_001,op00FE_010,op00FE_011,\
                op00FE_100,op00FE_101,op00FE_110,op00FE_111
jmp00FF dw      op00FF_000,op00FF_001,op00FF_010,op00FF_011,\
                op00FF_100,op00FF_101,op00FF_110,op00FF_111
jmp0F00 dw      op0F00_000,op0F00_001,op0F00_010,op0F00_011,\
                op0F00_100,op0F00_101,op0F00_110,op0F00_111
jmp0F01 dw      op0F01_000,op0F01_001,op0F01_010,op0F01_011,\
                op0F01_100,op0F01_101,op0F01_110,op0F01_111
jmp0FBA dw      op0FBA_000,op0FBA_001,op0FBA_010,op0FBA_011,\
                op0FBA_100,op0FBA_101,op0FBA_110,op0FBA_111
jmp0FC7 dw      op0FC7_000,op0FC7_001,op0FC7_010,op0FC7_011,\
                op0FC7_100,op0FC7_101,op0FC7_110,op0FC7_111
jmp0F71 dw      op0F71_000,op0F71_001,op0F71_010,op0F71_011,\
                op0F71_100,op0F71_101,op0F71_110,op0F71_111
jmp0F72 dw      op0F72_000,op0F72_001,op0F72_010,op0F72_011,\
                op0F72_100,op0F72_101,op0F72_110,op0F72_111
jmp0F73 dw      op0F73_000,op0F73_001,op0F73_010,op0F73_011,\
                op0F73_100,op0F73_101,op0F73_110,op0F73_111
jmp0FAE dw      op0FAE_000,op0FAE_001,op0FAE_010,op0FAE_011,\
                op0FAE_100,op0FAE_101,op0FAE_110,op0FAE_111

label   floatjmps word
  dw    D8jmp,D9jmp,DAjmp,DBjmp,DCjmp,DDjmp,DEjmp,DFjmp

label   D8_DF_C0_FFop byte      ;bit=0=use ESC,bit=1=has float opcode
  db    11111111b,11111111b,11111111b,11111111b ;00D8h with modR/M >= C0h
  db    11111111b,11111111b,11111111b,11111111b
  db    11111111b,11111111b,00000001b,11111111b ;00D9h
  db    00110011b,01111111b,11111111b,11111111b
  db    11111111b,11111111b,11111111b,11111111b ;00DAh
  db    00000000b,00000010b,00000000b,00000000b
  db    11111111b,11111111b,11111111b,11111111b ;00DBh
  db    00111111b,11111111b,11111111b,00000000b
  db    11111111b,11111111b,11111111b,11111111b ;00DCh
  db    11111111b,11111111b,11111111b,11111111b
  db    11111111b,11111111b,11111111b,11111111b ;00DDh
  db    11111111b,11111111b,00000000b,00000000b
  db    11111111b,11111111b,11111111b,00000010b ;00DEh
  db    11111111b,11111111b,11111111b,11111111b
  db    11111111b,11111111b,11111111b,11111111b ;00DFh
  db    00000111b,11111111b,11111111b,00000000b

macro   x y,z
        db      y
if z eq dr_none
        db      z
else
        db      z shl 4
endif
endm    x
label   baseindex16 word
        x       dr_bx,dr_si
        x       dr_bx,dr_di
        x       dr_bp,dr_si
        x       dr_bp,dr_di
        x       dr_si,dr_none;,dr_si    ;actually index, but it will look
        x       dr_di,dr_none;,dr_di    ; ugly if we use the at&t syntax...
        x       dr_bp,dr_none
        x       dr_bx,dr_none
purge   x

label   __dis_convertequtable byte
  db    dop_sizebyte,dop_sizebyte
  db    dop_sizedword,dop_sizedword
  db    dop_sizeqword,dop_sizeqword
  db    dop_sizeword,dop_sizedword
  db    dop_sizeword,dop_sizeword
  db    dop_sizetbyte,dop_sizetbyte
  db    dop_sizetwowords,dop_sizetwodwords
  db    dop_sizewordofs,dop_sizedwordofs
  db    dop_sizedwordsegofs,dop_sizefwordsegofs
  db    dop_sizepword,dop_sizepword

;If bit 7 is set, we shouldn't print the memory's size. 0FFh=Print it as ESC
label   D8_DF_00_BFsize byte
  db    dmode,dmode,dmode,dmode,dmode,dmode,dmode,dmode
  db    dmode,0FFh,dmode,dmode,vmode+80h,vmode+80h,vmode+80h,vmode+80h
  db    dmode,dmode,dmode,dmode,dmode,dmode,dmode,dmode
  db    dmode,0FFh,dmode,dmode,0FFh,tmode,0FFh,tmode
  db    qmode,qmode,qmode,qmode,qmode,qmode,qmode,qmode
  db    qmode,0FFh,qmode,qmode,vmode+80h,0FFh,vmode+80h,vmode+80h
  db    wmode,wmode,wmode,wmode,wmode,wmode,wmode,wmode
  db    wmode,0FFh,wmode,wmode,tmode,qmode,tmode,qmode
        endconst

        startcode

ifdef Clib
        ;
        ;   __dis_getbyte:near
        ;
        ;   get a byte from a C++ procedure
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;   output: cf=1=error
        ;           cf=0=ok=al=byte
        ;   registers: al,ecx[31:16]
        ;
proc    __dis_getbyte near
if @datasize
        push    gs
endif
        push    bx dx cx eax
if @datasize
        push    gs
endif
        push    si
        call    (__dis_input_t ptr __dis_gs:si).getbyte
if @datasize
        db      66h
endif
        pop     cx
        cmp     ax,0100h
        cmc
@@666:
        pop     ecx
        mov     cl,al
        xchg    ecx,eax
        pop     cx dx bx
if @datasize
        pop     gs
endif
        retn
endp    __dis_getbyte
endif

        ;
        ;   __dis:proc
        ;
        ;   decode one instruction (reentrant)
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: none
        ;
ifdef Clib
proc    ___dis procptr
        public  ___dis
else
proc    __dis procptr
endif
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
ifdef Clib
        arg     dis_input:dataptr
        cld
        push    bp
        mov     bp,sp
        push    si di
  if @datasize
        lgs     si,dis_input
  else
        mov     si,dis_input
  endif
  if @datasize eq 2
        push    ds @data
        pop     ds
        assume  ds:@data
  endif
else
        push    eax cx dx bx di
endif
        and     (__dis_input_t ptr __dis_gs:si).opcode.flags,0000h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,00h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.prefixes,00h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.optype,optype_dunno
        mov     al,(__dis_input_t ptr __dis_gs:si).codesize
        mov     ah,al
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opadrsize,ax
__dis_getbyteloop:
        getbyte
if (opid_opnames1 shr 8) ne 0
  err
endif
        mov     ah,00h
        jc      short @@666
        xchg    bx,ax
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeword,bx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,bx
        add     bx,bx
        call    [bx+opcodes1]
@@666:
ifdef Clib
        sbb     ax,ax
  if @datasize eq 2
        pop     ds
  endif
        pop     di si bp
        inc     ax
else
        pop     di bx dx cx eax
endif
        ret
ifdef Clib
endp    ___dis
else
endp    __dis
endif

        ;
        ;   smallorlargeadr:near
        ;
        ;   check if we should use small or large. depends on adrsize
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: none
        ;   registers: none
        ;
proc    smallorlargeadr near
        push    ax di
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.adrsize
        mov     al,__dis_adrprefix
        jmp     short smallorlargejmp
endp    smallorlargeadr

        ;
        ;   smallorlargeop:near
        ;
        ;   check if we should use small or large. depends on opsize
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: none
        ;   registers: none
        ;
proc    smallorlargeop near
        push    ax di
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.opsize
        mov     al,__dis_opprefix
smallorlargejmp:
        testflag (__dis_input_t ptr __dis_gs:si).flags,__df_showsizeop
        jnz     short @@10
        test    (__dis_input_t ptr __dis_gs:si).opcode.prefixes,al
        jz      short @@666
@@10:
        mov     al,dop_small
        cmp     byte ptr __dis_gs:[di],10h
        je      short @@20
        mov     al,dop_large
@@20:
        or      byte ptr (dis_operand_t ptr __dis_gs:bx).flags,al
@@666:
        pop     di ax
        retn
endp    smallorlargeop

        ;
        ;   __dis_initmodrm:near
        ;
        ;   initialize the modR/M byte
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax
        ;
proc    __dis_initmodrm near
        testflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasmodrm
        jnz     short @@666
        getbyte
        jc      short @@666
        mov     ah,al
        and     al,07h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.rmmodrm,ax
        mov     al,ah
        shr     al,03h
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasmodrm
        shr     ah,06h
        and     al,07h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.regmod,ax
@@666:
        retn
endp    __dis_initmodrm

        ;
        ;   __dis_getword:near
        ;
        ;   get a word
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;   output: cf=1=error
        ;           cf=0=eax=zero extended word
        ;   registers: eax
        ;
proc    __dis_getword near
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        xor     eax,eax
        getbyte
        mov     ah,al
        jc      short @@666
        getbyte
        xchg    ah,al
@@666:
        retn
endp    __dis_getword

        ;
        ;   __dis_getdword:near
        ;
        ;   get a dword
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;   output: cf=1=error
        ;           cf=0=eax=dword
        ;   registers: eax
        ;
proc    __dis_getdword near
        assume  es:nothing,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
        push    cx
        mov     cx,0004h
@@loop:
        getbyte
        jc      short @@666
        ror     eax,08h
        loop    @@loop
        clc
@@666:
        pop     cx
        retn
endp    __dis_getdword

        ;
        ;   A:near
        ;
        ;   far call/jmp
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    A near
        mov     (__dis_input_t ptr __dis_gs:si).opcode.optype,optype_far
        call    near ptr smallorlargeop
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_farofs
        mov     cl,dop_sizeword
        mov     ax,offset __dis_getword
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@10h
        mov     cl,dop_sizedword
        mov     ax,offset __dis_getdword
@@10h:
        mov     (dis_operand_t ptr __dis_gs:bx).size,cl
        call    ax
        mov     (dis_operand_t ptr __dis_gs:bx).ops.farptr.ofs,eax
        jc      short @@retn
        call    near ptr __dis_getword
        mov     (dis_operand_t ptr __dis_gs:bx).ops.farptr.seg,ax
@@retn:
        retn
endp    A

        ;
        ;   C:near
        ;
        ;   select a control register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cl
        ;
proc    C
        mov     cl,dr_cr0
endp    C

        ;
        ;   crdrtrmm:near
        ;
        ;   select cr0-cr7/dr0-dr7/tr0-tr7/mm0-mm7
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          cl   dr_cr0, dr_dr0, dr_tr0 or dr_mm0
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cx
        ;
proc    crdrtrmm near
        mov     ch,dop_sizedword
crdrtrmmsavesize:
        mov     (dis_operand_t ptr __dis_gs:bx).size,ch
        call    near ptr __dis_initmodrm
        jc      short @@retn
        add     cl,(__dis_input_t ptr __dis_gs:si).opcode.reg
crdrtrmmsavedata:
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasreg
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_reg
        mov     (dis_operand_t ptr __dis_gs:bx).ops.reg.register,cl
@@retn:
crdrtrmmretn:
        retn
endp    crdrtrmm

        ;
        ;   D:near
        ;
        ;   select a debug register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cl
        ;
proc    D near
        mov     cl,dr_dr0
        jmp     short crdrtrmm
endp    D

        ;
        ;   T:near
        ;
        ;   select an test register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cl
        ;
proc    T near
        mov     cl,dr_tr0
        jmp     short crdrtrmm
endp    T

        ;
        ;   P:near
        ;
        ;   select a mmx register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cl
        ;
proc    P near
        mov     cl,dr_mm0
        mov     ch,dop_sizeqword
        jmp     short crdrtrmmsavesize
endp    P

        ;
        ;   Prm:near
        ;
        ;   select an mmx register (use rm field for register name)
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax,cl
        ;
proc    Prm near
        call    near ptr __dis_initmodrm
        mov     cl,dr_mm0
        jc      short crdrtrmmretn
        add     cl,(__dis_input_t ptr __dis_gs:si).opcode.rm
        mov     (dis_operand_t ptr __dis_gs:bx).size,dop_sizeqword
        jmp     short crdrtrmmsavedata
endp    Prm

        ;
        ;   savebaseandindex:near
        ;
        ;   save a base and index
        ;
        ;   input: __dis_gs:bx dis_operand_t struc
        ;          al   base register
        ;          ah   index register
        ;   output: cf=0
        ;   registers: al,cl
        ;
proc    savebaseandindex near
        call    near ptr __savesegoverride
        xor     cl,cl
        cmp     al,dr_none
        je      short @@none1
        mov     cl,dm_hasbase
@@none1:
        cmp     ah,dr_none
        je      short @@none2
        or      cl,dm_hasindex
        and     al,0Fh                  ;if al=dr_none (FFh)
        or      al,ah
@@none2:
        or      (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,cl
        mov     (dis_operand_t ptr __dis_gs:bx).ops.mem.baseindex,al
        retn
endp    savebaseandindex

savesegoverride_defaultds:
        push    bx
        mov     bx,di
        mov     ah,dm_segds shl 4
        call    near ptr savesegoverride
        pop     bx
        retn

        ;
        ;   __savesegoverride:near
        ;
        ;   save the segment override and default segment override
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          al   base register
        ;          ah   index register shl 4 !!!! (if base = dr_none)
        ;   output: none
        ;   registers: none
        ;
proc    __savesegoverride near
        push    ax
        cmp     al,dr_none
        jne     short @@10
        mov     al,ah
        shr     al,04h
@@10:
        mov     ah,dm_segss shl 4
        cmp     al,dr_bp
        je      short @@20
        cmp     al,dr_ebp
        je      short @@20
        cmp     al,dr_esp
        je      short @@20
        mov     ah,dm_segds shl 4
@@20:
        call    near ptr savesegoverride
        pop     ax
        retn
endp    __savesegoverride

        ;
        ;   savesegoverride:near
        ;
        ;   save the segment override and default segment override
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          ah   default segment override shl 4 (dm_segXX shl 4)
        ;   output: none
        ;   registers: al
        ;
proc    savesegoverride near
if dm_seges ne 0
  err
endif
if __dis_esprefix ne 1
  err
endif
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.prefixes
        and     al,07h
        jz      short @@10
        setflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_segoverride
        dec     ax              ;__dis_esprefix is 1
@@10:
        or      al,ah
        mov     (dis_operand_t ptr __dis_gs:bx).ops.mem.segoverride,al
savesegoverrideretn:
        retn
endp    savesegoverride

ERMregister:
        test    cl,cl
        mov     cl,(__dis_input_t ptr __dis_gs:si).opcode.rm
        jz      __dis_generalregister
        add     cl,dr_mm0
        mov     ch,dop_sizeqword
        jmp     __dis_generalregistersavedata

        ;
        ;   Q:near
        ;
        ;   the operand is either a mmx register or memory
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cx,dx
        ;
proc    Q near
        mov     cl,01h
        jmp     short ERMstarthere
endp    Q

        ;
        ;   E/R/M:near
        ;
        ;   the operand is either a register or memory
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cx,dx
        ;
proc    E near
proc    R near
proc    M near
        xor     cl,cl
ERMstarthere:
        push    ax
        call    near ptr __dis_initmodrm
        pop     ax
        jc      short savesegoverrideretn
        mov     dl,(__dis_input_t ptr __dis_gs:si).opcode.mod
        cmp     dl,03h
        je      short ERMregister
if dop_mem
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_mem
endif
        call    near ptr __dis_convertequ
        mov     (dis_operand_t ptr __dis_gs:bx).size,al
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.adrsize,10h
        je      short @@adr10h
@@adr20h:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.rm
        test    dl,dl
        jnz     short @@3210
        cmp     al,05h
        je      short @@onlydworddispl
@@3210:
        cmp     al,04h
        jne     short @@32nosib
        getbyte
        mov     ah,al
        jc      short savesegoverrideretn
        shr     ah,03h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.sib,al
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hassib
        and     ax,0707h
        mov     dh,ah
        shl     ah,04h
        cmp     al,05h
        jne     short @@sibnoindexdispl
        test    dl,dl
        jnz     short @@sibnoindexdispl
if dr_eax
        add     ah,dr_eax shl 4
endif
        mov     al,dr_none
        mov     dl,10b
        jmp     short @@esp
@@sibnoindexdispl:
if dr_eax
        add     ax,(dr_eax shl 0Ch) or dr_eax
endif
        cmp     ah,dr_esp shl 04h
        jne     short @@3220
        mov     ah,dr_none
@@3220:
@@esp:
        call    near ptr savebaseandindex
        cmp     dh,04h
        je      short @@32savedispl
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.sib
        shr     al,06h
        setflag (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,dm_hasscale
        or      (dis_operand_t ptr __dis_gs:bx).ops.mem.scale,al
        jmp     short @@32savedispl
@@32nosib:
        mov     ah,dr_none
if dr_eax
        add     al,dr_eax
endif
        call    near ptr savebaseandindex
@@32savedispl:
        cmp     dl,01h
        je      short @@32getsignedbyte
        ja      short @@32getdword
        cmc
        retn

@@onlydworddispl:
        mov     ah,dm_segds shl 4
        call    near ptr savesegoverride
        call    near ptr smallorlargeadr
@@32getdword:
        call    near ptr __dis_getdword
        mov     cl,dm_displdword
        jnc     short @@savedispl
        retn

@@adr10h:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.rm
        test    dl,dl
        jnz     short @@modnezero
        cmp     al,06h
        je      short @@onlyworddispl
@@modnezero:
        push    bx
        movzx   bx,al
        add     bx,bx
        mov     ax,[bx+baseindex16]     ;al=base,ah=index
        pop     bx
        call    near ptr savebaseandindex

        cmp     dl,01h
        je      short @@16getsignedbyte
        ja      short @@16getword
        cmc
        retn
@@32getsignedbyte:
        mov     cl,dm_displbyte or dm_displsignextended
        getbyte
        movsx   eax,al
        jnc     short @@savedispl
        retn
@@16getsignedbyte:
        xor     eax,eax
        mov     cl,dm_displbyte or dm_displsignextended
        getbyte
        jc      short @@retn
        cbw
@@savedispl:
        or      cl,dm_hasdispl
        mov     (dis_operand_t ptr __dis_gs:bx).ops.mem.displ,eax
        or      (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,cl
@@retn:
        retn
@@onlyworddispl:
        mov     ah,dm_segds shl 4
        call    near ptr savesegoverride
        call    near ptr smallorlargeadr
@@16getword:
        call    near ptr __dis_getword
        mov     cl,dm_displword
        jnc     short @@savedispl
        retn
endp    M
endp    R
endp    E

        ;
        ;   __dis_convertequ:near
        ;
        ;   convert vmode/bmode/etcmode equate to a dop_sizebyte/dop_sizeXXX
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          al   vmode/bmode/etcmode
        ;   output: al  dop_sizebyte/dop_sizeXXX
        ;   registers: al
        ;
proc    __dis_convertequ near
        push    bx
        movzx   bx,al
        add     bx,bx
        mov     al,[bx+__dis_convertequtable]
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@666
        mov     al,[bx+__dis_convertequtable+1]
@@666:
        pop     bx
        retn
endp    __dis_convertequ

        ;
        ;   O:near
        ;
        ;   get a memory offset
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    O near
if dop_mem
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_mem
endif
        call    near ptr __dis_convertequ
        mov     (dis_operand_t ptr __dis_gs:bx).size,al
        mov     cl,dm_displword or dm_hasdispl
        mov     ax,offset __dis_getword
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.adrsize,10h
        je      short @@10
        mov     cl,dm_displdword or dm_hasdispl
        mov     ax,offset __dis_getdword
@@10:
        call    ax
        mov     (dis_operand_t ptr __dis_gs:bx).ops.mem.displ,eax
        jc      short @@666
        mov     ah,dm_segds shl 4
        call    near ptr savesegoverride
        call    near ptr smallorlargeadr
        or      (dis_operand_t ptr __dis_gs:bx).ops.mem.__flags,cl
@@666:
        retn
endp    O

        ;
        ;   G:near
        ;
        ;   select a general register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: cx
        ;
proc    G near
        push    ax
        call    near ptr __dis_initmodrm
        pop     ax
        jc      short @@666
        mov     cl,(__dis_input_t ptr __dis_gs:si).opcode.reg
__dis_generalregister:
        xor     ch,ch
        call    near ptr __dis_getregequandregsize
__dis_generalregistersavedata:
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasreg
        mov     (dis_operand_t ptr __dis_gs:bx).ops.reg.register,cl
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_reg
        mov     (dis_operand_t ptr __dis_gs:bx).size,ch
@@666:
        retn
endp    G

        ;
        ;   __dis_getregequandregsize:near
        ;
        ;   return a register equate and get its size
        ;
        ;   input: al   register mode (bmode,wmode,etcmode)
        ;          cx   register number (0-7)
        ;          __dis_gs:si __dis_input_t struc
        ;   output: cl  register equate (dr_ax,dr_esp,dr_etc)
        ;           ch  register size (dop_sizebyte,dop_sizedword,dop_sizeetc)
        ;   registers: cx
        ;
proc    __dis_getregequandregsize near
        cmp     al,vmode
        je      short @@vmode
        cmp     al,bmode
        je      short @@bmode
        cmp     al,dmode
        je      short @@dmode
        cmp     al,wmode
        je      short @@wmode
        ;we get here if the type is osmode (les eax,eax) when the source
        ;is a register instead of a memory
@@vmode:
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@wmode
@@dmode:
        add     cx,(dop_sizedword shl 8) or dr_eax
        retn
@@wmode:
        add     cx,(dop_sizeword shl 8) or dr_ax
        retn
@@bmode:
        add     cx,(dop_sizebyte shl 8) or dr_al
        retn
endp    __dis_getregequandregsize

        ;
        ;   I:near
        ;
        ;   immediate operand
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    I near
        cmp     al,vmode
        je      short @@Iv
        cmp     al,wmode
        je      short @@Iw
@@Ib:
        xor     eax,eax
        getbyte
        mov     cl,dop_sizebyte
        jmp     short @@I
@@Iv:
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@Iw
@@Id:
        call    near ptr __dis_getdword
        mov     cl,dop_sizedword
        jmp     short @@I
@@Iw:
        mov     cl,dop_sizeword
        call    near ptr __dis_getword
@@I:
        jc      short @@retn
Isavedata:
        mov     (dis_operand_t ptr __dis_gs:bx).ops.imm.immediate,eax
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_imm
        mov     (dis_operand_t ptr __dis_gs:bx).size,cl
@@retn:
Iretn:
        retn
endp    I

        ;
        ;   Is:near
        ;
        ;   immediate operand (sign-extended byte to default size)
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    Is near
        setflag (dis_operand_t ptr __dis_gs:bx).ops.imm.__flags,di_signextended
        xor     eax,eax
        getbyte
        mov     cl,dop_sizeword
        jc      short Iretn
        cbw
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short Isavedata
        cwde
        mov     cl,dop_sizedword
        jmp     short Isavedata
endp    Is

        ;
        ;   Icb:near
        ;
        ;   immediate constant operand byte
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;          al   value
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    Icb near
        movzx   eax,al
        mov     cl,dop_sizebyte
        jmp     short Isavedata
endp    Icb

        ;
        ;   J:near
        ;
        ;   jmp/call relative offset
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cl
        ;
proc    J near
        cmp     al,vmode
        je      short @@vmode
@@bmode:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.optype,optype_short
        setflag (dis_operand_t ptr __dis_gs:bx).ops.nearptr.__flags,dn_short
        xor     eax,eax
        getbyte
        jc      short @@retn
        cbw
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,20h
        je      short @@b32
@@b16:
@@16:
        add     eax,(__dis_input_t ptr __dis_gs:si).eip
        mov     cl,dop_sizeword
        movzx   eax,ax
@@savenumber:
        mov     (dis_operand_t ptr __dis_gs:bx).ops.nearptr.ofs,eax
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_nearofs
        mov     (dis_operand_t ptr __dis_gs:bx).size,cl
        retn
@@b32:
        cwde
@@32:
        mov     cl,dop_sizedword
        add     eax,(__dis_input_t ptr __dis_gs:si).eip
        jmp     short @@savenumber
@@dmode:
        call    near ptr __dis_getdword
        jnc     short @@32
@@retn:
        retn
@@vmode:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.optype,optype_near
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,20h
        je      short @@dmode
@@wmode:
        call    near ptr __dis_getword
        jnc     short @@16
        retn
endp    J

        ;
        ;   S:near
        ;
        ;   select a segment register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax
        ;
proc    S near
        call    near ptr __dis_initmodrm
        jc      short @@retn
        mov     al,dop_sizeword
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@10
        mov     al,dop_sizedword
@@10:
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_reg
        mov     (dis_operand_t ptr __dis_gs:bx).size,al
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasreg or do_hassegreg
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.reg
        add     al,dr_es
        mov     (dis_operand_t ptr __dis_gs:bx).ops.reg.register,al
@@retn:
        retn
endp    S

        ;
        ;   reg:near
        ;
        ;   select a general register or a segment register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: ax
        ;
proc    reg near
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hasreg
if $eAX
        cmp     al,$eAX
        jb      short @@not$eAX
endif
        cmp     al,$eDI
        ja      short @@not$eAX
        mov     ah,dr_ax-$eAX
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@10
        mov     ah,dr_eax-$eAX
@@10:
        add     al,ah
@@wordordword:  ;word ord word
        mov     ah,dop_sizeword
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,10h
        je      short @@ok
        mov     ah,dop_sizedword
        jmp     short @@ok
@@not$eAX:
if $al
        cmp     al,$al
        jb      short @@not$al
endif
        cmp     al,$bh
        ja      short @@not$al
        mov     ah,dop_sizebyte
        add     al,dr_al-$al
        jmp     short @@ok
@@not$al:
        cmp     al,$es
        jb      short @@not$es
        cmp     al,$gs
        ja      short @@not$es
        add     al,dr_es-$es
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hassegreg
        jmp     short @@wordordword
@@not$es:
        cmp     al,$dx
        jne     short @@not$dx
        mov     ax,(dop_sizeword shl 8) or dr_dx
        jmp     short @@ok
@@not$dx:
        mov     ax,(dop_sizeword shl 8) or dr_ax
@@ok:
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_reg
        mov     (dis_operand_t ptr __dis_gs:bx).size,ah
        mov     (dis_operand_t ptr __dis_gs:bx).ops.reg.register,al
regretn:
        retn
endp    reg

op00F6: ;Unary Grp3 Eb
        mov     di,offset jmp00F6
        mov     ah,opid_grp3Eb shr 8
        jmp     short changegrpname
op00F7: ;Unary Grp3 Ev
        mov     di,offset jmp00F7
        mov     ah,opid_grp3Ev shr 8
        jmp     short changegrpname
op00FE: ;inc/dec Grp4
        mov     di,offset jmp00FE
        mov     ah,opid_grp4 shr 8
        jmp     short changegrpname
op00FF: ;inc/dec Grp5
        mov     di,offset jmp00FF
        mov     ah,opid_grp5 shr 8
        jmp     short changegrpname
op0F00: ;Grp6
        mov     di,offset jmp0F00
        mov     ah,opid_grp6 shr 8
        jmp     short changegrpname
op0F01: ;Grp7
        mov     di,offset jmp0F01
        mov     ah,opid_grp7 shr 8
        jmp     short changegrpname
op0FBA: ;Grp8 Ev,Ib
        mov     di,offset jmp0FBA
        mov     ah,opid_grp8 shr 8
        jmp     short changegrpname
op0FC7: ;Grp9
        mov     di,offset jmp0FC7
        mov     ah,opid_grp9 shr 8

        ;
        ;   changegrpname:near
        ;
        ;   the opcode is in one of the nine groups.
        ;
        ;   input: ah   opid_grpX equate
        ;          di   offset to a jmpXXXX table (jmp0080,jmp0081,etc)
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: eax,cx,dx,bx,di
        ;
proc    changegrpname near
        push    ax
        call    near ptr __dis_initmodrm
        pop     ax
        jc      short regretn
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.reg
        movzx   bx,al
        add     bx,bx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        jmp     word ptr ds:[bx+di]
endp    changegrpname

op0080: ;Immediate Grp1 Eb,Ib
        mov     di,offset jmp0080
        mov     ah,opid_grp1EbIbA shr 8
        jmp     short changegrpname
op0081: ;Immediate Grp1 Ev,Iv
        mov     di,offset jmp0081
        mov     ah,opid_grp1EvIv shr 8
        jmp     short changegrpname
op0082: ;Immediate Grp1 Eb,Ib   !!!! intel sez: Ev,Ib
        mov     di,offset jmp0082
        mov     ah,opid_grp1EbIbB shr 8
        jmp     short changegrpname
op0083: ;Immediate Grp1 Ev,Ib   !!!! intel sez: Eb,Ib
        mov     di,offset jmp0083
        mov     ah,opid_grp1EvIb shr 8
        jmp     short changegrpname
op00C0: ;Shift Grp2a Eb,Ib
        mov     di,offset jmp00C0
        mov     ah,opid_grp2EbIb shr 8
        jmp     short changegrpname
op00C1: ;Shift Grp2a Ev,Ib
        mov     di,offset jmp00C1
        mov     ah,opid_grp2EvIb shr 8
        jmp     short changegrpname
op00D0: ;Shift Grp2 Eb,01h
        mov     di,offset jmp00D0
        mov     ah,opid_grp2Eb1 shr 8
        jmp     short changegrpname
op00D1: ;Shift Grp2 Ev,01h
        mov     di,offset jmp00D1
        mov     ah,opid_grp2Ev1 shr 8
        jmp     short changegrpname
op00D2: ;Shift Grp2 Eb,CL
        mov     di,offset jmp00D2
        mov     ah,opid_grp2EbCL shr 8
        jmp     short changegrpname
op00D3: ;Shift Grp2 Ev,CL
        mov     di,offset jmp00D3
        mov     ah,opid_grp2EvCL shr 8
        jmp     short changegrpname
op0F71: ;Grp #A PSHIMW
        mov     di,offset jmp0F71
        mov     ah,opid_grpA0F71 shr 8
        jmp     short changegrpname
op0F72: ;Grp #A PSHIMD
        mov     di,offset jmp0F72
        mov     ah,opid_grpA0F72 shr 8
        jmp     short changegrpname
op0F73: ;Grp #A PSHIMQ
        mov     di,offset jmp0F73
        mov     ah,opid_grpA0F73 shr 8
        jmp     short changegrpname
op0FAE: ;Grp #B
        mov     di,offset jmp0FAE
        mov     ah,opid_grpB shr 8
        jmp     short changegrpname

; Here comes the boring stuff 

op0F78: ;svdc (Cyrix)
        mov     al,opid_cyrixsvdc and 0FFh
        jmp     short checkcyrix
op0F79: ;rsdc (Cyrix)
        mov     al,opid_cyrixrsdc and 0FFh
        jmp     short checkcyrix
op0F7A: ;svldt (Cyrix)
        mov     al,opid_cyrixsvldt and 0FFh
        jmp     short checkcyrix
op0F7B: ;rsldt (Cyrix)
        mov     al,opid_cyrixrsldt and 0FFh
        jmp     short checkcyrix
op0F7C: ;svts (Cyrix)
        mov     al,opid_cyrixsvts and 0FFh
        jmp     short checkcyrix
op0F7D: ;rsts (Cyrix)
        mov     al,opid_cyrixrsts and 0FFh
        jmp     short checkcyrix
op0F36: ;rdshr (Cyrix)
        mov     al,opid_cyrixrdshr and 0FFh
        jmp     short checkcyrix
op0F37: ;wrshr (Cyrix)
        mov     al,opid_cyrixwrshr and 0FFh
        jmp     short checkcyrix
op0F38: ;smint (Cyrix)
        mov     al,opid_cyrixsmint and 0FFh
checkcyrix:
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_cyrix
        jne     db0Fopcode
        mov     ah,opid_cyrixspecial shr 8
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        retn

op0F50: ;paveb Pq,Qq (Cyrix)
        mov     al,opid_cyrixpaveb and 0FFh
        jmp     short checkcyrixPqQq
op0F51: ;paddsiw Pq,Qq (Cyrix)
        mov     al,opid_cyrixpaddsiw and 0FFh
        jmp     short checkcyrixPqQq
op0F52: ;pmagw Pq,Qq (Cyrix)
        mov     al,opid_cyrixpmagw and 0FFh
        jmp     short checkcyrixPqQq
op0F55: ;psubsiw Pq,Qq (Cyrix)
        mov     al,opid_cyrixpsubsiw and 0FFh
        jmp     short checkcyrixPqQq
op0F59: ;pmulhrw Pq,Qq (Cyrix)
        mov     al,opid_cyrixpmulhrw and 0FFh
        jmp     short checkcyrixPqQq
op0F5D: ;pmulhriw Pq,Qq (Cyrix)
        mov     al,opid_cyrixpmulhriw and 0FFh
checkcyrixPqQq:
        mov     dx,offset Q
checkcyrixPqXq:
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_cyrix
        jne     db0Fopcode
        mov     ah,opid_cyrixspecial shr 8
        mov     cx,offset P
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        mov     ax,(qmode shl 8) or qmode
        jmp     twooperands

op0F54: ;pdistib Pq,Mq (Cyrix)
        mov     al,opid_cyrixpdistib and 0FFh
        jmp     short checkcyrixPqMq
op0F58: ;pmvzb Pq,Mq (Cyrix)
        mov     al,opid_cyrixpmvzb and 0FFh
        jmp     short checkcyrixPqMq
op0F5A: ;pmvnzb Pq,Mq (Cyrix)
        mov     al,opid_cyrixpmvnzb and 0FFh
        jmp     short checkcyrixPqMq
op0F5B: ;pmvlzb Pq,Mq (Cyrix)
        mov     al,opid_cyrixpmvlzb and 0FFh
        jmp     short checkcyrixPqMq
op0F5C: ;pmvgezb Pq,Mq (Cyrix)
        mov     al,opid_cyrixpmvgezb and 0FFh
        jmp     short checkcyrixPqMq
op0F5E: ;pmachriw Pq,Mq (Cyrix)
        mov     al,opid_cyrixpmachriw and 0FFh
checkcyrixPqMq:
        mov     dx,offset M
        jmp     short checkcyrixPqXq

op0F0F: ;escape to K3D opcodes (AMD K3D)
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_amd
        jne     db0Fopcode
        ;The K3D operand encoding is this:
        ;0Fh, 0Fh, modR/M, [displ/whatever according to modR/M], opcode
        call    near ptr twooperandsPqQq
        jc      short op0F0Fretn
        getbyte
        mov     ah,opid_amdk3d shr 8
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        mov     ah,0Fh
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeword,ax
op0F0Fretn:
        retn

op0F0D: ;prefetchX M (AMD K3D)
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_amd
        jne     db0Fopcode
        call    near ptr __dis_initmodrm
        mov     ax,opid_amdprefetch
        jc      short op0F07retn
        add     al,(__dis_input_t ptr __dis_gs:si).opcode.reg
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
        mov     al,dmode                ;we need a memory size...
        jmp     oneoperandM

op0F0E: ;femms (AMD K3D)
        mov     ax,opid_amdfemms
        jmp     short saveamdopid
op0FFF: ;UD (#UD exception) (AMD K3D)
        mov     ax,opid_amdud
        jmp     short saveamdopid
op0F07: ;sysret (AMD)
        mov     ax,opid_amdsysret
saveamdopid:
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_amd
        jne     short db0Fopcode
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
op0F07retn:
        retn

op00B9: ;mov eCX,Iv
op00BA: ;mov eDX,Iv
op00BB: ;mov eBX,Iv
op00BC: ;mov eSP,Iv
op00BD: ;mov eBP,Iv
op00BE: ;mov eSI,Iv
op00BF: ;mov eDI,Iv
        mov     cl,0B8h-$eAX
        mov     ah,vmode
        jmp     short twooperandsregIsubalcl

op00FE_010:
op00FE_011:
op00FE_100:
op00FE_101:
op00FE_110:
op00FE_111:
op00FF_111:
        mov     al,byte ptr (__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        mov     ah,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        jmp     short IcbIcbopcodeiddb

op0FB6: ;movzx Gv,Eb
op0FBE: ;movsx Gv,Eb
        mov     ax,(bmode shl 8) or vmode
        jmp     short twooperandsGEshowmemsize

op0F26: ;mov Td,Rd
        mov     cx,offset T
        jmp     short twooperandsdmodedmodeR
op0F23: ;mov Dd,Rd
        mov     cx,offset D
        jmp     short twooperandsdmodedmodeR
op0F21: ;mov Rd,Dd
        mov     cx,offset R
        mov     dx,offset D
        jmp     short twooperandsdmodedmode
op0F22: ;mov Cd,Rd
        mov     cx,offset C
twooperandsdmodedmodeR:
        mov     dx,offset R
        jmp     short twooperandsdmodedmode
op0F24: ;mov Rd,Td
        mov     cx,offset R
        mov     dx,offset T
        jmp     short twooperandsdmodedmode

op0FB7: ;movzx Gv,Ew
op0FBF: ;movsx Gv,Ew
        mov     ax,(wmode shl 8) or vmode
twooperandsGEshowmemsize:
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_showmemsize
        jmp     short twooperandsGE

; Start of Gv,Ev code 
op0F40: ;cmovo Gv,Ev
op0F41: ;cmovno Gv,Ev
op0F42: ;cmovc/cmovb/cmovnae Gv,Ev
op0F43: ;cmovnc/cmovnb/cmovae Gv,Ev
op0F44: ;cmovz/cmove Gv,Ev
op0F45: ;cmovnz/cmovne Gv,Ev
op0F46: ;cmovbe/cmovna Gv,Ev
op0F47: ;cmovnbe/cmova Gv,Ev
op0F48: ;cmovs Gv,Ev
op0F49: ;cmovns Gv,Ev
op0F4A: ;cmovp/cmovpe Gv,Ev
op0F4B: ;cmovnp/cmovpo Gv,Ev
op0F4C: ;cmovl/cmovnge Gv,Ev
op0F4D: ;cmovnl/cmovge Gv,Ev
op0F4E: ;cmovle/cmovng Gv,Ev
op0F4F: ;cmovnle/cmovg Gv,Ev
op0F13: ;umov Gv,Ev
op000B: ;or Gv,Ev
op0013: ;adc Gv,Ev
op001B: ;sbb Gv,Ev
op0023: ;and Gv,Ev
op002B: ;sub Gv,Ev
op0033: ;xor Gv,Ev
op003B: ;cmp Gv,Ev
op008B: ;mov Gv,Ev
op0F02: ;lar Gv,Ew      !@# Use Gv,Ev
op0F03: ;lsl Gv,Ew      !@# Use Gv,Ev
op0FAF: ;imul Gv,Ev
op0FBC: ;bsf Gv,Ev
op0FBD: ;bsr Gv,Ev
op0003: ;add Gv,Ev
        mov     ax,(vmode shl 8) or vmode
        jmp     short twooperandsGE

op00D1_000: ;rol Ev,01h
op00D1_001: ;ror Ev,01h
op00D1_010: ;rcl Ev,01h
op00D1_011: ;rcr Ev,01h
op00D1_100: ;shl/sal Ev,01h
op00D1_101: ;shr Ev,01h
op00D1_110: ;shr Ev,01h (UNDOCUMENTED)
op00D1_111: ;sar Ev,01h
        mov     al,vmode
        jmp     short twooperandsEIcb01

op00D3_000: ;rol Ev,CL
op00D3_001: ;ror Ev,CL
op00D3_010: ;rcl Ev,CL
op00D3_011: ;rcr Ev,CL
op00D3_100: ;shl/sal Ev,CL
op00D3_101: ;shr Ev,CL
op00D3_110: ;shr Ev,CL (UNDOCUMENTED)
op00D3_111: ;sar Ev,CL
        mov     al,vmode
        jmp     short twooperandsEregCL

; Start of eAX,Iv code 
op000D: ;or eAX,Iv
op0015: ;adc eAX,Iv
op001D: ;sbb eAX,Iv
op0025: ;and eAX,Iv
op002D: ;sub eAX,Iv
op0035: ;xor eAX,Iv
op003D: ;cmp eAX,Iv
op00A9: ;test eAX,Iv
op00B8: ;mov eAX,Iv
op0005: ;add eAX,Iv
        mov     ah,vmode
        jmp     short twooperandsregIeAX

op00B1: ;mov CL,Ib
op00B2: ;mov DL,Ib
op00B3: ;mov BL,Ib
op00B4: ;mov AH,Ib
op00B5: ;mov CH,Ib
op00B6: ;mov DH,Ib
op00B7: ;mov BH,Ib
        mov     cl,0B0h-$al
        mov     ah,bmode
twooperandsregIsubalcl:
        mov     al,byte ptr (__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        sub     al,cl
        jmp     short twooperandsregI

op00E5: ;in eAX,Ib
ife bmode
        xor     ah,ah
else
        mov     ah,bmode
endif
twooperandsregIeAX:
        mov     al,$eAX
        jmp     short twooperandsregI

; Start of Ev,Gv code 
op0F11: ;umov Ev,Gv
op0001: ;add Ev,Gv
op0009: ;or Ev,Gv
op0011: ;adc Ev,Gv
op0019: ;sbb Ev,Gv
op0021: ;and Ev,Gv
op0029: ;sub Ev,Gv
op0031: ;xor Ev,Gv
op0039: ;cmp Ev,Gv
op0085: ;test Ev,Gv
op0087: ;xchg Ev,Gv
op0063: ;arpl Ew,Gw     !@# Use Ev,Gv
op0089: ;mov Ev,Gv
op0FA3: ;bt Ev,Gv
op0FAB: ;bts Ev,Gv
op0FB1: ;cmpxchg Ev,Gv
op0FB3: ;btr Ev,Gv
op0FBB: ;btc Ev,Gv
op0FC1: ;xadd Ev,Gv
EvGv:
        mov     ax,(vmode shl 8) or vmode
        jmp     short twooperandsEG

op0F04:
op0F0A:
op0F0C:
op0F14:
op0F15:
op0F16:
op0F17:
op0F18:
op0F19:
op0F1A:
op0F1B:
op0F1C:
op0F1D:
op0F1E:
op0F1F:
op0F25:
op0F27:
op0F28:
op0F29:
op0F2A:
op0F2B:
op0F2C:
op0F2D:
op0F2E:
op0F2F:
op0F39:
op0F3A:
op0F3B:
op0F3C:
op0F3D:
op0F3E:
op0F3F:
op0F53:
op0F56:
op0F57:
op0F5F:
op0F6C:
op0F6D:
op0F70:
op0FA6:
op0FA7:
op0FB8:
op0FC2:
op0FC3:
op0FC4:
op0FC5:
op0FC6:
op0FD0:
op0FD4:
op0FD6:
op0FD7:
op0FDA:
op0FDE:
op0FE0:
op0FE3:
op0FE4:
op0FE6:
op0FE7:
op0FEA:
op0FEE:
op0FF0:
op0FF4:
op0FF6:
op0FF7:
op0FFB:
db0Fopcode:
        mov     ax,(__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        xchg    al,ah
IcbIcbopcodeiddb:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_db
IcbIcb:
        mov     cx,offset Icb
        mov     dx,cx
        jmp     short twooperands

op00D0_000: ;rol Eb,01h
op00D0_001: ;ror Eb,01h
op00D0_010: ;rcl Eb,01h
op00D0_011: ;rcr Eb,01h
op00D0_100: ;shl/sal Eb,01h
op00D0_101: ;shr Eb,01h
op00D0_110: ;shr Eb,01h (UNDOCUMENTED)
op00D0_111: ;sar Eb,01h
ife bmode
        xor     al,al
else
        mov     al,bmode
endif
twooperandsEIcb01:
        mov     ah,01h
        mov     cx,offset E
        mov     dx,offset Icb
        jmp     short twooperands

op00D2_000: ;rol Eb,CL
op00D2_001: ;ror Eb,CL
op00D2_010: ;rcl Eb,CL
op00D2_011: ;rcr Eb,CL
op00D2_100: ;shl/sal Eb,CL
op00D2_101: ;shr Eb,CL
op00D2_110: ;shr Eb,CL (UNDOCUMENTED)
op00D2_111: ;sar Eb,CL
ife bmode
        xor     al,al
else
        mov     al,bmode
endif
twooperandsEregCL:
        mov     ah,$cl
        mov     cx,offset E
        mov     dx,offset reg
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_showmemsize
        jmp     short twooperands

op0F20: ;mov Rd,Cd
        mov     cx,offset R
        mov     dx,offset C
twooperandsdmodedmode:
        mov     ax,(dmode shl 8) or dmode
        jmp     short twooperands

op008C: ;mov Ew,Sw      !@# Use mov Ev,Sv
        mov     cx,offset E
        mov     dx,offset S
twooperandsvmodevmodeseg:
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_hassegreg
twooperandsvmodevmode:
        mov     ax,(vmode shl 8) or vmode
        jmp     short twooperands
op008E: ;mov Sw,Ew      !@# Use mov Sv,Ev
        mov     cx,offset S
        mov     dx,offset E
        jmp     short twooperandsvmodevmodeseg

; Start of Gb,Eb code 
op0F12: ;umov Gb,Eb
op0002: ;add Gb,Eb
op000A: ;or Gb,Eb
op0012: ;adc Gb,Eb
op001A: ;sbb Gb,Eb
op0022: ;and Gb,Eb
op002A: ;sub Gb,Eb
op0032: ;xor Gb,Eb
op003A: ;cmp Gb,Eb
op008A: ;mov Gb,Eb
GbEb:
ife bmode
        xor     ax,ax
else
        mov     ax,(bmode shl 8) or bmode
endif
twooperandsGE:
        mov     cx,offset G
        mov     dx,offset E
        jmp     short twooperands

op00E7: ;out Ib,eAX
        mov     ah,$eAX
        jmp     short twooperandsIbreg
op00E6: ;out Ib,AL
        mov     ah,$al
twooperandsIbreg:
ife bmode
        xor     al,al
else
        mov     al,bmode
endif
twooperandsIreg:
        mov     cx,offset I
        mov     dx,offset reg
        jmp     short twooperands

; Start of AL,Ib code 
op0004: ;add AL,Ib
op000C: ;or AL,Ib
op0014: ;adc AL,Ib
op001C: ;sbb AL,Ib
op0024: ;and AL,Ib
op002C: ;sub AL,Ib
op0034: ;xor AL,Ib
op003C: ;cmp AL,Ib
op00A8: ;test AL,Ib
op00B0: ;mov AL,Ib
op00E4: ;in AL,Ib
        mov     ax,(bmode shl 8) or $al
twooperandsregI:
        mov     cx,offset reg
        mov     dx,offset I
        jmp     short twooperands

; Start of Eb,Gb code 
op0F10: ;umov Eb,Gb
op0000: ;add Eb,Gb
op0008: ;or Eb,Gb
op0010: ;adc Eb,Gb
op0018: ;sbb Eb,Gb
op0020: ;and Eb,Gb
op0028: ;sub Eb,Gb
op0030: ;xor Eb,Gb
op0038: ;cmp Eb,Gb
op0084: ;test Eb,Gb
op0086: ;xchg Eb,Gb
op0088: ;mov Eb,Gb
op0FB0: ;cmpxchg Eb,Gb
op0FC0: ;xadd Eb,Gb
EbGb:
ife bmode
        xor     ax,ax
else
        mov     ax,(bmode shl 8) or bmode
endif
twooperandsEG:
        mov     cx,offset E
        mov     dx,offset G
        ;
        ;   twooperands:near
        ;
        ;   input: cx   offset of first procedure to call
        ;          dx   offset of second procedure to call
        ;          al   input to first procedure
        ;          ah   input to second procedure
        ;
twooperands:
        call    near ptr __dis_zerotwoops
__twooperands:
        push    ax dx
        call    near ptr __oneoperand
        pop     cx ax
        mov     al,ah
        jc      short twooperandsretn
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.op2
        call    cx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,02h
twooperandsretn:
        retn

op0062: ;bound Gv,Ma    !@# Use Gv,Mv
        mov     ah,amode
        jmp     short twooperandsGMvmode
op008D: ;lea Gv,M
        mov     ah,vmode
twooperandsGMvmode:
        mov     al,vmode
        mov     cx,offset G
        mov     dx,offset M
        jmp     short twooperands

op00C6: ;mov Eb,Ib
op0080_000: ;add Eb,Ib
op0080_001: ;or Eb,Ib
op0080_010: ;adc Eb,Ib
op0080_011: ;sbb Eb,Ib
op0080_100: ;and Eb,Ib
op0080_101: ;sub Eb,Ib
op0080_110: ;xor Eb,Ib
op0080_111: ;cmp Eb,Ib
op0082_000: ;add Eb,Ib  !!!! intel sez: Ev,Ib
op0082_001: ;or Eb,Ib  !!!! intel sez: Ev,Ib
op0082_010: ;adc Eb,Ib  !!!! intel sez: Ev,Ib
op0082_011: ;sbb Eb,Ib  !!!! intel sez: Ev,Ib
op0082_100: ;and Eb,Ib  !!!! intel sez: Ev,Ib
op0082_101: ;sub Eb,Ib  !!!! intel sez: Ev,Ib
op0082_110: ;xor Eb,Ib  !!!! intel sez: Ev,Ib
op0082_111: ;cmp Eb,Ib  !!!! intel sez: Ev,Ib
op00C0_000: ;rol Eb,Ib
op00C0_001: ;ror Eb,Ib
op00C0_010: ;rcl Eb,Ib
op00C0_011: ;rcr Eb,Ib
op00C0_100: ;shl/sal Eb,Ib
op00C0_101: ;shr Eb,Ib
op00C0_110: ;shr Eb,Ib (UNDOCUMENTED)
op00C0_111: ;sar Eb,Ib
op00F6_000: ;test Eb,Ib
op00F6_001: ;test Eb,Ib (UNDOCUMENTED)
twooperandsEbIb:
ife bmode
        xor     ax,ax
else
        mov     ax,(bmode shl 8) or bmode
endif
twooperandsEI:
        mov     cx,offset E
        mov     dx,offset I
        jmp     short twooperands

op0083_000: ;add Ev,Ib  !!!! intel sez: Eb,Ib
op0083_001: ;or Ev,Ib  !!!! intel sez: Eb,Ib
op0083_010: ;adc Ev,Ib  !!!! intel sez: Eb,Ib
op0083_011: ;sbb Ev,Ib  !!!! intel sez: Eb,Ib
op0083_100: ;and Ev,Ib  !!!! intel sez: Eb,Ib
op0083_101: ;sub Ev,Ib  !!!! intel sez: Eb,Ib
op0083_110: ;xor Ev,Ib  !!!! intel sez: Eb,Ib
op0083_111: ;cmp Ev,Ib  !!!! intel sez: Eb,Ib
        mov     dx,offset Is
twooperandsbmodevmodeE:
        mov     ax,(bmode shl 8) or vmode
        mov     cx,offset E
        jmp     short twooperands

op00C8: ;enter Iw,Ib
        mov     ax,opid_enterd
        mov     cx,opid_enterw
        mov     dx,opid_enter
        call    near ptr normworddwordop
        mov     ax,(bmode shl 8) or wmode
        mov     cx,offset I
        mov     dx,cx
        jmp     short twooperands

; Start of AL,Ob/Ob,Al/eAX,Ov/Ov,eAX code 
op00A0: ;mov AL,Ob
        mov     ax,(bmode shl 8) or $al
twooperandsregO:
        mov     cx,offset reg
        mov     dx,offset O
        jmp     twooperands
op00A2: ;mov Ob,AL
        mov     ax,($al shl 8) or bmode
twooperandsOreg:
        mov     cx,offset O
        mov     dx,offset reg
        jmp     twooperands
op00ED: ;in eAX,DX
        mov     al,$eAX
twooperandsregDX:
        mov     ah,$dx
twooperandsregreg:
        mov     cx,offset reg
        mov     dx,cx
        jmp     twooperands
op00C4: ;les Gv,Mp
op00C5: ;lds Gv,Mp
op0FB2: ;lss Gv,Mp
op0FB4: ;lfs Gv,Mp
op0FB5: ;lgs Gv,Mp
        mov     ah,osmode
        jmp     short twooperandsGMvmode
op00A1: ;mov eAX,Ov
        mov     ax,(vmode shl 8) or $eAX
        jmp     short twooperandsregO
op00A3: ;mov Ov,eAX
        mov     ax,($eAX shl 8) or vmode
        jmp     short twooperandsOreg

op00C1_000: ;rol Ev,Ib
op00C1_001: ;ror Ev,Ib
op00C1_010: ;rcl Ev,Ib
op00C1_011: ;rcr Ev,Ib
op00C1_100: ;shl/sal Ev,Ib
op00C1_101: ;shr Ev,Ib
op00C1_110: ;shr Ev,Ib (UNDOCUMENTED)
op00C1_111: ;sar Ev,Ib
op0FBA_100: ;bt Ev,Ib
op0FBA_101: ;bts Ev,Ib
op0FBA_110: ;btr Ev,Ib
op0FBA_111: ;btc Ev,Ib
        mov     dx,offset I
        jmp     short twooperandsbmodevmodeE

op00C7: ;mov Ev,Iv
op0081_000: ;add Ev,Iv
op0081_001: ;or Ev,Iv
op0081_010: ;adc Ev,Iv
op0081_011: ;sbb Ev,Iv
op0081_100: ;and Ev,Iv
op0081_101: ;sub Ev,Iv
op0081_110: ;xor Ev,Iv
op0081_111: ;cmp Ev,Iv
op00F7_000: ;test Ev,Iv
op00F7_001: ;test Ev,Iv (UNDOCUMENTED)
        mov     ax,(vmode shl 8) or vmode
        jmp     short twooperandsEI

op00EC: ;in AL,DX
        mov     al,$al
        jmp     short twooperandsregDX
op00EE: ;out DX,AL
        mov     ah,$al
        jmp     short twooperandsDXreg
op00EF: ;out DX,eAX
        mov     ah,$eAX
twooperandsDXreg:
        mov     al,$dx
        jmp     short twooperandsregreg
op0090: ;xchg eAX,eAX (nop)
        testflag (__dis_input_t ptr __dis_gs:si).opcode.prefixes,__dis_opprefix
        jnz     short xchgREGREG
        retn
xchgREGREG:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_xchg
op0091: ;xchg eCX,eAX
op0092: ;xchg eDX,eAX
op0093: ;xchg eBX,eAX
op0094: ;xchg eSP,eAX
op0095: ;xchg eBP,eAX
op0096: ;xchg eSI,eAX
op0097: ;xchg eDI,eAX
        mov     al,byte ptr (__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        mov     ah,$eAX
        sub     al,90h-$eAX
        jmp     short twooperandsregreg

op0F63: ;PACKSSWB Pq,Qq
op0F64: ;PCMPGTB Pq,Qq
op0F65: ;PCMPGTW Pq,Qq
op0F66: ;PCMPGTD Pq,Qq
op0F67: ;PACKUSWB Pq,Qq
op0F74: ;PCMPEQB Pq,Qq
op0F75: ;PCMPEQW Pq,Qq
op0F76: ;PCMPEQD Pq,Qq
op0FD1: ;PSRLW Pq,Qq
op0FD2: ;PSRLD Pq,Qq
op0FD3: ;PSRLQ Pq,Qq
op0FD5: ;PMULLW Pq,Qq
op0FE1: ;PSRAW Pq,Qq
op0FE2: ;PSRAD Pq,Qq
op0FE5: ;PMULHW Pq,Qq
op0FF1: ;PSLLW Pq,Qq
op0FF2: ;PSLLD Pq,Qq
op0FF3: ;PSLLQ Pq,Qq
op0FF5: ;PMADDWD Pq,Qq
op0F68: ;PUNPCKHBW Pq,Qq
op0F69: ;PUNPCKHWD Pq,Qq
op0F6A: ;PUNPCKHDQ Pq,Qq
op0F6B: ;PACKSSDW Pq,Qq
op0F6F: ;MOVQ Pq,Qq
op0FD8: ;PSUBUSB Pq,Qq
op0FD9: ;PSUBUSW Pq,Qq
op0FDB: ;PAND Pq,Qq
op0FDC: ;PADDUSB Pq,Qq
op0FDD: ;PADDUSW Pq,Qq
op0FDF: ;PANDN Pq,Qq
op0FE8: ;PSUBSB Pq,Qq
op0FE9: ;PSUBSW Pq,Qq
op0FEB: ;POR Pq,Qq
op0FEC: ;PADDSB Pq,Qq
op0FED: ;PADDSW Pq,Qq
op0FEF: ;PXOR Pq,Qq
op0FF8: ;PSUBB Pq,Qq
op0FF9: ;PSUBW Pq,Qq
op0FFA: ;PSUBD Pq,Qq
op0FFC: ;PADDB Pq,Qq
op0FFD: ;PADDW Pq,Qq
op0FFE: ;PADDD Pq,Qq
twooperandsPqQq:
        mov     ax,(qmode shl 8) or qmode
twooperandsPQ:
        mov     cx,offset P
        mov     dx,offset Q
        jmp     twooperands

op0F60: ;PUNPCKLBW Pq,Qd
op0F61: ;PUNPCKLWD Pq,Qd
op0F62: ;PUNPCKLDQ Pq,Qd
        mov     ax,(dmode shl 8) or qmode
        jmp     short twooperandsPQ

op0F71_010: ;PSRLW Pq,Ib
op0F71_100: ;PSRAW Pq,Ib
op0F71_110: ;PSLLW Pq,Ib
op0F72_010: ;PSRLD Pq,Ib
op0F72_100: ;PSRAD Pq,Ib
op0F72_110: ;PSLLD Pq,Ib
op0F73_010: ;PSRLQ Pq,Ib
op0F73_110: ;PSLLQ Pq,Ib
        mov     ax,(bmode shl 8) or qmode
twooperandsPrmI:
        mov     cx,offset Prm
        mov     dx,offset I
        jmp     twooperands

op0F6E: ;MOVD Pq,Ed
        mov     ax,(dmode shl 8) or qmode
twooperandsPE:
        mov     cx,offset P
        mov     dx,offset E
        jmp     twooperands

op0F7E: ;MOVD Ed,Pq
        mov     ax,(qmode shl 8) or dmode
twooperandsEP:
        mov     cx,offset E
        mov     dx,offset P
        jmp     twooperands

op0F7F: ;MOVQ Qq,Pq
        mov     ax,(qmode shl 8) or qmode
twooperandsQP:
        mov     cx,offset Q
        mov     dx,offset P
        jmp     twooperands

op00EA: ;jmp Ap
op009A: ;call Ap
        mov     cx,offset A
        jmp     short oneoperand

op00D4: ;aam            !@# Use Ib if Ib is not 0A
op00D5: ;aad            !@# Use Ib if Ib is not 0A
        getbyte
        jc      short oneoperandretn
        cmp     al,0Ah
        jne     short oneoperandIcb
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontprintops
oneoperandIcb:
        mov     cx,offset Icb
        jmp     short oneoperand

op00CC: ;int 03
        mov     al,03h
        jmp     short oneoperandIcb

op006A: ;push Ib        !@# Use Isb
        mov     cx,offset Is            ;al doesn't need to be initialized
        jmp     short oneoperandregsmallorlargeopdiop1string
op0006: ;push ES
op0007: ;pop ES
        mov     al,$es
        jmp     short oneoperandregsmallorlargeop
op000E: ;push CS
        mov     al,$cs
        jmp     short oneoperandregsmallorlargeop
op0016: ;push SS
op0017: ;pop SS
        mov     al,$ss
        jmp     short oneoperandregsmallorlargeop
op001E: ;push DS
op001F: ;pop DS
        mov     al,$ds
        jmp     short oneoperandregsmallorlargeop
op0FA0: ;push FS
op0FA1: ;pop FS
        mov     al,$fs
        jmp     short oneoperandregsmallorlargeop
op0FA8: ;push GS
op0FA9: ;pop GS
        mov     al,$gs
oneoperandregsmallorlargeop:
        mov     cx,offset reg
oneoperandregsmallorlargeopdiop1string:
        call    near ptr __dis_zerooneop
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.op1
        call    near ptr smallorlargeop
        jmp     short __oneoperand

        ;
        ;   oneoperand:near
        ;
        ;   input: cx   procedure to call
        ;          al   input to procedure
        ;
oneoperand:
        call    near ptr __dis_zerooneop
__oneoperand:
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.op1
        call    cx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,01h
oneoperandretn:
        retn

op00CA: ;retf Iw
        call    near ptr retfretfdretfw
        jmp     short oneoperandIwmode
op00C2: ;retn Iw
        call    near ptr retnretndretnw
oneoperandIwmode:
        mov     al,wmode
        jmp     short oneoperandI
op00CD: ;int Ib
        mov     al,bmode
oneoperandI:
        mov     cx,offset I
        jmp     short oneoperand

op00FF_010: ;call Ev
op00FF_100: ;jmp Ev
        mov     al,omode
        jmp     short oneoperandE

op0FAE_000: ;fxsave M (160 bytes)
op0FAE_001: ;fxrstor M (160 bytes)
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
op008F: ;pop Ev
op00F7_010: ;not Ev
op00F7_011: ;neg Ev
op00F7_100: ;mul Ev
op00F7_101: ;imul Ev
op00F7_110: ;div Ev
op00F7_111: ;idiv Ev
op00FF_000: ;inc Ev
op00FF_001: ;dec Ev
op00FF_110: ;push Ev
        mov     al,vmode
oneoperandE:
oneoperandM:
oneoperandR:
        mov     cx,offset E
        jmp     short oneoperand

op0F90: ;seto Eb        !@# Don't print 'byte ptr'
op0F91: ;setno Eb       !@# Don't print 'byte ptr'
op0F92: ;setc/setb/setnae Eb !@# Don't print 'byte ptr'
op0F93: ;setnc/setnb/setae Eb !@# Don't print 'byte ptr'
op0F94: ;setz/sete Eb   !@# Don't print 'byte ptr'
op0F95: ;setnz/setne Eb !@# Don't print 'byte ptr'
op0F96: ;setbe/setna Eb !@# Don't print 'byte ptr'
op0F97: ;setnbe/seta Eb !@# Don't print 'byte ptr'
op0F98: ;sets Eb        !@# Don't print 'byte ptr'
op0F99: ;setns Eb       !@# Don't print 'byte ptr'
op0F9A: ;setp/setpe Eb  !@# Don't print 'byte ptr'
op0F9B: ;setnp/setpo Eb !@# Don't print 'byte ptr'
op0F9C: ;setl/setnge Eb !@# Don't print 'byte ptr'
op0F9D: ;setnl/setge Eb !@# Don't print 'byte ptr'
op0F9E: ;setle/setng Eb !@# Don't print 'byte ptr'
op0F9F: ;setnle/setg Eb !@# Don't print 'byte ptr'
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
op00F6_010: ;not Eb
op00F6_011: ;neg Eb
op00F6_100: ;mul Eb
op00F6_101: ;imul Eb
op00F6_110: ;div Eb
op00F6_111: ;idiv Eb
op00FE_000: ;inc Eb
op00FE_001: ;dec Eb
        mov     al,bmode
        jmp     short oneoperandE

op00FF_011: ;call Ep
op00FF_101: ;jmp Ep
        mov     al,osmode
        jmp     short oneoperandE

op0FC7_001: ;cmpxchg8b Mq !@# Use no memsize!
        mov     al,qmode
        jmp     short oneoperandEnomemsize
op0F00_000: ;sldt Ew    !@# Use no memsize!
op0F00_001: ;str Ew     !@# Use no memsize!
op0F00_010: ;lldt Ew    !@# Use no memsize!
op0F00_011: ;ltr Ew     !@# Use no memsize!
op0F00_100: ;verr Ew    !@# Use no memsize!
op0F00_101: ;verw Ew    !@# Use no memsize!
op0F01_100: ;smsw Ew    !@# Use no memsize!
op0F01_110: ;lmsw Ew    !@# Use no memsize!
op0F01_111: ;invplg E   ;intel forgot Ex (x=unknown size, might be dword)
oneoperandEvnomemsize:
        mov     al,vmode
oneoperandEnomemsize:
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
        jmp     short oneoperandE

op0040: ;inc eAX
op0041: ;inc eCX
op0042: ;inc eDX
op0043: ;inc eBX
op0044: ;inc eSP
op0045: ;inc eBP
op0046: ;inc eSI
op0047: ;inc eDI
        mov     ah,40h-$eAX
regsubalah:
        mov     al,byte ptr (__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        sub     al,ah
oneoperandreg:
        mov     cx,offset reg
        jmp     short oneoperand

op0068: ;push Iv
        mov     cx,offset I
        mov     al,vmode
        jmp     short oneoperandregsmallorlargeopdiop1string
op0F80: ;jo Jv
op0F81: ;jno Jv
op0F82: ;jc/jb/jnae Jv
op0F83: ;jnc/jnb/jae Jv
op0F84: ;jz/je Jv
op0F85: ;jnz/jne Jv
op0F86: ;jbe/jna Jv
op0F87: ;jnbe/ja Jv
op0F88: ;js Jv
op0F89: ;jns Jv
op0F8A: ;jp/jpe Jv
op0F8B: ;jnp/jpo Jv
op0F8C: ;jl/jnge Jv
op0F8D: ;jnl/jge Jv
op0F8E: ;jle/jng Jv
op0F8F: ;jnle/jg Jv
op00E8: ;call Jv
op00E9: ;jmp Jv
        mov     al,vmode
oneoperandsmallorlargeop2J:
        mov     cx,offset J
        jmp     oneoperandregsmallorlargeopdiop1string

op0F01_000: ;sgdt Ms    !@# Use no memsize!
        mov     ax,opid_sgdtd
        mov     cx,opid_sgdtw
        mov     dx,opid_sgdt
oneoperandEpnomemsize__normworddwordop:
        call    near ptr __normworddwordop
        mov     al,smode
        jmp     short oneoperandEnomemsize

op0048: ;dec eAX
op0049: ;dec eCX
op004A: ;dec eDX
op004B: ;dec eBX
op004C: ;dec eSP
op004D: ;dec eBP
op004E: ;dec eSI
op004F: ;dec eDI
        mov     ah,48h-$eAX
        jmp     short regsubalah

op0050: ;push eAX
op0051: ;push eCX
op0052: ;push eDX
op0053: ;push eBX
op0054: ;push eSP
op0055: ;push eBP
op0056: ;push eSI
op0057: ;push eDI
        mov     ah,50h-$eAX
        jmp     short regsubalah

op0058: ;pop eAX
op0059: ;pop eCX
op005A: ;pop eDX
op005B: ;pop eBX
op005C: ;pop eSP
op005D: ;pop eBP
op005E: ;pop eSI
op005F: ;pop eDI
        mov     ah,58h-$eAX
        jmp     short regsubalah

op0FC8: ;bswap eAX
op0FC9: ;bswap eCX
op0FCA: ;bswap eDX
op0FCB: ;bswap eBX
op0FCC: ;bswap eSP
op0FCD: ;bswap eBP
op0FCE: ;bswap eSI
op0FCF: ;bswap eDI
        mov     ah,0C8h-$eAX
        jmp     short regsubalah

op0F01_001: ;sidt Ms    !@# Use no memsize!
        mov     ax,opid_sidtd
        mov     cx,opid_sidtw
        mov     dx,opid_sidt
        jmp     short oneoperandEpnomemsize__normworddwordop

op0F01_010: ;lgdt Ms    !@# Use no memsize!
        mov     ax,opid_lgdtd
        mov     cx,opid_lgdtw
        mov     dx,opid_lgdt
        jmp     short oneoperandEpnomemsize__normworddwordop

op0F01_011: ;lidt Ms    !@# Use no memsize!
        mov     ax,opid_lidtd
        mov     cx,opid_lidtw
        mov     dx,opid_lidt
        jmp     short oneoperandEpnomemsize__normworddwordop

op00E0: ;loopnz/loopne Jb
        mov     ax,opid_loopdne
        mov     cx,opid_loopwne
        mov     dx,opid_loopne
        jmp     short shortjmpbmode__normworddwordadr
op00E1: ;loopz/loope Jb
        mov     ax,opid_loopde
        mov     cx,opid_loopwe
        mov     dx,opid_loope
        jmp     short shortjmpbmode__normworddwordadr
op00E2: ;loop Jb
        mov     ax,opid_loopd
        mov     cx,opid_loopw
        mov     dx,opid_loop
shortjmpbmode__normworddwordadr:
        call    near ptr __normworddwordadr
op00EB: ;jmp Jb
op0070: ;jo Jb
op0071: ;jno Jb
op0072: ;jc/jb/jnae Jb
op0073: ;jnc/jnb/jae Jb
op0074: ;jz/je Jb
op0075: ;jnz/jne Jb
op0076: ;jbe/jna Jb
op0077: ;jnbe/ja Jb
op0078: ;js Jb
op0079: ;jns Jb
op007A: ;jp/jpe Jb
op007B: ;jnp/jpo Jb
op007C: ;jl/jnge Jb
op007D: ;jnl/jge Jb
op007E: ;jle/jng Jb
op007F: ;jnle/jg Jb
shortjmpbmode:
        mov     al,bmode
        jmp     short oneoperandsmallorlargeop2J
op00E3: ;jcxz/jecxz Jb
        mov     ax,opid_jcxz
        mov     cx,opid_jecxz
        call    near ptr axorcxadr
        jmp     short shortjmpbmode

axorcxadr:
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.adrsize
        jmp     short axorcxop10
op0098: ;cbw/cwde
        mov     ax,opid_cbw
        mov     cx,opid_cwde
        jmp     short axorcxop
op0099: ;cwd/cdq
        mov     ax,opid_cwd
        mov     cx,opid_cdq
axorcxop:
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.opsize
axorcxop10:
        cmp     byte ptr __dis_gs:[di],10h
        je      short savemnemonicptrclcretn
        jmp     short savemnemonicptrclcretnxchgcxax

op0060: ;pusha/pushad
        mov     ax,opid_pushad
        mov     cx,opid_pushaw
        mov     dx,opid_pusha
        ;decide if we want to use iret/iretw/iretd (and similar opcodes)
        ;if opsize=20h, use iretd
        ;if dis_codesize is 10h, use iret
        ;use iretw (32-bit code segment is default)
normworddwordop:
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.opsize,20h
        je      short savemnemonicptrclcretn ;iretd
        testflag (__dis_input_t ptr __dis_gs:si).flags,__df_showsizeop
        jnz     short @@normworddwordW  ;iretw
        xchg    dx,ax
        cmp     (__dis_input_t ptr __dis_gs:si).codesize,10h
        je      short savemnemonicptrclcretn ;iret
@@normworddwordW:
savemnemonicptrclcretnxchgcxax:
        xchg    cx,ax
savemnemonicptrclcretn:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        clc
axorcxretn:
        retn
op0061: ;popa/popad
        mov     ax,opid_popad
        mov     cx,opid_popaw
        mov     dx,opid_popa
        jmp     short normworddwordop
op009C: ;pushf/pushfd
        mov     ax,opid_pushfd
        mov     cx,opid_pushfw
        mov     dx,opid_pushf
        jmp     short normworddwordop
op009D: ;popf/popfd
        mov     ax,opid_popfd
        mov     cx,opid_popfw
        mov     dx,opid_popf
        jmp     short normworddwordop
;op00C8: ;enter Iw,Ib
op00C9: ;leave
        mov     ax,opid_leaved
        mov     cx,opid_leavew
        mov     dx,opid_leave
        jmp     short normworddwordop
op00CF: ;iret
        mov     ax,opid_iretd
        mov     cx,opid_iretw
        mov     dx,opid_iret
        jmp     short normworddwordop

op00C3: ;retn
retnretndretnw:
        mov     ax,opid_retnd
        mov     cx,opid_retnw
        mov     dx,opid_retn
        jmp     short __normworddwordop
op00CB: ;retf
retfretfdretfw:
        mov     ax,opid_retfd
        mov     cx,opid_retfw
        mov     dx,opid_retf
__normworddwordop:
        mov     bl,(__dis_input_t ptr __dis_gs:si).opcode.opsize
__normworddwordop10:
        cmp     bl,(__dis_input_t ptr __dis_gs:si).codesize
        je      short __normwordwordopxchgdxax
        cmp     bl,20h
        je      short savemnemonicptrclcretn ;retnd
        mov     dx,cx                   ;retnw
__normwordwordopxchgdxax:
        xchg    dx,ax                   ;retn
        jmp     short savemnemonicptrclcretn
__normworddwordadr:
        mov     bl,(__dis_input_t ptr __dis_gs:si).opcode.adrsize
        jmp     short __normworddwordop10

        ;
        ;   expandstringinstructions?:near
        ;
        ;   should we expand the string instruction? (cf=0=yes,cf=1=no)
        ;
proc    expandstringinstructions? near
        testflag (__dis_input_t ptr __dis_gs:si).flags,__df_stringoperands
        jnz     short @@yes
        test    (__dis_input_t ptr __dis_gs:si).opcode.prefixes,07h
        jnz     short @@yes
        mov     al,(__dis_input_t ptr __dis_gs:si).codesize
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.adrsize,al
        jne     short @@yes
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontprintops
        cmc
        retn
@@yes:
        clc
        retn
endp    expandstringinstructions?

op006D: ;insw/insd Yv,DX
        call    near ptr __dis_zerotwoops
        mov     ax,opid_insw
        mov     cx,opid_insd
        call    near ptr axorcxopesdivmode
        jmp     short ins10
op006C: ;insb Yb,DX
        call    near ptr __dis_zerotwoops
        call    near ptr esdibmode
ins10:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,02h
        setflag (__dis_input_t ptr __dis_gs:si).opcode.op2.flags,dop_reg
        mov     (__dis_input_t ptr __dis_gs:si).opcode.op2.ops.reg.register,dr_dx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.op2.size,dop_sizeword
        call    near ptr expandstringinstructions?
        jc      short insclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_ins
insclcretn:
        clc
        retn

;input:
;al     16-bit base memory register (dr_si/dr_di/dr_bx)
;ah     32-bit base memory register (dr_esi/dr_edi/dr_ebx)
;bl     memory size (bmode/vmode)
;__dis_gs:di dis_operand_t struc
savememopbasereg:
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.adrsize,10h
        je      short @@adr10h
        mov     al,ah
@@adr10h:
        mov     (dis_operand_t ptr __dis_gs:di).ops.mem.baseindex,al
        setflag (dis_operand_t ptr __dis_gs:di).ops.mem.__flags,dm_hasbase
        mov     al,bl
        call    near ptr __dis_convertequ
        mov     (dis_operand_t ptr __dis_gs:di).size,al
        retn

op006F: ;outsw/outsd DX,Xv
        mov     ax,opid_outsw
        mov     cx,opid_outsd
        call    near ptr axorcxop
        mov     bl,vmode
        jmp     short outs10
op006E: ;outsb DX,Xb
        mov     bl,bmode
outs10:
        call    near ptr __dis_zerotwoops
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,02h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.op1.ops.reg.register,dr_dx
        setflag (__dis_input_t ptr __dis_gs:si).opcode.op1.flags,dop_reg
        mov     (__dis_input_t ptr __dis_gs:si).opcode.op1.size,dop_sizeword
        mov     ax,(dr_esi shl 8) or dr_si
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op2
        call    near ptr savememopbasereg
        call    near ptr savesegoverride_defaultds
        call    near ptr expandstringinstructions?
        jc      short outsclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_outs
outsclcretn:
        clc
        retn

op00D7: ;xlatb
        call    near ptr __dis_zerooneop
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,01h
        mov     ax,(dr_ebx shl 8) or dr_bx
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op1
        mov     bl,bmode
        call    near ptr savememopbasereg
        call    near ptr savesegoverride_defaultds
        call    near ptr expandstringinstructions?
        jc      short outsclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_xlat
        retn

op00AF: ;scasw/scasd eAX,Yv
        mov     ax,opid_scasw
        mov     cx,opid_scasd
        mov     dx,opid_scas
        jmp     short axorcxopesdivmode
op00AE: ;scasb AL,Yb
        mov     dx,opid_scas
        jmp     short esdibmode
op00AB: ;stosw/stosd Yv,eAX
        mov     ax,opid_stosw
        mov     cx,opid_stosd
        mov     dx,opid_stos
axorcxopesdivmode:
        call    near ptr axorcxop
        mov     bl,vmode
        jmp     short esdi
op00AA: ;stosb Yb,AL
        mov     dx,opid_stos
esdibmode:
        mov     bl,bmode
esdi:
        call    near ptr __dis_zerooneop
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,01h
        mov     ax,(dr_edi shl 8) or dr_di
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op1
        call    near ptr savememopbasereg
        mov     (dis_operand_t ptr __dis_gs:di).ops.mem.segoverride,(dm_seges shl 4) or dm_seges
        setflag (dis_operand_t ptr __dis_gs:di).ops.mem.__flags,dm_segoverride
        call    near ptr expandstringinstructions?
        jc      short outsclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,dx
        retn

op00AD: ;lodsw/lodsd eAX,Xv
        mov     ax,opid_lodsw
        mov     cx,opid_lodsd
        mov     dx,opid_lods
axorcxopXXsivmode:
        call    near ptr axorcxop
        mov     bl,vmode
        jmp     short XXsi
op00AC: ;lodsb AL,Xb
        mov     dx,opid_lods
XXsibmode:
        mov     bl,bmode
XXsi:
        call    near ptr __dis_zerooneop
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,01h
        mov     ax,(dr_esi shl 8) or dr_si
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op1
        call    near ptr savememopbasereg
        call    near ptr savesegoverride_defaultds
        call    near ptr expandstringinstructions?
        jc      short XXsiclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,dx
XXsiclcretn:
        clc
        retn

op00A7: ;cmpsw/cmpsd Xv,Yv
        mov     ax,opid_cmpsw
        mov     cx,opid_cmpsd
        mov     dx,opid_cmps
        jmp     short axorcxopesdiXXsivmode
op00A6: ;cmpsb Xb,Yb
        mov     dx,opid_cmps
        jmp     short esdiXXsibmode
op00A5: ;movsw/movsd Xv,Yv
        mov     ax,opid_movsw
        mov     cx,opid_movsd
        mov     dx,opid_movs
axorcxopesdiXXsivmode:
        call    near ptr axorcxop
        mov     bl,vmode
        jmp     short esdiXXsi
op00A4: ;movsb Xb,Yb
        mov     dx,opid_movs
esdiXXsibmode:
        mov     bl,bmode
esdiXXsi:
        call    near ptr __dis_zerotwoops
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,02h
        mov     ax,(dr_edi shl 8) or dr_di
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op1
        call    near ptr savememopbasereg
        mov     (dis_operand_t ptr __dis_gs:di).ops.mem.segoverride,(dm_seges shl 4) or dm_seges
        setflag (dis_operand_t ptr __dis_gs:di).ops.mem.__flags,dm_segoverride
        mov     ax,(dr_esi shl 8) or dr_si
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op2
        call    near ptr savememopbasereg
        call    near ptr savesegoverride_defaultds
        call    near ptr expandstringinstructions?
        jc      short XXsiclcretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,dx
        retn

op0069: ;imul Gv,Ev,Iv
        mov     bl,vmode
        mov     di,offset I
        jmp     short threeoperandsGvEv
op006B: ;imul Gv,Ev,Ib  !@# Use Isb
ife bmode
        xor     bl,bl
else
        mov     bl,bmode
endif
        mov     di,offset Is
threeoperandsGvEv:
        mov     ax,(vmode shl 8) or vmode
        mov     cx,offset G
        mov     dx,offset E
        jmp     short threeoperands

op0FA4: ;shld Ev,Gv,Ib
op0FAC: ;shrd Ev,Gv,Ib
ife bmode
        xor     bl,bl
else
        mov     bl,bmode
endif
        mov     di,offset I
threeoperandsEvGv:
        mov     ax,(vmode shl 8) or vmode
        mov     cx,offset E
        mov     dx,offset G
        jmp     short threeoperands
op0FA5: ;shld Ev,Gv,CL
op0FAD: ;shrd Ev,Gv,CL
        mov     bl,$cl
        mov     di,offset reg
        jmp     short threeoperandsEvGv

op0F00_110:
op0F00_111:
op0F01_101:
op0F71_000:
op0F71_001:
op0F71_011:
op0F71_101:
op0F71_111:
op0F72_000:
op0F72_001:
op0F72_011:
op0F72_101:
op0F72_111:
op0F73_000:
op0F73_001:
op0F73_011:
op0F73_100:
op0F73_101:
op0F73_111:
op0FBA_000:
op0FBA_001:
op0FBA_010:
op0FBA_011:
op0FC7_000:
op0FC7_010:
op0FC7_011:
op0FC7_100:
op0FC7_101:
op0FC7_110:
op0FC7_111:
op0FAE_010:
op0FAE_011:
op0FAE_100:
op0FAE_101:
op0FAE_110:
op0FAE_111:
        mov     ax,(__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        xchg    al,ah
        mov     bl,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        mov     cx,offset Icb
        mov     dx,cx
        mov     di,cx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_db

        ;
        ;   threeoperands:near
        ;
        ;   input: cx   first procedure to call
        ;          dx   second procedure to call
        ;          di   third procedure to call
        ;          al   input to first procedure
        ;          ah   input to second procedure
        ;          bl   input to third procedure
        ;
threeoperands:
        push    di
        call    near ptr __dis_zerothreeops
        pop     di
__threeoperands:
        push    di bx
        call    near ptr __twooperands
        pop     ax cx
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.op3
        jc      short threeoperandsretn
        call    cx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.noperands,03h
threeoperandsretn:
        retn

op0026: ;seg ES
        mov     al,__dis_esprefix
        jmp     short popaxdisloopjmpahnot07h
op002E: ;seg CS
        mov     al,__dis_csprefix
        jmp     short popaxdisloopjmpahnot07h
op0036: ;seg SS
        mov     al,__dis_ssprefix
        jmp     short popaxdisloopjmpahnot07h
op003E: ;seg DS
        mov     al,__dis_dsprefix
        jmp     short popaxdisloopjmpahnot07h
op0064: ;seg FS
        mov     al,__dis_fsprefix
        jmp     short popaxdisloopjmpahnot07h
op0065: ;seg GS
        mov     al,__dis_gsprefix
popaxdisloopjmpahnot07h:
        mov     ah,not 07h
popaxdisloopjmpprefixes:
        testflag (__dis_input_t ptr __dis_gs:si).opcode.prefixes,__dis_opprefix or __dis_adrprefix
        jnz     short @@saveflagspopaxdisloopjmp ;if we've found 66h/67h
        testflag (__dis_input_t ptr __dis_gs:si).flags,__df_prefixinstructions
        jnz     short _stretn
@@saveflagspopaxdisloopjmp:
        and     (__dis_input_t ptr __dis_gs:si).opcode.prefixes,ah
        or      (__dis_input_t ptr __dis_gs:si).opcode.prefixes,al
popaxdisloopjmp:
        pop     ax                      ;return address
        jmp     __dis_getbyteloop
op0066: ;operand size
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.opsize
        setflag (__dis_input_t ptr __dis_gs:si).opcode.prefixes,__dis_opprefix
op0066jmphere:
        mov     al,10h
        cmp     (__dis_input_t ptr __dis_gs:si).codesize,al
        jne     short op0066saveit
        add     al,al
op0066saveit:
        mov     __dis_gs:[bx],al
        jmp     short popaxdisloopjmp
op0067: ;address size
        lea     bx,(__dis_input_t ptr __dis_gs:si).opcode.adrsize
        setflag (__dis_input_t ptr __dis_gs:si).opcode.prefixes,__dis_adrprefix
        jmp     short op0066jmphere
op00F0: ;lock
        mov     ax,(0FFh shl 8) or __dis_lockprefix
        jmp     short popaxdisloopjmpprefixes
op00F2: ;repnz/repne
        mov     ax,((not (__dis_repprefix or __dis_repnzprefix)) shl 8) or __dis_repnzprefix
        jmp     short popaxdisloopjmpprefixes
op00F3: ;rep/repz/repe
        mov     ax,((not (__dis_repprefix or __dis_repnzprefix)) shl 8) or __dis_repprefix
        jmp     short popaxdisloopjmpprefixes

        ;
        ;   _st:near
        ;
        ;   st is the register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: al
        ;
proc    _st near
        mov     al,dr_st
__stX:
        setflag (dis_operand_t ptr __dis_gs:bx).flags,dop_reg
        mov     (dis_operand_t ptr __dis_gs:bx).ops.reg.register,al
        mov     (dis_operand_t ptr __dis_gs:bx).size,dop_sizetbyte
_stretn:
        retn
endp    _st

        ;
        ;   _stX:near
        ;
        ;   st(0-7) is the register
        ;
        ;   input: __dis_gs:si __dis_input_t struc
        ;          __dis_gs:bx dis_operand_t struc
        ;   output: cf=1=error
        ;           cf=0=ok
        ;   registers: al
        ;
proc    _stX near
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.rm
        add     al,dr_st0
        jmp     short __stX
endp    _stX

D8jmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0D0h
        jb      short twooperands_st_stX
        cmp     al,0DFh
        jbe     short oneoperand_stX
twooperands_st_stX:
        mov     cx,offset _st
        mov     dx,offset _stX
        jmp     twooperands

DAjmp:
        cmp     (__dis_input_t ptr __dis_gs:si).opcode.modrm,0E0h
        jb      short twooperands_st_stX
        retn

DBjmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0E0h
        jb      short twooperands_st_stX
        cmp     al,0E8h
        jb      short @@DBjmp10
        cmp     al,0F8h
        jb      short twooperands_st_stX
@@DBjmp10:
        clc
        retn

D9jmp:
        ;TODO: The first operand should be hidden (it's "st") if modR/M < D0h
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0D0h
        jb      short oneoperand_stX    ;tasm: "op st(X)", intel: "op st,st(X)"
        cmp     al,0D8h
        jb      short DBjmpretn
        cmp     al,0E0h
        jb      short oneoperand_stX    ;fstp1 st(X)
DBjmpretn:
        clc
        retn

DCjmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0D0h
        jb      short twooperands_stX_st
        cmp     al,0E0h
        jb      short oneoperand_stX
        jmp     short twooperands_stX_st

DEjmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0D9h
        je      short DBjmpretn
        cmp     al,0D0h
        jb      short twooperands_stX_st
        cmp     al,0D8h
        jb      short oneoperand_stX
twooperands_stX_st:
        mov     cx,offset _stX
        mov     dx,offset _st
        jmp     twooperands

DDjmp:
        ;TODO: fucom's first operand "st" should be hidden
oneoperand_stX:
        mov     cx,offset _stX
        jmp     oneoperand

DFjmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        cmp     al,0E0h
        jb      short oneoperand_stX
        cmp     al,0E8h
        jb      short @@DFjmp10
        cmp     al,0F8h
        jb      short twooperands_st_stX
@@DFjmp10:
        mov     al,$ax
        jmp     oneoperandreg

D8_DF_00_BFjmp:
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.reg
        add     ah,(opid_floatD8reg shr 8)-0D8h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        movzx   bx,al
        mov     ax,(__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        sub     al,0D8h
        shl     ax,03h
        add     bx,ax
        mov     al,[bx+D8_DF_00_BFsize]
        test    al,al
        jns     short @@alnotsigned
        cmp     al,0FFh
        je      short printesc
        and     al,7Fh
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
@@alnotsigned:
        jmp     oneoperandE

printesc:
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_esc
        mov     ax,(__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        sub     al,0D8h
        shl     ax,03h
        add     al,(__dis_input_t ptr __dis_gs:si).opcode.reg
        setflag (__dis_input_t ptr __dis_gs:si).opcode.flags,do_dontshowmemsize
        mov     ah,vmode
        mov     cx,offset Icb
        mov     dx,offset E
        jmp     twooperands

op00D8: ;Floating point
op00D9: ;Floating point
op00DA: ;Floating point
op00DB: ;Floating point
op00DC: ;Floating point
op00DD: ;Floating point
op00DE: ;Floating point
op00DF: ;Floating point
        call    near ptr __dis_initmodrm
        jc      short op009Fretn
        testflag (__dis_input_t ptr __dis_gs:si).flags,__df_floatasesc
        jnz     short printesc
        mov     al,(__dis_input_t ptr __dis_gs:si).opcode.modrm
        mov     ah,byte ptr (__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        cmp     al,0C0h
        jb      short D8_DF_00_BFjmp
        add     ah,(opid_floatD8 shr 8)-0D8h
        sub     al,0C0h
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        sub     ah,opid_floatD8 shr 8
        mov     cl,al
        shl     ah,03h                  ;8 bytes in each table (64 bits)
        shr     al,03h
        and     cl,07h
        add     al,ah
        movzx   bx,al
        mov     al,01h
        shl     al,cl
        test    [bx+D8_DF_C0_FFop],al
        jz      short printesc
        mov     bx,(__dis_input_t ptr __dis_gs:si).opcode.opcodeword
        add     bx,bx
        jmp     [bx+floatjmps-(00D8h*2)]

op0F05: ;loadall (intel 80286), syscall (AMD)
        cmp     (__dis_input_t ptr __dis_gs:si).cputype,__discpu_amd
        clc
        jne     short op009Fretn
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,opid_amdsyscall
        retn

op0F34: ;sysenter
op0F35: ;syscall
op0F77: ;EMMS
op0F0B: ;ud1
op0FB9: ;ud2
op00D6: ;salc/setalc
op00F1: ;int01/icebp
op00CE: ;into
op00F4: ;hlt
op00F5: ;cmc
op00F8: ;clc
op00F9: ;stc
op00FA: ;cli
op00FB: ;sti
op00FC: ;cld
op00FD: ;std
op0F06: ;clts
op0F08: ;invd
op0F09: ;wbinvd
op0F30: ;wrmsr
op0F31: ;rdtsc
op0F32: ;rdmsr
op0FA2: ;cpuid
op0FAA: ;rsm
op0027: ;daa
op002F: ;das
op0037: ;aaa
op003F: ;aas
op009B: ;wait/fwait
op009E: ;sahf
op009F: ;lahf
op0F33: ;rdpmc
op009Fretn:
        retn

op000F: ;2-byte escape
        getbyte
        mov     ah,00h
        jc      short op009Fretn
        mov     bx,ax
        mov     ah,0Fh
        add     bx,bx
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeword,ax
        mov     ah,opid_opnames2 shr 8
        mov     (__dis_input_t ptr __dis_gs:si).opcode.opcodeid,ax
        jmp     [bx+opcodes2]

__dis_zerothreeops:
        push    cx
        mov     cx,(size dis_operand_t)*3/4
        jmp     short __dis_zeroops
__dis_zerotwoops:
        push    cx
        mov     cx,(size dis_operand_t)*2/4
        jmp     short __dis_zeroops
__dis_zerooneop:
        push    cx
        mov     cx,(size dis_operand_t)*1/4
__dis_zeroops:
        lea     di,(__dis_input_t ptr __dis_gs:si).opcode.op1
__dis_zeroopsloop:
if (size dis_operand_t) and 3
  err
endif
        and     dword ptr __dis_gs:[di],00000000h
        add     di,0004h
        loop    __dis_zeroopsloop
        pop     cx
        retn

        endcode

        end
