struct combi_status {
  char ID_name[6];      /* COMBI-disk always returns "COMBI\0"  */
  int  version;         /* version number: high byte - major version number,
                         *      low byte - minor version number */
  char COMBI_options;   /* current options (see also below)     */
  char bl_sect;         /* number of sectors per allocation block */
  int  buff_size;       /* maximum buffer size (Kbytes)   */
  int  curr_size;       /* current buffer size (Kbytes) - may be less than
                         * buff_size if some memory is loaned to other
                         * programs */
  int  n_blocks;        /* total number of allocation blocks  */
  int  n_curr;          /* current number of allocation blocks - less or
                         * equal to the above */
  int  n_bl_RD;         /* number of blocks used by RAM disk  */
  int  n_bl_Cache;      /* number of blocks used by cache or unused */
  int  n_dirty;         /* number of blocks which are waiting to be updated
                         * to hard disk - this is likely to be 0 by the
                         * time You run the program */
  int  n_errors;        /* number of blocks which can't be updated to disk
                         * due to write errors    */

  int  read_rq;         /* total number of read from hard disk requests
                         * served by COMBI-disk */
  int  read_sect;       /* same as above in sectors */
  int  read_rq_a;       /* actual number of read requests passed
                         * to BIOS by COMBI */
  int  read_sect_a;     /* same as above in sectors */

  int  write_rq;        /* this and following 3 fields correspond to the  */
  int  write_sect;      /* above 4 and contain WRITE statistics */
  int  write_rq_a;
  int  write_sect_a;

  int  read_RD_num;     /* RAM disk read/write statistics -
                         * self-explanatory */
  int  read_RD_sect;
  int  write_RD_num;
  int  write_RD_sect;
};

/*  Write IOCtl packet has the following structure:
 *  struct  wr_ioctl {
 *    int     version;
 *    char    command;
 *    [<parameters for command if any>];
 *    char    next_command;
 *    [<parameters for that command if any>];
 *    ....
 *  }
 */


/* IOCtl commands definitions */

#define CMD_FLUSH   0x80
    /* flush cache - no parameters, returns error
     * if can't write to disk some of sectors  */
#define CMD_CH_OPT  0x81
    /* change options - the byte with new options follows */
#define CMD_SHRINK  0x82
    /* shrink memory - next word is parameter - the amount of Kbytes
     * to release */
#define CMD_EXPAND  0x83
    /* similar to the above */
#define CMD_N_ERR   0x84
    /* get information on n-th unupdated block (with write errors)
     * next word is n (<= n_dirty) and next 2 words is far pointer to
     * the following struct:
     *  struct bl_inf {
     *    long  block_ID; - high byte is the physical drive number,
     *                      the rest when multiplied by bl_sect gives 
     *                      sequential number of first sector in that block
     *                      (cylinder_number*sectors_per_cylinder+
     *                      +head_number*sectors_per_track+
     *                      +sector_number-1)
     *    char  valid_sect; - bits of valid sectors in block
     *    char  unupdated_sectors;
     *    char  last_error; - as returned by BIOS
     *    char  error_counter;  - number of errors
     *   }
     * You may use this information to discover physical sector
     * number (cylinder,head,sector) which caused the error*/
#define CMD_RESET_D 0x85
    /* reset write errors so that background routine can attempt to 
     * update block again, next DWORD is block ID */
#define CMD_RESET_C 0x86
    /* reset counters - next byte is parameter which statistics counters
     * to reset: bit 0 corresponds to hard disk read counters, 
     * bit 1 - to hard disk write counters and bit 2  - to RAM disk 
     * read/write counters */

/* Options definitions        */

#define OPT_OFF     1     /* cache off */
#define OPT_FREEZE  2     /* freeze cache */
#define OPT_WR_ON   4     /* write caching on */
#define OPT_DW_OFF  8     /* delayed write off == start writing immediately */
#define OPT_MEM    0x20   /* fix memory allocation */
#define OPT_NO_SNF 0x40   /* no 'sector not found' error */
