/*============================================================================
 *	D2D/98	- disc to disc copy for IBM-PC/AT compatible machines
 *	XMS support package
 *
 *	Borland-C++ 2.00
 *	Version $Revision: 1.4.1.1 $
 *
 *	Copyright (c) 1987 - 1992, 1998 by
 *		Ulrich Windl
 *		Alte Regensburger Strae 11a
 *		D-93149 Nittenau
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *============================================================================
 *$Id: xms.c'v 1.4.1.1 1998/12/24 22:26:40 UhW Exp $
 *$Log: xms.c'v $
 * Revision 1.4.1.1  1998/12/24  22:26:40  UhW
 * This is the GPL version for the 10th anniversary of D2D.
 *
 * Revision 1.4  1992/04/13  20:45:28  UhW
 * Changed XMS_error from signed to unsigned char.
 *
 * Revision 1.3  1992/01/08  20:21:28  UhW
 * Changed logic of XMS detection: QEMM 6.0 does support XMS, but it has no
 * separate driver name (XMSXXXX0) for it. Therefore the name won't be checked.
 *
 * Revision 1.2  1991/11/06  17:11:42  UhW
 * Prepared for use with RCS (co -kv required)
 *
 */
#pragma	inline

#include	<stdio.h>
#include	<mem.h>
#include	<dos.h>

#include	"xms.h"

#ifdef	DEBUG
extern	int	dbuglevl;
# define	BUG(l)	if ( (l) <= dbuglevl )
#endif

static	char	SCCS_ID[] = "@(#)" __FILE__ " $Revision: 1.4.1.1 $\t" __DATE__ "\t" __TIME__;
static	char	*RCS_ID	= "$Id" ": $Id: xms.c'v 1.4.1.1 1998/12/24 22:26:40 UhW Exp $" " $";

/*======== XMS Support ===== XMS Support ===== XMS Support =============*/

static	const char	XMS_name[]	= "XMSXXXX0";
static	void		(far *XMS_entry)(void) = NULL;

unsigned char	XMS_error;		/* last XMM error code */

int	XMSinstalled(void)
{
	struct REGPACK	r;

	r.r_ax = 0x4300;		/* get installation status */
	intr(0x2f, &r);			/* call driver */
	return( (r.r_ax & 0xff) == 0x80 );
}

static	void	XMSget_entry(void)
{
	struct REGPACK	r;

	r.r_ax = 0x4310;		/* get driver entry */
	intr(0x2f, &r);			/* call multiplex */
	XMS_entry = MK_FP(r.r_es, r.r_bx);	/* pointer to XMM */
}

/*
 * XMSsetup - return 0 if EMS is available
 */
int	XMSsetup(void)
{
	if ( XMSinstalled() )
	{
		XMSget_entry();		/* get entry point */
#if	0	/* at least QEMM 6.0 does not have an XMS_name driver */
		if ( memcmp(MK_FP(FP_SEG(XMS_entry), 0x0a), XMS_name,
			    sizeof(XMS_name) - 1) == 0 )
			return(0);
#else
		return(0);
#endif
	}
	return(-1);
}

/*
 * XMSgate - enter XMM
 */
static	int	XMSgate(struct REGPACK *rp)
{
	struct REGPACK	r	= *rp;
	void far	*entry	= XMS_entry;

	if ( XMS_entry == NULL )
		return(-1);
	asm	push	si
	asm	push	di
	asm	push	ds
	asm	mov	ax, r.r_ax
	asm	mov	bx, r.r_bx
	asm	mov	cx, r.r_cx
	asm	mov	dx, r.r_dx
	asm	mov	si, r.r_si
	asm	mov	ds, r.r_ds
	asm	push	bp
	asm	call	dword ptr entry
	asm	pop	bp
	asm	mov	r.r_ax, ax
	asm	mov	r.r_bx, bx
	asm	mov	r.r_cx, cx
	asm	mov	r.r_dx, dx
	asm	mov	r.r_si, si
	asm	pop	ds
	asm	pop	di
	asm	pop	si
	*rp = r;
	return(0);
}

/*
 * XMS function 00H - get version information
 */
int	XMSget_version_info(XMS_version_info *ip)
{
	unsigned	XMS_version, XMM_version;
	struct REGPACK	r;

	r.r_ax = 0x0000;
	if ( XMSgate(&r) )
		return(-1);
	XMS_version = r.r_ax;
	XMM_version = r.r_bx;
	ip->HMA_present = r.r_dx;
	ip->XMS_version = ((XMS_version >> 12) & 0x0f) * 1000 +
			  ((XMS_version >> 8) & 0x0f) * 100 +
			  ((XMS_version >> 4) & 0xf) * 10 +
			  (XMS_version & 0x0f);

	ip->XMM_version = ((XMM_version >> 12) & 0x0f) * 1000 +
			  ((XMM_version >> 8) & 0x0f) * 100 +
			  ((XMM_version >> 4) & 0x0f) * 10 +
			  (XMM_version & 0x0f);
	return(0);
}

/*
 * XMS function 08H - get memory information
 */
int	XMSquery_extended_memory(XMS_extended_info *ip)
{
	struct REGPACK	r;

	r.r_ax = 0x0800;
	if ( XMSgate(&r) )
		return(-1);
	if ( (XMS_error = r.r_bx & 0xff) != 0 )
	{
#ifdef	DEBUG
		BUG(99)	fprintf(stderr, "XMS#8: %#02x\n", XMS_error);
#endif
		return(-1);		/* register bl is zero on success */
	}
	ip->largest_free_block = r.r_ax;
	ip->total_extended_memory = r.r_dx;
	return(0);
}

/*
 * XMS function 09H - allocate memory; returns 0 on success
 */
int	XMSalloc(XMS_sizeKB size, XMS_handle *hp)
{
	struct REGPACK	r;

	r.r_ax = 0x0900;
	r.r_dx = size;
	if ( XMSgate(&r) )
		return(-1);
	XMS_error = r.r_bx & 0xff;
	if ( r.r_ax == 0 )
	{
#ifdef	DEBUG
		BUG(1)	fprintf(stderr, "XMS#9(%u): %#02x\n", size, XMS_error);
#endif
		return(-1);
	}
	*hp = r.r_dx;
	return(0);
}

/*
 * XMS function 0AH - free memory; returns 0 on success
 */
int	XMSfree(XMS_handle handle)
{
	struct REGPACK	r;

	r.r_ax = 0x0a00;
	r.r_dx = handle;
	if ( XMSgate(&r) )
		return(-1);
	XMS_error = r.r_bx & 0xff;
	if ( r.r_ax == 0 )
	{
#ifdef	DEBUG
		BUG(1)	fprintf(stderr, "XMS#a(%u): %#02x\n",
				handle, XMS_error);
#endif
		return(-1);
	}
	return(0);
}

/*
 * XMS function 0BH - move memory; returns 0 on success
 */
int	XMSmove(XMS_move_param far *x)
{
	struct REGPACK	r;

	r.r_ax = 0x0b00;
	r.r_si = FP_OFF(x);
	r.r_ds = FP_SEG(x);
	if ( XMSgate(&r) )
		return(-1);
	XMS_error = r.r_bx & 0xff;
	if ( r.r_ax == 0 )
	{
#ifdef	DEBUG
		BUG(1)	fprintf(stderr, "XMS#b: %#02x\n", XMS_error);
#endif
		return(-1);
	}
	return(0);
}

/*
 * XMS function 0CH - get 32 bit linear address of memory; return 0 on success
 */
int	XMSlock(XMS_handle handle, XMS_offset *op)
{
	struct REGPACK	r;

	r.r_ax = 0x0c00;
	r.r_dx = handle;
	if ( XMSgate(&r) )
		return(-1);
	if ( r.r_ax != 0 )
	{
		XMS_error = 0;
		*op = ((XMS_offset) r.r_dx << 16) | r.r_bx;
		return(0);
	}
	XMS_error = r.r_bx & 0xff;
#ifdef	DEBUG
	BUG(1)	fprintf(stderr, "XMS#c(%u): %#02x\n", handle, XMS_error);
#endif
	return(-1);
}

/*
 * XMS function 0DH - unlock memory; returns 0 on success
 */
int	XMSunlock(XMS_handle handle)
{
	struct REGPACK	r;

	r.r_ax = 0x0d00;
	r.r_dx = handle;
	if ( XMSgate(&r) )
		return(-1);
	XMS_error = r.r_bx & 0xff;
	if ( r.r_ax == 1 )
		return(0);
#ifdef	DEBUG
	BUG(1)	fprintf(stderr, "XMS#d(%u): %#02x\n", handle, XMS_error);
#endif
	return(-1);
}

/*
 * XMS function 0FH - resize memory; returns 0 on success
 */
int	XMSresize(XMS_handle handle, XMS_sizeKB size)
{
	struct REGPACK	r;

	r.r_ax = 0x0f00;
	r.r_bx = size;
	r.r_dx = handle;
	if ( XMSgate(&r) )
		return(-1);
	XMS_error = r.r_bx & 0xff;
	if ( r.r_ax == 1 )
		return(0);
#ifdef	DEBUG
	BUG(1)	fprintf(stderr, "XMS#f(%u): %#02x\n", size, XMS_error);
#endif
	return(-1);
}

