/*============================================================================
 *	D2D/98	- disc to disc copy for IBM-PC/AT compatible machines
 *	Header file contains data structures and typedefs
 *
 *	Copyright (c) 1987 - 1992, 1998 by
 *		Ulrich Windl
 *		Alte Regensburger Strae 11a
 *		D-93149 Nittenau
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *============================================================================
 *$Id: xms.h'v 1.3.1.1 1998/12/24 22:25:46 UhW Exp $
 *$Log: xms.h'v $
 * Revision 1.3.1.1  1998/12/24  22:25:46  UhW
 * This is the GPL version for the 10th anniversary of D2D.
 *
 * Revision 1.3  1992/04/13  20:44:07  UhW
 * Changed XMS_error from signed to unsigned char.
 *
 * Revision 1.2  1991/11/06  16:58:49  UhW
 * Prepared for use with RCS
 *
 */

/*
 * extended memory block types
 */
typedef	unsigned short	XMS_sizeKB;
typedef	unsigned long	XMS_offset;
typedef	short		XMS_handle;

/*
 * upper memory block types.
 */
typedef unsigned short	XMS_HMA_segment;
typedef unsigned short	XMA_HMA_size;

/*
 * structure defining information returned from XMS_query_extended_memory
 */
typedef struct {
	XMS_sizeKB	largest_free_block;
	XMS_sizeKB	total_extended_memory;
} XMS_extended_info;

/*
 * structure defining information returned from XMS_get_version_info
 */
typedef struct {
	unsigned	XMS_version;
	unsigned	XMM_version;
	unsigned	HMA_present;
} XMS_version_info;

/*
 * move parameter block for extended memory moves.
 */
typedef struct {
	XMS_offset	length;
	XMS_handle	source_handle;
	XMS_offset	source_offset;
	XMS_handle	dest_handle;
	XMS_offset	dest_offset;
} XMS_move_param;

extern unsigned char XMS_error;
/*
 * XMS error codes
 */
#define XMS_NOT_IMPLEMENTED		0x80
#define XMS_VDISK_DETECTED		0x81
#define XMS_A20_ERROR			0x82
#define XMS_DRIVER_ERROR		0x8e
#define XMS_FATAL_DRIVER_ERROR		0x8f
#define XMS_NO_HMA			0x90
#define XMS_HMA_INUSE			0x91
#define XMS_HMA_DX_TOO_SMALL		0x92
#define XMS_HMA_NOT_ALLOCATED		0x93
#define XMS_A20_STILL_ENABLED		0x94
#define XMS_EXT_NO_MEM			0xa0
#define XMS_EXT_NO_HANDLES		0xa1
#define XMS_EXT_BAD_HANDLE		0xa2
#define XMS_EXT_BAD_SRC_HANDLE		0xa3
#define XMS_EXT_BAD_SRC_OFFSET		0xa4
#define XMS_EXT_BAD_DST_HANDLE		0xa5
#define XMS_EXT_BAD_DST_OFFSET		0xa6
#define XMS_EXT_BAD_LENGTH		0xa7
#define XMS_EXT_OVERLAP			0xa8
#define XMS_EXT_PARITY			0xa9
#define XMS_EXT_NOT_LOCKED		0xaa
#define XMS_EXT_LOCKED			0xab
#define XMS_EXT_NO_LOCKS		0xac
#define XMS_EXT_LOCK_FAILED		0xad
#define XMS_UMB_SMALLER_AVAIL		0xb0
#define XMS_UMB_NO_MEM			0xb1
#define XMS_UMB_BAD_SEG			0xb2


/*
 * XMSsetup - return 0 if EMS is available
 */
int	XMSsetup(void);

/*
 * XMS function 00H - get version information
 */
int	XMSget_version_info(XMS_version_info *ip);

/*
 * XMS function 08H - get memory information
 */
int	XMSquery_extended_memory(XMS_extended_info *ip);

/*
 * XMS function 09H - allocate memory; returns 0 on success
 */
int	XMSalloc(XMS_sizeKB size, XMS_handle *hp);

/*
 * XMS function 0AH - free memory; returns 0 on success
 */
int	XMSfree(XMS_handle handle);

/*
 * XMS function 0BH - move memory; returns 0 on success
 */
int	XMSmove(XMS_move_param far *x);

/*
 * XMS function 0CH - get 32 bit linear address of memory; return 0 on success
 */
int	XMSlock(XMS_handle handle, XMS_offset *op);

/*
 * XMS function 0DH - unlock memory; returns 0 on success
 */
int	XMSunlock(XMS_handle handle);

/*
 * XMS function 0FH - resize memory; returns 0 on success
 */
int	XMSresize(XMS_handle handle, XMS_sizeKB size);
