// Name   : MAXLINE.C
// Author : Philippe Duby & J.D. Pauget
// Date   : January 12 94
// Note   : Source tab = 3

#include <dos.h>
#include <mem.h>

#define VARBIOS(n)	*(char far *)MK_FP (0x40, n)// Read Bios variable
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#define max(a,b)    (((a) > (b)) ? (a) : (b))

main ()
{
	union REGS	regs, regc;
	int	i;

	regc.h.ah = 0x3;							// Get cursor info
	regc.x.bx = 0;
	int86 (0x10, &regc, &regc);
	i = regc.h.dh;

	regs.h.ah = 0x0F;							// Get video mode
	int86 (0x10, &regs, &regs);
	if (regs.h.al == 3) 					 	// Text color
		if (VARBIOS (0x84)+1 == 25)		// We are in 25 lines mode
		{
			int	c = *(int far *)MK_FP (0xB800, 2*(80*i+regc.h.dl)),
					far *p= (int far *)MK_FP (0xB800, 2*80*25);

			for (i=25*80 ; i < 50*80 ; i++)// Empty screen after line 25
				*p++ = c;

			regs.x.ax = 0x1112;				// Set small font
			regs.h.bl = 0;
			int86 (0x10, &regs, &regs);
		}
		else										// We are in 43 or 50 lines mode
		{
			char szBuf[4000];					// Screen save buffer

			_fmemcpy (szBuf, MK_FP (0xB800, 2*80*max (i-25, 0)), 4000);

			regs.x.ax = 0x1114;				// Set big font
			regs.h.bl = 0;
			int86 (0x10, &regs, &regs);

			_fmemcpy (MK_FP (0xB800, 0), szBuf, 4000);

			regc.h.ah = 0x2;					// Set cursor
			regc.h.dh = min(i, 24);
			int86 (0x10, &regc, &regc);
		}

	return 0;
}