
// check the fats to see if they are equal
void check_fats(void)
	{
	int		i,j;
	uchar	*fat1_sec_buf;
	uchar	*fat2_sec_buf;
	ulong	fat1_sec_num;
	ulong	fat2_sec_num;

	fat1_sec_buf = (uchar*)calloc( hdb.bytes_sector, sizeof(uchar));
	if( fat1_sec_buf == NULL )
		{
		cprintf("\n\rFailed to allocate memory for fat1_buf in check_fats");
		getch();
		exit(0);
		}
	fat2_sec_buf = (uchar*)calloc( hdb.bytes_sector, sizeof(uchar));
	if( fat1_sec_buf == NULL )
		{
		cprintf("\n\rFailed to allocate memory for fat2_buf in check_fats");
		getch();
		exit(0);
		}

	// first fat starts right after boot record
	fat1_sec_num = (ulong)hdb.reserved_sectors;
	// 2nd fat starts right after first fat
	fat2_sec_num = (ulong)hdb.reserved_sectors + (ulong)hdb.sectors_fat;

	for( i = 0 ; i < hdb.sectors_fat ; i++ )
		{
		read_sec( (uchar far*)fat1_sec_buf,fat1_sec_num + (ulong)i,1);
		read_sec( (uchar far*)fat2_sec_buf,fat2_sec_num + (ulong)i,1);
		for( j = 0 ; j < hdb.bytes_sector ; j++ )
			{
			if( *(fat1_sec_buf+j) != *(fat2_sec_buf+j) )
				{
				cprintf("\n\rFATS ARE NOT EQUAL - RUN SCANDISK OR CHKDSK");
				getch();
				exit(0);
				}
			}
		}
	}
