

// check subdirectories for other files

void cln_ulg2(uint cluster)
	{
	// cluster = first cluster for the sub-directory
	uint	i,j,k,m; // indexes for 'for' loops
	uint 	ch; 	// character storage
	ulong	first_sector;    // first_sector = first sector of the cluster
	ulong	last_sector;     // last_sector = last sector of the cluster
	uint 	next_cluster;	 // next_cluster = value of a cluster - points to next cluster
	ulong 	fat_sector;      // fat_sector = relative sector number of the fat table
	ulong	next_fat_sector; // next_fat_sector = relative sector number of the fat table for the next cluster
	ulong	num_clusters;    // num_clusters = number of clusters in the directory
	uint 	fat_offset;      // fat_offset = offset into the sector to find the next cluster value
	uint	next_fat_offset; // next_fat_offset = same for next cluster
	uchar 	far *sec_buf;    	 // *sec_buf = pointer to sector buffer
	uchar 	*fat_sec_buf;       // *fat_sec_buf = pointer to fat sector buffer
	uchar 	*next_fat_sec_buf;  // *next_fat_sec_buf = pointer to next fat sector buffer
	uint 	far *cluster_chain_begin; // far *cluster_chain_begin = far pointer to beginning of cluster chain for this directory
	uint 	far *cluster_chain_ptr;   // far* cluster_chain_ptr = pointer to object within the cluster chain

	// allocate memory for the sector buffers and set the pointers
	sec_buf = (uchar far*)farcalloc((ulong)hdb.sectors_cluster*(ulong)hdb.bytes_sector,sizeof(uchar));
	if( sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc sec_buf in cln_ulg2");
		getch();
		exit(0);
		}
	fat_sec_buf = (uchar*)calloc(hdb.bytes_sector, sizeof(char));
	if( fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc fat_sec_buf in cln_ulg2");
		getch();
		exit(0);
		}
	next_fat_sec_buf = (uchar*)calloc(hdb.bytes_sector,sizeof(char));
	if( next_fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to alloc next_fat_sec_buf in cln_ulg2");
		getch();
		exit(0);
		}

	// calculate the sector and offset of the cluster location in the fat
	fat_sector =  ((ulong)cluster * 2L)/(ulong)hdb.bytes_sector
				  // use the first fat so add in the reserved sectors
				  + (ulong)hdb.reserved_sectors;
	fat_offset = (uint)(((ulong)cluster * 2L) % (ulong)hdb.bytes_sector);
	read_sec((uchar far*)fat_sec_buf, fat_sector,1);  // read the fat sector
	next_cluster = *(uint*)&fat_sec_buf[(uint)fat_offset];

	// count the clusters for this directory
	num_clusters = 1L; // got one at least
	while( next_cluster != 0xffff )
		{
		num_clusters += 1L;  // got more than one so increment
		// find the sector holding the next cluster
		next_fat_sector =  (ulong)((next_cluster * 2)/hdb.bytes_sector)
				+ (ulong)hdb.reserved_sectors;  // use the first fat so add in the reserved sectors
		// find the offset into the sector for the next cluster
		next_fat_offset = (next_cluster * 2) % hdb.bytes_sector;
		// read the fat sector
		read_sec((uchar far*)next_fat_sec_buf, next_fat_sector,1);
		// get the value of the cluster
		next_cluster = *(uint*)&next_fat_sec_buf[(uint)next_fat_offset];
		}  // when finished - num_clusters has the number of clusters in the directory

	// now reserve memory large enough to contain the cluster numbers
	// and assign it to the pointer
	cluster_chain_begin = (uint far*)farcalloc( num_clusters, sizeof(uint) );
	if( cluster_chain_begin == NULL )
		{
		cprintf("\n\rFailed to allocate cluster_chain_begin in cln_ulg2");
		getch();
		exit(0);
		}
	cluster_chain_ptr = cluster_chain_begin;
	*cluster_chain_ptr++ = cluster; // save the first cluster and increment the ptr

	// restore the 'value' of the starting cluster which is the next cluster #
	next_cluster = *(uint*)&fat_sec_buf[(uint)fat_offset];
	// now save the cluster values
	while( next_cluster != 0xffff )
		{
		*cluster_chain_ptr++ = next_cluster; // not the last so save the next cluster number and increment the ptr
		next_fat_sector =  (ulong)((next_cluster * 2)/hdb.bytes_sector)
				+ (ulong)hdb.reserved_sectors;  // use the first fat so add in the reserved sectors
		next_fat_offset = (next_cluster * 2) % hdb.bytes_sector;
		read_sec((uchar far*)next_fat_sec_buf, next_fat_sector,1);  // read the fat sector
		next_cluster = *(uint*)&next_fat_sec_buf[(uint)next_fat_offset];
		}

	//==============================================================
	// here I know all the cluster chain for this directory with the following data
	// cluster = first cluster number (not its value)
	// num_clusters = number of clusters in the directory
	// cluster_chain_begin = pointer to first location of cluster number storage
	// cluster_chain_ptr = floating pointer to cluster chain
	// the values of the cluster pointers are stored in cluster chain starting at cluster_chain_begin
	//===============================================================
	for( i = 0 ; i < (uint)num_clusters ; i++ )
		{
		calc_cluster_sectors( *(cluster_chain_begin + (uint)i),  &first_sector,  &last_sector );
		rd_multi( (uchar far*)(sec_buf), first_sector, 1 ,hdb.sectors_cluster);
		for( j = 0 ; j < hdb.sectors_cluster ; j++ )
			{
			for( k = 0 ; k < hdb.bytes_sector/32 ; k++ )
				{
				if( kbhit() )
					{
					get_key();
					cprintf("\n\rQuit? Y or N");
					ch = getch();
					if( (ch == 'Y') || (ch == 'y') )
						exit(0);
					}
				if( *(sec_buf+j*hdb.bytes_sector+k*32+11) & 0x10 ) // check if directory
					{
					ch = *(sec_buf+j*hdb.bytes_sector+k*32);
					if( ch == 0x00 ) // no more entries
						break;
					if( (ch != 0xe5) && (ch != 0x2e) ) // check for erased entry
						{
						cprintf("\n\rChecking  sub-Directory ");
						for( m = 0 ; m < 8 ; m++ )
							cprintf("%c",*(sec_buf+j*hdb.bytes_sector+k*32+m));
						// got another sub_directory so jump to it
						dircount += 1;
						cln_ulg2( *(uint*)(sec_buf+j*hdb.bytes_sector+k*32+26) );
						}
					}
				else // not a directory, so must be a file or label
					{
					ch = *(sec_buf+j*hdb.bytes_sector+k*32);
					if( ch == 0x00 )  // no more entries
						break;
					if( (ch != 0xe5)
						 && ((*(sec_buf+j*hdb.bytes_sector+k*32+11) & 0x08) != 0x08)
						 && (*(ulong*)(sec_buf+j*hdb.bytes_sector+k*32+28) != 0L)
						 && ( *(uint*)(sec_buf+j*hdb.bytes_sector+k*32+26) != 0) ) // check for erased entry or volume label
						{
						cprintf("\n\rCleaning File ");
						for( m = 0 ; m < 8 ; m++ )
							cprintf("%c",*(sec_buf+j*hdb.bytes_sector+k*32+m));
						cprintf(".");
						for( m = 0 ; m < 3 ; m++ )
							cprintf("%c",*(sec_buf+j*hdb.bytes_sector+k*32+8+m));
						filecount += 1L;
						clean_file( *(uint*)(sec_buf+j*hdb.bytes_sector+k*32+26), *(ulong*)(sec_buf+j*hdb.bytes_sector+k*32+28) );
						}
					}
				}
			}
		}
	farfree(sec_buf);
	free(fat_sec_buf);
	free(next_fat_sec_buf);
	farfree(cluster_chain_begin);
	}
