
// clean all file cluster ullage  (look it up!)
void cln_ulge(void)
	// This program cleans all left over data areas in a cluster that
	// is not used by a file.
	{
	int		i,j,m;		// index variables
	uint	ch;				// for character storage
	ulong	first_sector; 	// first sector of the root directory
	uchar	far *root_buf;  // data buffer for the root directory
	uint	num_secs_root;  // number of sectors in the root directory

	// set the global values
	dircount = 1;
	filecount = 0L;

	// find the root direrctory locations
	first_sector = (ulong)hdb.reserved_sectors +
				   (ulong)hdb.sectors_fat * (ulong)hdb.number_fats;
	num_secs_root = (uint)(((ulong)hdb.number_entries_root_dir * 32L)/(ulong)hdb.bytes_sector);

	root_buf = (uchar far*)farcalloc( (ulong)num_secs_root * (ulong)hdb.bytes_sector, sizeof(uchar) );
	if( root_buf == NULL )
		{
		cprintf("\n\rFailed to allocate root_buf in cln_ulge.cpp");
		getch();
		exit(0);
		}

	rd_multi((uchar far*)root_buf, first_sector, 1, num_secs_root );

	for( i = 0 ; i < (uint)num_secs_root ; i++ )
		{
		if( kbhit() )
			{
			get_key();
			cprintf("\n\rQuit? Y or N");
			ch = getch();
			if( (ch == 'Y') || (ch == 'y') )
            	exit(0);
			}
		for( j = 0 ; j < hdb.bytes_sector/32 ; j++ )
			{
			if( *(root_buf+i*hdb.bytes_sector+j*32+11) & 0x10 ) // check if directory
				{
				ch = *(root_buf+i*hdb.bytes_sector+j*32);
				if( ch == 0x00 ) // no more entries
					break;
				if( ch != 0xe5 ) // check for erased entry
					{
					cprintf("\n\rChecking  Directory ");
					for( m = 0 ; m < 8 ; m++ )
						cprintf("%c",*(root_buf+i*hdb.bytes_sector+j*32+m));
					cprintf(" at cluster # %u", *(uint*)(root_buf+i*hdb.bytes_sector+j*32+26));
					dircount += 1;
					cln_ulg2(*(uint*)(root_buf+i*hdb.bytes_sector+j*32+26));
					}
				}
			else // not a directory, so must be a file or label
				{
				ch = *(root_buf+i*hdb.bytes_sector+j*32);
				if( ch == 0x00 )  // no more entries
					break;
				if( (ch != 0xe5)
					 && ((*(root_buf+i*hdb.bytes_sector+j*32+11) & 0x08) != 0x08)
					 && (*(ulong*)(root_buf+i*hdb.bytes_sector+j*32+28) != 0L)
					 && ( *(uint*)(root_buf+i*hdb.bytes_sector+j*32+26) != 0) ) // check for erased entry or volume label
					{
					cprintf("\n\rCleaning File ");
					for( m = 0 ; m < 8 ; m++ )
						cprintf("%c",*(root_buf+i*hdb.bytes_sector+j*32+m));
					cprintf(".");
					for( m = 0 ; m < 3 ; m++ )
						cprintf("%c",*(root_buf+i*hdb.bytes_sector+j*32+8+m));
                    filecount += 1L;
					clean_file( *(uint*)(root_buf+i*hdb.bytes_sector+j*32+26), *(ulong*)(root_buf+i*hdb.bytes_sector+j*32+28) );
					}
				}
			}
		}
	cprintf("\n\rDirectory count = %u", dircount);
	cprintf("\n\rFile count =      %lu", filecount);
	farfree(root_buf);
	}


