//================================================
// getbootdata()
//================================================


// get the boot record data into the structures
void gbdinit(uchar disk)
	{
	int 	i;
	uint 	result;
	uchar 	far *bufptr;
	int 	bootoffset;
	uint	cylinder, sector, temp;
	char    fat_type_str[8] = {'F','A','T','1','6',0x00 };
	char	os_type_str[8] = {'M','S','D','O','S',0x00 };

	// now work the magic on the cylinder and sector stuff
	sector = apart.startcylandsector & 0x003f;  // lsb 6 bits = sector
	temp = (apart.startcylandsector & 0x00c0) << 2;  // msb 2 bits of cylinder
	// get the lsb 8 bits of the cyl and combine with the 2 msb bits
	cylinder = ((apart.startcylandsector >> 8) & 0x00ff) | temp;

	mydisk.drive = disk;
	mydisk.head = (uint)apart.start_head;
	mydisk.track = cylinder;
	mydisk.sector = sector;
	mydisk.nsectors = 1; // only need one sector
	mydisk.buffer = sector_buffer;
	result = _bios_disk( _DISK_READ, &mydisk );
	if( (result & 0xff00) != 0)
		{
		cprintf("\n\rCould not read boot sector, fail code = 0x%.2x",(uchar)((result>>8)&0x00ff));
		getch();
		exit(0);
		}
	// the data is in secbuf, 512 bytes.
	// transfer the data of interest to the boot structure hdboot
	bootoffset = 0x0003;
	bufptr = (uchar far *)&hdb;
	for( i = 0 ; i < sizeof(hdb) ; i++ )
		bufptr[i] = sector_buffer[i+bootoffset];

	// check the boot record for valid data

	// check OS type
	if( strncmp( (char*)&hdb.systemname[0], os_type_str, 5 ) != 0 )
		{
		cprintf("\n\rThis is not an MSDOS boot record.");
		getch();
		exit(0);
		}
	// check the fat type
	if( strncmp( (char*)&hdb.type_fat[0], fat_type_str, 5 ) != 0 )
		{
		cprintf("\n\rThis is not a FAT16 partition");
		getch();
		exit(0);
		}
	}


