// filetree.cpp Class FILETREE definitions
// last updated by Roedy Green, 1996 November 4

/* I N C L U D E S */

#include <stdlib.h>
// e.g. exit, min, max

#include <stdio.h>
// e.g. FILE, printf, fopen

#include <dos.h>
// _dos_findfirst _dos_findnext

#include <string.h>
// strcpy

#include "typedef.hpp"
// WORD BYTE BOOL

#include "filetree.hpp"
// FILETREE - process tree of files

/* ***************************************** */

void FILETREE::ForEachFile  (char * WildCard, ATTRIBPATTERN AttribPattern, BOOL Recurse )
{
    Stop = FALSE;
    InitAttribFilters(AttribPattern);

    if (Recurse) ProcessSubs(WildCard);
    else ProcessFiles(WildCard);

} /* end ForEachFile */

/* ***************************************** */

void  FILETREE::ProcessSubs(char *WildCard)
/* We recursively process all WildCard-matching ordinary files and all
 * subdirs of this dir.  Since we
 * are processing recursively we use new rather than the stack to avoid
 * overflowing it. Wildcard describes files, not subdirs. */

{
    struct find_t * Hit  = new struct find_t;
    /* a subdir found by _dos_findnext */

    char * FindSubsWildCard = new char [FILENAME_MAX];

    char * SubWildCard = new char [FILENAME_MAX];

    if (WildCard && WildCard[0]) /* not null */
	{
	ProcessFiles(WildCard); /* process ordinary files first */

	/* ignore file part when searching for dirs.
	 * e.g. E:/MyDir/*.* to search for any subdirs.
	 * Process only Subdirs, including hidden, system etc. subdirs.
	 * Ignore all hits but true subdirs.
	 * User's FineAttribFilter is irrelevant */
	if (!Stop && _dos_findfirst(Join ( FindSubsWildCard, WildCard, NULL, "*.*"),
	    (_A_SUBDIR | _A_ARCH | _A_RDONLY | _A_HIDDEN | _A_SYSTEM),
	    Hit) == 0)
	    do
		{
		if ((Hit->attrib & _A_SUBDIR) && Hit->name[0] != '.')
		    {
		    /* e.g. E:/MyDir/MySub/*.TXT */
		    ProcessSubs(Join(SubWildCard, WildCard, Hit->name, NULL ));
		    /* recursively */
		    }
		}
	    while (!Stop && _dos_findnext(Hit) == 0);
	}
    delete FindSubsWildCard;
    delete SubWildCard;
    delete Hit;

}  /* end ProcessSubs */

/* ***************************************** */

void FILETREE::ProcessFiles( char * WildCard )
{
    /* non-recursively process files in directory described by WildCard. */
    struct find_t * Hit = new struct find_t;
    /* a file found by _dos_findnext */

    char * QualFileName = new char [FILENAME_MAX];

    if (WildCard && WildCard[0]) /* not null */
	if (_dos_findfirst(WildCard, CoarseAttribFilter, Hit) == 0)
	    do
		{
		if (FineAttribFilter[Hit->attrib])
		    {
		    if (ProcessOneFile
			(Join(QualFileName, WildCard, NULL, Hit->name),
			Hit->size ))
			{
			Stop = TRUE;
			break;
			}
		    }
		} while (_dos_findnext(Hit) == 0);

    delete QualFileName;
    delete Hit;

}    /* end ProcessFiles */

/* ***************************************** */

void FILETREE::InitAttribFilters (ATTRIBPATTERN AttribPattern)
{
    /* Prepare FineAttribFilter so we don't have to keep invoking the
     * slow ProbeAttribFilter function.
     * Also prepare CoarseAttribFilter -- special types of files
     * EVER wanted.
     * We can use CoarseAttribFilter to get DOS to do some gross filtering. */
    ATTRIB	     Attrib;
    CoarseAttribFilter = 0;
    for (Attrib = 0; Attrib < 64; Attrib++)
	{
	if ((FineAttribFilter[Attrib] = ProbeAttribFilter(Attrib, AttribPattern)))
	    CoarseAttribFilter |= Attrib;
	}
} /* end InitAttribFilters */

/* ***************************************** */

BOOL FILETREE::ProbeAttribFilter(ATTRIB Attrib, ATTRIBPATTERN AttribPattern)
{
    /* true if Attrib matches the given string pattern .
     * attribute pattern string is of form:
     * ADVSHR A-archive D-directory V-volume S-system H-hidden R-read-only
     * "ADVSHR"
     * "?00+1-" <-- example
     * ?=ignore, irrelevant.
     * 1=must be 1
     * 0=must be 0
     * +=must have some 1s, all plus slots many not be 0
     * -=must have some 0s, all minus slots may not be 1 */

    BOOL	   Bit;
    BOOL	   NeedPlus = FALSE; /* no + seen yet, so no need for 1s in + slots */
    BOOL	   NeedMinus = FALSE; /* ditto for minus */
    int 	   i;
    WORD	   PlusCount = 0;
    WORD	   MinusCount = 0;

    /* work right to left comparing the Pattern char string with the Attrib bits */
    for (i = 5; i >= 0; i--)
	{
	Bit = (BOOL) (((WORD) Attrib >> (5 - i)) & 1);
	switch (AttribPattern[i])
	    {
	    case '1':
		if (!Bit)
		    return (FALSE);
		break;
	    case '0':
		if (Bit)
		    return (FALSE);
		break;
	    case '+':
		NeedPlus = TRUE;
		if (Bit)
		    PlusCount++;
		break;
	    case '-':
		NeedMinus = TRUE;
		if (!Bit)
		    MinusCount++;
		break;
	    case '?':
		break;
	    default:
		printf(
		    "\n Programmer error: Invalid WildCard attribute specifier string: %s.\n",
		    AttribPattern);
		exit(99);
	    } /* end switch */
	} /* end for */
    if (NeedPlus && (PlusCount == 0))
	return (FALSE);
    if (NeedMinus && (MinusCount == 0))
	return (FALSE);
    return (TRUE);

} /* end ProbeAttribFilter */

/* ***************************************** */

char * FILETREE::Join(char *Result, char *WildCard, char *SubDir, char *FileName)

{
    /* Glue Wildcard, Subdir and FileName together */
    /* SubDir and FileName might be null */
    char	    Drive[_MAX_DRIVE];
    char	    Dir[_MAX_DIR];
    char	    Fname[_MAX_FNAME];
    char	    Ext[_MAX_EXT];

    _splitpath(WildCard, Drive, Dir, Fname, Ext);
    /* Dir will usually have lead and trail backslash */

    if (SubDir) strcat(Dir, SubDir);

    if (FileName) _makepath(Result, Drive, Dir, FileName, NULL);
    else _makepath(Result, Drive, Dir, Fname, Ext);
    return Result;

} /* end Join */

/* ***************************************** */
// -30-

