REM: Include file for Hex Editor v2.4a PD 2002.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' get include files.
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'wdta.bi'

' declare undo arrays.
COMMON SHARED UndoByte() AS INTEGER, UndoPosition() AS LONG

' declare undo variables.
COMMON SHARED MaxUndos AS LONG, CurrentUndo AS LONG

' declare marker array.
COMMON SHARED Markers() AS LONG

' declare marker variables.
COMMON SHARED CurrentMarker AS LONG, NewMarker AS LONG
COMMON SHARED MaxMarkers AS LONG, MarkerCount AS LONG

' declare ascii character variables.
COMMON SHARED Hline AS INTEGER, Vline AS INTEGER
COMMON SHARED ULcorner AS INTEGER, URcorner AS INTEGER
COMMON SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
COMMON SHARED Low AS LONG, High AS LONG
COMMON SHARED TempPosition AS LONG, TempPosition1 AS LONG
COMMON SHARED TempPosition2 AS LONG, TempPosition3 AS LONG

' declare common program variables.
COMMON SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
COMMON SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
COMMON SHARED PageColumn AS INTEGER, PageRow AS INTEGER
COMMON SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
COMMON SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare filename/file position variables.
COMMON SHARED DumpFile AS STRING, Filename AS STRING
COMMON SHARED FileByte AS STRING*1, FileBytePosition AS LONG
COMMON SHARED FileLength AS LONG, FilePage AS LONG
COMMON SHARED FilePosition AS LONG, FirstByte AS LONG
COMMON SHARED LastByte AS LONG, LastPage AS LONG
COMMON SHARED NewByte AS LONG, NextByte AS LONG
COMMON SHARED NextLine AS LONG, NextPage AS LONG
COMMON SHARED SeekPosition AS LONG, StorePosition AS LONG
COMMON SHARED NewPosition AS LONG, FilePage2 AS LONG
COMMON SHARED PageRow2 AS LONG, PageColumn2 AS LONG
COMMON SHARED Column2 AS LONG, FilePosition2 AS LONG

' declare all long filename common variables.
COMMON SHARED ASCIIZ AS STRING*261, ASCIIZ2 AS STRING*261
COMMON SHARED Buffer AS STRING*1, ConfigFile AS STRING
COMMON SHARED BASIC.DTA.OFF AS INTEGER, BASIC.DTA.SEG AS INTEGER
COMMON SHARED DTAfile AS DTAtype, ErrorTrap AS INTEGER
COMMON SHARED FileAttribute AS INTEGER, Quote AS STRING
COMMON SHARED Windows.Detected AS INTEGER, Wfile.Handle AS INTEGER
COMMON SHARED WDTAfile AS WDTAtype

' declare all common mouse variables.
COMMON SHARED Mouse.Active AS INTEGER, Mouse.Present AS INTEGER
COMMON SHARED Mouse.Button1 AS INTEGER, Mouse.Button2 AS INTEGER
COMMON SHARED Mouse.Row AS INTEGER, Mouse.Column AS INTEGER
COMMON SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
COMMON SHARED Mouse.X AS INTEGER, Mouse.Y AS INTEGER

' declare arrays for menu.bas
COMMON SHARED Num.Dirs AS INTEGER, Max.Dirs AS INTEGER
COMMON SHARED Directories() AS STRING * 256
COMMON SHARED Num.Files AS INTEGER, Max.Files AS INTEGER
COMMON SHARED Filenames() AS STRING * 256

' declare filename variables for menu.bas
COMMON SHARED Attribute AS INTEGER, ASCIIZ3 AS STRING*261

' declare menu screen location offsets for menu.bas
COMMON SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare interrupt structures.
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

' declare author constants.
CONST Author="Erik Jon Oredson AS. CSci"
CONST Email="eoredson@yahoo.com"
CONST Urls="www.simtel.net www.filegate.net"

' declare constants.
CONST Nul=""
CONST False=0
CONST True=-1
CONST Version="v2.4a"
CONST Release="r1.0a"
CONST Publish="06/01/2002."
CONST Status="Public Domain"
CONST Program="Hex Editor for DOS"

' declare colors.
CONST Black=0
CONST Blue=1
CONST Cyan=11
CONST Green=10
CONST Magenta=13
CONST Plain=7
CONST Red=12
CONST White=15
CONST Yellow=14

' declare bit constants.
CONST ReadOnlyBit=1
CONST HiddenBit=2
CONST SystemBit=4
CONST ArchiveBit=32

' declare mouse function constants.
CONST CheckMouse=0
CONST ShowMouse=1
CONST HideMouse=2
CONST Position=3
CONST Button=5

' declare functions.
DECLARE FUNCTION Conanicalize$(V$)
DECLARE FUNCTION ReleaseTime ()
DECLARE FUNCTION TrimSpaces$(V$)

' declare subroutines.
Declare Sub MouseFunction(V1%,V2%)
Declare Sub Menu(V1$,V2$,V3$,V4$)
