#define MYREV 'A'
/*
 * FLOPINFO -- a Turbo 'C' program which will display the current drive
 * parameters for your floppy disk(s).  Compiled using version 1.5 of Turbo
 * 'C'.  This program is released into the public domain 8/29/88.  This is
 * NOT a shareware program. It might or might not be supported by the author. 
 *
 * Original code:	8/29/88 D. Bushong This revision:  A  (original) 
 *

Revision history 
========================== 
REV	DATE	BY	Reason for mod / effect obtained 
======= ======= ======= ================================================== 
    A	2/ 3/91 Bushong	Change of address (no functional changes)
    B	 /  / 
    C	 /  / 

 *
 */

#include <bios.h>
#include <mem.h>
#include <conio.h>
#include <dos.h>
#include <process.h>

typedef unsigned char BYTE;
typedef unsigned WORD;

struct table {
    unsigned hut:4, srt:4, nd:1, hlt:7;
    char motor, bpsec, last_sec, gap, data, gap_format, fmt_data, settle, startup;
};
#if ((sizeof(struct table))!=11)
***Alignment error ! Must be byte - aligned structures ! ***
#endif

#if (MYREV=='A')
#define MODBY ""
#else
#define MODBY "Modified 00/00/00 by [yourname]"
#endif

void hello(void)
{
     clrscr();
    gotoxy(1, 2);
    cprintf("   FLOPINFO.... display floppy disk information from BIOS and drive table\r\n");
    cprintf("   (%c)   Public domain software from Dave Bushong, Dracut, MA 01826\r\n", MYREV);
    gotoxy(1, 25);
    cprintf("%79s\r\n", MODBY);
}

struct table far *tp;
unsigned char far *bp;
extern _8087;
void main(void)
{
    /*
     * this program will show what the BIOS thinks is going on with the
     * floppy. 
     */

     lowvideo();
    _8087 = 0;
    tp = (struct table far *) getvect(0x1e);
    bp = (char far *) tp;

    hello();

    gotoxy(1, 4);
    lowvideo();

    cprintf("The eleven entries in the disk base table at %Fp are:\r\n\r\n", tp);
    highvideo();
    cprintf("%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X\r\n\r\n",
	    bp[0], bp[1], bp[2], bp[3], bp[4], bp[5], bp[6], bp[7], bp[8], bp[9], bp[10]);

    lowvideo();

    cprintf("                        Step-rate time: %d msec.\r\n", 16 - (tp->srt));
    cprintf("                      Head unload time: %d msec.\r\n", 16 * tp->hut);
    cprintf("                        Head-load time: %d msec.\r\n", 2 * tp->hlt);
    cprintf("                              DMA mode: %s\r\n", (tp->nd == 0) ? "Yes" : "No");

    cprintf("      Wait time until motor turned off: %0.1g seconds\r\n", (float) (tp->motor) * (.054931));

    cprintf("                      Bytes per sector: %d\r\n", 128 << tp->bpsec);
    cprintf("                    Last sector number: %d\r\n", tp->last_sec);
    cprintf("            Gap length between sectors: %d\r\n", tp->gap);
    cprintf("Data length (if unknown sector length): %d\r\n", tp->data);
    cprintf("      Gap length for format operations: %d\r\n", tp->gap_format);
    cprintf("Data value stored in formatted sectors: %02X\r\n", tp->fmt_data);
    cprintf("                      Head settle time: %d millisecond%s\r\n", tp->settle, tp->settle == 1 ? "" : "s");
    cprintf("                          Startup time: %0.1g second%s\r\n", 0.125 * (float) tp->startup, tp->startup == 8 ? "" : "s");
}
