/*  dev.h -- Values needed for disk device access */
/*  Copyright 1991, Steven W. Harrold - All rights reserved. */
/*  $Header: DEV.H_V 1.3 91/03/20 08:48:53 SWH Exp $ */

#include    <bios.h>

#define NEW_MEDIA       0x06            /* Media has changed */
#define NO_MARKER       0x02            /* Address mark not found */
#define NO_SECTOR       0x04            /* Sector not found */

#ifdef TURBOC
#define _DISK_RESET     0
#define _DISK_READ      2
#define _DISK_VERIFY    4
#endif

extern int Dstatus ;            /* status of most recent dev operation */

struct devdata                  /* describes the disk being accessed */
{
    int     d_drive ;           /* drive num; 0x0n=floppy; 0x8n=hard */
    int     d_tracks ;          /* number of tracks (aka cylinders) */
    int     d_heads ;           /* number of heads (aka tracks) */
    int     d_sectors ;         /* number of sectors (aka records) */
    int     d_partnum ;         /* partition number */
    int     d_partoff ;         /* partition offset in tracks (cyls) */
    int     d_interleave ;      /* interleave factor */
    int     d_status ;          /* last BIOSDISK status */
} ;

#define BIOSDISK(cmd)   biosdisk((cmd),drive,head,track,sector,1,buffer)

/* The biosdisk() is supplied with TurboC.
*/
#ifdef MSC
int biosdisk(int cmd,int drive,int head,int track,int sector,
             int nsectors,void *buffer);
#endif


/*---eof---*/
