/*  mhexbuf.c   -- print a Minix buffer in hex */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MHEXBUF.C_V 1.2 91/03/19 09:57:59 SWH Exp $ */

#include    <stdio.h>
#include    <ctype.h>
#include    "mfs.h"


/*==================================================================*/
void print_hex_buf (buffer, blkno, title)
void    *buffer ;
int     blkno ;
char    *title ;
{
    int     i, j ;
    byte    c ;
    byte    *buf = buffer ;

    printf ("****  %05u - %s  ****\n", blkno, title) ;

    for (i=0; i<BLOCK_SIZE; i+=16)
    {
        printf ("%04X.   ", i) ;

        for (j=0; j<8; j++)
            printf ("%02X ", (buf[i+j]& 0xff)) ;

        printf ("- ") ;

        for (j=8; j<16; j++)
            printf ("%02X ", (buf[i+j]& 0xff)) ;

        printf ("  *") ;

        for (j=0; j<16; j++)
        {
            c = buf[i+j] ;
            if (isprint(c))
                printf ("%c", c) ;
            else
                printf (".") ;

        } /* for j */

        printf ("*\n") ;

    } /* for i */

    printf ("\n") ;

} /* print_hex_buf() */


/*---eof---*/
