/*  mrdblk.c        -- read a block from a Minix file system */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MRDBLK.C_V 1.5 91/03/20 09:46:24 SWH Exp $ */

#include    <stdio.h>
#include    <dos.h>
#include    "mfs.h"
#include    "dev.h"

DEVREAD


/*==================================================================*/
void read_block (buf, blkno, ddata)
void            *buf ;              /* input buffer */
int             blkno ;             /* first block is # 0 */
struct devdata  *ddata ;
{
    int     sb, sect ;

    sb = BLOCK_SIZE / SECTOR_SIZE ;
    sect = blkno * sb ;

    Dstatus = devread (ddata, sb, sect, buf) ;
    if (Dstatus)
    {
        fprintf(stderr, "Can't read drive %c: at block %d, ",
                        DRIVES[ddata->d_drive], blkno) ;
        fprintf(stderr, "Status code = %d\n", Dstatus) ;
        exit (2) ;
    }

} /* read_block() */


/*---eof---*/
