REM Free/total disk space in PDS 7.1 - note: greater 2 GB not* reported..

TYPE RegtypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
END TYPE

DECLARE SUB InterruptX (N AS INTEGER, I AS RegtypeX, O AS RegtypeX)
DIM InregsX AS RegtypeX, OutregsX AS RegtypeX

'--------D-2136-------------------------------
'INT 21 - DOS 2+ - GET FREE DISK SPACE
'        AH = 36h
'        DL = drive number (00h = default, 01h = A:, etc)
'Return: AX = FFFFh if invalid drive
'        else
'            AX = sectors per cluster
'            BX = number of free clusters
'            CX = bytes per sector
'            DX = total clusters on drive
'Notes:  free space on drive in bytes is AX * BX * CX
'        total space on drive in bytes is AX * CX * DX
'        (FAT32 drive) the reported total and free space are limited to 2G-32K
'          should they exceed that value

LINE INPUT "Disk drive letter? ", D$
InregsX.AX = &H3600
InregsX.DX = ASC(UCASE$(D$)) - 64
CALL InterruptX(&H21, InregsX, OutregsX)
IF OutregsX.AX = &HFFFF THEN
   PRINT "Invalid drive.": END
END IF
If OutregsX.AX<0 Then
   SectorsPerCluster#=Cdbl(OutregsX.AX+65536)
Else
   SectorsPerCluster#=Cdbl(OutregsX.AX)
Endif
If OutregsX.BX<0 Then
   FreeClusters#=Cdbl(OutregsX.BX+65536)
Else
   FreeClusters#=Cdbl(OutregsX.BX)
Endif
If OutregsX.CX<0 Then
   BytesPerSector#=Cdbl(OutregsX.CX+65536)
Else
   BytesPerSector#=Cdbl(OutregsX.CX)
Endif
If OutregsX.DX<0 Then
   TotalClusters#=Cdbl(OutregsX.DX+65536)
Else
   TotalClusters#=Cdbl(OutregsX.DX)
Endif
DiskSpace# = BytesPerSector# * SectorsPerCluster# * FreeClusters#
IF DiskSpace# = 2147155968# THEN
   PRINT "Free disk space >"; DiskSpace#; "bytes."
ELSE
   PRINT "Free disk space"; DiskSpace#; "bytes."
END IF
TotalSpace# = BytesPerSector# * SectorsPerCluster# * TotalClusters#
IF TotalSpace# = 2147155968# THEN
   PRINT "Total disk space >"; TotalSpace#; "bytes."
ELSE
   PRINT "Total disk space"; TotalSpace#; "bytes."
END IF
END
