REM Copyright (c) 2002 Startech Industries Inc. pfm + ejo.
CLS
SCREEN 8
COLOR 5, 0
'   DIM starpoint(360)

dsec = 30   ' seconds to update: 30 sec = 1/8 of 1 degree arc of zodiac
' c = (5 / 12) * 8     ' screen scale correct factor SCREEN 8
c = 2.3
cflag = 0    ' clock mode flag:   clock = on, simulation = off
' pi = atn(1)*4
pi = 3.1416

5  ' begin, re-begin each TIMER = 00000 (midnight local time) or RESET mode
CLS
PRINT "zorastro chart northern hemisphere";

tlast = 0            ' reset check for change of day  clock mode
timlast = 0           ' simulation mode reset check
' check initialization error, minutes:

tmn! = TIMER / 240
dtm! = (tmn! / 8 - INT(tmn! / 8)) * .5   ' initialization error
lna = INT(tmn!)    ' local number ascension (local time, degrees zodiac)
LOCATE 3, 2
PRINT INT(dtm! * 100) / 100; "minutes log in error";

tm! = TIMER + dsec    ' set next iteration period, 1/8 degree per shift

'read and convert date string:
'dx$="12-01-2000" ' replace date$
'tx$="12:00:00" ' replace time$
'TIMER could be replaced by a function.
yr$ = RIGHT$(DATE$, 4)
fyr$ = LEFT$(DATE$, 5)
mos$ = LEFT$(fyr$, 2)
mos = VAL(mos$)
day$ = RIGHT$(fyr$, 2)
day = VAL(day$)

'calculate days elapsed this year:

GOSUB yearco

' add galaxy time to local time, 10 days scale shift to dec 21; convert to
' fraction of year, convert to zodiac degrees, minus ninety days for
' scale shift to pisces point at 0.00 degrees

tgtm = ((day + days + 10.444) / yr) * 360
gtm = INT(tgtm) - 90
IF gtm <= 0 THEN gtm = gtm + 360
LOCATE 25, 62
PRINT gtm;   ' local galaxy time, due south, ecliptic; celestial
LOCATE 25, 67
PRINT "solar";   ' actually gtm is solar time; use for galaxy position fix

' temporary local number ascension, truncated to one degree intervals, and
' shifted for reference at noon = 00000 for add to galaxy time:

tlna = gtm + lna - 180

' add 40 to center screen:     (note: gtm.** reset at 00000 clock time)

na = tlna + 40    ' na = number ascension; left justified on screen

IF na <= 0 THEN na = na + 360   ' cycle limit check; initialize year cycle
IF na > 360 THEN na = na - 360

ishift = na - 10 * INT(na / 10)    ' line up numbers to increments; offset.*

' output debug data:

' days:   sum of days of month/s, truncated at month now                                     ' (new idea: Tmoon)
' day:    days so far this month
' mos:    months so far this year

' na:     ascension number, na, adjusted for screen left
' tlna:   temporary local number ascension: local zodiac time
'         (truncated at one degree intervals)

' gtm:    local solar time, on ecliptic, due south; noon local time


10    '  draw zodiac line and scale increments, moving.** + shift
   GOSUB moonclock
   DO
      FOR shift = 0 TO 79 STEP 1
        starshift = shift - 8 * INT(shift / 8)
        FOR ra = 81 TO -19 STEP -1
         
         pix = 8 * ra + shift + ishift * 8 + 4
         LINE (1, 100)-(640, 100)
         IF ra / 10 - INT(ra / 10) <> 0 THEN
            LINE (pix - 1, 97)-(pix - 1, 105), 0
            LINE (pix, 97)-(pix, 103)
         ELSE
            LINE (pix - 1, 94)-(pix - 1, 105), 0
            LINE (pix, 94)-(pix, 105)
         END IF
     
      NEXT
                     
      LINE (324, 63)-(324, 79), 7
      LINE (324, 90)-(324, 109), 7
      LINE (324, 121)-(324, 137), 7
                     
                      ' note: local time re-calculated here; simplify ??
      nrta = na - 40
      IF nrta <= 0 THEN nrta = nrta + 360
      LOCATE 24, 62
      PRINT "   ";
      LOCATE 24, 62
      PRINT nrta;
      LOCATE 24, 67
      PRINT "local";
    

          
     IF na < 80 THEN GOTO 11
     IF na - 80 < gtm <= na THEN GOSUB sundata
     GOTO 13
11   IF gtm <= na OR gtm > na + 360 - 80 THEN
        GOSUB sundata
        GOTO 13
     END IF
     sntna = na + 360
     IF sntna - 80 < gtm <= sntna THEN GOSUB sundata
13   IF na < 80 THEN GOTO 14
     IF na - 80 < monna <= na THEN GOSUB moondata
     GOTO 17
14   IF monna <= na OR monna > na + 360 - 80 THEN
        GOSUB moondata
        GOTO 17
     END IF
     montna = na + 360
     IF montna - 80 < monna <= montna THEN GOSUB moondata
17   LOCATE 17, 73
     PRINT monna

     

'      LOCATE 3, 2          '  error control data   shift, delta pixel
'      PRINT shift;
'      LOCATE 3, 7                             '  shift = delta pixel
'      PRINT "delta pixels";

      IF shift / 8 - INT(shift / 8) <> 0 THEN GOTO 20
         FOR ra = 80 TO 0 STEP -10
            scr = ra - 10 + INT(shift / 8) + ishift
            IF na - ra <= 0 THEN
               tna = na + 360
           
              
            ELSE
               tna = na
            END IF
            IF scr > 1 AND scr < 76 THEN
               LOCATE 15, scr - 1
               PRINT "   ";
               LOCATE 15, scr
               intgr = 10 * INT((tna + (10 - ishift)) / 10) - ra
               IF intgr <= 0 THEN intgr = intgr + 360
               IF intgr > 360 THEN intgr = intgr - 360
               PRINT intgr;
               PRINT "    ";
            ELSE
  
               LOCATE 15, 1
               PRINT "    ";
               LOCATE 15, 76
               PRINT "   ";
        
         END IF
    
         NEXT
         GOSUB zodiac
         GOSUB starchart
         GOSUB sunclock
       
         GOTO 30
20
         GOSUB zodiac
         GOSUB starchart
         GOSUB sunclock
       
        IF shift / 8 - INT(shift / 8) = .875 THEN
           na = na + 1
           IF na = 361 THEN na = 1
        END IF
30
'        LOCATE 25, 3
'        PRINT "pfm enterprise";

        tperiod = (INT((TIMER - timlast) * 100)) / 100

        IF TIMER - timlast < 0 THEN GOTO 5
     
        timlast = TIMER
      
        IF cflag = -1 THEN
 
          GOSUB daytime
         
          LOCATE 25, 9
          PRINT "         ";
          LOCATE 25, 9
          PRINT tperiod;
         
          LOCATE 25, 2
          PRINT " cycle";
         
          GOTO 40

        END IF
        LOCATE 25, 2
        PRINT "update";

        DO UNTIL TIMER > tm!
           tmr! = TIMER - tm! + dsec
           ttlast = tlast
           tlast = TIMER
           IF TIMER - ttlast < 0 THEN GOTO 5
'           tlast = TIMER
   
           GOSUB daytime

           LOCATE 25, 9
           PRINT "    ";
           PRINT INT(dsec - tmr!);
   GOSUB modekeys
'           mode$ = INKEY$
'           IF LEN(mode$) THEN
'              SELECT CASE LEN(mode$)
'                 CASE 1
'                    ykey = ASC(mode$)
'                    SELECT CASE ykey
'                    CASE 27 ' escape
'                       END
'                    CASE 67, 99  ' C or c
'                       dsec = 30
'                       cflag = 0
'                  
'                       GOTO 5
'                    CASE 83, 115 ' S or s
'                       dsec = .3
'                       sflag = 1
'                       cflag = -1
'                       GOTO 5
'                    END SELECT
'                 CASE 2
'                END SELECT
'              END IF
       
        LOOP
        tm! = tm! + dsec
        GOTO 45
40  GOSUB modekeys                '  note:  IN KEY $  input repeated here
45
  NEXT

  LOOP
       ' end of main program loop

END     ' this program loops and never ends until ESCAPE or POWER SHUTOFF
        ' or until date accumulation buffers overload number limit

'    subroutines, astrmtr* = astrometer 9  version pfm.2001 ::

daytime:        ' local celestial time   hrs : min : sec
                                      
IF cflag = -1 THEN      ' if clock mode is off, use simulation mode
   IF sflag = 1 THEN       'if clock mode is on, use clock mode
      sflag = 0
      n0 = na
      min0 = min
      hr0 = hrs
    END IF
      nc = na - n0
      IF nc <= 0 THEN nc = nc + 360
     tmin = INT(nc * 8 * .5)
'     if min >= 60 then min = min - 60
     thrs = tmin / 60
'     if hrs >= 24 then hrs = hrs - 24
     min = tmin - 60 * INT(tmin / 60) + min0
     
'      min = delmins + min0
      IF min >= 60 THEN min = min - 60


      hrs = INT(thrs - 24 * INT(thrs / 24) + hr0 + min0 / 60)
'      hrs = delhrs + hr0
      IF hrs >= 24 THEN hrs = hrs - 24

'      min = mins - 60 * INT(mins / 60)
'      IF mins >= 60 THEN
'         min = min - 60
'         hrs = INT(min / 60) + hr0
'         IF hrs > 24 THEN hrs = hrs - 24
'      END IF
      GOTO 123
END IF

tmc! = TIMER

mn! = tmc! / 60
hr! = mn! / 60

hrs = INT(hr!)
min = INT(mn! - 60 * INT(hr!))
sec = INT(tmc! - 60 * INT(mn!))
                  
123
LOCATE 2, 67
   PRINT hrs;
LOCATE 2, 71
   PRINT "hrs";

LOCATE 3, 67
   PRINT min;
LOCATE 3, 71
   PRINT "min";

IF cflag = -1 THEN
   LOCATE 4, 67
      PRINT "simulation"
   RETURN
END IF

LOCATE 4, 67
   PRINT sec;
LOCATE 4, 71
   PRINT "sec";

RETURN

sundata:

    IF gtm >= 280 AND na < 80 THEN
       sna = na + 360   ' - gtm
    ELSE
        sna = na
    END IF
'    IF gtm < 80 AND na >= 280 THEN
'        sna = na - 360  ' - gtm
'    ELSE
'        sna = na
'    END IF
 
   sdta = 8 * (sna - gtm) + starshift + 4

   CIRCLE (sdta - 1, 100), 13, 0
   CIRCLE (sdta, 100), 13, 15
RETURN

moondata:

    IF monna >= 280 AND na < 80 THEN
        mna = na + 360   ' - monna
    ELSE
        mna = na
    END IF
'    IF monna < 80 AND na >= 280 THEN
'        mna = na - 360   ' - monna
'    ELSE
'        mna = na
'    END IF


   mdta = 8 * (mna - monna) + starshift + 4
   mony = 100 + 5.4 * c * SIN((monna + 269.2) * pi / 180)
   CIRCLE (mdta - 1, mony), 11, 0
   CIRCLE (mdta, mony), 11, 7

   RETURN


sunsim:      ' calculates sun position in simulation mode

RETURN

moonsim:      ' calculates moon position in simulation mode

RETURN

sunclock:      ' english language da-ta output:  day, month, year

GOSUB daytime
data$ = DATE$

month$ = LEFT$(data$, 2)
tday$ = LEFT$(data$, 5)
nday$ = RIGHT$(tday$, 2)
year$ = RIGHT$(data$, 4)
LOCATE 25, 34
PRINT nday$;

LOCATE 25, 37

month = VAL(month$)
SELECT CASE month
   CASE 1
   PRINT "JAN";
   CASE 2
   PRINT "FEB";
   CASE 3
   PRINT "MAR";
   CASE 4
   PRINT "APR";
   CASE 5
   PRINT "MAY";
   CASE 6
   PRINT "JUN";
   CASE 7
   PRINT "JUL";
   CASE 8
   PRINT "AUG";
   CASE 9
   PRINT "SEP";
   CASE 10
   PRINT "OCT";
   CASE 11
   PRINT "NOV";
   CASE 12
   PRINT "DEC";

   END SELECT

LOCATE 25, 41
PRINT year$;
     
RETURN

moonclock:

mn$ = DATE$
mnx$ = LEFT$(mn$, 5)
mnth = VAL(LEFT$(msx$, 2))
mndy = VAL(RIGHT$(msx$, 2))
mnyr = VAL(RIGHT$(mn$, 4))

GOSUB yearco

myrs = mnyr - 2001
mdys = days

sgmphi = gtm - 269.2
IF sgmphi < 0 THEN sgmphi = sgmphi + 360

mon = sgmphi / 29.538
monna = (mon - INT(mon)) * 360


'mnpxRA = 0
'mnpxDC = 0

'  moonclock is still compiling   20 dec 2001    pfm

RETURN


zodiac:

FOR zna = 86 TO -14 STEP -1
   eqx = 8 * (zna) + ishift + 4
   eqn = na - zna
   eql = eqn - 1
   IF eqn < 1 THEN eqn = eqn + 360
   IF eql < 1 THEN eql = eql + 360


   eqtrn = 100 - (23.5 * c * SIN(pi * eqn / 180 + pi))
   eqtrm = 100 - (23.5 * c * SIN(pi * eql / 180 + pi))
 
   PSET (eqx - 8, eqtrm), 0
   PSET (eqx, eqtrn), 9
   'CIRCLE (eqx - 8, eqtrm), 0, 0
   'CIRCLE (eqx, eqtrn), 0, 9
NEXT
RETURN

stardata:
'   star moon sun and planet data, equations
'   degfile = na * 8 + 40
'   FOR file = degfile TO degfile + 80
'    gosub    stardata not complete     2nd order solutions

RETURN
starchart:

    fldna = 10 * INT(na / 10)
    
    FOR sc = 80 TO 0 STEP -10
      scrn10 = fldna - sc

      IF scrn10 < 0 THEN
         scrn10 = scrn10 + 360
         stna = na + 360
      
      ELSEIF scrn10 = 0 THEN
         scrn10 = scrn10 + 360
         stna = na
      ELSE
         stna = na
      END IF
'      c = (5 / 12) * 8   ' (3.3333 ... ) or (4*200/640 * 8)
'      c = 5 / 3            ' screen field error correct 200 * 640 v.g.a.
      zn = 100

    SELECT CASE scrn10

    CASE 10

    CASE 20
    ' aries-1:
      tdta = 8 * (stna - 29) + starshift + 4
      d = 9
      h = zn - (d * c)
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
   
    ' aries point, old old equinox, vicinity  00 a.d.c.
      tdta = 8 * (stna - 29) + starshift + 4 - 5
      LINE (tdta - 1, 92)-(tdta - 1, 111), 0
      LINE (tdta, 92)-(tdta, 111), 4
  
    CASE 30
    ' aries-2:
      tdta = 8 * (stna - 33) + starshift + 4
      d = 11
      h = zn - (d * c)
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15


    CASE 40
    ' aries-3:
      tdta = 8 * (stna - 44) + starshift + 4
      d = 10
      h = zn - (d * c)
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
    
    CASE 50

    CASE 60

    CASE 70
    ' rigel:
      d = -32
      h = zn - (d * c)
      tdta = 8 * (stna - 79) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 9
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 14
    ' capella:
      d = 23
      h = zn - (d * c)
      tdta = 8 * (stna - 79) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 13
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 9
   
    ' aldebaran:
      d = -6
      h = zn - (d * c)
      tdta = 8 * (stna - 70) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 9
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 15
   
   
    CASE 80
    ' orion's belt stars, 3:
      d = -24
      h = zn - (d * c)
      tdta = 8 * (stna - 83) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
     
      d = -25
      h = zn - (d * c)
      tdta = 8 * (stna - 84) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
     
      d = -26
      h = zn - (d * c)
      tdta = 8 * (stna - 85) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
   
    ' betelgeux:   (latin sp??; german: betelgeus, english: betelgeuse)
      d = -20
      h = zn - (d * c)
      tdta = 8 * (stna - 89) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 14
      CIRCLE (tdta - 1, h), 3, 0
      CIRCLE (tdta, h), 3, 12
  

    CASE 90
    ' winter solstice:
      tdta = 8 * (stna - 90) + starshift + 4
      LINE (tdta - 1, 84)-(tdta - 1, 110), 0
      LINE (tdta, 84)-(tdta, 110), 13

    CASE 100
    ' sirius:
      d = -39
      h = zn - (d * c)
      tdta = 8 * (stna - 102) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 7
      CIRCLE (tdta - 1, h), 3, 0
      CIRCLE (tdta, h), 3, 14
   
    CASE 110
    ' procyon:
      d = -18
      h = zn - (d * c)
      tdta = 8 * (stna - 116) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 1

    ' castor:
      d = 8
      h = zn - (d * c)
      tdta = 8 * (stna - 114) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
   
    ' pollux:
      d = 5
      h = zn - (d * c)
      tdta = 8 * (stna - 117) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15


    CASE 120

    CASE 130

    CASE 140
    ' hydra-*:
      d = -22
      h = zn - (d * c)
      tdta = 8 * (stna - 143) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
  
    CASE 150
    ' regulus:
      d = 1
      h = zn - (d * c)
      tdta = 8 * (stna - 152) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 1
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 15

    ' leo-2:
      d = 10
      h = zn - (d * c)
      tdta = 8 * (stna - 155) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7

    CASE 160
    ' leo-3:
      d = 16
      h = zn - (d * c)
      tdta = 8 * (stna - 169) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
    
    CASE 170
    ' leo-4:
      d = 14
      h = zn - (d * c)
      tdta = 8 * (stna - 178) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
    
    CASE 180
    ' virgo point:
      tdta = 8 * (stna - 180) + starshift + 4
      LINE (tdta - 1, 87)-(tdta - 1, 96), 0
      LINE (tdta, 87)-(tdta, 96), 13
      LINE (tdta - 1, 98)-(tdta - 1, 102), 0
      LINE (tdta, 98)-(tdta, 102), 13
      LINE (tdta - 1, 104)-(tdta - 1, 110), 0
      LINE (tdta, 104)-(tdta, 110), 13
   
    CASE 190

    CASE 200
    ' spica:
      d = -2
      h = zn - (d * c)
      tdta = 8 * (stna - 202) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 1

    ' beta centauri:
      d = -28
      h = zn - (d * c)
      tdta = 8 * (stna - 207) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 9
   
   
   
    CASE 210
    ' arcturus:
      d = 33
      h = zn - (d * c)
      tdta = 8 * (stna - 214) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 12

    ' alpha centauri:
      d = -20
      h = zn - (d * c)
      tdta = 8 * (stna - 212) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 1
      
   
    CASE 220

    CASE 230

    CASE 240
    ' antares:
      d = -3
      h = zn - (d * c)
      tdta = 8 * (stna - 247) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 14
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 12

    CASE 250
'     LOCATE 23, 3
'     PRINT "IBM";

    CASE 260
    

    CASE 270
    ' winter solstice:
      tdta = 8 * (stna - 270) + starshift + 4
      LINE (tdta - 1, 84)-(tdta - 1, 110), 0
      LINE (tdta, 84)-(tdta, 110), 13
   
    ' january point  (old solstice ja nu ar y :  yes new arc eve  c.1800)
    
      tdta = 8 * (stna - 279) + starshift + 4     ' 270 + 2.9 degree r.a.
     
      LINE (tdta - 1, 77)-(tdta - 1, 88), 0
      LINE (tdta, 77)-(tdta, 88), 1

'      LINE (tdta - 1, 96)-(tdta - 1, 104), 0
'      LINE (tdta, 96)-(tdta, 104), 1
     
      LINE (tdta - 1, 112)-(tdta - 1, 123), 0
      LINE (tdta, 112)-(tdta, 123), 1

    CASE 280
    ' vega:
      d = 61
      h = zn - (d * c)
      tdta = 8 * (stna - 280) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 15
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 14

   
    CASE 290
    ' altair:
      d = 29
      h = zn - (d * c)
      tdta = 8 * (stna - 298) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 1
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 15

   
    CASE 300

    CASE 310
    ' deneb:
      d = 65
      h = zn - (d * c)
      tdta = 8 * (stna - 311) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 1
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 7

   
    CASE 320

    CASE 330

    CASE 340
    ' fomalhaut:
      d = -23
      h = zn - (d * c)
      tdta = 8 * (stna - 344) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 13
      CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 2, 7

    ' pisces-1:
      d = 7
      h = zn - (d * c)
      tdta = 8 * (stna - 350) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
    
    CASE 350
    ' pisces-2:
      d = 8
      h = zn - (d * c)
      tdta = 8 * (stna - 356) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
      CIRCLE (tdta, h), 1, 7
     
   
   
    CASE 360
    ' pisces point:
      tdta = 8 * (stna - 0) + starshift + 4
      LINE (tdta - 1, 70)-(tdta - 1, 78), 0
      LINE (tdta, 70)-(tdta, 78), 13
      LINE (tdta - 1, 88)-(tdta - 1, 110), 0
      LINE (tdta, 88)-(tdta, 110), 13
      LINE (tdta - 1, 120)-(tdta - 1, 133), 0
      LINE (tdta, 120)-(tdta, 133), 13
   
    ' pisces-3:
      d = 8
      h = zn - (d * c)
      tdta = 8 * (stna - 0) + starshift + 4
      CIRCLE (tdta - 1, h), 1, 0
    '  CIRCLE (tdta - 1, h), 2, 0
      CIRCLE (tdta, h), 1, 7
    '  CIRCLE (tdta, h), 2, 7
   
    END SELECT

  NEXT
RETURN

yearco:
yrs = VAL(yr$)
'     IF moonflag = -1 THEN
'
'        moonflag = 0
'        GOTO 105
'     END IF
IF yrs / 4 - INT(yrs / 4) = .5 THEN
   yr = 366
   GOTO 110
   ELSE
   yr = 365
END IF
SELECT CASE (mos)
  CASE 1
    days = 0
  CASE 2
    days = 31
  CASE 3
    days = 59
  CASE 4
    days = 90
  CASE 5
    days = 120
  CASE 6
    days = 151
  CASE 7
    days = 181
  CASE 8
    days = 212
  CASE 9
    days = 243
  CASE 10
    days = 272
  CASE 11
    days = 304
  CASE 12
    days = 334
END SELECT
RETURN
110
SELECT CASE (mos)
  CASE 1
    days = 0
  CASE 2
    days = 31
  CASE 3
    days = 60
  CASE 4
    days = 91
  CASE 5
    days = 121
  CASE 6
    days = 152
  CASE 7
    days = 182
  CASE 8
    days = 213
  CASE 9
    days = 244
  CASE 10
    days = 274
  CASE 11
    days = 305
  CASE 12
    days = 335
END SELECT

RETURN

map:     ' map control subroutine/s:    subspace not operational

RETURN

modekeys:
   mode$ = INKEY$
   IF LEN(mode$) THEN
      SELECT CASE LEN(mode$)
      CASE 1
         xkey = ASC(mode$)
         SELECT CASE xkey
         CASE 27 ' escape
            END
         CASE 84, 116 ' T or t
'            LOCATE 4, 22
'            PRINT "time input mode"
'            LOCATE 5, 23
'            PRINT "not ready yet"
            GOTO 5
         CASE 73, 105 ' I or i
            GOSUB stardata         ' star input mode: not ready yet
         CASE 77, 109 ' M or m
            GOSUB map            ' map mode not ready
         CASE 67, 99  ' C or c
            dsec = 30
            cflag = 0
           
            GOTO 5
         CASE 83, 115 ' S or s
            dsec = .3
            sflag = 1
            cflag = -1
            GOTO 5
       
         END SELECT
      CASE 2
         xkey = ASC(RIGHT$(mode$, 1))
         SELECT CASE xkey
       
         CASE 72 '  up
       
         CASE 80 '  down
        
         CASE 75 '  left

         CASE 77 '  right
      
         END SELECT
      END SELECT
   END IF

RETURN

