        PAGE    ,132

CSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME  CS:CSEG,DS:CSEG

SetDT    PROC
        JMP   StartOfCode

A_DeviceParameters:
SpecialFunctions:    db               04h      ;  this is the new default BPB
                                               ; all sectors are the same size
DeviceType:          db               00h      ; 320/360kb 5.25" floppy
DeviceAttributes:    dw               00h      ; no change line support
                                               ; media is removeable
NumberOfCylinders:   dw               80
MediaType:           db               02h      ; media type is dd ds 5.25"
DeviceBpB:

BytesPerSector      dw               512
SectorsPerCluster   db               2
ReservedSectors     dw               1
NumberOfFats        db               2
RootEntries         dw               112
TotalSectors        dw               80*9*2
MediaDescriptor     db               0FDH
SectorsPerFat       dw               3
SectorsPerTrack     dw               9
Heads               dw               2
HiddenSectors       dd               0
Reserved_1          dd               ?
Reserved_2          db               6 dup(0)

TrackLayout:
SectorCount:        dw               9h
SectorNumber:       dw               1h
SectorSize:         dw               200h
etc:                dw               6h
                    dw               200h
                    dw               2h
                    dw               200h
                    dw               7h
                    dw               200h
                    dw               3h
                    dw               200h
                    dw               8h
                    dw               200h
                    dw               4h
                    dw               200h
                    dw               9h
                    dw               200h
                    dw               5h
                    dw               200h


StartOfCode:
                    MOV              AH,44H         ; IOCTL
                    MOV              AL,0DH         ; Subfunction Generic request
                    MOV              BL,2           ; For drive B
                    MOV              CH,08H         ; Major code (Category)
                    MOV              CL,40H         ; Set Device Parameters
                    PUSH             CS             ; DS has to point to Code Segment
                    POP              DS
                    MOV              DX,Offset A_DeviceParameters
                    INT              21H
                    mov              ah,4ch         ; Terminate nicely
                    int              21h


SetDT               ENDP

CSEG                ENDS
                    END

