/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/pattern.c,v 2.35 1992/03/31 07:55:03 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "choice.e"
#include "color.e"
#include "cmd.e"
#include "dialog.e"
#include "drawing.e"
#include "file.e"
#include "font.e"
#include "mainmenu.e"
#include "mark.e"
#include "menu.e"
#include "obj.e"
#include "poly.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "spline.e"
#include "text.e"

int     objFill = NONEPAT;
int     lineStyle = LS_RIGHT;
int     lineWidth = 0;
int     penPat = SOLIDPAT;
int     curSpline = LT_STRAIGHT;
int     curDash = 0;
int     rcbRadius = DEF_RCB_RADIUS;
int     useGray = FALSE;
char    patternStr[] = "8 1 0 72 300 32 div div tgifsetpattern";

static int	tileAsGrayDetected=FALSE;
static int	canFakeGray=FALSE;
static char	*grayStr[9] =
{
   "0.995", "0.94", "0.868", "0.779", "0.763", "0.55", "0.41", "0.253", "0.079"
};

void ResetGrayDetection ()
{
   tileAsGrayDetected = FALSE;
   canFakeGray = FALSE;
}

char * GrayStr (index)
   int	index;
   /* this routine should only be called when useGray == TRUE */
{
   char	cmd[MAXSTRING];

   if (index <= 2)
   {
      fprintf (stderr, "Error:  GrayStr() called with index<=2.\n");
      return ("");
   }
   else if (index >= 12)
   {
      if (!tileAsGrayDetected)
      {
         tileAsGrayDetected = TRUE;
         if (PRTGIF)
            fprintf (stderr, "%s.\n",
                  "Warning:  Gray scales used instead of tiling patterns.");
         else
            Dialog ("Warning:  Gray scales used instead of tiling patterns.",
                  "( <CR> or <ESC> to continue )", cmd);
      }
      switch (index)
      {
         case 12: index = 5; break;
         case 13: index = 4; break;
         case 14: index = 7; break;
         case 15: index = 6; break;
         case 16: index = 7; break;
         case 17: index = 6; break;
         case 18: index = 6; break;
         case 19: index = 6; break;
         case 20: index = 5; break;
         case 21: index = 6; break;
         case 22: index = 8; break;
         case 23: index = 7; break;
         case 24: index = 9; break;
         case 25: index = 8; break;
         case 26: index = 5; break;
         case 27: index = 6; break;
         case 28: index = 8; break;
         case 29: index = 7; break;
         case 30: index = 9; break;
         case 31: index = 8; break;
      }
   }
   return (grayStr[index-3]);
}

void GrayCheck (index)
   int	index;
   /* this routine should only be called when useGray == FALSE */
{
   if (index > BACKPAT)
   {
      if (index >= 12)
         tileAsGrayDetected = TRUE;
      else
         canFakeGray = TRUE;
   }
}

void EndGrayDetection ()
   /* this routine should only be called when useGray == FALSE */
{
   int	num_msgs = 1;
   char	msg1[MAXSTRING], msg2[MAXSTRING];

   if (colorDump) return;

   if (useGray)
   {
      if (!tileAsGrayDetected && !canFakeGray) return;

      strcpy (msg1, "Gray scale used in printing tiling patterns.");
   }
   else if (tileAsGrayDetected)
      strcpy (msg1, "Note: slow printing due to the use of patterns.");
   else if (canFakeGray)
   {
      num_msgs = 2;
      strcpy (msg1, "Note: slow printing due to the use of patterns.");
      strcpy (msg2, "      May try UseGrayScale() to speed things up.");
   }
   else
      return;

   if (PRTGIF)
   {
      fprintf (stderr, "%s.\n", msg1);
      if (num_msgs==2) fprintf (stderr, "%s.\n", msg2);
   }
   else
   {
      if (num_msgs==1)
         Msg (msg1);
      else
         TwoLineMsg (msg1, msg2);
   }
}

void ModeMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXCHOICES, &fore_colors, &valid, &init_rv);
   free (valid);
   init_rv[curChoice] = TRUE;
   activeMenu = MENU_MODE;
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, MAXCHOICES, 1,
         MAXCHOICES, fore_colors, choicePixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) SetCurChoice (index);
}

static
int ChangeObjFill (ObjPtr, FillIndex)
   struct ObjRec	* ObjPtr;
   int			FillIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_TEXT:
         if (ObjPtr->detail.t->fill != FillIndex)
         {
            ObjPtr->detail.t->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_BOX:
         if (ObjPtr->detail.b->fill != FillIndex)
         {
            ObjPtr->detail.b->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_OVAL:
         if (ObjPtr->detail.o->fill != FillIndex)
         {
            ObjPtr->detail.o->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_POLY:
         if (ObjPtr->detail.p->fill != FillIndex)
         {
            ObjPtr->detail.p->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->fill != FillIndex)
         {
            ObjPtr->detail.g->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_ARC:
         if (ObjPtr->detail.a->fill != FillIndex)
         {
            if (ObjPtr->detail.a->fill == NONEPAT || FillIndex == NONEPAT)
            {
               ObjPtr->detail.a->fill = FillIndex;
               UpdArcBBox (ObjPtr);
            }
            else
               ObjPtr->detail.a->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_RCBOX:
         if (ObjPtr->detail.rcb->fill != FillIndex)
         {
            ObjPtr->detail.rcb->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_XBM:
         if (ObjPtr->detail.xbm->fill != FillIndex)
         {
            ObjPtr->detail.xbm->fill = FillIndex;
            changed = TRUE;
         }
         break;
      case OBJ_XPM:
         if (ObjPtr->detail.xpm->fill != FillIndex)
         {
            ObjPtr->detail.xpm->fill = FillIndex;
            changed = TRUE;
         }
         break;

      case OBJ_SYM:
      case OBJ_GROUP:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjFill (obj_ptr, FillIndex))
               changed = TRUE;
         break;
   }
   return (changed);
}

void ChangeAllSelFill (FillIndex)
   int	FillIndex;
{
   register struct SelRec	* sel_ptr;
   int				changed=FALSE, ltx, lty, rbx, rby;

   if (topSel == NULL)
   {
      objFill = FillIndex;
      ShowFill ();
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjFill (sel_ptr->obj, FillIndex))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
      RedrawAreas (botObj, ltx-GRID_ABS_SIZE(1), lty-GRID_ABS_SIZE(1),
            rbx+GRID_ABS_SIZE(1), rby+GRID_ABS_SIZE(1), selLtX-GRID_ABS_SIZE(1),
            selLtY-GRID_ABS_SIZE(1), selRbX+GRID_ABS_SIZE(1),
            selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

void FillMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXPATTERNS, &fore_colors, &valid, &init_rv);
   free (valid);
   activeMenu = MENU_FILL;
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, 8, 4, MAXPATTERNS,
         fore_colors, patPixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelFill (index);
}

static
int ChangeObjLineStyle (ObjPtr, StyleIndex)
   struct ObjRec	* ObjPtr;
   int			StyleIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->style != StyleIndex)
         {
            ObjPtr->detail.p->style = StyleIndex;
            changed = TRUE;
            AdjObjSplineVs (ObjPtr);
         }
         break;
      case OBJ_ARC:
         if (ObjPtr->detail.a->style != StyleIndex)
         {
            ObjPtr->detail.a->style = StyleIndex;
            changed = TRUE;
         }
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjLineStyle (obj_ptr, StyleIndex))
               changed = TRUE;
         break;
   }
   if (changed) AdjObjBBox (ObjPtr);
   return (changed);
}

void ChangeAllSelLineStyle (StyleIndex)
   int	StyleIndex;
{
   register struct SelRec	* sel_ptr;
   int				ltx, lty, rbx, rby, changed=FALSE;

   if (topSel == NULL)
   {
      lineStyle = StyleIndex;
      ShowLineStyle ();
      UpdateSubMenu (MENU_LINESTYLE);
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjLineStyle (sel_ptr->obj, StyleIndex))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
      RedrawAreas (botObj, ltx-GRID_ABS_SIZE(1), lty-GRID_ABS_SIZE(1),
            rbx+GRID_ABS_SIZE(1), rby+GRID_ABS_SIZE(1), selLtX-GRID_ABS_SIZE(1),
            selLtY-GRID_ABS_SIZE(1), selRbX+GRID_ABS_SIZE(1),
            selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

static
int ChangeObjLineType (ObjPtr, TypeIndex)
   struct ObjRec	* ObjPtr;
   int			TypeIndex;
{
   register struct ObjRec       * obj_ptr;
   register int			changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->curved != TypeIndex)
         {
            ObjPtr->detail.p->curved = TypeIndex;
            changed = TRUE;
            AdjObjSplineVs (ObjPtr);
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->curved != TypeIndex)
         {
            ObjPtr->detail.g->curved = TypeIndex;
            changed = TRUE;
            AdjObjSplineVs (ObjPtr);
         }
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjLineType (obj_ptr, TypeIndex))
               changed = TRUE;
         break;
   }
   if (changed) AdjObjBBox (ObjPtr);
   return (changed);
}

void ChangeAllSelLineType (TypeIndex)
   int	TypeIndex;
{
   register struct SelRec	* sel_ptr;
   int				ltx, lty, rbx, rby, changed=FALSE;

   if (topSel == NULL)
   {
      curSpline = TypeIndex;
      ShowLineType ();
      UpdateSubMenu (MENU_LINETYPE);
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjLineType (sel_ptr->obj, TypeIndex))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
      RedrawAreas (botObj, ltx-GRID_ABS_SIZE(1), lty-GRID_ABS_SIZE(1),
            rbx+GRID_ABS_SIZE(1), rby+GRID_ABS_SIZE(1), selLtX-GRID_ABS_SIZE(1),
            selLtY-GRID_ABS_SIZE(1), selRbX+GRID_ABS_SIZE(1),
            selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

static
int ChangeObjLineWidth (ObjPtr, W, AW, AH)
   struct ObjRec	* ObjPtr;
   int			W, AW, AH;
{
   register struct ObjRec	* obj_ptr;
   register int			changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->width != W || ObjPtr->detail.p->aw != AW ||
               ObjPtr->detail.p->ah != AH)
         {
            ObjPtr->detail.p->width = W;
            ObjPtr->detail.p->aw = AW;
            ObjPtr->detail.p->ah = AH;
            changed = TRUE;
            AdjObjSplineVs (ObjPtr);
         }
         break;
      case OBJ_BOX:
         if (ObjPtr->detail.b->width != W)
         {
            ObjPtr->detail.b->width = W;
            changed = TRUE;
         }
         break;
      case OBJ_OVAL:
         if (ObjPtr->detail.o->width != W)
         {
            ObjPtr->detail.o->width = W;
            changed = TRUE;
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->width != W)
         {
            ObjPtr->detail.g->width = W;
            changed = TRUE;
         }
         break;
      case OBJ_ARC:
         if (ObjPtr->detail.a->width != W || ObjPtr->detail.a->aw != AW ||
               ObjPtr->detail.a->ah != AH)
         {
            ObjPtr->detail.a->width = W;
            ObjPtr->detail.a->aw = AW;
            ObjPtr->detail.a->ah = AH;
            changed = TRUE;
         }
         break;
      case OBJ_RCBOX:
         if (ObjPtr->detail.rcb->width != W)
         {
            ObjPtr->detail.rcb->width = W;
            changed = TRUE;
         }
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjLineWidth (obj_ptr, W, AW, AH))
               changed = TRUE;
         break;
   }
   if (changed) AdjObjBBox (ObjPtr);
   return (changed);
}

void ChangeAllSelLineWidth (WidthIndex)
   int	WidthIndex;
{
   register struct SelRec	* sel_ptr;
   int				ltx, lty, rbx, rby, changed=FALSE;
   int				w, aw, ah;

   if (topSel == NULL)
   {
      lineWidth = WidthIndex;
      ShowLineWidth ();
      UpdateSubMenu (MENU_LINEWIDTH);
      return;
   }

   w = curWidthOfLine[WidthIndex];
   aw = curArrowHeadW[WidthIndex];
   ah = curArrowHeadH[WidthIndex];

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjLineWidth (sel_ptr->obj, w, aw, ah))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
      RedrawAreas (botObj, ltx-GRID_ABS_SIZE(1), lty-GRID_ABS_SIZE(1),
            rbx+GRID_ABS_SIZE(1), rby+GRID_ABS_SIZE(1), selLtX-GRID_ABS_SIZE(1),
            selLtY-GRID_ABS_SIZE(1), selRbX+GRID_ABS_SIZE(1),
            selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

static
int ChangeObjDashes (ObjPtr, DashIndex)
   struct ObjRec	* ObjPtr;
   int			DashIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->dash != DashIndex)
         {
            ObjPtr->detail.p->dash = DashIndex;
            changed = TRUE;
         }
         break;
      case OBJ_BOX:
         if (ObjPtr->detail.b->dash != DashIndex)
         {
            ObjPtr->detail.b->dash = DashIndex;
            changed = TRUE;
         }
         break;
      case OBJ_OVAL:
         if (ObjPtr->detail.o->dash != DashIndex)
         {
            ObjPtr->detail.o->dash = DashIndex;
            changed = TRUE;
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->dash != DashIndex)
         {
            ObjPtr->detail.g->dash = DashIndex;
            changed = TRUE;
         }
         break;
      case OBJ_ARC:
         if (ObjPtr->detail.a->dash != DashIndex)
         {
            ObjPtr->detail.a->dash = DashIndex;
            changed = TRUE;
         }
         break;
      case OBJ_RCBOX:
         if (ObjPtr->detail.rcb->dash != DashIndex)
         {
            ObjPtr->detail.rcb->dash = DashIndex;
            changed = TRUE;
         }
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjDashes (obj_ptr, DashIndex))
               changed = TRUE;
         break;
   }
   return (changed);
}

void ChangeAllSelDashes (DashIndex)
   int	DashIndex;
{
   register struct SelRec	* sel_ptr;
   int				changed=FALSE;

   if (topSel == NULL)
   {
      curDash = DashIndex;
      ShowDash ();
      UpdateSubMenu (MENU_LINEDASH);
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjDashes (sel_ptr->obj, DashIndex))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      RedrawAnArea (botObj, selLtX-GRID_ABS_SIZE(1), selLtY-GRID_ABS_SIZE(1),
            selRbX+GRID_ABS_SIZE(1), selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

void LineWidthMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (maxLineWidths, &fore_colors, &valid, &init_rv);
   free (valid);
   init_rv[lineWidth] = TRUE;
   activeMenu = MENU_LINEWIDTH;
   index = PxMpMenuLoop (X, Y, menuImageW, menuImageH, maxLineWidths, 1,
         maxLineWidths, fore_colors, lineWidthPixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelLineWidth (index);
}

void LineStyleMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXLINESTYLES, &fore_colors, &valid, &init_rv);
   free (valid);
   init_rv[lineStyle] = TRUE;
   activeMenu = MENU_LINESTYLE;
   index = PxMpMenuLoop (X, Y, menuImageW, menuImageH, MAXLINESTYLES, 1,
         MAXLINESTYLES, fore_colors, lineStylePixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelLineStyle (index);
}

void LineTypeMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXLINETYPES, &fore_colors, &valid, &init_rv);
   free (valid);
   init_rv[curSpline] = TRUE;
   activeMenu = MENU_LINETYPE;
   index = PxMpMenuLoop (X, Y, menuImageW, menuImageH, MAXLINETYPES, 1,
         MAXLINETYPES, fore_colors, lineTypePixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelLineType (index);
}

void LineDashMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXDASHES, &fore_colors, &valid, &init_rv);
   free (valid);
   init_rv[curDash] = TRUE;
   activeMenu = MENU_LINEDASH;
   index = PxMpMenuLoop (X, Y, menuImageW, menuImageH, MAXDASHES, 1,
         MAXDASHES, fore_colors, dashPixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelDashes (index);
}

static
int ChangeObjPen (ObjPtr, PenIndex)
   struct ObjRec	* ObjPtr;
   int			PenIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->pen != PenIndex)
         {
            ObjPtr->detail.p->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_TEXT:
         if (ObjPtr->detail.t->pen != PenIndex)
         {
            ObjPtr->detail.t->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_BOX:
         if (ObjPtr->detail.b->pen != PenIndex)
         {
            ObjPtr->detail.b->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_OVAL:
         if (ObjPtr->detail.o->pen != PenIndex)
         {
            ObjPtr->detail.o->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->pen != PenIndex)
         {
            ObjPtr->detail.g->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_ARC:
         if (ObjPtr->detail.a->pen != PenIndex)
         {
            ObjPtr->detail.a->pen = PenIndex;
            changed = TRUE;
         }
         break;
      case OBJ_RCBOX:
         if (ObjPtr->detail.rcb->pen != PenIndex)
         {
            ObjPtr->detail.rcb->pen = PenIndex;
            changed = TRUE;
         }
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjPen (obj_ptr, PenIndex))
               changed = TRUE;
         break;
   }
   return (changed);
}

void ChangeAllSelPen (PenIndex)
   int	PenIndex;
{
   register struct SelRec	* sel_ptr;
   int				changed=FALSE;

   if (topSel == NULL)
   {
      penPat = PenIndex;
      ShowPen ();
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjPen (sel_ptr->obj, PenIndex))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      RedrawAnArea (botObj, selLtX-GRID_ABS_SIZE(1), selLtY-GRID_ABS_SIZE(1),
            selRbX+GRID_ABS_SIZE(1), selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

void PenMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid, * init_rv;

   DefaultColorArrays (MAXPATTERNS, &fore_colors, &valid, &init_rv);
   free (valid);
   activeMenu = MENU_PEN;
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, 8, 4, MAXPATTERNS,
         fore_colors, patPixmap, init_rv, SINGLECOLOR);

   if (index != INVALID) ChangeAllSelPen (index);
}

static
int ToggleObjLineType (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec       * obj_ptr;
   register int			changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         ObjPtr->detail.p->curved = !ObjPtr->detail.p->curved;
         changed = TRUE;
         AdjObjSplineVs (ObjPtr);
         break;
      case OBJ_POLYGON:
         ObjPtr->detail.g->curved = !ObjPtr->detail.g->curved;
         changed = TRUE;
         AdjObjSplineVs (ObjPtr);
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ToggleObjLineType (obj_ptr))
               changed = TRUE;
         break;
   }
   if (changed) AdjObjBBox (ObjPtr);
   return (changed);
}

void ToggleAllSelLineType ()
{
   register struct SelRec	* sel_ptr;
   register int			changed = FALSE;

   if (topSel == NULL)
   {
      curSpline = !curSpline;
      ShowLineType ();
      UpdateSubMenu (MENU_LINETYPE);
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ToggleObjLineType (sel_ptr->obj))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      RedrawAnArea (botObj, selLtX-GRID_ABS_SIZE(1), selLtY-GRID_ABS_SIZE(1),
            selRbX+GRID_ABS_SIZE(1), selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

static
int ChangeObjRCBRadius (ObjPtr, Radius)
   struct ObjRec	* ObjPtr;
   int			Radius;
{
   register struct ObjRec	* obj_ptr;
   int				changed=FALSE;

   switch (ObjPtr->type)
   {
      case OBJ_RCBOX:
         if (ObjPtr->detail.rcb->radius != Radius)
         {
            ObjPtr->detail.rcb->radius = Radius;
            changed = TRUE;
         }
         break;

      case OBJ_GROUP:
      case OBJ_SYM:
         for (obj_ptr = ObjPtr->detail.r->last; obj_ptr != NULL;
               obj_ptr = obj_ptr->prev)
            if (ChangeObjRCBRadius (obj_ptr, Radius))
               changed = TRUE;
         break;
   }
   return (changed);
}

void ChangeAllSelRCBRadius (Radius)
   int	Radius;
{
   register struct SelRec	* sel_ptr;
   int				changed=FALSE;

   if (topSel == NULL)
   {
      rcbRadius = Radius;
      ShowRCBRadius ();
      return;
   }

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      PrepareToReplaceAnObj (sel_ptr->obj);
      if (ChangeObjRCBRadius (sel_ptr->obj, Radius))
      {
         changed = TRUE;
         RecordReplaceAnObj (sel_ptr->obj);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      RedrawAnArea (botObj, selLtX-GRID_ABS_SIZE(1), selLtY-GRID_ABS_SIZE(1),
            selRbX+GRID_ABS_SIZE(1), selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}

static
int UpdateAnObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   int	w, aw, ah, changed=FALSE;

   w = curWidthOfLine[lineWidth];
   aw = curArrowHeadW[lineWidth];
   ah = curArrowHeadH[lineWidth];

   if (ChangeObjColor (ObjPtr, colorIndex)) changed = TRUE;

   if (ChangeObjFill (ObjPtr, objFill)) changed = TRUE;
   if (ChangeObjLineStyle (ObjPtr, lineStyle)) changed = TRUE;
   if (ChangeObjLineType (ObjPtr, curSpline)) changed = TRUE;
   if (ChangeObjLineWidth (ObjPtr, w, aw, ah)) changed = TRUE;
   if (ChangeObjDashes (ObjPtr, curDash)) changed = TRUE;
   if (ChangeObjPen (ObjPtr, penPat)) changed = TRUE;
   if (ChangeObjRCBRadius (ObjPtr, rcbRadius)) changed = TRUE;

   if (ChangeObjTextStyle (ObjPtr, curStyle)) changed = TRUE;
   if (ChangeObjTextJust (ObjPtr, textJust)) changed = TRUE;
   if (ChangeObjTextSize (ObjPtr, curSize)) changed = TRUE;
   if (ChangeObjTextFont (ObjPtr, curFont)) changed = TRUE;
   if (ChangeObjVSpace (ObjPtr, textVSpace)) changed = TRUE;

   return (changed);
}

void UpdateSelObjs ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, changed=FALSE;

   if (topSel == NULL) return;

   HighLightReverse ();
   StartCompositeCmd ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->type==OBJ_ICON || obj_ptr->type==OBJ_SYM ||
            obj_ptr->type==OBJ_GROUP)
         continue;

      PrepareToReplaceAnObj (obj_ptr);
      if (UpdateAnObj (obj_ptr))
      {
         changed = TRUE;
         RecordReplaceAnObj (obj_ptr);
      }
      else
         AbortPrepareCmd (CMD_REPLACE);
   }
   EndCompositeCmd ();

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
      RedrawAreas (botObj, ltx-GRID_ABS_SIZE(1), lty-GRID_ABS_SIZE(1),
            rbx+GRID_ABS_SIZE(1), rby+GRID_ABS_SIZE(1), selLtX-GRID_ABS_SIZE(1),
            selLtY-GRID_ABS_SIZE(1), selRbX+GRID_ABS_SIZE(1),
            selRbY+GRID_ABS_SIZE(1));
   }
   HighLightForward ();
}
