/*
 * SetIcon.c defines icon for X application
 *
 * usage: SetIcon(theDisplay, theWindow, state);
 *
 * do a global replace on "xci" and "xcm"
 * GBP Nov 15, 92
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xci.bit"
#include "xcm.bit"

SetIcon(dsp, wnd, state)
    Display	*dsp;
    Window	wnd;
    int		state;
{

    Pixmap 	 icon_bmp, icon_mask_bmp;
    XWMHints 	 xwmh;

/* create icon bitmap */    
    if ((icon_bmp=XCreateBitmapFromData(dsp,wnd,
                                        xci_bits,
                                        xci_width,
                                        xci_height))==None)
        printf("Error on icon creation\n");

/* create mask bitmap */
    if ((icon_mask_bmp=XCreateBitmapFromData(dsp,wnd,
                                        xcm_bits,
                                        xcm_width,
                                        xcm_height))==None)
        printf("Error on icon mask creation\n");

/* define the WM attributes */
    xwmh.flags = IconPixmapHint |
                 IconMaskHint |
                 StateHint;
    xwmh.icon_pixmap = icon_bmp;
    xwmh.icon_mask   = icon_mask_bmp;
    xwmh.initial_state = state;

/* set the Wm attribrutes */
    XSetWMHints(dsp,wnd,&xwmh);
} 
