.TH xv l "Feb 26, 1992" "Rev: 2.10"
.SH NAME
\fBxv\fP \- interactive image display for the X Window System
.SH SYNTAX
\fBxv\fP \fI[options] [filename [filename...]]\fP
.SH NOTE
This man page is merely the text portion of the (PostScript) \fIxv\fP docs, 
without
the figures, and without the appendicies.  As such, it is highly recommended
that you get your hands on the *real* documentation.
.SH DESCRIPTION
\fIxv\fP is an X11 program that displays images in the GIF, JPEG, TIFF,
PBM, PGM, PPM, 
X11 bitmap, Utah Raster Toolkit RLE, PDS/VICAR, Sun Rasterfile, 
and PM formats on 1-, 2-, 4-, 6-, 
8-, 16-, 24-, and 32-bit X displays.  \fIxv\fP will also read \fIcompress\fP-ed
versions of these files.

.SH SECTION 1:  OVERVIEW

\fIxv\fP version 2.10 lets you do a large number of things (many of
them actually useful), including, but not limited to, the following:
.TP 3
\(bu
display an image in a window on the screen
.TP
\(bu
display an image on the root window, in a variety of styles
.TP
\(bu
grab any rectangular portion of the screen and turn it into an image
.TP
\(bu
arbitrarily stretch or compress the image
.TP
\(bu
rotate the image in 90-degree steps
.TP
\(bu
flip the image around the horizontal or vertical axes
.TP
\(bu
crop a rectangular portion of the image
.TP
\(bu
magnify any portion of the image by any amount, up to the size of the screen
.TP
\(bu
determine pixel values and x,y coordinates in the image
.TP
\(bu
adjust image brightness and contrast with a gamma correction function
.TP
\(bu
apply different gamma functions to the Red, Green, and Blue color 
components, to correct for non-linear color response
.TP
\(bu
adjust global image saturation
.TP
\(bu
perform global hue remapping
.TP
\(bu
perform histogram equalization
.TP
\(bu
edit an image's colormap
.TP
\(bu
reduce the number of colors in an image
.TP
\(bu
dither in color and b&w
.TP
\(bu
smooth an image
.TP
\(bu
crop off solid borders automatically
.TP
\(bu
convert image formats
.TP
\(bu
generate Encapsulated PostScript
.LP
Unfortunately the \fIAutomatic Checkbook Balancing Module\fP still isn't 
completely debugged, and is not included in this distribution. 

.SH SECTION 2: STARTING XV 

Note: unless explicitly stated otherwise, the term \fIclick\fP means "click
with the \fILeft\fP mouse button."

Start the program up by typing 'xv'.  After a short delay, a window will
appear with the default image (the \fIxv\fP logo, credits and revision date)
displayed in it.  If you change the size of the window (using whatever method
your window manager provides), the image will be automatically stretched to
fit the window.

.SS Section 2.1:  Displaying Pixel Values

Clicking (and optionally dragging) the \fILeft\fP mouse button inside this 
window will display pixel information in the following format:
.IP
196, 137 = 191,121,209 (287 42 81 HSV)
.LP
The first pair of numbers (196,137) are the x and y positions of the cursor,
in image coordinates.  These numbers remain the same regardless of any image
resizing, or cropping.  For example, if you click on the eye of the fish on
the right side of the default image, you'll get (approximately) 251,129
regardless of the size of the displayed image.  This allows you to zoom in
for precise measurements.

The first triplet of numbers (191,121,209) are the RGB values of the selected
pixel.  The components will have integer values in the range 0-255.  The
values displayed are prior to any HSV/RGB modification, but after any
colormap changes.  See "Section 5: The Color Editor" for details.

The second triplet of numbers (287 42 81) are the HSV values of the selected
pixel.  The first component will have integer values in the range 0-359, and
the second and third components will have integer values in the range 0-100.
The values displayed are prior to any HSV/RGB modification, but after any
colormap changes.  See "Section 5: The Color Editor" for details.  Also, see
"Appendix D: RGB and HSV Colorspaces" for more information about what these
numbers mean.

Note: If you actually want to measure some pixels, it will probably help to
crop to a small region of your image, and expand that region to the point
where you can see the individual pixels.

This string is automatically copied to your X server's cut buffer whenever
you measure pixel values.  This lets you easily feed this information to
another program, useful if you're doing manual feature extraction, or
something.  Try it: measure a pixel's value, and then go click your 
\fIMiddle\fP mouse button in an \fIxterm\fP window.

.SS Section 2.2:  Cropping

Bring up the \fIxv controls\fP window by typing the '?' key or clicking the
\fIRight\fP mouse button inside the image window.

Clicking and dragging the \fIMiddle\fP button of the mouse inside the
image window will allow you to draw a cropping rectangle on the image.
If you're unhappy with the one you've drawn, simply click the
\fIMiddle\fP button and draw another.  If you'd like the rectangle to
go away altogether, click the \fIMiddle\fP button and release it
without moving the mouse.

You can determine how large the cropping rectangle is (in image
coordinates) by bringing up the \fIxv info\fP window.  Do this by
clicking the \fBInfo\fP button in the \fIxv controls window\fP or by
typing the 'i' key into any open \fIxv\fP window.

The \fIxv info window\fP will display, among other things, the current size and
position of the cropping rectangle in terms of image coordinates.  For
example, if it says:
.IP
114x77 rectangle starting at 119,58
.LP
that would mean that the current cropping rectangle is 114 image pixels wide,
77 image pixels high, and its top-left corner is located 119 image pixels in
from the left edge of the image, and 58 image pixels in from the top edge.
These values will be updated as you drag the cropping rectangle around.

If you want to set the size or position of the cropping rectangle
precisely, you can use the arrow keys on your keyboard.  First, make
the \fIxv info\fP window visible as described above (if it's not already
visible).  Second, use the mouse to draw a rough approximation of the
cropping rectangle that you want.  You can now use the arrow keys to
move the cropping rectangle around the image.  Once you've gotten the
top and left sides of the cropping rectangle precisely where you want
them, you can move the bottom-right corner of the cropping rectangle
(only) by holding the <shift> key down while using the arrow keys.
Pressing the up arrow will make the rectangle shorter, and pressing
the down arrow will make the rectangle taller.

Once you have a cropping rectangle that you can live with, you can
proceed with the actual cropping operation.  Click the \fBCrop\fP button in
the \fIxv controls\fP window, or type the 'c' key in any open \fIxv\fP window.
The image window will shrink to show only portions of the image that
were inside the cropping rectangle.

Note: if you are running a window manager such as \fImwm\fP,
which decorates windows with a title bar, resizing regions, and
such, it is quite possible that the aspect ratio of the cropped image
will get screwed up.  This is because certain window managers enforce a
minimum window size.  If you try to crop to a rectangle that is too
small, the window manager will create the smallest window it can, and
the image will be stretched to fit this window.  If this happens, you
can press the \fBAspect\fP button in the \fIxv controls\fP window, or type the
\'a' key in any open \fIxv\fP window.  This will expand the image so that it
has the correct aspect ratio again.

You can crop a cropped image by repeating the same steps (drawing a
new cropping rectangle and issuing the \fBCrop\fP command), ad infinitum.

You can return to the original, uncropped image by using the \fBUnCrop\fP
command.  Simply click the \fBUnCrop\fP button or type the 'u' key in any
open \fIxv\fP window.  Note that using the \fBUnCrop\fP command will
turn off image smoothing (the \fBSmooth\fP) command), due to the potentially 
long time it can take to generate a large, smoothed image.

Note that if you try to make the cropping rectangle too small in
either width or height (under 5 screen pixels), it'll just turn
itself off.  If you want to crop a very small portion of an image,
you'll probably have to do it in two passes.  First, crop to a small
(but large enough to still be enabled) rectangle, expand that region,
then crop again.

.SS Section 2.3:  Zooming

You can zoom in by a factor of two (or four, eight, etc.) on any 
rectangular region of the image by holding down the <ctrl> key on your keyboard
and clicking the \fILeft\fP mouse button in the image.  A rectangle will
flash, centered around the cursor position, and the region inside that
rectangle will be doubled in size.  The image window should remain the
same size, and in the same position.  You can repeat this operation to 
zoom in by a factor of four, or eight, or whatever, as many times as you
wish.  

You can zoom out by a factor of two (if possible) by holding down
the <ctrl> key on your keyboard and clicking the \fIRight\fP mouse
button inside the image window.  You can not zoom out beyond the point 
where the entire image fill the window.

.SH SECTION 3:	THE CONTROL WINDOW

The \fIxv controls\fP window is the central point of control for the
program, hence the name.  It provides controls to resize the current
image, flip and rotate it, load and save different files, and bring
up the other \fIxv\fP windows.  It can be brought up by clicking the 
\fIRight\fP mouse 
button in the image window, or by typing the '?' key inside any
open \fIxv\fP window.  Doing either of these things while the \fIxv controls\fP
window is visible will hide it.

All of the following commands may be executed by either clicking the
appropriate command button, or typing the keyboard equivalent (where
given) into any open \fIxv\fP window.

.SS Section 3.1:  Resizing Commands

Note that none of the 'resizing' commands modify the image in any
way.  They only affect how the image is displayed.  The image remains
at its original size.  This allows you to arbitrarily stretch and
compact the image without compounding error caused by earlier
resizing.  In each case, the displayed image is recomputed from the
original internal image.

.IP "\fBNormal\fP  (Keyboard equivalent 'n')"
Attempts to return the image to its normal size,
where one image pixel maps to one screen pixel.  For example, if the
image (or the current cropped portion of the image) has a size of
320x200, this command will attempt to make the image window be 320
screen pixels wide by 200 screen pixels high.

This command may fail in two cases.  If you're
running a window manager (such as \fImwm\fP) that enforces a minimum window
size, and the 'normal' size is too small, the image may get
distorted.  See the note in "Section 2.2: Cropping" for more
information.

Also, if the image is larger than the size of your
screen, it will be 'halved' until it fits on the screen.  For
example, if you try to display a 1400x900 image on a 1280x1024
screen, the \fBNormal\fP command will display a 700x450 image.

.IP "\fBMax Size\fP  (Keyboard equivalent 'm')"
This command will make the displayed image be
the same size as the screen.  If you are running a window manager
that puts up a titlebar, you'll find that the titlebar is now off the
top of the screen.  To get the titlebar back, simply shrink the image
to anything smaller than the size of the screen.  The window will be
moved so that the titlebar is once again visible.

.IP "\fBMaxpect\fP  (Keyboard equivalent 'M')"
Makes the image as large as possible, while
preserving the aspect ratio.  This avoids the generally unwanted
image distortion that \fBMax Size\fP is capable of generating.  For
example, if you have a 320x200 image, and an 1280x1024 screen, doing
the \fBMaxpect\fP command will result in an image that is 1280x800.  \fBMax
Size\fP, on the other hand, would've generated an image of size
1280x1024, which would be appear 'stretched' vertically.

.IP "\fBDbl Size\fP  (Keyboard equivalent '>')"
Doubles the current size of the image, with the constraint that
neither axis is allowed to be larger than the screen.  For example,
given a 320x200 image and a 1280x1024 screen, the image can be
doubled once (to 640x400), a second time (to 1280x800), but a third
time would make the image 1280x1024.  You'll note that on the third
time, the width didn't change at all, since it was already at its
maximum value.  Also note that the height wasn't allowed to double
(from 800 to 1600), but was truncated at its maximum value (1024).

.IP "\fBHalf Size\fP  (Keyboard equivalent '<')"
Halves the current size of the image, with the constraint that
neither axis is allowed to have a size less than 1 pixel.  Also, you
may run into 'minimum size' problems with your window manager.  See
the note in "Section 2.2: Cropping" for more information.

Note that the window size is maintained as a pair of integers.  As a
result you may see some integer round-off problems.  For example, if
you halve a 265x185 image, you'll get a 132x92 image, which is just
fine.  However, if you \fBDbl Size\fP this image, you'll get a 264x184
image, not the 265x185 image you might have expected.

.IP "\fB+10%\fP  (Keyboard equivalent '.')"
Increases the current size of the image by 10%, subject to
the constraint that the image cannot be made larger than the screen
size (in either axis).  For example, issuing this command on a
320x200 image will result in a 352x220 image.

.IP "\fB-10%\fP  (Keyboard equivalent ',')"
Decreases the current size of the image by 10%.  Neither axis of the
image is allowed to shrink below 1 pixel.  Also, you run the risk of
running into 'minimum window size' problems with your window manager.

It should be noted that the \fB+10%\fP and \fB-10%\fP commands have no
concept of an 'original size'.  They simply increase or decrease the
current image size by 10%.  As a result, they do not undo each other.
For example, take a 320x200 image.  Do a \fB+10%\fP and the image will be
352x220.  If you issue the \fB-10%\fP command now, the image will be made
(352 - 35.2)x(220 - 22), or 316x198.

.IP "\fB4x3\fP  (Keyboard equivalent '4')"
Attempts to resize the image so that the ratio of width to
height is equal to 4 to 3.  (e.g., 320x240, 400x300, etc.)  This is
useful because many images were meant to fill the screen of whatever
system they were generated on, and nearly all video tubes have an aspect
ratio of 4:3.  This command will stretch the image so that things
will probably look right on your X display (nearly all of which,
thankfully, have square pixels).  This command is particularly useful
for images which have really bizarre sizes (such as the 600x200
images presumably meant for CGA, and the 640x350 16-color EGA
images).

.IP "\fBAspect\fP  (Keyboard equivalent 'a')"
Applies the 'default aspect ratio' to the image.  This is done
automatically when the image is first loaded.  Normally, the default
aspect ratio is '1:1', but certain GIF files may have an aspect ratio
encoded in them.  You can also set the default aspect ratio via a
command-line argument or an X resource.  See 'Section 9: Modifying XV
Behavior' for more info.  The idea behind this command is that you'd
stretch the image manually (via your window manager) to roughly the
size you'd like, and then use the Aspect command to fix up the
proportions.

Normally \fBAspect\fP expands one axis of the image to correct the aspect
ratio.  If this would result in an image that is larger than the
screen, the \fBAspect\fP command will instead shrink one of the axes to
correct the aspect ratio.

.SS Section 3.2:  Rotate/Flip Commands
.PP
.IP "\fBTurn CW\fP  (Keyboard equivalent 't')"
Rotates the image 90 degrees clockwise.

.IP "\fBTurn CCW\fP  (Keyboard equivalent 'T')"
Rotates the image 90 degrees counter-clockwise.

.IP "\fBFlip H\fP  (Keyboard equivalent 'h')"
Flips the image horizontally (around the vertical center-line of the image).

.IP "\fBFlip V\fP  (Keyboard equivalent 'v')"
Flips the image vertically (around the horizontal center-line of the image).

.SS Section 3.3:  Smoothing Commands
.PP
.IP "\fBRaw\fP  (Keyboard equivalent 'r')"
Returns the displayed image to its 'raw' state (where each pixel in
the displayed image is as close as possible to the corresponding
pixel in the internal image).  In short, it turns off any dithering
or smoothing.  When dithering or smoothing haven't been done, this
command is disabled.

.IP "\fBDither\fP  (Keyboard equivalent 'd')"
Regenerates the displayed image by dithering with the available
colors in an attempt to approximate the original image.  This is only
relevant if the color allocation code failed to get all the colors it
wanted.  If it did get all the desired colors, the \fBDither\fP command
will just generate the same display image as the \fBRaw\fP command.  On the
other hand, if you didn't get all the desired colors, the \fBDither\fP
command will try to approximate the missing colors by dithering with
the colors that were obtained.  If you're running \fIxv\fP on a 1-bit
display the \fBDither\fP command will be disabled, as the image will always
be dithered for display.

.IP "\fBSmooth\fP  (Keyboard equivalent 's')"
Smooths out distortion caused by integer round-off when an image is
expanded or shrunk.  This is generally a desirable effect, however it
is fairly time-consuming on large images on most current
workstations.  As such, by default, it is not done automatically.
See "Section 9: Modifying XV Behavior" for more details.

.SS Section 3.4:  Cropping Commands
.PP
.IP "\fBCrop\fP  (Keyboard equivalent 'c')"
Crops the image to the current cropping rectangle.  This command is
only available when a cropping rectangle has been drawn on the image.
See "Section 2.2: Cropping" for further information.

.IP "\fBUnCrop\fP  (Keyboard equivalent 'u')"
Returns the image to its normal, uncropped state.  This command is
only available after the image has been cropped.  See "Section 2.2:
Cropping" for further information.

.IP "\fBAutoCrop\fP  (Keyboard equivalent 'A')"
Crops off any constant borders that exist in the image.  It will crop
to the smallest rectangle that encloses the 'interesting' section of
the image.  It may not always appear to work because of minor
invisible color changes in the image.  As such, it works best on
computer-generated images, and not as well on scanned images.

.SS Section 3.5:  The Display Modes Menu

In addition to displaying an image in a window, \fIxv\fP can also
display images on the root (background) window of your X display.
There are a variety of ways that \fIxv\fP can display an image on the
root window.  The \fBDisplay Modes\fP popup menu lets you select 
where (and how) \fIxv\fP will display the image.

Click on the \fBDisplay Modes\fP button in the \fIxv controls\fP
window, and hold the mouse button down.  This will cause the \fBDisplay
Modes\fP menu to pop up.  The current display mode will be shown with a
check mark next to it.  To select a new mode, drag the mouse down to
the desired mode, and release the mouse button.

It is not possible for \fIxv\fP to receive button presses or keyboard
presses in the root window.  As such, there are several functions
that cannot be used while in a 'root' mode, such as pixel tracking
and image cropping.  If you want to do such things, you'll have to
temporarily return to 'window' mode, and return to 'root' mode when
you're finished.  Also, when you are in a 'root' mode, you will not
be able to get rid of the \fIxv controls\fP window.  At best you can
iconify it (using your window manager).  (The reason for this is that
if you ever got rid of it there'd be no way to get it back.)

.IP "\fBWindow\fP"
Displays the image in a window.  If you were previously in a 'root'
mode, the root window will also be cleared.

.IP "\fBRoot: Tiled\fP"
The image is displayed in the root window.  One image is
displayed aligned with the top-left corner of the screen.  The image
is then duplicated towards the bottom and right edges of the screen,
as many times as necessary to fill the screen.

.IP "\fBRoot: Integer Tiled\fP" 
Similar to \fBRoot: Tiled\fP, except
that the image is first shrunk so that its width and height are
integer divisors of the screen's width and height.  This keeps the
images along the bottom and right edges of the screen from being
'chopped-off'.  Note: using any of the \'resizing' commands (such as
\fBNormal\fP, \fBDbl Size\fP, etc.) will lose the \'integer'-ness of
the image.

.IP "\fBRoot: Mirrored\fP"
Tiles the original image with versions that have been
horizontally flipped, vertically flipped, and both horizontally and
vertically flipped.  This gets rid of the sharp dividing lines where
tiled images meet.  The effect is quite interesting.

.IP "\fBRoot: Integer Mirrored\fP"
Like \fBRoot: Mirrored\fP, but also does the integer-ization described
under the \fBRoot: Integer Tiled\fP entry.

.IP "\fBRoot: Center Tiled\fP"
Like \fBRoot: Tiled\fP, but it positions the images so that one of them is
centered on the screen, and the rest are tiled off in all directions.
Visually pleasing without the image size distortion associated with
\fBRoot: Integer Tiled\fP.

.IP "\fBRoot: Centered\fP"
Displays a single image centered in the root window, surrounded by black.

.IP "\fBRoot: Centered, Warp\fP"
Displays a single image centered in the root window, surrounded by a
black and white 'warp' pattern, which produces some mildly visually
pleasing Moire effects.

.IP "\fBRoot: Centered, Brick\fP"
Displays a single image centered in the root window, surrounded by a
black and white 'brick' pattern.

.LP
Note: The three 'centered' modes (\fBRoot: Centered\fP, \fBRoot:
Centered, Warp\fP, and \fBRoot: Centered, Brick\fP, but not \fBRoot:
Center Tiled\fP) require the creation of a Pixmap the size of the
screen.  This can be a fairly large request for resources, and will
fail on a color X terminal with insufficient memory.  They can also
require the transmission of considerably more data than the other
\'root' modes.  If you're on a brain-damaged X terminal hanging off a
slow network, you should probably go somewhere else.  Barring that,
you should certainly avoid the 'centered' modes.

Also note: If you quit \fIxv\fP while displaying an image on the root
window, the image will remain in the root window, and the colors used
by the image will remain allocated.  This is generally regarded as
correct behavior.  If you decide you want to get rid of the root image
to free up resources, or simply because you're sick of seeing it, the
quickest route is to use run 'xv -clear', which will clear the root
window, release any allocated colors, and exit.  Alternately, \fIxsetroot\fP
and any other X program that puts things in the root window should be
able to do the trick as well.

.SS Section 3.6:  The 24-bit Conversion Menu

\fIxv\fP can currently only operate on 8-bit images.  Whenever you load a
24-bit image (such as JPEG, TIFF, PPM, etc) it is immediately converted
into an 8-bit colormapped image using one of three algorithms.

.IP "\fBFast\fP"
Converts 24-bit images into 8-bit images by dithering with a fixed 6x6x6
RGB colormap.  It is the quickest of the three algorithms, but also generally
produces the worst images.  It can also be selected via the '-quick24'
command-line option or X resource.

.IP "\fBSlow\fP"
The default algorithm.  Takes about twice as long as the fast algorithm.  
Uses the median-cut algorithm to pick a set of 256 colors, and then dithers
using these colors.  It can be selected via the '-slow24' command-line
option or X resource.

.IP "\fBBest\fP"
By far and away the slowest of the algorithms.  It can take up to ten times
as long as the 'slow' algorithm.  It uses a cleverer version of the
median-cut algorithm to pick a better set of colors than the slow
algorithm.  It does \fBnot\fP dither.  This might look best if you're
going to be expanding the image by very much, as the dithering in the
other two algorithms becomes very noticable.  You can also select this
option via the '-best24' command-line option or X resource.

.SS Section 3.7:  Working With Multiple Files

\fIxv\fP provides a a set of controls that let you conveniently operate on
a list of images.  To use the following commands, you'll have to
start up \fIxv\fP with a list of filenames.  For example, you could type
\'xv *.gif' (assuming, of course, that you have a bunch of files that
end with the suffix '.gif' in the current directory).

The filenames are listed in a scrollable window.  The current
selection is shown in reverse video.  If there are more names than
will fit in the window, the scrollbar will be enabled.

.SS Section 3.7.1:  Operating a List Window

The scrollbar operates as follows:  
.TP 3
\(bu
clicking in the top or bottom arrow of the scrollbar scrolls the list
by one line in the appropriate direction.  It will continue to scroll
the list as long as you hold the mouse down.
.TP
\(bu
The thumb (the small white rectangle in the middle of the scrollbar)
shows roughly where in the list you are.  You can change your
position in the list by clicking and dragging the thumb to another
position in the scrollbar.  The list will scroll around as you move the
thumb.
.TP
\(bu
You can scroll the list up or down a page at a time by clicking in
the grey region between the thumb and the top or bottom arrows.
.LP
If you click on a name in the list, that name will become
highlighted.  You can drag the highlight bar up and down, and the
list will scroll appropriately.

It is also possible to control the list window from the keyboard.  In
all cases, you must make sure that the window sees the keypress.
Generally, this means you have to have the cursor inside the window,
though your window manager may also require you to click inside the
window first.
.TP 3
\(bu
The up and down arrow keys move the highlight bar up and down.  If
the bar is at the top or bottom of the window, the list will scroll
one line.
.TP
\(bu
The page up and page down keys scroll the list up or down a page at a time.
.TP
\(bu
Pressing the home key will jump to the beginning of the list.
Pressing the end key will jump to the bottom of the list.

.SS Section 3.7.2:  The File Commands

You can directly view any image in the list by double-clicking on its
filename.  If \fIxv\fP is unable to load the file (for any of a variety of
reasons), it'll display an error message and put up the default
image, the \fIxv\fP logo.

.IP "\fBNext\fP  (Keyboard equivalent <space>)"
Attempts to load the next file in the list.  If it is unable
to load the next file, it will continue down the list until it
successfully loads a file.  If it gets to the bottom of the list
without successfully loading a file, it will put up the default
image.

.IP "\fBPrevious\fP  (Keyboard equivalent <backspace>)"
Attempts to load the previous file in the list.  If it is unable to
load the previous file, it will continue up the list until it
successfully loads a file.  If it gets to the top of the list without
successfully loading a file, it will put up the default image.

.IP "\fBDelete\fP  (Keyboard equivalent <ctrl-D>)"
This command lets delete the currently selected file from the list
(and optionally delete the associated disk file).  Note that the
currently selected file is the one with the highlight bar on it.
While this is generally the same as the currently displayed image, it
doesn't have to be.

The \fBDelete\fP command will pop-up a window asking you what you want to
delete.  Your choices are:
.RS
.TP 3
\(bu
\fBList Entry\fP, which will remove the highlighted name from the list.
(Keyboard equivalent: the enter key)
.TP
\(bu
\fBDisk File\fP, which will remove the highlighted name from the list and
also delete the associated disk file.  This removes unwanted images,
just like manually typing 'rm <filename>' in another window.
(Keyboard equivalent: <ctrl-D>)
.TP
\(bu
\fBCancel\fP, which lets you get out of the Delete command without actually
deleting anything.  (Keyboard equivalent: the esc key)
.RE
.SS Section 3.7.3:  Image Reloading
It is occasionally desirable to reload an image file because the
contents of the file have changed.  For example, you could be
downloading a file, and you might want to keep reloading the file to
check on the progress of the download.  Or perhaps you have a program
that generates images, and you'd like to view these images without any
manual intervention.

\fIXV\fP provides a way to reload an image via an external signal.  If
you send the xv process a SIGQUIT signal ('kill -QUIT \fIpid\fP', or
'kill -3 \fIpid\fP' on most systems), the program will reload the
currently selected file.  (The one that is currently highlighted in
the \fIxv controls\fP window filename list.)  This behavior is exactly
the same as hitting '<return>' in the \fIxv controls\fP window.  If
\fIxv\fP is currently in a state where hitting '<return>' in the
controls window won't load an image (ie, some pop-up dialog box is
grabbing all such events), then sending this signal wonUt work either.

An idea: You could write a 'clock' program that, once a minute,
generates a really spiffy looking picture of the current time (with
color gradations, 3d extruded numbers, whatever), then sends \fIxv\fP the
signal to reload the generated image.

.SS Section 3.8:  The Grab Command

The \fBGrab\fP command works as follows:  click on the \fBGrab\fP button
in the \fIxv controls\fP window, or type a <ctrl-G> key in any active
\fIxv\fP window (except for the JPEG, PostScript, and TIFF 'save' 
dialog boxes).  The terminal will beep once, and the cursor will change 
to a cross.  The screen will remain frozen until you complete the \fBGrab\fP
command.

You can \fBGrab\fP an arbitrary region of the screen by clicking the 
\fILeft\fP mouse button and dragging a rectangle in exactly the same
way you draw a cropping rectangle.  When you let go of the mouse
button, the contents of this rectangle will be read from the
screen and loaded into \fIxv\fP.  

Alternately, you can grab the entire contents of a window (including its 
frame) by clicking the \fIMiddle\fP mouse button anywhere inside the chosen
window.  If you click the \fIMiddle\fP mouse button somewhere on the root 
window, the entire screen will be loaded into \fIxv\fP.

Or, alternately, you can simply abort the \fBGrab\fP command by 
clicking the \fIRight\fP mouse button anywhere on the screen.

You can use the \fBGrab\fP command for a wide variety of purposes.  For 
example, you can use it to print the contents of any window (or the
whole screen) by grabbing the appropriate image and then saving it as
a PostScript file.  

You can use the \fBGrab\fP command, in conjunction with
the Zoom and UnZoom commands, as an effective replacement for the \fIxmag\fP
program.  

You can also use the \fBGrab\fP command to pick 'just the right colors'
for any application.  Simply start the application in question, \fBGrab\fP
the window into \fIxv\fP, and use the colormap editor to twiddle the colors
around to your heart's content.

Note:  The \fBGrab\fP command does not work on Macintoshes running \fIMacX\fP
in a rootless mode, which isn't too surprising, if you think about it...

.SS Section 3.9:  Other Commands
.PP
.IP "\fBInfo\fP  (Keyboard equivalent 'i')"
Opens and closes the \fIxv info\fP window.  See "Section 4: The Info
Window" for more details.

.IP "\fBColEdit\fP  (Keyboard equivalent 'e')"
Opens and closes the \fIxv color editor\fP window.  See "Section 5: The
Color Editor" for more details.

.IP "\fBLoad\fP  (Keyboard equivalent <ctrl-L>)"
Opens the \fIxv load\fP window.  See "Section 6: The Load Window" for more
details.

.IP "\fBSave\fP  (Keyboard equivalent <ctrl-S>)"
Opens the \fIxv save\fP window.  See "Section 7: The Save Window" for more
details.

.IP "\fBQuit\fP  (Keyboard equivalent 'q')"
Quits out of the program.

.SH SECTION 4:	THE INFO WINDOW

.SS Section 4.1:  Overview

\fIxv\fP provides a window to display information about the current image,
color allocation, expansion, cropping, and any error messages.  This
window can be opened by issuing the Info command.  (Click on the Info
button in the \fIxv controls\fP window, or type 'i' in any open 
\fIxv\fP window.)
You can close the window by using the \fBInfo\fP command while the window is
open.  You can also close the window by clicking anywhere inside it.

The top portion of the window displays the program name, revision
date, and patchlevel.  It also shows the University of Pennsylvania
shield, the GRASP Lab logo, the copyright notice, and of course, the
author's name.

.SS Section 4.2:  The Fields

The "Filename" field displays the name of the currently loaded file.
The name is displayed without any leading pathname.  If there is no
currently loaded image (you're looking at the default image) this
field will display "<none>".

The "Format" field displays information describing what image format
the file is stored in, and how large the file is (in bytes).

The "Resolution" field shows the width and height (in image pixels) of
the loaded image.  Note that this does not necessarily have anything
to do with the size of the image currently displayed on your screen.
These numbers do not change as you modify the display image.

The "Cropping" field displays the current state of any cropping
activity.  If you are looking at the entire (uncropped) image, and
there is no cropping rectangle drawn, this field will show "<none>".
If you draw a cropping rectangle, or if you are viewing cropped
portion of image, this field will display something like "247x128
rectangle starting at 132,421".  See "Section 2.2: Cropping" for more
details.

The "Expansion" field gives you information about how the image is
displayed.  It will display something like "1.58 x 1.37 (505 x 273)".
This tells you that the current displayed image is 505 pixels wide and
273 pixels high, and that it is 1.58 times wider and 1.37 times higher
than the internal image (which, in this case, had a size of 320x200).

The "Colors" field gives you detailed information on how well (or
poorly) color allocation went.  If everything went reasonably well it
will display something like:
.IP
Got all 67 desired colors.  (66 unique)
.LP
This means that 67 entries in the image's colormap were used in the
image, but that only 66 of these colors were different, as far as the
X server was concerned.

See "Appendix E: Color Allocation" for a complete discussion of how
colors are allocated, and what the "Colors" field can tell you.

Note that the fields are filled in as information becomes available.
As such, they can be used as a rough 'progress indicator' when loading
images.  When you begin loading, all the fields are cleared.  Once the
image has been successfully loaded, the top three fields (Filename,
Format, Resolution) are filled in.  Once the colors have been
allocated, and the display image generated, the bottom three fields
are shown (Cropping, Expansion, and Colors).

.SS Section 4.3:  Status Lines

The bottom two lines in the info window display various error
messages, warnings, and status information.  These two lines are also
duplicated in the \fIxv controls\fP window.

The upper line is the more commonly used.  It normally displays a
one-line summary of the current image and color allocation success.
If an error occurs, it will be displayed on this line as well.

The lower line is used to display warning messages.

.SH SECTION 5:	THE COLOR EDITOR

.SS Section 5.1:  Overview

The \fIxv color editor\fP provides a powerful system for manipulating color
images.  Since there are many different reasons why a person would
want to modify an image's colors, and many different types of images
that may need modification, there is no one color manipulation tool
that would be 'best' for all purposes.  Because of this problem, \fIxv\fP
gives the user three different color tools, all of which can be used
simultaneously.
.TP 3
\(bu
Colormap Editing: This tool lets you arbitrarily modify individual
colormap entries.  Useful for modifying the color of captions or other
things that have been added to images.  Also works well on images that
have a small number of colors, such as images generated by 'drawing'
or CAD programs.  It's also an easy way to spiff up boring 1-bit black
and white images.
.TP 
\(bu
HSV Modification: This tool lets you alter the image globally in the
HSV colorspace.  (See "Appendix D: RGB and HSV Colorspaces" for more
info.)  Here are examples of the sort of things you can do with this
tool:
.RS
.TP 3
\(bu
turn all the blues in an image into reds
.TP
\(bu
change the tint of an image
.TP
\(bu
change a greyscale image into a mauve-scale image
.TP
\(bu
increase or decrease the amount of color saturation in an image
.TP
\(bu
change the overall brightness of an image
.TP
\(bu
change the overall contrast of an image
.RE
.TP 3
\(bu
RGB Modification: This tool lets you route the red, green, and blue
color components of an image through independent mapping functions.
The functions can either be the standard gamma function, or any
arbitrary function that can be drawn with straight line segments or a
cubic spline.  See "Section 5.3.4: The Intensity Graph" for more info
about graph functions.
.LP
The major use of the RGB Modification tool is to correct for the
differing color response curves of various color monitors, printers,
and scanners.  This is the tool to use when "the image is too red",
for instance.

These three tools are tied together in a fixed order.  The Colormap
Editing tool operates on the original colors in the image.  The output
of this tool is piped into the HSV Modification tool.  Its output is
piped into the RGB Modification tool.  The output from the RGB
Modification tool is what actually gets displayed.

In addition there is a collection of buttons that control the 
\fIxv color editor\fP as a whole (more or less).

Don't Panic!  It's not as complicated as it looks.

.SS Section 5.2:  The Colormap Editing Tool

The top portion of this window shows the colormap of the current
image.  There are 16 cells across, and up to 16 rows down, for a
maximum of 256 color cells.  Only cells actually used somewhere in the
image are shown in this array.

The currently selected color cell is shown with a thick border.  You
can change the selection by clicking anywhere in the array.  If you
drag the mouse through this area, you'll see the dials at the bottom
change to track the current pixel values.

You can also select a color cell by clicking anywhere in the image
window.  Whichever pixel value you were on when you let go of the
mouse will become the new selected color cell.

You can define a smoothly gradated range of colors by \fILeft\fP clicking on
the color cell that marks the 'start' of the range, and \fIMiddle\fP
clicking on the color cell that marks the 'end' of the range.
Intervening color cells will be interpolated between the colors of the
'start' and 'end' colorcells.

As an example:
.TP 3
\(bu
View the 'default' image by running \fIxv\fP without specifying any filenames.
.TP
\(bu
Open the \fIxv color editor\fP window, and \fILeft\fP click on the first 
color cell.
.TP
\(bu
Turn this color cell \fIred\fP by setting the RGB dials to 255,0,0.
.TP
\(bu
\fILeft\fP click on the 64th color cell (the rightmost color cell in the 
last complete row).
.TP
\(bu
Turn this color cell \fIyellow\fP by setting the RGB dials to 255,255,0.
.TP
\(bu
\fIMiddle\fP click on the first color cell.  A smooth series of
\fIyellowish-reds\fP will be generated from the 64th color cell to the first
color cell.  Note that the 'direction' doesn't matter.
.LP
Since certain images will have many colors that are the same, or
nearly the same, it is sometimes convenient to group color cells
together.  Grouped color cells all take on the same color, and
changing any one of them affects all of the other colors in the group.

To group color cells together, do the following:
.TP 3
\(bu
Hold down the <shift> key.
.TP
\(bu
Left click on one color cell that you would like to be in the group
.TP
\(bu
Right click on other color cells that you wish to be in this group.  (Right clicking on cells that are already selected will de-select them.)
.TP
\(bu
Release the <shift> key when you're done.
.LP
You can create as many groups as you like.

You can use this grouping/ungrouping technique to copy colors from one
color cell to another.  Left click on the source color cell, Right
click on the destination color cell, and Right click on the
destination color cell again (to ungroup it).

.SS Section 5.2.1:  Using the Dial Controls

At the bottom the Colormap Editing tool are three dials that let you
set the color of the current color cell (or group of cells).  By
default, the dials control the Red, Green, and Blue components of the
RGB colorspace, but they can also control the Hue, Saturation, and
Value components of the HSV colorspace.  (The \fBRGB/HSV\fP button controls
this.)

Regardless of what they control, all dials in \fIxv\fP work the same way.
Clicking on the single arrows increase/decrease the value by 1.
Clicking on the double arrows increase/decrease the value by a larger
amount (16 in this case).  If you click on one of the arrows, and hold
the mouse button down, the increase/decrease will repeat until you
release the mouse button.

You can also click in the general area of the pointer and simply drag
it to the position you want.  The further your mouse cursor is from
the center of the dial, the more precise the control will be.  While
dragging, you do not have to keep the cursor inside the dial window.

.SS Section 5.2.2:  Colormap Editing Commands

.IP "\fBColUndo\fP"
Undoes the last change made to the colormap that resulted in a color
cell changing value.  This includes grouping and ungrouping color
cells, and changing any of the dials.

.IP "\fBRevert\fP"
Undoes all color changes.  Returns the colormap to its
original state.  Destroys any groups that you may have created.

.IP "\fBRGB/HSV\fP
Toggles the Colormap Editing dials between editing colors in terms of
Red, Green, and Blue, and editing colors in terms of Hue, Saturation,
and Value.

.IP "\fBGrey\fP"
Turns color images into greyscale images by changing the colormap.
This replaces each color cell with a
greyscale representation of itself.  Use the \fBRevert\fP command to restore
the colors.

.IP "\fBRevVid\fP"
This command behaves differently, depending on the setting of the
RGB/HSV mode.  (You can tell which mode you're in by the titles on the
dials.)

In RGB mode, each color component is separately 'inverted'.  For
example, Yellow (which is composed of full red, full green, and no
blue) would turn to Blue (no red, no green, full blue).

In HSV mode, only the Value (intensity) component is 'inverted'.  The
Hue and Saturation components remain the same.  In this mode, bright
colors turn to dark versions of the same color.  For example, a Yellow
would turn Brown.

.IP "\fBRandom\fP"
Generates a random colormap.  This is of questionable usefulness, but
it will occasionally come up with pleasing color combinations that you
never would've come up with yourself.  So it stays in.  It works best
on images with a small number of colors.  Note that it respects cell
groupings, so if your image has a lot of colors, you can create a few
large groups and then use the Random command.

.LP 
Note: It is HIGHLY RECOMMENDED that if you're using the Colormap
Editing tool, you do NOT use the HSV Modification tool or the RGB
Modification tool as well.  If you do, the results can be quite
confusing.  For example, you might edit a color cell, and set its
color values to produce a purple.  However, because of HSV/RGB
Modification further down the line, the actual color displayed on the
image (and in the color cell) is yellow.  Very confusing, indeed.

.SS Section 5.3:  The HSV Modification Tool

There are four separate controls in the HSV Modification tool.  At the
top of the window are a pair of circular controls that handle hue
remapping.  Lower down is a circular control that maps 'white' (and
greys) to a specified color.  There is a dial control that lets you
saturate/desaturate the colors of the current information.  Finally,
at the bottom there is a graph window that lets you modify intensity
values via an arbitrary remapping function.

.SS Section 5.3.1:  Hue Remapping Controls

These two dials are used to define a source and a destination range of
hue values.  Every hue in the source range (defined in the From dial)
gets mapped to the value of the corresponding point in the destination
range (defined in the To dial).

Each dial has a pair of radial lines with handles at their ends.
Between the two lines an arc is drawn with an arrow at one end.  The
wedge drawn by these lines and the arc defines a range of values (in
degrees).  The direction of the arc (clockwise, or counter-clockwise)
determines the direction of this range of values (increasing or
decreasing).

Distributed around the dial are tick marks and the letters 'R', 'Y',
\'G', 'C', 'B', and 'M'.  These letters stand for the colors Red,
Yellow, Green, Cyan, Blue, and Magenta, and they show where these
colors appear on the circle.

The range is shown numerically below the control.  By default the
range is '330, 30 CW'.  This means that a range of values [330, 331,
332, ... 359, 0, 1, ... 28, 29, 30] has been defined.  Note that
(being a circle) it wraps back to 0 after 359.

The range can be changed in many different ways.  You can click on 
the 'handles' at the end of the radial lines and move them around.  If you
click inside the dial, but not on one of the handles, you'll be able
to drag the range around as a single object.  There are also 5 buttons
below the dial that let you rotate the range, flip the direction of
the range, and increase/decrease the size of the range while keeping
it centered around the same value.

In its default state, the To dial is set to the same range as the From
dial.  When the two dials are set to the same range, they are
effectively 'turned off', and ignored.

An example of hue remapping:
.TP 3
\(bu
As a simple example of the sort of things you can do with the hue
remapping control, we'll change the background color of the default
(\fIxv\fP logo) image without changing any other colors in the image.  Since
the background is composed of a gradient of 64 colors, you would not
want to do this with the Colormap Editing tool.  It would take
forever.
.TP
\(bu
First, get the default image up on the screen by running 'xv' without
giving any filenames.  Open up the \fIxv color editor\fP window via the
\fBColEdit\fP command.
.TP
\(bu
Next, click the mouse in the image window and drag it around.  You'll
see that all the background pixels have the same Hue component value
(240).
.TP
\(bu
To remap this hue, simply adjust the From dial so that its range
includes this Hue value.  The background should change from 'blue' to
a reddish color, assuming the To dial is still set to its default
range (centered around 'R').  If more than the background changed
color, you can shrink the From range so that it covers fewer colors.
In fact, it's possible to shrink the range to the point where it only
covers only a single value.
.LP
Note that the values printed when you are tracking pixel values in the
image are the values before the HSV Modification tool is applied.  For
example, the background of the default image will still claim to be
blue, regardless of what color you may have changed it to.  This is so
that you know what Hue value you will need to remap if you want to
change its color again.

If you press the Reset button that is located near the hue remapping
controls, it will effectively disable the hue remapping by setting the
To range equal to the From range.

Below the hue remapping controls are a group of 'radio buttons'.  You
can have up to six different hue remappings happening simultaneously.
Higher numbered mappings take precedence over lower number mappings.

An example of multiple hue remappings:
.TP 3
\(bu
Draw a From range that is a complete circle.  The easiest way to do
this is to draw a range that is nearly a full circle, then click and
hold down the 'increase range' button located below the From range
dial until the range stops getting bigger.
.TP
\(bu
Copy this range to the To range by pressing the Reset button.
.TP
\(bu
Rotate the To range slightly, by either clicking and dragging anywhere
in the To range dial, or by using the 'rotate clockwise' and 'rotate
counter-clockwise' buttons located below the To range.
.TP
\(bu
You've just built yourself what is effectively a tint control.
.TP
\(bu
Now, suppose, you'd like to adjust the background color of your
(tint-modified) image, without affecting anything else.  Clicking on
the background in the image window reveals that the background still
has an (original) hue of 240.  To modify this hue without affecting
anything else, we'll need a second hue remapping.
.TP
\(bu
Click on the 2 radio button.  The dials will change to some other
default setting.  As before, set the From range to encompass the value
240, preferably as 'tightly' as possible, and set the To range to
produce the desired background color.
.LP
Note that the six hue remappings are not 'cascaded'.  The output of
one remapping is not fed as input into any of the other hue
remappings.  The hue remappings always operate on the hue values in
the original image.  In this example, if remapping #1 adds 32 to all
hue values, thereby mapping the blue background (value 240) into a
purple-blue (value 272), remapping #2 still sees the background at
240, and can remap it to anything it likes.  Similarly, in the same
example, if remapping #1 has mapped a green-blue color (value 208)
into blue (value 240), remapping #2 will not map this into another
color.  As far as remapping #2 is concerned, that green-blue is still
green-blue.

If it seems complicated, I'm sorry.  It is.

.SS Section 5.3.2:  The White Remapping Control

In the HSV colorspace, 'white' (including black, and all the greys in
between) has no Hue or Saturation components.  As such, it is not
possible to use the hue remapping controls to change the color of
white pixels in the image, since they have no 'color' to change.

The white remapping control provides a way to add Hue and Saturation
components to all the whites in the image.  It consists of a movable
point in a color dial.  The angle of the dot from the center of the
dial determines the Hue component.  The distance of the dot from the
center of the dial determines the Saturation component.  The further
the dot is from the center of the dial, the more saturated the color
will be.

You can control the white remapping control in several ways.  You can
click on the handle and drag it around with the mouse.  There are also
four buttons provided under the dial.  One pair allows you to rotate
the handle clockwise and counter-clockwise without changing its
distance from the center.  The other pair of buttons lets you change
the distance between the handle and the center without changing the
angle.

The current Hue and Saturation values provided by the control is
displayed below the dial.  The first number is the Hue component, in
degrees, and the second is the Saturation component, as a percentage.

There is also a checkbox that will let you turn off the white
remapping control.  This lets you quickly compare your modified
\'white' with the original white.  You can also effectively disable the
white remapping control by putting the handle back in the center of
the control.  The easiest way to do this is to click and hold the
\'move towards center' button until the saturation gets down to 0%.

Example:  
.TP 3
\(bu
Press the Grey control in the Colormap Editing tool.  This turns all
the colors in the image into shades of grey.
.TP
\(bu
Drag the handle in the white remapping control halfway down towards
the 'R' mark.  The Hue and Saturation values should be roughly
0-degrees and 50%.  The image should now be displayed in shades of
pink.

.SS Section 5.3.3:  The Saturation Control

The saturation control lets you globally increase or decrease the
color saturation of the image.  In effect, it is much like the 'color'
control on most color televisions.

The saturation control is a dial that operates exactly like the dials
described in "Section 5.2.1 Using the Dial Controls".  In short, you
can click and hold down any of the four buttons in the bottom of the
control to increase or decrease the control's value.  You can also
click on the dial itself and move the pointer around directly.

The saturation control has values that range from '-100%' to '+100%'.
At its default setting of '0%', the saturation control has no effect
on the image.  As the values increase, the colors become more
saturated, up to '+100%' where every color is fully saturated.
Likewise, as values decrease, the colors become desaturated.  At
\'-100%', every color will become a completely desaturated (i.e., a
shade of grey).  Note that this control is applied after the the White
Remapping control, so if you 'greyify' the image by completely
desaturating it, you will not be able to color it using the White
Remapping control.

Unless you're trying for some special effects, the useful range of
this control is probably '+/-20%'.  Also note that the control will
have no effect on shades of grey, as they have no color to saturate.

.SS Section 5.3.4:  The Intensity Graph

The intensity graph allows you to change the brightness of the image,
change the contrast of the image, and get some unique effects.

The intensity graph is a function that lets you remap intensity values
(the Value component in HSV Colorspace) into other intensity values.
The input and output values of this function both range from 0 to 255.
The input values range along the x axis of this graph (the
horizontal).  For every input value (point along the x axis) there is
a unique output value determined by the height of the graph at that
point.  In the graph's default state, the function is a straight line
from bottom-left to top-right.  In this case, each input value
produces an equivalent output value, and the graph has no effect.

There are a number of 'handles' along the graph.  These provide your
major means of interacting with the graph.  You can move them around
arbitrarily, subject to these two constraints: the handles at the far
left and far right of the graph can only be moved vertically, and
handles must remain between their neighboring handles for the graph to
remain a proper function.

The handles are normally connected by a spline curve.  To see this,
move one of the handles by clicking and dragging it.  (Note that the
\fIx,y\fP position of the current handle is displayed while the mouse
button is held down.)  The function will remain a smoothly curved line
that passes through all the handles.  You can change this behavior by
putting the function into 'lines' mode.  Press the 'lines' button
(the second button down from the top).  The function will change to a
series of line segments that connect the handles.  Press the 'spline'
button (the top button) to go back to 'spline' mode.

The next two buttons let you add or delete handles.  The 'add handle'
button will insert a handle into the largest 'gap' in the function.
The 'delete handle' button will remove a handle from the smallest
\'gap' in the function.  You can have as little as 2 handles, or as
many as 16.  Note that as the number of handles gets large, the spline
will start getting out of control.  You may wish to switch to 'lines'
mode in this case.

The 'Reset' button puts everything back on a straight line connecting
bottom-left to top-right (a 1:1 function).  It does not change the
number of handles, nor does it change the x-positions of the handles.

The 'Gam' button lets you set the function curve by entering a single
number.  The function is set equal to the gamma function:
.IP
Y = 255 * (I/255) ^ (1/g)
.LP
where I is the input value (0-255), g is the gamma value, and Y is the
computed result.

Gamma values (for our purposes) can range between 0 and 10000, non-inclusive.
.TP 3
\(bu
A gamma value of '1.00' results in the normal 1:1 straight line.
.TP
\(bu
Gamma values of less than 1.00 but greater than 0.00 result in
\'exponential' curves, which will dim the image.
.TP
\(bu
Gamma values greater than 1.00 result in 'logarithmic' curves, which
will brighten the image.  Try it and see.
.LP
There is a shortcut for the 'Gam' button.  Type 'g' while the mouse is
inside the graph window.

Also, touching any of the handles after a 'Gam' command will put the
graph back into its 'normal' mode.  (Either 'spline' or 'lines'
depending on which of the top two buttons is turned on.)

Generally, whenever you move a graph handle and let go of it, the
image will be redrawn to show you the effects of what you've done.
This can be time-consuming if you intend to move many points around.
You can temporarily prevent the redisplay of the image by holding down
a <shift> key.  Continue to hold the <shift> key down while you move
the handles to the new position.  Release the <shift> key when you're
done, and the image will be redisplayed.

.SS Section 5.4:  The RGB Modification Tool

The RGB Modification tool is a collection of three graph windows, each
of which operate on one of the components of the RGB colorspace.  This
tool lets you perform global color-correction on the image by boosting
or cutting the values of one or more of the RGB color components.  You
can use this to correct for color screens that are 'too blue', or for
color printers that produce 'brownish' output, or whatever.

The graphs work exactly as explained in "Section 5.3.4:  The Intensity Graph".

Neat Trick: In addition to color-correction, you can use the RGB
modification tool to add color to images that didn't have color to
begin with.  For instance, you can 'pseudo-color' a greyscale image.

An example of pseudo-coloring:
.TP 3
\(bu
Adjust the Red graph so that there is a strong red presence on the
right side of the graph, and none on the left, or in the middle.
.TP
\(bu
Adjust the Green graph so that there is a strong green presence in the
middle of the graph, and none on the left or right.
.TP
\(bu
Adjust the Blue graph so that there is a strong blue presence on the
left side of the graph, and none on the left, or in the middle.
.LP
You now have a transformation that will take greyscale images and
display them in pseudo-color, using a 'temperature' color scheme.
Neato!

.SS Section 5.5:  The Color Editor Controls

These buttons provide general control over the whole \fIxv color editor\fP
window.  You can display the image with or without color modification,
save and recall presets, and undo/redo changes.  Also, convenience
controls are given for performing some of the most common operations
on the Intensity graph.

.IP "\fBApply\fP  (Keyboard equivalent 'p')"
Displays the image using the current HSV and RGB Modifications.  Also
turns the 'Display with HSV/RGB mods' checkbox on.  (See below.)

This is only useful when the 'Auto-apply HSV/RGB mods' checkbox is
off.

.IP "\fBNoMod\fP"
Displays the image without any HSV or RGB Modifications.  Also turns
the 'Display with HSV/RGB mods' checkbox off.

.IP "\fBReset\fP  (Keyboard equivalent 'R')"
Resets all HSV and RGB controls to their default settings.  Doesn't
affect the Colormap Editing tool.

.IP "\fBUndo\fP"
Undoes the last change to the HSV or RGB controls.

It may be helpful to think of \fIxv\fP as maintaining a series of 32
\'snapshots' of the HSV and RGB controls.  You are normally looking at
the last frame in this series.  The \fBUndo\fP control moves you backwards
in the series.

.IP "\fBRedo\fP"
Only available after you've hit Undo.  Moves you forward in the
\'snapshot' series described above.  Note that if you have hit \fBUndo\fP a
few times (i.e., you're now looking at some frame in the middle of the
series), and you change an HSV or RGB control, all subsequent frames
in the series are thrown away, and the current state becomes that last
frame in the series.

.IP "\fB1,2,3,4\fP"
Pressing any of these buttons recalls a preset (a complete set of
values for the HSV and RGB controls).

.IP "\fBSet\fP"
Used in conjunction with the \fBReset,1,2,3,4\fP buttons to store the current
settings of the HSV and RGB controls into a preset.  To do so, press
the \fBSet\fP button, and then press one of the \fBReset,1,2,3,4\fP 
buttons.  The
current HSV and RGB control settings will be stored in that preset, as
long as \fIxv\fP continues running.  The values will be lost when the
program exits.  It is also possible to save these values permanently.
See the \fBCutRes\fP button (below) and "Section 9: Modifying XV
Behavior" for more details.

.IP "\fBCutRes\fP"
Copies the current settings of the HSV and RGB controls, as text, into
the X server's cut buffer.  You can then use a text editor to paste
these values into your '.Xdefaults' (or '.Xresources') file.  This
lets you save the current settings 'permanently'.  See "Section 9:
Modifying XV Behavior" for more details.

.IP "\fBClose\fP"
This button closes the \fIxv color editor\fP window.

.IP "\fBBrite\fP"
Brightens the image by moving all the handles in the Intensity graph
up by a constant amount.

.IP "\fBDim\fP"
Darkens the image by moving all the handles in the Intensity graph
down by a constant amount.

.IP "\fBSharp\fP"
Increases the contrast of the image by moving handles on the left side
of the Intensity graph down, and handles on the right side up.

.IP "\fBDull\fP"
Decreases the contrast of the image by moving handles on the left side
of the Intensity graph up, and handles on the right side down.

.IP "\fBNorm\fP  (Keyboard equivalent 'N')
Normalizes the image so that the darkest pixels in the image are given an
intensity of '0', and the brightest pixels in the image are given an
intensity of '255'.  Intermediate colors are interpolated accordingly.
This forces the image to have the full (maximum) dynamic range.

.IP "\fBHistEQ\fP  (Keyboard equivalent 'H')
Runs a histogram equalization algorithm on the currently displayed 
region of the image.  This is, if you're cropped, it will only run the
algorithm on the cropped section.  Note, however, that the only 
modification it makes to the image is to generate a bizarre corrective
Intensity curve.  As such, if you \fBHistEQ\fP a section of the image, then
\fBUnCrop\fP, the rest of the image will probably not be what you'd want.
Also note that the histogram curve will 'go away' if you touch any of the
handles in the Intensity graph window, just like a 'gamma' curve would.

.LP
The 'Display with HSV/RGB mods' checkbox tells you whether or you're
looking at a modified image (checked) or the 'raw', unmodified image
(unchecked).  The \fBApply\fP and \fBNoMod\fP buttons change the setting of 
this checkbox, and you can also change the checkbox directl by clicking on
it.

The 'Auto-apply HSV/RGB mods' checkbox controls whether or not the
program regenerates and redisplays the image after each change to an
HSV or RGB control.  By default, this checkbox is turned on, so that
you can easily see the results of your modifications.  However, in the
case that you want to make a large number of changes at once, it might
be preferable to turn automatic redisplay off for a while, to speed
things up.

The 'Auto-reset on new image' checkbox controls whether or not the HSV
and RGB controls are \fBReset\fP back to their default values whenever a new
image is loaded up.  By default, this is also turned on, as when
you're playing with the HSV/RGB controls, you probably only want to
affect the current image, and not all subsequently loaded images as
well.

.SH SECTION 6:  THE LOAD WINDOW

The \fIxv load\fP window lets you load and view images interactively,
without specifying them on the command line when you start \fIxv\fP.

The load window shows the contents of the current directory in a
scrolling window.  The files will be sorted alphabetically, with all
the directories (and symbolic links to directories, if your operating
system supports them) displayed first.

This list window operates in the same way that the one in the \fIxv\fP
controls window works.  (See "Section 3.7.1: Operating a List Window"
for details.)  In short, you can operate the scroll bar, drag the
highlight bar around the window, and use the up-arrow, down-arrow,
Home, End, Page Up, and Page Down keys on your keyboard.

Whenever you click on a name in the list (or otherwise change the
position of the highlight bar), the name of the highlighted file is
copied to the "Load file" text entry region, located below the list
window.  Pressing the Ok button (or typing <return>) will cause the
program to attempt to load the specified file.  If the load attempt is
successful, the load window will disappear, and the new image will be
displayed.  Otherwise, an error message will be displayed, and the
load window will remain visible.

The \fBBrowse\fP checkbox overrides this behavior, and keeps the load
window visible until it is explicitly closed via the \fBCancel\fP
button.  This is handy if you're using \fIxv\fP to 'wander around a
directory tree', and plan to be using the \fBLoad\fP command quite
often.

If the image is successfully loaded, its name will be added to the 
\fIxv controls\fP window list.  This will let you quickly reload it later
without have to go through the \fIxv load\fP window again.

You can also load a file by double-clicking on its name in the file list.

If the specified filename begins with a '!' or '|' character, the
filename will be interpeted as a shell command to run.  The
leading '!' or '|' gets stripped off, and the rest of the line
is fed to the default system shell.  The command is expected to 
generate an image in one of the formats that \fIxv\fP recognizes.  This
image is expected to be the stdout of the specified command.  If the
command returns non-zero, it is assumed that the command failed, and 
no image is loaded.  You can pipe multiple commands together.
For example, loading "! xwd | xwdtopnm" would run \fIxwd\fP to generate
a window dump, pipe that to \fIxwdtopnm\fP to convert it to a PPM file, 
which in turn is piped to \fIxv\fP.

If the specified file is a directory, \fIxv\fP will figure that out and
(instead of loading it) will 'cd' to that directory, and display its
contents in the list window.

Above the list window is a pop-up menu button, much like the \fBDisplay
Modes\fP button in the \fIxv controls\fP window.  It normally displays the name
of the current directory.  If you click this button, and hold the
mouse down, the complete path will be shown, one directory per line.
You can go 'up' the directory tree any number of levels, all the way
up to the root directory, by simply selecting a directory name in this
list.

For those who prefer the direct approach, you can simply type file or
directory names in the "Load file" text entry region.  If you type a
directory name and hit <return>, \fIxv\fP will 'cd' to that directory and
display its contents in the list window.  If you type a file name and
hit <return>, \fIxv\fP will attempt to load the file.  You can enter
relative paths (relative to the currently displayed directory),
absolute paths, and even paths that begin with a '~'.

The "Load file" text entry region supports a number of emacs-like editing keys.
.IP
Ctrl-F	moves the cursor forward one character
.IP
Ctrl-B	moves the cursor backward one character
.IP
Ctrl-A	moves the cursor to the beginning of the line
.IP
Ctrl-E	moves the cursor to the end of the line
.IP
Ctrl-D	deletes the character to the right of the cursor
.IP
Ctrl-U	clears the entire line
.IP
Ctrl-K	clears from the cursor position to the end of the line.
.LP
If the filename is so long that it cannot be completely displayed in
the text entry region, a thick line will appear on the left or right
side (or both sides) of the region to show that "there's more over
this way".

Pressing the \fBRescan\fP button will rescan the current directory.
While the contents of the current directory are read each time the
load window is opened, it is perfectly possible (given a multitasking
operating system) that some other program may add, delete, or rename
files in the current directory.  \fIXV\fP would not know if this
happened.  The \fBRescan\fP button gives you an easy way of 'kicking'
\fIxv\fP into looking again.

.SH SECTION 7:  THE SAVE WINDOW

The \fIxv save\fP window lets you write images back to disk,
presumably after you've modified them.  You can write images back many
different formats, not just the original format.  \fBWarning!\fP  Images are
saved as they are currently shown (at the current size, with the
current color modification, rotation, cropping, etc. applied).  The
only exception to this rule is if you are on a 1-bit B/W display.
The fact that images have to be stippled in black and white in order
to be displayed on such a screen doesn't count as 'modification', and
the file won't be saved 'as displayed'.  You can manipulate and save
full-color images on such a display, even if you can't really see
them.

For the most part, the \fIxv save\fP window operates exactly like the 
\fIxv load\fP window.  (See "Section 6: The Load Window" for details.)  Only
the differences are listed here.

When the window is opened, it should have the filename of the
currently loaded file already entered into the text entry region.  If
you change directories, or click on a file name in the list window,
this name will be cleared and replaced with the new name.

At the bottom of the window are a list of possible formats in which
you can save the file.  If you click on one of these formats, and your
filename has a recognized suffix (i.e., '.gif', '.GIF', '.pbm', etc.),
the suffix portion of your filename will be replaced with the new,
appropriate suffix for the selected format.

You can pipe output from \fIxv\fP to other programs by using the \fIxv save\fP
window.  If the first character of the specified filename 
is '!' or '|', the rest of the filename is interpreted as a command to pipe
the output to, in the currently selected image format.
A fine use for this feature is directly printing images to a
PostScript printer by selecting 'PostScript' in the formats list, and
typing something like "| lpr" as the filename.  In this case, \fIxv\fP will
create a temporary file, write the PostScript to that file, and cat
the contents of that file to the entered command.  \fIXV\fP will wait for
the command to complete.  If the command completed successfully, the
\fIxv save\fP window will disappear.  If the command was unsuccessful, the
window will remain visible.  In any event, the temporary file will be
deleted.

There is a 'Save at normal size' checkbox.  Normally, when you 
save an image, it will be saved at the current expansion (ie,
one screen pixel will map to one image pixel in the saved file.  
Sometimes, however, it is desirable to save an image at its original size.
This is most relevant when you're viewing images larger than your
screen.  By default, \fIxv\fP will automatically shrink images
so that they fit on the screen.  If you save these images, you'll
find that you've lost a lot of data, that maybe you wanted to keep.
That's what this checkbox is here for.  Note:  certain operations,
such as \fBSmooth\fP and \fBDither\fP only affect the displayed image.
If you choose to save an image at its normal size, these effects will not 
be in the saved image.

At the bottom right side of the window there is a list of possible
\'Color' variations to save.  Most file formats support different
\'sub-formats' for 24-bit color, 8-bit greyscale, 1-bit B/W stippled,
etc.  Not all of them do.  Likewise, not all 'Color' choices are
available in all formats.

In general, the 'Color' choices do the following:

.IP "\fBFull Color\fP"
Saves the image as currently shown with all color modifications,
cropping, rotation, flipping, resizing, and smoothing.  The image will
be saved with all of its colors, even if you weren't able to display
them all on your screen.  For example, you can load a color image on a
1-bit B/W display, modify it, and write it back.  The saved image will
still be full color, even though all you could see on your screen was
some B/W-dithered nightmare.

.IP "\fBGreyscale\fP"
Like Full Color, but saves the image in a greyscale format.

.IP "\fBB/W Dithered\fP"
Like Full Color, but before saving the image \fIxv\fP generates a
1-bit-per-pixel, black-and-white dithered version of the image, and
saves that, instead.

.IP "\fBReduced Color\fP"
Saves the image as currently shown, with all color modifications,
cropping, rotation, flipping, resizing, and smoothing.  The image will
be saved as shown on the screen, with as many or few colors as \fIxv\fP was
able to use on the display.  The major purpose of this is to allow
special effects (color reduction) to be saved, in conjunction with the
\'-ncols' command line option.  You will probably never need to use
this.
.LP
Format notes:

.IP \fBGIF\fP
While \fIxv\fP can read both the GIF87a and GIF89a formats, it will only
write GIF87a.  This is in keeping with the GIF89 specification, which
states that if you don't need any of the features added in GIF89
(which \fIxv\fP doesn't), you should continue to write GIF87, for greater
compatibility with old GIF87-only readers.

Since GIF only supports one format (up to 8 bits per pixel, with a
colormap), there will be no size difference between a Full Color and a
Greyscale image.  A B/W Dithered image, on the other hand, will be
considerably smaller.

.IP \fBPM\fP
Full Color images are saved in the 3-plane, 1-band, PM_C format.
Greyscale and B/W Dithered images are both saved in the 1-plane,
1-band, PM_C format.  As such, there is no size advantage to saving in
the B/W Dithered format.

.IP "\fBPBM (raw)\fP"
Full Color images are saved in PPM format.  Greyscale images are saved
in PGM format.  B/W Dithered images are saved in PBM format.  Each of
these formats are tailored to the data that they save, so PPM images
are larger than PGM images, which are in turn larger than PBM images.

In the raw variation of the PBM formats, the header information is
written in plain ASCII text, and the image data is written as binary
data.  This is the more popular of the two dialects of PBM.

.IP "\fBPBM (ascii)\fP"
Like PBM (raw), only the image data is written as ASCII text.  As
such, images written in this format will be several times larger than
images written in PBM (raw).  This is a pretty good format for
interchange between systems because it is easy to parse.  Also, since
they are pure, printable ASCII text, images saved in this format can
be mailed, without going through a \fIuuencode\fP-like program.

Note that \fIxv\fP-produced PBM files may break some PBM readers that do not
correctly parse comments.  If your PBM reader cannot parse comments,
you can easily edit the PBM file and remove the comment lines.  A
comment is everything from a "#" character to the end of the line.

.IP "\fBX11 Bitmap\fP"
Saves files in the format used by the \fIbitmap\fP program, which is part
of the standard X11 distribution.  Since bitmap files are inherently
1-bit per pixel, you can only select the B/W Dithered option for this
format.

.IP "\fBSun Rasterfile\fP"
Full/Reduced Color images are stored in a 24-bit RGB format, Greyscale
images are stored in an 8-bit greyscale format, and B/W Dithered
images are stored in a 1-bit B/W format.

.IP "\fBPostScript\fP"
Full/Reduced Color images are stored in a 24-bit RGB format, Greyscale
images are stored in an 8-bit greyscale format, and B/W Dithered
images are stored in a 1-bit B/W format.

\fIXV\fP writes Encapsulated PostScript, so you can incorporate 
\fIxv\fP-generated
PostScript into many desktop-publishing programs.  \fIXV\fP also prepends
some color-to-greyscale code, so even if your printer doesn't support
color, you can still print 'color' PostScript images.  These images
will be three times larger (in file size) than their greyscale
counterparts, so it's a good idea to save Greyscale PostScript, unless
you know you may be printing the file on a color printer at some
point.

Also, you should probably never need to generate B/W Dithered
PostScript, as every PostScript printer I've ever heard of can print
greyscale images.  The only valid cases I can think of are: A) doing
it for a special effect, and B) doing it to generate a much smaller
(roughly 1/8th the size) PostScript file.

Note: When you try to save a PostScript file, the \fIxv postscript\fP window
will pop up to let you specify how you want the image printed.  (See
"Section 8: The PostScript Window", for details.)

.IP "\fBJPEG\fP"
\fIXV\fP writes files in the JFIF format created by the Independent JPEG
Group.  Full/Reduced Color images are written in a 24-bit RGB format,
and Greyscale images are written in an 8-bit greyscale format.  B/W
Dithered images should not be used, as they will probably wind up
being larger than Greyscale versions of the same images, due to the
way JPEG works.  Note:  You cannot write Reduced Color JPEG files.  If
you attempt to, a Full Color JPEG file will be saved.

When you save in the JPEG format, a dialog box will pop up and ask you
for a quality setting.  '75%' is the default value, and really, it's a
fine value.  You shouldn't have to change it unless you're
specifically trying to trade off quality for compression, or vice
versa.  The useful range of values is 5%-95%.

.IP "\fBTIFF\fP"
Full/Reduced Color images are written in a 24-bit RGB format, Greyscale images
are written in an 8-bit greyscale format, and B/W Dithered images are written 
in a 1-bit B/W format.

When you save in the TIFF format, a dialog box will pop up and ask you
which type of image compression it should use.  \fBNone\fP, \fBLZW\fP,
and \fBPackBits\fP compression types are available for Full/Reduced
Color, Greyscale, and B/W Dithered modes.  In addition, there are two
B/W Dithered-only algorithms, \fBCCITT Group3\fP and \fBCCITT
Group4\fP.

.SH SECTION 8:  THE POSTSCRIPT WINDOW

The \fIxv postscript\fP window lets you describe how your image should look
when printed.  You can set the paper size and the image size, position
the image on the paper, and print in 'portrait' or 'landscape' mode.

The majority of the \fIxv postscript\fP window is taken up by a window that
shows a white rectangle (the page) with a black rectangle (the image)
positioned on it.  You can position the image rectangle anywhere on
the page.  The only constraint is that the center of the image (where
the two diagonal lines meet) must remain on the page.  Only the
portion of the image that is on the page will actually be printed.

The image can be (roughly) positioned on the page by clicking in the
image rectangle and dragging it around.  As you move the image, the
"Top" and "Left" position displays will show the size of the top and
left margins (the distance between the top-left corner of the page and
the top-left corner of the image).

You'll note that you have limited placement resolution with the mouse.
If you want to fine-position the image, you can use the arrow keys to
move the image around.  The arrow keys will move the image in .001"
increments.  You can hold them down, and they will auto-repeat.  You
can also hold a <shift> key down while using the arrow keys.  This
will move the image in .01" increments.

You can change the size of the printed image by adjusting the "Width"
or "Height" dials.  Normally, the dials are locked together, to keep
the aspect ratio of the image constant.  You can unlock the dials by
turning the off the checkbox located below the dials.  As you change
the dials, the size of the image (when printed) is displayed below, in
inches and in millimeters.  The current resolution of the image is
also displayed below.  The "Resolution" numbers tell you how many
image pixels will be printed per inch.

Located below the 'page' rectangle are a set of radio buttons that let
you specify the current paper size (8.5" x 11", 8.5" x 14", 11" x 17",
A4, B5, 4"x5", and 35mm), and orientation (Portrait and Landscape).

The Center button will center the image on the page.  The Maxpect
button will make the image as large as possible (maintaining half-inch
margins on all sides) without changing the aspect ratio.

There are a pair of small buttons located next to the "Left" and "Top"
displays.  Clicking the "Left" one will cycle between displaying the
"Left" margin, the "Right" margin, and the "Center X" position (the
distance from the left edge of the paper to the center of the image).

Clicking the "Top" display's button will cycle between displaying the
size of the "Top" margin, the size of the "Bottom" margin, and the
"Center Y" position (the distance from the top edge of the paper to
the center of the image).

At the top of the \fIxv postscript\fP window are a pair of checkboxes.
The "preview" checkbox lets you specify whether or not to include a b/w 
preview of the image in the PostScript file.  Certain desktop
publishing programs may make use of such a preview.

The 'compress' checkbox lets you specify whether or not to generate compressed
8-bit PostScript.  This is particularly handy if you're generating
color PostScript as color PostScript files are normally three times
larger than their greyscale counterparts.  Compression can shrink these
color PostsScript files by a factor of 4:1.  It has a lesser effect on 
greyscale images.  It should be noted, however, that compressed PostScript
files may take 2-3 times longer to print than uncompressed PostScript files.  
However, if you are connected to your laser printer via a slow 9600 baud
serial line, the decreased transmission time due to compressed data may
more than make up for the increased execution time.  You'll have to decide
for yourself.

Click the "Ok" button when you're finished with the \fIxv
postscript\fP window.  If everything is successful, the \fIxv
postscript\fP and the \fIxv save\fP window will both close.  If
\fIxv\fP was unable to write the PostScript file, the \fIxv postscript\fP
window will close, but the \fIxv save\fP window will remain open, to give
you a chance to enter a different filename.

.SH SECTION 9:  MODIFYING XV BEHAVIOR

\fIXV\fP supports literally dozens of command line options and X11
resources.  Fortunately, it is doubtful that you'll ever need to use
more than a small few.  The rest are provided mainly for that 'one
special case' application of \fIxv\fP...

.SS Section 9.1:  Command Line Options Overview

If you start \fIxv\fP with the command 'xv -help', the current list of
options will be displayed:
.IP
xv [-] [-2xlimit] [-aspect \fIw:h\fP] [-bg \fIcolor\fP] [-black \fIcolor\fP]
.ti +0.5
[-bw \fIwidth\fP] [-cegeometry \fIgeom\fP] [-cemap] [-cgeometry \fIgeom\fP]
.ti +0.5
[-clear] [-cmap] [-cursor \fIchar#\fP] [-DEBUG \fIlevel\fP]
.ti +0.5
[-display \fIdisp\fP] [-dither] [-expand \fIexp\fP] [-fg \fIcolor\fP]
.ti +0.5
[-fixed] [-geometry \fIgeom\fP] [-help] [-hi \fIcolor\fP] [-hsv]
.ti +0.5
[-igeometry \fIgeom\fP] [-imap] [-keeparound] [-lo \fIcolor\fP] [-max]
.ti +0.5
[-maxpect] [-mono] [-ncols \fInc\fP] [-nglobal] [-ninstall]
.ti +0.5
[-nopos] [-noqcheck] [-owncmap] [-perfect] [-quit] [-rbg \fIcolor\fP]
.ti +0.5
[-rfg \fIcolor\fP] [-rgb] [-rmode \fPmode\fI] [-root] [-rw] [-slow24]
.ti +0.5
[-smooth] [-visual \fItype\fP] [-wait \fIseconds\fP] [-white \fIcolor\fP]
.ti +0.5
[-wloop] [-noresetroot] [-browse] [-nostat] [-best24] [-quick24]
.ti +0.5
[-cecmap] [-crop] [-rv] [-nolimits] [-loadclear] [filename ...]

.SS Section 9.2:  General Options

.IP "-help"
Print usage instructions, listing the current available command-line
options.  Any unrecognized option will do this as well.

.IP "-display \fIdisp\fP"
Specifies the display that \fIxv\fP should attempt to connect to.  If you
don't specify a display, \fIxv\fP will use the environment variable
\fI$DISPLAY\fP.

.IP "-fg \fIcolor\fP  (Resource name: foreground \fIstring\fP)"
Sets the foreground color used by the windows.

.IP "-bg \fIcolor\fP  (Resource name: background \fIstring\fP)"
Sets the background color used by the windows.

.IP "-hi \fIcolor\fP  (Resource name: highlight \fIstring\fP)"
Sets the highlight color used for the top-left edges of the control
buttons.

.IP "-lo \fIcolor\fP  (Resource name: lowlight \fIstring\fP)"
Sets the lowlight color used for the bottom-right edges of the control
buttons, and also the background of some windows.

.IP "-bw \fIbwidth\fP  (Resource name: borderWidth \fIinteger\fP)"
Sets the width of the border on the windows.  Your window manager may
choose to ignore this, however.

.SS Section 9.3:  Image Sizing Options

.IP "-geometry \fIgeom\fP  (Resource name: geometry \fIstring\fP)"
Lets you specify the size and placement of the 'image' window.  It's
most useful when you only specify a position, and let \fIxv\fP choose the
size.  If you specify a size as well, \fIxv\fP will create a window of that
size, unless -fixed is specified.  The geom argument is in the form of
a normal X geometry string (e.g. "300x240" or "+10+10" or
"400x300+10+10").

.IP "-fixed  (Resource name: fixed \fIboolean\fP)"
Only used in conjunction with the -geometry option.  If you specify a
window size with the -geometry option, \fIxv\fP will normally stretch the
picture to exactly that size.  This is not always desirable, as it may
seriously distort the aspect ratio of the picture.  Specifying the
-fixed option corrects this behavior by instructing \fIxv\fP to use the
specified geometry size as a maximum window size.  It will, however,
preserve the original aspect ratio of the picture.

For example, if you give a rectangular geometry of '320x240', and you
try to display a square picture with a size of '256x256', the window
opened will actually be '240x240', which is the largest square that
still fits in the '320x240' rectangle that was specified.

.IP "-expand \fIexp\fP  (Resource name: expand  \fIfloating-point\fP)"
Lets you specify an initial expansion or compression factor for the
picture.  You can specify floating-point values.  Values larger than
zero multiply the picture's dimensions by the given factor.  (i.e., an
expand factor of '3' will make a 320x200 image display as 960x600).

Factors less than zero are treated as reciprocals.  (i.e., an expand
factor of '-4' makes the picture 1/4th its normal size.).  '0' is not
a valid expansion factor.

.IP "-aspect \fIw:h\fP  (Resource name: aspect \fIstring\fP)"
Lets you set an initial aspect ratio, and also sets the value used by
the \fBAspect\fP control.  The aspect ratio of nearly every X display (and,
in fact, any civilized graphics display) is 1:1.  What this means is
that pixels appear to be 'square'.  A 100 pixel wide by 100 pixel high
box will appear on the screen as a square.  Unfortunately, this is not
the case with some screens and digitizers.  The -aspect option lets
you stretch the picture so that the picture appears correctly on your
display.  Unlike the other size-related options, this one doesn't care
what the size of the overall picture is.  It operates on a
pixel-by-pixel basis, stretching each image pixel slightly, in either
width or height, depending on the ratio.

Aspect ratios greater than '1:1' (e.g., '4:3') make the picture wider
than normal.  Aspect ratios less than '1:1' (e.g. '2:3') make the
picture taller than normal.  (Useful aspect ratio: A 512x480 image
that was supposed to fill a standard 4x3 video screen (produced by
many video digitizers) should be displayed with an aspect ratio of '5:4')

.SS Section 9.4:  Color Allocation Options

.IP "-ncols \fInc\fP  (Resource name: ncols \fIinteger\fP)"
Sets the maximum number of colors that \fIxv\fP will use.  Normally, this is
set to 'as many as it can get'.  However, you can set this to smaller
values for interesting effect.  Most notably, if you set it to '0', it
will display the picture by dithering with 'black' and 'white'.  (The
actual colors used can be set by the -black and -white options,
below.)

.IP "-nglobal (Resource name: nglobal \fIboolean\fP)"
Adjusts the way the program behaves when it is unable to get all the
colors it requested.  Normally, it will search the display's default
colormap, and 'borrow' any colors it deems appropriate.  These
borrowed colors are, however, not owned by \fIxv\fP, and as such, can
changed without \fIxv's\fP permission, or knowledge.  If this happens, the
displayed picture will change, in a less-than-desirable direction.  If
you specify the -nglobal option, \fIxv\fP will not use 'global' colors.  It
will only use colors that it successfully allocated, which makes it
immune to any color changes.

It should be noted that 'use global colors' is the default because
color changes aren't generally a problem if you are only using \fIxv\fP to
display a picture for a short time.  Color changes only really become
a problem if you use \fIxv\fP to display a picture that you will be keeping
around for a while, while you go and do some other work (such as using
\fIxv\fP to display a background).  In such cases you will want to specify
-nglobal.  Note: using the -ncols or -root options automatically turn
on -nglobal.

.IP "-rw  (Resource name: rwColor \fIboolean\fP)"
Tells \fIxv\fP to use read/write color cells.  Normally, \fIxv\fP
allocates colors
read-only, which allows it to share colors with other programs.  If
you use read/write color cells, no other program can use the colors
that \fIxv\fP is using, and vice-versa.  The only reason you'd do such a
thing is that using read/write color cells allows the Apply function
in the \fIxv color editor\fP window to operate much faster.

.IP "-perfect  (Resource name: perfect \fIboolean\fP)"
Makes \fIxv\fP try 'extra hard' to get all the colors it wants.  In
particular, when -perfect is specified, \fIxv\fP will allocate and install
its own colormap if (and only if) it was unable to allocate all the
desired colors.  This option is not allowed in conjunction with the
-root option.

.IP "-owncmap  (Resource name: ownCmap \fIboolean\fP)"
Like '-perfect', only this option forces \fIxv\fP to always allocate and
install its own colormap, thereby leaving the default colormap
untouched.

.IP "-cecmap  (Resource name: ceditColorMap \fIboolean\fP)"
Specifies whether \fIxv\fP installs the image's colormap in the
\fIxv color editor\fP window, as well as in the image's window.  By default,
the program does install the colormap in the color editor window, however
this can occasionally make the color editor window unreadable.  (This
option only apples when the '-perfect' or '-owncmap' options create their
own colormaps.)

.IP "-ninstall  (Resource name: ninstall \fIboolean\fP)"
Prevents \fIxv\fP from 'installing' its own colormap, when the -perfect or
-owncmap options are in effect.  Instead of installing the colormap,
it will merely 'ask the window manager, nicely' to take care of it.
This is the correct way to install a colormap (i.e., ask the WM to do
it), unfortunately, it doesn't actually seem to work in many window
managers, so the default behavior is for \fIxv\fP to handle installation
itself.  However, this has been seen to annoy one window manager
(\fIdxwm\fP), so this option is provided if your WM doesn't like programs
installing their own colormaps.

.SS Section 9.5:  24-bit Conversion Options

The following options only come into play if you are using \fIxv\fP to
display 24-bit RGB data (PPM files, color PM files, JPEG files, 
the output of \fIbggen\fP, etc.).  They have no effect whatsoever on how GIF
pictures or 8-bit greyscale images are displayed.

.IP "-quick24  (Resource name: quick24 \fIboolean\fP)"
Forces \fIxv\fP to use the 'quick' 24-bit to 8-bit conversion algorithm.
This algorithm dithers the picture using a fixed set of colors that span the
entire RGB colorspace.  In versions of \fIxv\fP prior to 2.10, this was the
default algorithm.  It no longer is.

.IP "-slow24  (Resource name: slow24 \fIboolean\fP)"
Specifies that the 'slow' 24-bit to 8-bit conversion algorithm is
to be used by the program.  This algorithm uses a version of Heckbert's
median cut algorithm to pick the 'best' colors on a per-image basis, and 
dithers with those.  This is the current default conversion algorithm.

Advantages: The -slow24 algorithm often produces better looking pictures
than the -quick24 algorithm.

Disadvantages: The -slow24 algorithm is about half the speed of 
the -quick24 algorithm.  Also, since the colors are chosen on a per-image
basis, it can't be used to display multiple images simultaneously, as
each image will almost certainly want a different set of 256 colors.
The -quick24 algorithm, however, uses the same exact colors for all
images, so it can display many images simultaneously, without running
out of colors.

.IP "-best24  (Resource name: best24 \fIboolean\fP)"
Forces \fIxv\fP to use the same algorithm used in the program \fIppmquant\fP,
written by Jef Poskanzer.  This algorithm also uses a version of Heckbert's
median cut algorithm, but is capable of picking 'better' colors than 
the -slow24 algorithm, and it \fIdoesn't\fP dither.

Advantages:  Generally produces slightly better images than the -slow24
algorithm.  Also, the images are undithered, so they look better when
expanded.

Disadvantages:  \fIMuch\fP slower than the -slow24 algorithm.  Like, 5 to 10
times slower.  The images produced aren't \fIthat\fP much better than those
produced by the -slow24 algorithm.

.IP "-noqcheck  (Resource name: noqcheck \fIboolean\fP)"
Turns off a 'quick check' that is normally made.  Normally, before
running either of the 24-bit to 8-bit conversion algorithms, \fIxv\fP
determines whether the picture to be displayed has more than 256
unique colors in it.  If the picture doesn't, it will treat the
picture as an 8-bit colormapped image (i.e., GIF), and won't run
either of the conversion algorithms.

Advantages: The pictures will be displayed 'perfectly', whereas if
they went through either of the conversion algorithms, they'd be
dithered.

Disadvantages: Often uses a lot of colors, which limits the ability to
view multiple images at once.  (See the -slow24 option above for
further info about color sharing.)

.SS Section 9.6:  Root Window Options

\fIxv\fP has the ability to display images on the root window of an X
display, rather than opening its own window (the default behavior).
When using the root window, the program is somewhat limited, because
the program cannot receive input events (key press and mouse clicks)
from the root window.  As a result, you cannot track pixel values, or
crop, nor can you use keyboard commands while the mouse is in the root
window.

.IP "-root  (Resource name:  <none>)"
Directs \fIxv\fP to display images in the root window, instead of
opening its own window.  Exactly how the images will be displayed in
the root window is determined by the setting of the -rmode option.

.IP "-rmode \fImode\fP	(Resource name: rootMode \fIinteger\fP)"
Determines how images are to be displayed on the root window, when
-root has been specified.  You can find the current list of 'modes' by
using a mode value of '-1'.  \fIXV\fP will complain, and show a list of
valid modes.  The current list at of the time of this writing is:
.RS
.IP
0:	tiling
.br
1:	integer tiling
.br
2:	mirrored tiling
.br
3:	integer mirrored tiling
.br
4:	centered tiling
.br
5:	centered on a solid background
.br
6:	centered on a 'warp' background
.br
7:	centered on a 'brick' background
.RE
.IP
The default mode is '0'.  See "Section 3.5: The Display Modes Menu"
for a description of the different display modes.

.IP "-noresetroot (Resource name: resetroot)"
Normally, when changing from root to window display mode, the
root is set to the standard X crosshatch pattern.
Using -noresetroot or setting resetroot to false will force the
root to remain.
This is useful when comparing between different tiled images.

.IP "-rfg \fIcolor\fP  (Resource name: rootForeground \fIstring\fP)"
Sets the 'foreground' color used in some of the root display modes.

.IP "-rbg \fIcolor\fP  (Resource name: rootBackground \fIstring\fP)"
Sets the 'background' color used in some of the root display modes.

.IP "-max  (Resource name: <none>)"
Makes \fIxv\fP automatically stretch the image to the full size of the
screen.  This is mostly useful when you want \fIxv\fP to display a
background.  While you could just as well specify the dimensions of
your display ('-geom 1152x900' for example), the -max option is
display-independent.  If you suddenly decide to start working on a
1280x1024 display (ferinstance) the same command will still work.
Note: If you specify -max when you aren't using -root, the behavior is
slightly different.  The image will be made as large as possible while
still preserving the normal aspect ratio.

.IP "-maxpect  (Resource name: <none>)"
Makes the image as large as possible while preserving the aspect
ratio.

.IP "-quit  (Resource name: <none>)"
Makes \fIxv\fP display the (first) specified file and exit, without any user
intervention.  Since images displayed on the root window remain there
until explicitly cleared, this is very useful for having \fIxv\fP display
background images on the root window in some sort of start-up script.
Needless to say, this is only useful if you are using -root.

.IP "-clear  (Resource name: <none>)"
Clears the root window of any extraneous \fIxv\fP images.  Note: it is not
necessary to do an 'xv -clear' before displaying another picture in
the root window.  \fIxv\fP will detect that there's an old image in the root
window and automatically clear it out (and free the associated
colors).

.SS Section 9.7:  Window Options

\fIXV\fP currently consists of three main windows, plus one window for the
actual image.  These three windows (the \fIxv controls\fP window, the \fIxv
info\fP window, and the \fIxv color editor\fP window) may be automatically
mapped and positioned when the program starts.

.IP "-cmap  (Resource name: ctrlMap \fIboolean\fP)"
Maps the \fIxv controls\fP window.

.IP "-cgeom \fIgeom\fP  (Resource name: ctrlGeometry \fIstring\fP)"
Sets the initial geometry of the \fIxv controls\fP window.  Note: only the
position information is used.  The window is of fixed size.

.IP "-imap  (Resource name: infoMap \fIboolean\fP)"
Maps the \fIxv info\fP window.

.IP "-igeom \fIgeom\fP  (Resource name: infoGeometry \fIstring\fP)"
Sets the initial geometry of the \fIxv info\fP window.  Note: only the
position information is used.  The window is of fixed size.

.IP "-cemap  (Resource name: ceditMap \fIboolean\fP)"
Maps the \fIxv color editor\fP window.

.IP "-cegeom \fIgeom\fP  (Resource name: ceditGeometry \fIstring\fP)"
Sets the initial geometry of the \fIxv color editor\fP window.  Note: only
the position information is used.  The window is of fixed size.

.IP "-nopos  (Resource name: nopos \fIboolean\fP)"
Turns off the 'default' positioning of the various \fIxv\fP windows.  Every
time you open a window, you will be asked to position it.  (Assuming
your window manager asks you such things.  \fImwm\fP, for instance doesn't
seem to ask)

.SS Section 9.8:  Miscellaneous Options

.IP "-mono  (Resource name: mono \fIboolean\fP)"
Forces the image to be displayed as a greyscale.  This is most useful
when you are using certain greyscale X displays.  While \fIxv\fP attempts to
determine if it's running on a greyscale display, many X displays lie,
and claim to be able to do color.  (This is often because they have
color graphics boards hooked up to b/w monitors.  The computer, of
course, has no way of knowing what type of monitor is attached.)  On
these displays, if you don't specify -mono, what you will see is a
greyscale representation of one of the RGB outputs of the system.
(For example, you'll see the 'red' output on our greyscale Sun 3/60s.)
The -mono option corrects this behavior.

.IP "-white \fIcolor\fP  (Resource name: white \fIstring\fP)"
Specifies the 'white' color used when the picture is b/w stippled.
(When '-ncols 0' has been specified.)

.IP "-black \fIcolor\fP  (Resource name: black \fIstring\fP)"
Specifies the 'black' color used when the picture is b/w stippled.
(When '-ncols 0' has been specified.)

Try something like: 'xv -ncols 0 -bl red -wh yellow <filename>' 
for some interesting, late-'60s-style psychodelia effects.

.IP "-wait \fIsecs\fP  (Resource name: <none>)"
Turns on a 'slide-show' feature.  Normally, if you specify multiple
input files, \fIxv\fP will display the first one, and wait for you to give
the \fBNext\fP command (or whatever).  The -wait option makes \fIxv\fP wait the
specified number of seconds, and then go on to the next picture,
without any user intervention.  The program still accepts commands, so
it's possible to 'abort' the current picture without waiting the full
specified time by using the \fBNext\fP command.

.IP "-wloop  (Resource name: <none>)"
Normally, when running a slide-show with the -wait option, \fIxv\fP will
terminate after displaying the last image.  If you also specify the
-wloop option, the program will loop back to the first image and
continue the slide-show until the user issues the Quit command.

.IP "-rgb  (Resource name: hsvMode \fIboolean\fP)"
Specifies that, by default, the colormap editing dials in the \fIxv color
editor\fP window should be in RGB mode.  This is the normal default
behavior.

.IP "-hsv  (Resource name: hsvMode \fIboolean\fP)"
Specifies that, by default, the colormap editing dials in the \fIxv color
editor\fP window should be in HSV mode.

.IP "-dither  (Resouce name: autoDither \fIboolean\fP)"
When specified, tells \fIxv\fP to automatically issue a \fBDither\fP command
whenever an image is first displayed.  Useful on displays with limited
color capabilities (4-bit and 6-bit displays.)

.IP "-smooth  (Resource name:  autoSmooth \fIboolean\fP)"
When specified, tells \fIxv\fP to automatically issue a \fBSmooth\fP command
whenever an image is first displayed.  This is useful when you are
using one of the image sizing options (such as '-expand' or '-max').

.IP "-crop  (Resource name: autoCrop \fIboolean\fP)"
When specified, tells \fIxv\fP to automatically issue an \fBAutoCrop\fP
command whenever an image is first displayed.

.IP "-visual \fIvistype\fP  (Resource name: visual \fIstring\fP)"
Normally, \fIxv\fP uses the default visual model provided by your X server.
You can override this by explicitly selecting a visual to use.  Valid
types are \fIStaticGray, StaticColor, TrueColor, GrayScale, PseudoColor,
\fP and \fIDirectColor\fP.  Not all of these are necessarily provided on any
given X display.  Run \fIxdpyinfo\fP on your display to find out what
visual types are supported.

.IP "-cursor \fIcurs\fP  (Resource name: cursor \fIinteger\fP)"
Specifies an alternate cursor to use in the image window (instead of
the normal 'cross' cursor).  curs values are obtained by finding the
character number of a cursor you like in the 'cursor' font.  (Run 'xfd
-fn cursor' to display the cursor font.)  For example, a curs value of
\'56' corresponds to the (singularly useless) 'Gumby' cursor.

.IP "-keeparound  (Resource name: keepAround \fIboolean\fP)
The '-keeparound' option is now poorly named, as I've changed the
default behavior.  Now, if you \fBDelete\fP the last file in the 
\fIxv controls\fP list, nothing unexpected will happen.  If you
specify the '-keeparound' option, which toggles the '-keeparound' flag
off, the program will automatically exit as a convenience.  It should
probably be renamed '-goaway' or something...

.IP "-2xlimit  (Resource name: 2xlimit \fIboolean\fP)"
By default, \fIxv\fP prevents the image window from ever getting larger than
the screen.  Unfortunately, because of this, if you load an image that
is larger than your screen, the image will be shrunk until it fits on
your screen.  Some folks find this undesirable behavior.  Specifying
the -2xlimit option doubles the size limitations.  The image window
will be kept from getting larger than 2x the width and height of your
screen.

Just in case you're wondering why there's any size limitations: it's
fairly easy to accidentally ask for a huge image to be generated.
Simply crop a section of the image, zoom so you can see the individual
pixels, and uncrop.  If there were no size limitations, the (expanded
many times) image could be huge, and might crash your X server.  At
the very least, it would take a long period of time, and freeze your X
server during part of it.  Generally undesirable behavior.

.IP "-nolimits  (Resource name: nolimites  \fIboolean\fP)"
For the truly daring, this turns off all limitations on the maximum
size of an image window.  (Well, there's still an X-imposed maximum
size of 64k by 64k, but that really shouldn't be a problem.)
Warning:  as mentioned above, it is fairly easy to accidentally
generate a huge image when you do an \fBUnCrop\fP command, and you
may well crash \fIxv\fP, your X server, the host machine, or all three.
Use At Your Own Risk!!!

.IP "-rv  (Resource name: reverse)"
Makes \fIxv\fP display a 'negative' of the loaded image.  White becomes
black, and black becomes white.  Color images will have 'interesting'
effects, as the RGB components are individually reversed.  For
example, \fIred\fP (255,0,0) will become \fIcyan\fP (0,255,255), 
\fIyellow\fP will become \fIblue\fP, and so on.

.IP "-DEBUG \fIlevel\fP  (Resource name: <none>)"
Turns on some debugging information.  You shouldn't need this.  If
everything worked perfectly, I wouldn't need this either.

.IP "-browse  (Resource name: browseMode \fIboolean\fP)"
Prevents the \fIxv load\fP window from being closed whenever you successfully
load a file.  This makes 'browsing' a directory somewhat more pleasant.

.IP "-nostat  (Resource name: nostat \fIboolean\fP)"
Turns off the stat() call is is performed for each file whenever you change
directories in the \fIxv load\fP and \fIxv save\fP windows.  This is useful
if you're on a machine with lots of remote files mounted on it, and you find
the directory switching to be too slow.

.IP "-loadclear  (Resource name: clearOnLoad \fIboolean\fP)"
If you were on a PseudoColor display, \fIxv\fP used to automatically clear
the image window (or the root window, if you were in a root mode),
whenever you loaded a new image.  This was to prevent the potentially
annoying/confusing 'rainbow' effect that happens when colormap entries
are freed and reallocated with different colors.  Ths has changed.
By default, \fIxv\fP no longer clears the image/root window.  This is
for two reasons:  I've decided that the rainbow effect is semi-entertaining,
in that it gives you something to look at while the next image is being
loaded.  Secondly, if you are viewing a series of images that have the same
colors in them, it's possible for \fIxv\fP to animate them (by using
the '-wait' command line option), albeit no faster than one frame every 1-2 
seconds.  For example, you can go get the satellite radar images from 
vmd.cso.uiuc.edu (in the directory 'wx'), run 'xv -wait 0 -wloop SA*',
and voila!  Just like the evening news!

.IP "-" 
Specifying '-' all by itself tells \fIxv\fP to take its input from
stdin, rather than from a file.  This lets you put \fIxv\fP on the end of a
Un*x pipe.

.SS Section 9.9:  Color Editor Resources

You can set default values for all of the HSV and RGB modification
controls in the \fIxv color editor\fP window via X resources.  The easiest
way to explain this is with an example.

.TP 3
\(bu
Start \fIxv\fP and put it in the background by typing 'xv &'.  
.TP
\(bu
Type the command 'cat >foo' in an active \fIxterm\fP window
.TP
\(bu
Bring the \fIxv color editor\fP window up.  
.TP
\(bu
Issue the \fBCut Resources\fP command.
.TP
\(bu
Click your \fIMiddle\fP mouse button in the \fIxterm\fP window.  A set
of resource lines describing the current state of the \fIxv color
editor\fP controls will be 'pasted' into the window.
.TP
\(bu
You could type '<ctrl-D>' in the \fIxterm\fP to complete the cat command,
edit this file, and put it in your .Xdefaults/.Xresources file.

.LP
The lines generated by \fBCut Resources\fP will look like the following:
.br
xv.default.huemap1: 330  30  CW 330  30  CW
.br 
xv.default.huemap2:  30  90  CW  30  90  CW
.br 
xv.default.huemap3:  90 150  CW  90 150  CW
.br 
xv.default.huemap4: 150 210  CW 150 210  CW
.br 
xv.default.huemap5: 210 270  CW 210 270  CW
.br 
xv.default.huemap6: 270 330  CW 270 330  CW
.br 
xv.default.whtmap:  0 0 1
.br 
xv.default.satval:  0
.br 
xv.default.igraf: S 4 : 0,0 : 64,64 : 192,192 : 254,254
.br 
xv.default.rgraf: S 4 : 0,0 : 64,64 : 192,192 : 254,254
.br 
xv.default.ggraf: S 4 : 0,0 : 64,64 : 192,192 : 254,254
.br 
xv.default.bgraf: S 4 : 0,0 : 64,64 : 192,192 : 254,254
.LP
These lines completely describe one state of the \fIxv color editor\fP
controls.  There are five different states that you can specify via X
resources.  The 'default' state (as shown) holds the settings used
whenever the program is first started, and whenever the Reset command
is used.  You can also store settings in one of the four \fIxv\fP presets
(accessed via the '1'-'4' buttons in the \fIxv color editor\fP) by changing
the string 'default' in the above lines to 'preset1', 'preset2',
\'preset3', or 'preset4' respectively.

There are four types of resource described in these lines: huemap,
whtmap, satval, and graf.

.SS Section 9.9.1:  Huemap Resources

The huemap resources describe the state of the hue remapping dials.
There are six huemap resources per state of the \fIxv color editor\fP.
These huemap resources are numbered 'huemap1', 'huemap2', ...
\'huemap6', and correspond to the '1'-'6' radio buttons under the hue
remapping dials.

Each huemap resources takes six parameters:
.IP "1." 3
The 'starting' angle of the From range, in degrees (integer).
.IP "2." 3
The 'ending' angle of the From range, in degrees (integer).
.IP "3." 3
The direction of the From range.  Either 'cw' (clockwise) 
or 'ccw' (counter-clockwise).
.IP "4." 3
The 'starting' angle of the To range, in degrees (integer).
.IP "5." 3
The 'ending' angle of the To range, in degrees (integer).
.IP "6." 3
The direction of the To range.  Either 'cw' or 'ccw'.

.SS Section 9.9.2:  Whtmap Resources

The whtmap resource describes the state of the white remapping
control.  There is one whtmap resource per state of the \fIxv color
editor\fP controls.  The whtmap resource takes three parameters:
.IP "1." 3
The hue to remap 'white' to, in degrees (integer).
.IP "2." 3
The saturation to give to the remapped 'white', in percent (integer).
.IP "3." 3
A boolean specifying whether the white remapping control is enabled.
If '1', the control is enabled.  If '0', the control is disabled.

.SS Section 9.9.3:  Satval Resource

The satval resource describes the value of the Saturation dial.  There
is one satval resource per state.  The satval resource takes a single
integer value, in the range +/-100, which specifies how much to add
or subtract to overall image color saturation.

.SS Section 9.9.4:  Graf Resources

The graf resources describe the state of the four 'graph' windows in
the \fIxv color editor\fP window (Intensity, Red, Green, and Blue).  The
graf resources can be in one of two formats, 'gamma' and
\'spline/line'.
.LP
In 'gamma' format, the graf resource takes two parameters:
.IP "1." 3
The letter 'G', specifying 'gamma' mode
.IP "2." 3
A single floating point number specifying the gamma value.

.LP
In 'spline/line' mode, the graf resource takes a variable number of parameters:
.IP "1." 3
The letter 'S' specifying 'spline' mode, or the letter 'L' specifying
\'line' mode.
.IP "2." 3
An integer number indicating the number of handles (control points)
that this graph window will have.  (Must be in the range 2-16,
inclusive.)
.IP "3." 3
For each handle, there will be a ':', and the x and y positions of the
handle, separated by a comma.  The x and y positions can be in the
range 0-255 inclusive.

.SS Section 9.9.5:  Other Resources

Also, there are the boolean resources 'autoApply', 'displayMods', 
and 'autoReset', which control the initial settings of the three
checkboxes in the \fIxv color editor\fP window.

There are also boolean resources 'saveNormal', 'pspreview', 
and 'pscompress' which control the initial settings of the checkboxes
in the \fIxv save\fP and \fIxv postscript\fP windows.

.SH LIMITATIONS
\fIxv\fP will NOT work on displays that aren't 1-, 2-, 4-, 6-, 8-, 16- 24-, 
or 32-bits
deep.  Luckily, that should still cover nearly every display out there.  It
may not work on certain 6- or 24-bit displays.
.PP
It also only displays the first image in GIF files that have multiple 
images in them.
.PP
As for PM pictures, this program only displays 1-plane PM_I pictures, or
1-, 3-, or 4-plane PM_C pictures.
.PP
.SH PM FORMAT
The PM format is a file format that we use at the GRASP Lab for our
image processing work.  If you aren't at Penn, you are unlikely to
ever run into a PM-format file, so don't worry about it.  Please
ignore all references to PM.
.PP BUGS
The 4-, 6-, 16-, 24-, and 32-bit code has not been extensively 
tested.  (A 4-bit MicroVax GPX system, a 6-bit HP 9000/320, a 16-bit Sony
3710, and a 
24-bit HP 9000/350, respectively.  The 32-bit code hasn't actually been 
tested at all.)  
You won't be able to do '\fB\-ncols\fP 0' on a 6-, 16-, 24-, or 32-bit 
display, not that you should want to.
.SH AUTHORS
John Bradley  -  bradley@cis.upenn.edu
.PP
GIF reading code based on gif2ras.c, by Patrick J. Naughton 
(naughton@wind.sun.com)
.PP
GIF writing code essentially unchanged from code written 
by Michael Maudlin (mlm@cs.cmu.edu).
.PP
SUN Rasterfile i/o code written by Dave Heath  (heath@cs.jhu.edu)
.PP
JPEG interface code written by Markus Baur  (s_baur@iravcl.ira.uka.de)
.PP
JPEG i/o code provided by the Independent JPEG Group.
.PP
TIFF i/o code and interface code written by Sam Leffler  (sam@sgi.com)
.PP
Portions of 'ppmquant' snarfed for the '-best24' algorithm.  
\fIppmquant\fP (and the rest of the \fIpbmplus\fP package) was written by
Jef Poskanzer.  (jef@well.sf.ca.us)
.PP
fsQuick code written and supplied by David B. Rosen  (rosen@cns.bu.edu).  
This code is a very fast implementation of Floyd-Steinberg dithering for
1-bit b/w displays.

