








                   JJJJOOOOVVVVEEEE MMMMaaaannnnuuuuaaaallll ffffoooorrrr UUUUNNNNIIIIXXXX UUUUsssseeeerrrrssss
                          VVVVeeeerrrrssssiiiioooonnnn 4444....11116666


                         Jonathan Payne
(with revisions by Doug Kingston, Mark Seiden and Charles Lindsey)






_1.  _I_n_t_r_o_d_u_c_t_i_o_n

JOVE* is an  advanced,  self-documenting,  customizable,  display
editor.   It  (and  this  tutorial introduction) are based on the
original EMACS editor  and  user  manual  written  at  M.I.T.  by
Richard Stallman|-.

JOVE is considered a display editor  because  normally  the  text
being  edited  is  visible on the screen and is updated automati-
cally as you type your commands.  What You See Is What You Get.

JOVE provides many facilities that go beyond simple insertion and
deletion.  Some of the more advanced features are:
        cut and paste (or kill and yank in our terminology);
        search and replace using regular-expressions;
        multiple files, buffers and windows available simultaneously;
        filling of text, both on demand and as you type;
        manipulation of words, lines, sentences and paragraphs;
        automatic indentation of programs;
        automatic location of procedure definitions;
        executing programs, capturing their output in buffers;
        automatic location of spelling and compilation errors;
        parenthesis matching.

JOVE is self-documenting insofar as you can call up  descriptions
of commands, variables and key bindings.





_________________________
*JOVE stands for Jonathan's Own Version of EMACS.
|- Although  JOVE  is meant to be compatible with EMACS,
and indeed many of the basic commands are very similar,
there  are  some  major  differences  between  the  two
editors, and you should  not  rely  on  their  behaving
identically.




                         March 19, 1996





2                  JOVE Manual for UNIX Users



JOVE is customizable insofar as you can
        change its behavior by changing appropriate variables;
        change its behavior by setting appropriate modes;
        automatically set the modes for a buffer from its filename;
        define macros to perform complex tasks;
        change the key bindings to match features of the particular keyboard.
All of these options can be exercised by the  system  administra-
tor, or by the user at startup, or even in the middle of a job.

Finally, mouse support is available (on screens which support the
X-Windows package from M.I.T.)  using the front end program _x_j_o_v_e
(or alternatively via the mouse-reporting facilities of the  ter-
minal emulator _x_t_e_r_m).

_2.  _T_h_e _O_r_g_a_n_i_z_a_t_i_o_n _o_f _t_h_e _S_c_r_e_e_n

JOVE divides the screen into several sections.

8_________________________________________________________________________________________________________________________
 #include <stdio.h>

 void main()
 {
     printf("Hello world!\n");
     return 0;                                               < the Window
 }

8____________________________________________________________
 JJJJOOOOVVVVEEEE ((((CCCC OOOOvvvvrrrrWWWWtttt))))   [[[[MMMMaaaaiiiinnnn::::1111]]]]  """"hhhheeeelllllllloooo....cccc""""  ****  ////hhhhoooommmmeeee////ffffoooooooo    11115555::::22223333 < the Mode Line
8____________________________________________________________
 : write-file (default hello.c) aloha.c[]                    < the Message Line
8_________________________________________________________________________________________________________________________
7|8|7|7|7|7|7|7|7|7|7|7|999999999999999999999|8|7|7|7|7|7|7|7|7|7|7|









9                                                           |8|7|7|7|7|7|7|7|7|7|7|999999999999999999999|8|7|7|7|7|7|7|7|7|7|7|











9_2._1.  _T_h_e _W_i_n_d_o_w

The Window section is used to display the text you  are  editing.
The  terminal's  cursor shows the position of _p_o_i_n_t, the location
at which editing takes place.  While the cursor appears to  point
_a_t a character, point should be thought of as between characters;
it points _b_e_f_o_r_e the character that the cursor appears to  be  on
top  of.   Terminals  have only one cursor, and when output is in
progress it must appear where the typing  is  being  done.   This
doesn't  mean  that  point is moving; it is only that JOVE has no
way of showing you the location of point except when the terminal
is  idle.  In the example, the user is in the middle of issuing a
_w_r_i_t_e-_f_i_l_e command, so the cursor is at the end  of  the  message
line.

_2._1._1.  _T_y_p_e_o_u_t

The lines of the window are usually available for displaying text
but  sometimes  are  pre-empted  by typeout from certain commands
(such as a listing of all the buffers).  You can always recognize
such  _t_y_p_e_o_u_t  because it is terminated by either an --------eeeennnndddd-------- line
or a --------mmmmoooorrrreeee-------- line.  Most of the time, output from commands  like



                         March 19, 1996





                   JOVE Manual for UNIX Users                   3


these  is  only  desired for a short period of time, usually just
long enough to glance at it.  When you have finished  looking  at
the output, you can type Space to make the text reappear (usually
a Space that you type inserts itself, but when there  is  typeout
in  the  window, it does nothing but get rid of that).  Any other
command executes normally, _a_f_t_e_r redrawing your text.

You will see --------mmmmoooorrrreeee-------- on the line above the last mode  line  when
typeout  from  a  command  is  too long to fit on the screen.  It
means that if you type a Space the next screenful of typeout will
be  printed.  If you are not interested, typing ^G will cause the
rest of the output to be discarded.  Typing any  other  key  will
discard  the rest of the output and that key will be taken as the
next keyboard input.  Similarly, --------eeeennnndddd-------- signifies  that  typeout
is complete; the same responses are accepted.

Sometimes you may wish to keep a permanent record of the  typeout
from  these commands.  To do this, set the variable _s_e_n_d-_t_y_p_e_o_u_t-
_t_o-_b_u_f_f_e_r to _o_n.  The typeout will then  be  put  into  a  newly-
created  buffer,  which  you  can  arrange to save to a permanent
file.

_2._2.  _T_h_e _M_o_d_e _L_i_n_e

The Mode Line gives information about the window above it.  There
is  a  variable _m_o_d_e-_l_i_n_e which determines the layout of the mode
line.  For the example above, this was set as  described  in  the
section on customizing JOVE.

((((CCCC OOOOvvvvrrrrWWWWtttt)))) shows that CCCC is the name of the current _m_a_j_o_r _m_o_d_e  and
that the Over Write _m_i_n_o_r _m_o_d_e is turned on.

At any time, JOVE can be in only one major mode.  Currently there
are  four  major  modes: _F_u_n_d_a_m_e_n_t_a_l, _T_e_x_t, _L_i_s_p and _C.  New ones
may be added in the future.

The words which indicate which minor modes are turned on are:
        AAAAbbbbbbbbrrrreeeevvvv meaning that _W_o_r_d _A_b_b_r_e_v mode is on;
        AAAAIIII meaning that _A_u_t_o _I_n_d_e_n_t mode is on;
        FFFFiiiillllllll meaning that _A_u_t_o _F_i_l_l mode is on;
        OOOOvvvvrrrrWWWWtttt meaning that _O_v_e_r _W_r_i_t_e mode is on;
        RRRROOOO meaning that _R_e_a_d _O_n_l_y mode is on.
        DDDDeeeeffff meaning that you are in the process of defining a keyboard macro.
        This is not really a mode, but it's useful to be reminded about it.
The meanings of these modes are described later in this document.

[[[[MMMMaaaaiiiinnnn::::1111]]]] shows that the name of the currently selected _b_u_f_f_e_r  is
MMMMaaaaiiiinnnn and its number is 1111.  Each buffer has its own name and holds
a file being edited, which is how JOVE can hold several files  at
once.   But  at  any given time you are editing only one of them,
the _s_e_l_e_c_t_e_d buffer.  When we speak of what some command does  to
"the buffer", we are talking about the currently selected buffer.
Multiple buffers make it easy to switch  around  between  several
files,  and  then  it is very useful that the mode line tells you



                         March 19, 1996





4                  JOVE Manual for UNIX Users


which one you are editing at any time.

""""hhhheeeelllllllloooo....cccc"""" shows the name of the file being edited in buffer MMMMaaaaiiiinnnn.
This  is  also  the  default  filename for commands that expect a
filename as input, as can be seen in the message line which  fol-
lows.

The * in the mode line means that there are changes in the buffer
that have not been saved in the file.  If the buffer had not been
changed since it was read in or last  saved,  there  would  be  a
minus instead.

Sometimes a file is changed  ``behind  JOVE's  back'':  something
changes  the  file (not the buffer) after it has been loaded into
or saved from a buffer.  This can be  quite  dangerous,  so  JOVE
tests  for  this  when it reads, writes, or finds the file.  JOVE
indicates the problem by displaying a # before the change indica-
tor.  It also asks for confirmation before performing the read or
write.

////hhhhoooommmmeeee////ffffoooooooo shows the name of the current directory.

11115555....22223333 shows the time.

_2._3.  _T_h_e _M_e_s_s_a_g_e _L_i_n_e

The Message Line  is  reserved  for  printing  messages  and  for
accepting  input  from  the  user,  such  as  filenames or search
strings.  When JOVE prompts  for  input,  the  cursor  will  tem-
porarily  appear  on  the  bottom line, waiting for you to type a
string.  When you have finished typing your input, you can type a
Return to send it to JOVE.  If you change your mind about running
the command that is waiting for input, you can type ^G to  abort,
and you can then continue with your editing.

The message line and the list of filenames from the shell command
that  invoked  JOVE  are  kept in a special buffer called _M_i_n_i_b_u_f
that can be edited like any other buffer.  It is  instructive  to
view  the  Minibuf  in  a window and to observe how it changes as
parameters to commands are typed, and as the ^N and ^P  functions
are invoked.

_2._4.  _M_u_l_t_i_p_l_e _W_i_n_d_o_w_s

The window area, described above,  can  in  fact  be  split  into
several  _w_i_n_d_o_w_s,  each  showing  a different _b_u_f_f_e_r, or possibly
different parts of the same buffer.  Each window has its own mode
line  beneath it.  The methods of creating and destroying windows
will be described presently.

_3.  _I_n_p_u_t _C_o_n_v_e_n_t_i_o_n_s






                         March 19, 1996





                   JOVE Manual for UNIX Users                   5


_3._1.  _K_e_y_b_o_a_r_d _U_s_a_g_e

In this manual, "Control" characters (that  is,  characters  that
are  typed  with  the  Control key and some other key at the same
time) are represented by a circumflex  (^)  followed  by  another
character.   Thus,  ^A  is  the character you get when you type A
with the Control key (sometimes labeled CTRL) held down.  Control
characters  in  the JOVE buffer are displayed with a caret; thus,
^A for Control-A.  DEL is displayed as ^?, ESC as ^[.

If the keyboard has extra keys, such as Function keys, Arrow keys
and the like, then JOVE can be customized to use them.

_3._2.  _T_h_e _C_h_a_r_a_c_t_e_r _S_e_t

JOVE normally accepts the ASCII character set, with its 95 print-
ing  characters,  including Space, (which appear on the screen as
themselves) and its 33 Control characters (which, except for TAB,
appear  on  the  screen  as, e.g. "^C").  There are, however, two
characters that may not appear.  One is the NL character (because
it  is always converted into a _l_i_n_e-_s_e_p_a_r_a_t_o_r, which is not quite
a character) and the other is the NUL  character  (^@)  which  is
used  internally  within JOVE to delimit lines (lines also have a
maximum length, which is 1023 in most systems).

However, JOVE is "8-bit clean", so if your keyboard  is  able  to
produce  all  256 8-bit characters, the extra ones will appear in
octal (e.g.  "\277").  Moreover, if your UNIX |-  system  supports
the  _L_o_c_a_l_e  facility  (as  most modern ones do), you may set the
variable _l_c-_c_t_y_p_e to "C" (the default, which corresponds to  pure
ASCII),  or  to  "iso_8859_1"  (which  corresponds to the Latin-1
alphabet with a total of 192 printing characters,  all  of  which
JOVE should be able to display), or to any other _L_o_c_a_l_e available
on your system.  The initial value of _l_c-_c_t_y_p_e is taken from your
LC_CTYPE  environment  variable,  and  otherwise defaults to "C".
With each _L_o_c_a_l_e JOVE will know which of the extra characters are
upper-case letters, lower-case letters, etc.

_3._3.  _N_a_m_e _C_o_m_p_l_e_t_i_o_n

JOVE knows the names of all sorts of objects, such as  JOVE  Com-
mands,  JOVE  Variables,  Macros, Keymaps, Buffers and even (with
some help from the UNIX directories) Files.  Since names must  be
entered often, JOVE has features to make this easier.

For many names, JOVE is willing to supply a default if you  enter
an empty answer.  For example, when you are telling _s_e_l_e_c_t-_b_u_f_f_e_r
which buffer to select, it will default to the  previous  buffer.
When  the  prompt mentions a default, this is the value that will
be used in place of an empty answer.

_________________________
|- UNIX is a trademark of Bell Laboratories.




                         March 19, 1996





6                  JOVE Manual for UNIX Users


If the default isn't the name you want, name completion can  help
you  enter  a  name.   When you are prompted for a name, you need
type only enough letters to make it unambiguous.  At any point in
the  course of typing the name, you can type question mark (?) to
see a list of all the relevant names which begin with the charac-
ters you have already typed; you can type Tab to have JOVE supply
as many characters as it can; or you can type Return to terminate
your  input, or you can type Space to do both (supply the charac-
ters and terminate).  For example, you are typing a  Command  and
you  have so far typed the letters "_a_u" and you then type a ques-
tion mark, you will see the list
           auto-execute-command
           auto-execute-macro
           auto-fill-mode
           auto-indent-mode
If you type a Return at this point, JOVE will complain by ringing
the bell, because the letters you have typed do not unambiguously
specify a single command.  But if you type  Tab  or  Space,  JOVE
will  supply the characters "_t_o-" because all commands that begin
"_a_u" also begin "_a_u_t_o-".  You could then type the letter "f" fol-
lowed by either Space or Return, and JOVE would complete and obey
the entire command.

There are in fact two cases that can arise.

1.   _T_h_e _n_a_m_e _y_o_u _a_r_e _t_y_p_i_n_g _i_s _s_u_p_p_o_s_e_d _t_o _e_x_i_s_t  _a_l_r_e_a_d_y  (Com-
     mands,  Variables  and  Keymaps  always,  Macros and Buffers
     except when you are trying to create a new one).
     If you type Return and what you have typed is not an unambi-
     guous  prefix  of  any name of the right kind, you will hear
     the bell; otherwise, it will complete what  you  have  typed
     and  then  use  it.   Tab will complete what it can (you can
     then type Return if it looks right).   Space  will  complete
     what it can and use it if it then matches.

2.   _T_h_e _n_a_m_e _y_o_u _a_r_e _t_y_p_i_n_g _m_a_y _b_e _a _n_e_w _o_n_e (Files always, Mac-
     ros  (including  the  Keyboard Macro) and Buffers if you are
     allowed to create or rename one at that point).
     If you type Return, and it does not match any name, then  it
     will  take  exactly  what you have typed as a new name.  Tab
     and Space try to complete as before.

If you type ^R, it will insert a name that might be useful.  Even
if  this  name is not the one you wish to enter, it is often con-
venient to edit this name into the  desired  one.   The  inserted
name  will be the default (if there is one), or the current value
(if there is one).  When JOVE is asking for a command or variable
name, ^R will insert the last one named.

Buffers, keymaps, and macros are also numbered (if you  type  "?"
when first prompted, you will see the numbers as well as the pos-
sible names), and the number may be used in place of the name.





                         March 19, 1996





                   JOVE Manual for UNIX Users                   7


_3._3._1.  _F_i_l_e_n_a_m_e _C_o_m_p_l_e_t_i_o_n

Whenever JOVE is prompting you for a filename, say in  the  _f_i_n_d-
_f_i_l_e  command,  things happen as just described and Return always
accepts the name just as it is (because you might be  wanting  to
create  a  new  file  with  a name similar to that of an existing
one).  The variable _b_a_d-_f_i_l_e_n_a_m_e-_e_x_t_e_n_s_i_o_n_s contains  a  list  of
words separated by spaces which are to be considered bad filename
extensions; any filename with one of these extensions will not be
counted  in filename completion.  The default includes ".o" so if
you have jove.c and jove.o in the same  directory,  the  filename
completion  will  not  complain  of  an ambiguity because it will
ignore jove.o.

When JOVE is prompting for a _f_i_l_e_n_a_m_e, it has the following extra
functions:

^N   Insert the next filename from the argument list in the Mini-
     buf.

^P   Insert the previous filename from the argument list  in  the
     Minibuf.

_4.  _C_o_m_m_a_n_d_s _a_n_d _V_a_r_i_a_b_l_e_s

_4._1.  _C_o_m_m_a_n_d_s

JOVE uses _c_o_m_m_a_n_d_s which have long names such as _n_e_x_t-_l_i_n_e.  Then
_k_e_y_s  such  as  ^N  are connected to commands through the _c_o_m_m_a_n_d
_d_i_s_p_a_t_c_h _t_a_b_l_e.  When we say that ^N  moves  the  cursor  down  a
line, we are glossing over a distinction which is unimportant for
ordinary use, but essential for simple customization:  it is  the
command  _n_e_x_t-_l_i_n_e  which  knows  how to move down a line, and ^N
moves down a line because it is connected to that  command.   The
name  for this connection is a _b_i_n_d_i_n_g; we say that the key ^N _i_s
_b_o_u_n_d _t_o the command _n_e_x_t-_l_i_n_e (or vice versa).   JOVE  has  many
bindings already _b_u_i_l_t-_i_n, but you (or your system administrator)
may also add your own, e.g. to make full use of any Function Keys
provided on your particular keyboard.

Thus there may be three ways to refer to a command - by its  full
name,  or  by its standard (built-in) binding, or by your custom-
ized binding.  Throughout this manual, we shall  always  use  the
standard  bindings,  followed by the full name (in italics).  The
standard bindings are designed to work on any ASCII keyboard, and
can  always be used so long as you (or your system administrator)
have not actually changed them.  But they are hard  to  remember,
so  you  may  well  prefer  to  use your own, particularly if you
always use the same terminal.  See the section  on  Customization
for more details.

Some terminals and modems cannot accept characters flat out at  a
reasonable  baud  rate,  and  therefore require the use of a flow
control protocol using the characters ^S and ^Q (see the variable



                         March 19, 1996





8                  JOVE Manual for UNIX Users


_a_l_l_o_w-^_S-_a_n_d-^_Q).   These  characters cannot, therefore, be typed
by the user.  It has therefore  been  arranged  that  whenever  a
standard  binding  requires ^S (^Q) to be typed, a spare standard
binding for that facility is also provided in which ^\  (^^)  can
be typed in its place.

Not all commands are bound to keys.  To  invoke  a  command  that
isn't  bound  to a key, you can type the sequence ESC X, which is
bound to the command _e_x_e_c_u_t_e-_n_a_m_e_d-_c_o_m_m_a_n_d.   You  will  then  be
able  to type the name of whatever command you want to execute on
the message line.

_4._2.  _P_r_e_f_i_x _C_h_a_r_a_c_t_e_r_s

Because there are more command names than  keys,  JOVE  allows  a
sequence  of  keystrokes  to be bound to a command.  Usually, the
first character of the sequence will be one  of  the  two  _p_r_e_f_i_x
_c_h_a_r_a_c_t_e_r_s ^X or ESC.  When you type such a prefix character JOVE
will wait for the next character before deciding what to do.   If
you  wait  more  than  a second or so, JOVE will print the prefix
character on the message line as a reminder and leave the  cursor
down  there  while  you type the rest of the sequence.  Many JOVE
commands are bound to a 2-stroke sequence  starting  with  ^X  or
ESC.   How  the next character is interpreted depends on which of
them you typed.  For example, if you type ESC followed by  B  you
will run _b_a_c_k_w_a_r_d-_w_o_r_d, but if you type ^X followed by B you will
run _s_e_l_e_c_t-_b_u_f_f_e_r.

_4._3.  _V_a_r_i_a_b_l_e_s

Sometimes the description of a command will say "to change  this,
set  the  variable  _m_u_m_b_l_e-_f_o_o".   A  variable  is a name used to
remember a value.  JOVE contains variables  which  are  there  so
that  you  can  change  them  if  you  want  to  customize.   The
variable's value may be examined by some  command,  and  changing
that  value  makes  the command behave differently.  However, the
facilities provided are pretty limited:  you  cannot  invent  new
variables,  or  use  them for other than their built-in purposes,
and their values apply globally to all  buffers  irrespective  of
mode settings.

            _s_e_t                   Sets the value of a variable.
            _p_r_i_n_t                 Displays the current value of a variable.

To set or  change  the  value  of  a  variable,  type  ESC X  _s_e_t
<variable-name>  <value><return>.   Values  may be _o_n of _o_f_f (for
Boolean variables) or  numbers  (numeric  variables)  or  strings
(string  variables).  To inspect the current value of a variable,
type ESC X print <variable-name><return>.

_4._4.  _G_i_v_i_n_g _N_u_m_e_r_i_c _A_r_g_u_m_e_n_t_s _t_o _J_O_V_E _C_o_m_m_a_n_d_s

Many JOVE commands can be given a _n_u_m_e_r_i_c  _a_r_g_u_m_e_n_t.   Many  com-
mands  interpret  the  argument  as  a repetition count (possibly



                         March 19, 1996





                   JOVE Manual for UNIX Users                   9


negative).  For example, giving an argument of ten to the ^F com-
mand  (_f_o_r_w_a_r_d-_c_h_a_r_a_c_t_e_r)  moves  forward  ten  characters.  With
these commands, no argument is equivalent to an argument of 1.

Some commands use the value of the argument,  or  even  just  its
presence  or absence, in highly idiosyncratic ways.  For example,
the commands which change the minor  modes  (such  as  _a_u_t_o-_f_i_l_l-
_m_o_d_e)  toggle the mode if there is no argument, but turn the more
off with a zero argument, and on with any other argument.

The fundamental way of specifying an argument is to use ESC  fol-
lowed  by  the digits of the argument, for example, ESC 123 ESC G
to go to line 123.  Negative arguments are allowed, although  not
all commands know what to do with them.  Unless otherwise stated,
ESC Minus ... is equivalent to ESC Minus 1 ... .  Note that  when
giving  arguments to _s_o_u_r_c_e_d commands (described later under Cus-
tomization) different rules apply.

Typing ^U means "supply an argument of 4".  Two such ^U's  supply
sixteen.   Thus, ^U ^U ^F moves forward sixteen characters.  This
is a good way to move forward quickly, since it moves  about  1/4
of  a line on most terminals.  Other useful combinations are:  ^U
^U ^N (move down a good fraction of the screen),  and  ^U  ^U  ^O
(make "a lot" of blank lines).

There are other, terminal-dependent,  ways  of  specifying  argu-
ments.   They have the same effect but may be easier to type.  If
your terminal has a numeric keypad which sends  something  recog-
nizably  different  from  the  ordinary digits, it is possible to
customize JOVE to allow use of the numeric keypad for  specifying
arguments.

_4._5.  _H_e_l_p

To get a list of keys and their  associated  commands,  you  type
ESC X  _d_e_s_c_r_i_b_e-_b_i_n_d_i_n_g_s  (warning: the list runs to many screen-
fuls; type Space to see the next one, or ^G when  you  have  seen
enough).   If  you want to describe a single key, ^X ? (_d_e_s_c_r_i_b_e-
_k_e_y) will work.  A description of an individual command is avail-
able by using ESC ? (_d_e_s_c_r_i_b_e-_c_o_m_m_a_n_d), and descriptions of vari-
ables by using ESC X _d_e_s_c_r_i_b_e-_v_a_r_i_a_b_l_e.  If  you  can't  remember
the  name of the thing you want to know about, ESC X _a_p_r_o_p_o_s will
tell you if a command or variable has a given string in its name.
For  example,  ESC X  _a_p_r_o_p_o_s _d_e_s_c_r_i_b_e will list the names of the
four describe commands just mentioned.

_5.  _B_a_s_i_c _E_d_i_t_i_n_g _C_o_m_m_a_n_d_s


_5._1.  _I_n_s_e_r_t_i_n_g _T_e_x_t

To insert printing characters into the text, just type them.  All
such  printing  characters you type are inserted into the text at
the cursor (that is, at _p_o_i_n_t), and  the  cursor  moves  forward.



                         March 19, 1996





10                 JOVE Manual for UNIX Users


Any characters after the cursor move forward too.  If the text in
the buffer is FOOBAR, with the cursor before the B, then  if  you
type XX you get FOOXXBAR, with the cursor still before the B.

To correct text you have just inserted, you  can  use  DEL.   DEL
deletes  the  character  _b_e_f_o_r_e  the cursor (not the one that the
cursor is on top of or under; that is  the  character  _a_f_t_e_r  the
cursor).   The cursor and all characters after it move backwards.
Therefore, if you typing a printing character and then type  DEL,
they cancel out.

To end a line and start typing a new one,  type  Return.   Return
operates  by inserting a _l_i_n_e-_s_e_p_a_r_a_t_o_r, so if you type Return in
the middle of a line, you break  the  line  in  two.   Because  a
line-separator  behaves like a single character, you can type DEL
at the beginning of a line to delete the line-separator and  join
it  with the preceding line.  Note that the line separator is nnnnooootttt
a character (it is not the ASCII NL character,  for  example)  so
that you cannot include it in search or replace strings.

As a special case, if you type Return at the end of  a  line  and
there  are  two  or more empty lines just below it, JOVE does not
insert a line-separator but instead  merely  moves  to  the  next
(empty)  line.   This behavior is convenient when you want to add
several lines of text in the middle of a buffer.  You can use the
^O  (_n_e_w_l_i_n_e-_a_n_d-_b_a_c_k_u_p) command to "open" several empty lines at
once; then you can insert the new text, filling  up  these  empty
lines.   The  advantage  is that JOVE does not have to redraw the
bottom part of the screen for each Return you type, as  it  would
ordinarily.  That "redisplay" can be both slow and distracting.

If you add too many characters to one line, without  breaking  it
with Return, the line will grow too long to display on one screen
line.  When this happens, JOVE puts an "!" at the  extreme  right
margin, and doesn't bother to display the rest of the line unless
the cursor happens to be in it.  The "!"  is  not  part  of  your
text;  conversely,  even  though  you  can't see the rest of your
line, it is still there, and if you break the line, the "!"  will
go away.

Direct insertion works for printing  characters  and  space,  but
other  characters act as editing commands and do not insert them-
selves.  If you need to insert a control character, ESC, or  DEL,
you  must first _q_u_o_t_e it by typing the ^Q command (_q_u_o_t_e_d-_i_n_s_e_r_t)
first, for example ^Q ^C to insert a genuine ^C.

_5._2.  _M_o_v_i_n_g _t_h_e _C_u_r_s_o_r

To do more than insert characters, you have to know how  to  move
the cursor.  Here are the commands for doing that.

^A          _b_e_g_i_n_n_i_n_g-_o_f-_l_i_n_e     Move to the beginning of the line.
^E          _e_n_d-_o_f-_l_i_n_e           Move to the end of the line.
^F or ->    _f_o_r_w_a_r_d-_c_h_a_r_a_c_t_e_r     Move forward over one character.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  11


^B or <-    _b_a_c_k_w_a_r_d-_c_h_a_r_a_c_t_e_r    Move backward over one character.
^N or |v     _n_e_x_t-_l_i_n_e
7                                  Move down  one  line,  vertically.   If  you
                                  start  in the middle of one line, you end in
                                  the middle of the next.
^P or |^     _p_r_e_v_i_o_u_s-_l_i_n_e         Move up one line, vertically.
ESC <       _b_e_g_i_n_n_i_n_g-_o_f-_f_i_l_e     Move to the beginning of the entire buffer.
ESC >       _e_n_d-_o_f-_f_i_l_e           Move to the end of the entire buffer.
ESC ,       _b_e_g_i_n_n_i_n_g-_o_f-_w_i_n_d_o_w   Move to the beginning of the visible window.
ESC ....       _e_n_d-_o_f-_w_i_n_d_o_w         Move to the end of the visible window.
^Z          _s_c_r_o_l_l-_u_p
7                                  Move the lines in the  window  upwards.   If
                                  this  brings  the cursor outside of the win-
                                  dow, it is automatically relocated.
ESC Z       _s_c_r_o_l_l-_d_o_w_n           Move the lines in the window downwards.
Observe the use of the arrow keys (->, <-, |v and |^)  as  alterna-
tives  for  ^F, ^B, ^N and ^P.  These should be available on just
about any terminal.  You (or your system administrator) may  find
it  convenient to bind other Function Keys available on your key-
board to some of these commands, especially if those keys already
have  appropriate engravings on them.  See the section on Custom-
izing JOVE.

_5._3.  _D_e_l_e_t_i_n_g _T_e_x_t

DEL         _d_e_l_e_t_e-_p_r_e_v_i_o_u_s-_c_h_a_r_a_c_t_e_r  Delete the character before the cursor.
^D          _d_e_l_e_t_e-_n_e_x_t-_c_h_a_r_a_c_t_e_r      Delete the character after the cursor.
ESC \       _d_e_l_e_t_e-_w_h_i_t_e-_s_p_a_c_e         Delete spaces and tabs around point.
^X ^O       _d_e_l_e_t_e-_b_l_a_n_k-_l_i_n_e_s         Delete blank lines around the current line.

You already know about the DEL command which deletes the  charac-
ter  _b_e_f_o_r_e the cursor.  Another command, ^D, deletes the charac-
ter _a_f_t_e_r the cursor, the one  the  cursor  is  "on  top  of"  or
"underneath",  causing  the rest of the text on the line to shift
left.  Line-separators act like normal characters  when  deleted,
so  if  ^D  is typed at the end of a line, that line and the next
line are joined together.

The other delete commands are those which delete only  formatting
characters:   spaces,  tabs, and line-separators.  ESC \ (_d_e_l_e_t_e-
_w_h_i_t_e-_s_p_a_c_e) deletes all the spaces and tab characters before and
after  point.  ^X ^O (_d_e_l_e_t_e-_b_l_a_n_k-_l_i_n_e_s) deletes all blank lines
after the current line, and if the current line is blank  deletes
all  the  blank lines preceding the current line as well (leaving
one blank line, the current line).

_5._4.  _F_i_l_e_s - _S_a_v_i_n_g _Y_o_u_r _W_o_r_k

The commands above are sufficient for creating text in  the  JOVE
buffer.  The more advanced JOVE commands just make things easier.
But to keep any text permanently you must put  it  into  a  _f_i_l_e.
Files  are  the  objects  which  UNIX uses for storing data for a
length of time.  To tell JOVE to read text into a file, choose  a
filename,  such as _f_o_o._b_a_r, and type ^X ^F _f_o_o._b_a_r<return> (_f_i_n_d-
_f_i_l_e).  This reads the file _f_o_o._b_a_r so that its  contents  appear
in  a  new buffer on the screen for editing.  Alternatively, type



                         March 19, 1996





12                 JOVE Manual for UNIX Users


^X ^R _f_o_o._b_a_r<return> (_r_e_a_d-_f_i_l_e) to have the file appear  in  an
existing buffer.  You can make changes, and then save the file by
typing ^X ^S (_s_a_v_e-_f_i_l_e).  This makes the changes  permanent  and
actually  changes  the file _f_o_o._b_a_r.  Until then, the changes are
only inside JOVE, and the file _f_o_o._b_a_r is not really changed.  If
the  file _f_o_o._b_a_r does not exist, and you want to create it, read
it as if it did exist.  When you save your text with  ^X ^S,  the
file will be created then.

_5._5.  _E_x_i_t_i_n_g _a_n_d _P_a_u_s_i_n_g - _L_e_a_v_i_n_g _J_O_V_E

The command ^X ^C (_e_x_i_t-_j_o_v_e) will terminate the JOVE session and
return  to the shell.  If there are modified but unsaved buffers,
JOVE will ask you for confirmation, and you can  abort  the  com-
mand,  look  at what buffers are modified but unsaved using ^X ^B
(_l_i_s_t-_b_u_f_f_e_r_s), save the valuable ones, and then exit.   If  what
you  want  to  do,  on the other hand, is to _p_r_e_s_e_r_v_e the editing
session but return to the shell temporarily you can  (under  most
modern versions of UNIX) issue the command ESC S (_p_a_u_s_e-_j_o_v_e), do
your UNIX work within your shell, and then return to  JOVE  using
the  _f_g  command to resume editing at the point where you paused.
Alternatively, for this sort of  situation,  you  might  consider
using  an  _i_n_t_e_r_a_c_t_i_v_e  _s_h_e_l_l (that is, a shell in a JOVE window)
which lets you use the editor to issue  your  UNIX  commands  and
manipulate  their  output,  while  never  leaving the editor (the
interactive shell feature is described later).

_6.  _K_i_l_l _a_n_d _Y_a_n_k (_o_r _C_u_t _a_n_d _P_a_s_t_e)

Any editor needs a facility for dealing with large blocks of text
- deleting them or moving them to other places.  The usual termi-
nology speaks of "Cut" (to remove a block of text),  "Paste"  (to
replace  it somewhere else) and "Copy" (to copy it for subsequent
pasting without removal from its original place).  For historical
reasons, editors based on EMACS use the terms Kill, Yank and Copy
with essentially the same meanings, and we shall continue  to  do
so in this manual.  However, it may be sensible, if your keyboard
has keys marked Cut, Paste and Copy, to  bind  appropriate  Kill,
Yank  and  Copy commands to them as part of your local customiza-
tion.

_6._1.  _T_h_e _M_a_r_k _a_n_d _t_h_e _R_e_g_i_o_n

In general, a command that processes an  arbitrary  part  of  the
buffer must know where to start and where to stop.  In JOVE, such
commands usually operate on the text between _p_o_i_n_t and _t_h_e  _m_a_r_k.
On  most  terminals,  the  position  of  the mark is indicated by
underlining.  This body of text is called _t_h_e _r_e_g_i_o_n.  To specify
a  region,  you set point at one end of it and mark at the other.
It doesn't matter which one comes earlier in the text.

^@          _s_e_t-_m_a_r_k                 Set the mark where point is.
^X ^X       _e_x_c_h_a_n_g_e-_p_o_i_n_t-_a_n_d-_m_a_r_k  Interchange point and mark.
            _p_o_p-_m_a_r_k                 Move to the previous mark in the ring.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  13


The way to set the mark is with the ^@ command or (on some termi-
nals)  the  ^Space  command.   They  set the mark where point is.
Then you can move point away, leaving the mark behind.  When  the
mark is set, "[Point pushed]" is printed on the message line.

For example, if you wish to convert part of  the  buffer  to  all
upper-case,  you  can  use  the  _c_a_s_e-_r_e_g_i_o_n-_u_p_p_e_r command, which
operates on the text in the region.  You  can  first  go  to  the
beginning of the text to be capitalized, put the mark there, move
to the other end, and then type ESC X _c_a_s_e-_r_e_g_i_o_n-_u_p_p_e_r.  Or, you
can  set  the mark at the end of the text, move to the beginning,
and then type the same thing.

On terminals with the requisite capabilities, the marked  charac-
ter  is  underlined.  Otherwise, you have to remember where it is
(the usual method is to set the  mark  and  then  use  it  soon).
Alternatively,  you  can  see  where the mark is with the command
^X ^X which puts the mark where point was  and  point  where  the
mark  was.  The extent of the region is unchanged, but the cursor
and point are now at the previous location of the mark.

_6._2.  _T_h_e _R_i_n_g _o_f _M_a_r_k_s

Aside from delimiting the region, the mark  is  also  useful  for
remembering a spot that you may want to go back to.  To make this
feature more useful, JOVE remembers 16 previous locations of  the
mark.   Most  commands  that  set the mark push the old mark onto
this  stack.   To  return  to  a  marked  location,   use   ^U ^@
(equivalent  to  _p_o_p-_m_a_r_k).   This  moves point to where the mark
was, and restores the mark from the stack of  former  marks.   So
repeated  use of this command moves point to all of the old marks
on the stack, one by one.  Since the stack is  actually  a  ring,
enough uses of ^U ^@ bring point back to where it was originally.

Some commands whose primary purpose is to move point a great dis-
tance  take  advantage of the stack of marks to give you a way to
undo the command.  The best example is ESC < (_b_e_g_i_n_n_i_n_g-_o_f-_f_i_l_e),
which  moves  to  the beginning of the buffer.  If there are more
than 22 lines between the beginning  of  the  buffer  and  point,
ESC <  sets the mark first, so that you can use ^U ^@ or ^X ^X to
go back to where you were.  You can change the  number  of  lines
from 22 since it is kept in the variable _m_a_r_k-_t_h_r_e_s_h_o_l_d.  By set-
ting it to 0, you can make these commands always set the mark and
by  setting it to a very large number you can make them never set
it.  If a command decides to set the mark, it prints the  message
[Point pushed].

_6._3.  _K_i_l_l_i_n_g _a_n_d _M_o_v_i_n_g _T_e_x_t

The way of moving text with JOVE is to _k_i_l_l (cut)  it,  and  _y_a_n_k
(paste)  it back again later in one or more places.  This is very
safe because the last several  pieces  of  killed  text  are  all
remembered,  and  it  is  versatile because the many commands for
killing syntactic units can also be used for moving those units.



                         March 19, 1996





14                 JOVE Manual for UNIX Users


_6._3._1.  _D_e_l_e_t_i_o_n _a_n_d _K_i_l_l_i_n_g

Most commands which erase text from the buffer save  it  so  that
you  can  get it back if you change your mind, or you can copy it
to other parts of the buffer (even to a different buffer).  These
commands  are  known  as _k_i_l_l commands.  The rest of the commands
that erase text do not save it; they are  known  as  _d_e_l_e_t_e  com-
mands.  The delete commands include ^D and DEL, which delete only
one character at a time, and  those  commands  that  delete  only
spaces or line-separators.  Commands that can destroy significant
amounts of nontrivial data generally kill.  A command's name  and
description  will  use  the  words _k_i_l_l or _d_e_l_e_t_e to say which it
does.

^D          _d_e_l_e_t_e-_n_e_x_t-_c_h_a_r_a_c_t_e_r          Delete next character.
DEL         _d_e_l_e_t_e-_p_r_e_v_i_o_u_s-_c_h_a_r_a_c_t_e_r      Delete previous character.
ESC \       _d_e_l_e_t_e-_w_h_i_t_e-_s_p_a_c_e             Delete spaces and tabs around point.
^X ^O       _d_e_l_e_t_e-_b_l_a_n_k-_l_i_n_e_s             Delete blank lines around the current line.
^K          _k_i_l_l-_t_o-_e_n_d-_o_f-_l_i_n_e            Kill rest of line or one or more lines.
^W          _k_i_l_l-_r_e_g_i_o_n                    Kill the region (from point to mark).
ESC D       _k_i_l_l-_n_e_x_t-_w_o_r_d                 Kill word.
ESC DEL     _k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d             Kill word backwards.
ESC K       _k_i_l_l-_t_o-_e_n_d-_o_f-_s_e_n_t_e_n_c_e        Kill to end of sentence.
^X DEL      _k_i_l_l-_t_o-_b_e_g_i_n_n_i_n_g-_o_f-_s_e_n_t_e_n_c_e  Kill to beginning of sentence.
ESC ^K      _k_i_l_l-_s-_e_x_p_r_e_s_s_i_o_n              Kill from point to the end of an s-expression.

_6._3._2.  _D_e_l_e_t_i_o_n

The various delete commands have already been  described.   Actu-
ally,  ^D  and  DEL aren't always _d_e_l_e_t_e commands; if you give an
argument, they _k_i_l_l instead.  This prevents  you  from  losing  a
great deal of text by typing a large argument to a ^D or DEL.

_6._3._3.  _K_i_l_l_i_n_g (_a_n_d _C_o_p_y_i_n_g) _t_h_e _r_e_g_i_o_n,  _a_n_d  _Y_a_n_k_i_n_g  _i_t  _b_a_c_k
_a_g_a_i_n

The commonest kill  command  is  ^W  (_k_i_l_l-_r_e_g_i_o_n),  which  kills
everything between point and the mark*.  With this  command,  you
can  kill  and  save  contiguous characters, if you first set the
mark at one end of them and then go to the other end.

^W          _k_i_l_l-_r_e_g_i_o_n           Kill everything between point and mark.
ESC W       _c_o_p_y-_r_e_g_i_o_n           Save the region without killing.

Yanking (un-killing) is getting back text which was killed.   The
usual  way  to  move  or copy text is to kill or copy it and then
yank it one or more times.

^Y          _y_a_n_k                  Yank (re-insert) the last killed text.
ESC Y       _y_a_n_k-_p_o_p              Replace re-inserted killed text with the previously killed text.
_________________________
*Often users switch  this  binding  from  ^W  to  ^X ^K
because it is too easy to hit ^W accidentally.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  15


Killed text is pushed onto a _r_i_n_g _b_u_f_f_e_r  called  the  _k_i_l_l  _r_i_n_g
that  remembers  the last sixteen blocks of text that were killed
(why it is called a ring buffer will be  explained  below).   The
command  ^Y  (_y_a_n_k)  reinserts  the text of the most recent kill.
The yanked text becomes the new region.  Thus, a single ^Y undoes
the ^W and vice versa.

If you wish to copy a block of text, you might want to use  ESC W
(_c_o_p_y-_r_e_g_i_o_n), which copies the region into the kill ring without
removing it from the buffer.

There is only one kill ring shared among all the buffers.   After
reading  a  new file or selecting a new buffer, whatever was last
killed in the previous file or buffer is still on top of the kill
ring.  This is important for moving text between buffers.

_6._3._4.  _O_t_h_e_r _K_i_l_l _c_o_m_m_a_n_d_s

Other syntactic units can be killed,  too;  words,  with  ESC DEL
(_k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d)  and  ESC D (_k_i_l_l-_n_e_x_t-_w_o_r_d); and sentences,
with  ESC K  (_k_i_l_l-_t_o-_e_n_d-_o_f-_s_e_n_t_e_n_c_e)   and   ^X DEL   (_k_i_l_l-_t_o-
_b_e_g_i_n_n_i_n_g-_o_f-_s_e_n_t_e_n_c_e).

_6._3._5.  _K_i_l_l_i_n_g _b_y _L_i_n_e_s

Another kill command is the ^K command (_k_i_l_l-_t_o-_e_n_d-_o_f-_l_i_n_e).  If
issued  at  the beginning of a line, it kills all the text on the
line, leaving it blank.  If given in the middle  of  a  line,  it
kills all the text up to the end of the line.  If given on a line
that is empty or contains only white space (blanks and tabs)  the
line  disappears.   If  ^K is done at the end of a line, it joins
that line and the next line.  As a consequence, if you go to  the
front  of a non-blank line and type two ^K's, the line disappears
completely (but be careful,  because  one  ^K  is  sufficient  to
remove an empty line).

In general, ^K kills from point up to the end of the line, unless
it  is  at  the  end  of a line, in which case it kills the line-
separator following the line, thus merging the next line into the
current  one.   Invisible  spaces and tabs at the end of the line
are ignored when deciding which case applies, so if point appears
to  be at the end of the line, you can be sure the line-separator
will be killed.

^K with an argument kills that many lines, including  their  line
separators  (whether  the  lines  are  empty or not).  Without an
argument, ^K behaves as described in the previous paragraph.   ^U
^K  kills  four  lines  (but note that typing ^K four times would
kill only 2 lines)

^K with an argument of zero kills all the text  before  point  on
the current line.





                         March 19, 1996





16                 JOVE Manual for UNIX Users


_6._3._6.  _A_p_p_e_n_d_i_n_g _K_i_l_l_s

Normally, each kill command pushes a  new  block  onto  the  kill
ring.   However,  two  or more kill commands immediately in a row
(without any other intervening commands) combine their text  into
a  single  entry  on the ring, so that a single ^Y (_y_a_n_k) command
gets it all back as it was before it was killed.  This means that
you  don't have to kill all the text in one command; you can keep
killing line after line, or  word  after  word,  until  you  have
killed it all, and you can still get it all back at once.

Commands that kill forward from point add onto  the  end  of  the
previously  killed  text.  Commands that kill backward from point
add onto the beginning.  This way, any sequence of mixed  forward
and  backward  kill  commands  puts  all the killed text into one
entry without needing rearrangement.

Suppose, for example you have a line containing FOO BAR BAZ  with
the  cursor  at  the  start of BAR.  Type ESC D (_k_i_l_l-_n_e_x_t-_w_o_r_d),
then ESC DEL (_k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d), then ESC F  (_f_o_r_w_a_r_d-_w_o_r_d)  to
put the cursor after BAZ, and Space to insert a space.  Then type
^Y (_y_a_n_k) and your line will contain BAZ FOO BAR.

_6._4.  _T_h_e _K_i_l_l _R_i_n_g

To recover killed text that is no longer the  most  recent  kill,
you  need the ESC Y (_y_a_n_k-_p_o_p) command.  The ESC Y command can be
used only immediately after a ^Y (_y_a_n_k) command or another ESC Y.
It  takes the yanked text inserted by the ^Y and replaces it with
the text from an earlier kill.  So, to recover the  text  of  the
next-to-the-last kill, you first use ^Y to recover the last kill,
and then discard it by use of ESC Y to move back to the  previous
one.

You can think of all the last few kills  as  living  on  a  ring.
After  a  ^Y  command, the text at the front of the ring is still
present in the buffer.  ESC Y "rotates"  the  ring  bringing  the
previous  string  of text to the front and this text replaces the
other text in the buffer as  well.   Enough  ESC Y  commands  can
rotate  any  part of the ring to the front, so you can get at any
killed text so long as it is recent enough to  be  still  in  the
ring.  Eventually the ring rotates all the way round and the most
recently killed text comes to the front  (and  into  the  buffer)
again.   ESC Y  with  a  negative argument rotates the ring back-
wards.

When the text you are looking for is brought into the buffer, you
can  stop  doing  ESC Y's  and  the  text will stay there.  It is
really just a copy of what's at the front of the ring, so editing
it  does  not  change  what's  in  the  ring.  And the ring, once
rotated, stays rotated, so that doing  another  ^Y  gets  another
copy of what you rotated to the front with ESC Y.

If you change your mind about yanking, ^W (_k_i_l_l-_r_e_g_i_o_n) gets  rid



                         March 19, 1996





                   JOVE Manual for UNIX Users                  17


of the yanked text, even after any number of ESC Y's.

_7.  _S_e_a_r_c_h_i_n_g _a_n_d _R_e_p_l_a_c_i_n_g

_7._1.  _S_e_a_r_c_h_i_n_g

The search commands are useful for finding and  moving  to  arbi-
trary  positions in the buffer in one swift motion.  For example,
if you just ran the spell program on a document and you  want  to
correct  some  word,  you  can  use  the  search commands to move
directly to that word.  There are two flavors of  search:  _s_t_r_i_n_g
_s_e_a_r_c_h  and _i_n_c_r_e_m_e_n_t_a_l _s_e_a_r_c_h.  The former is the default flavor
- if you want to use incremental search you  must  rearrange  the
key bindings (see below).

_7._1._1.  _C_o_n_v_e_n_t_i_o_n_a_l _S_e_a_r_c_h

^S or ^\    _s_e_a_r_c_h-_f_o_r_w_a_r_d        Search forward.
^R          _s_e_a_r_c_h-_r_e_v_e_r_s_e        Search backward.

To search for the string "FOO" you type ^S FOO<return>.  If  JOVE
finds  FOO it moves point to the end of it; otherwise JOVE prints
an error message and leaves point unchanged.  ^S searches forward
from  point so only occurrences of FOO after point are found.  To
search in the other direction use ^R.  It is exactly the same  as
^S  except  that it searches in the opposite direction, and if it
finds the string it leaves point at the beginning of it,  not  at
the end as in ^S.

While JOVE is searching it displays the search string on the mes-
sage  line.   This  is  so you know what JOVE is doing.  When the
system is heavily  loaded  and  editing  in  exceptionally  large
buffers, searches can take several (sometimes many) seconds.

JOVE remembers the last search string you used, so if you want to
search  for  the  same string again you can type ^S <return>.  If
you mistyped the last search string, you  can  type  ^S  followed
immediately  by  ^R  (which  is _n_o_t the _s_e_a_r_c_h-_r_e_v_e_r_s_e command in
this context) which inserts the default search string,  and  then
you can fix it up.

Note that the precise interpretation  of  the  search  string  is
dependent  on  the variable _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s and is sub-
ject  to  the  rules  for  _r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s  to  be  described
shortly.

_7._1._2.  _I_n_c_r_e_m_e_n_t_a_l _S_e_a_r_c_h

This search command is unusual in  that  is  is  _i_n_c_r_e_m_e_n_t_a_l;  it
begins  to  search  before  you  have  typed  the complete search
string.  As you type in the search string, JOVE shows  you  where
it  would  be  found.   When  you have typed enough characters to
identify the place you want, you can stop.  Depending on what you
will  do  next,  you  may or may not need to terminate the search



                         March 19, 1996





18                 JOVE Manual for UNIX Users


explicitly with a Return.

To use the incremental searches, you first have to bind  them  to
suitable  keys,  for  example  to  ^S and ^R if you want all your
searching to become incremental.  To do this, type

     _E_S_C _X _b_i_n_d-_t_o-_k_e_y _i-_s_e_a_r_c_h-_f_o_r_w_a_r_d ^_S
     _E_S_C _X _b_i_n_d-_t_o-_k_e_y _i-_s_e_a_r_c_h-_r_e_v_e_r_s_e ^_R

The command to search is now ^S (_i-_s_e_a_r_c_h-_f_o_r_w_a_r_d).  ^S reads  in
characters  and  positions  the cursor at the first occurrence of
the characters that you have typed so far.  If you  type  ^S  and
then  F,  the  cursor  moves in the text just after the next "F".
Type an "O", and see the cursor move  to  after  the  next  "FO".
After  another  "O",  the cursor is after the next "FOO".  At the
same time, "FOO" has echoed on the message line.

If you type a mistaken character, you can rub it out.  After  the
FOO,  typing a DEL makes the "O" disappear from the message line,
leaving only "FO".  The cursor moves back in the  buffer  to  the
"FO".  Rubbing out the "O" and "F" moves the cursor back to where
you started the search.

When you are satisfied with the place you have reached,  you  can
type  a  Return,  which stops searching, leaving the cursor where
the search brought it.  Also, any command not specially  meaning-
ful  in searches stops the searching and is then executed.  Thus,
typing ^A would exit the search and then move to the beginning of
the  line.   Return  is  necessary only if the next character you
want to type is a printing character,  DEL,  Return,  or  another
search  command, since those are the characters that have special
meanings inside the search.

Sometimes you search for "FOO" and find it, but not the  one  you
hoped  to  find.  Perhaps there is a second FOO after the one you
just found.  Then type another "^S" and the cursor will find  the
next  FOO.   This  can  be  done  any  number  of  times.  If you
overshoot, you can return to previous finds by  rubbing  out  the
"^S"s.   Note that, in this context, "^S" (alternatively "^\") is
a built-in use of the ^S character and not another invocation  of
_i-_s_e_a_r_c_h-_f_o_r_w_a_r_d (which is why I have shown it in "quotes").

After you exit a search, you can search for the same string again
by  typing  just  ^S  ^S:  one ^S command to start the search and
then another "^S" to mean "search again for the same string".

If your string is not found at all, the message line says  "Fail-
ing I-search".  The cursor is after the place where JOVE found as
much of your string as it could.  Thus, if you  search  for  FOOT
and  there  is no FOOT, you might see the cursor after the FOO in
FOOL.  At this point there are several things  you  can  do.   If
your  string was mistyped, you can rub some of it out and correct
it.  If you like the place you have found, you can type Return or
some  other JOVE command to "accept what the search offered".  Or



                         March 19, 1996





                   JOVE Manual for UNIX Users                  19


you can type ^G, which undoes the search altogether and positions
you back where you started the search.

You can also type ^R (_i-_s_e_a_r_c_h-_r_e_v_e_r_s_e)  at  any  time  to  start
searching  backwards.   If  a  search fails because the place you
started was too late in the file, you should do  this.   Repeated
"^R"s  keep  looking  backward  for  more occurrences of the last
search string.  A "^S" starts going forward again.  "^R"s can  be
rubbed out just like anything else.

Unlike conventional searching, incremental searching does not use
the rules for regular-expressions.

_7._2.  _R_e_p_l_a_c_i_n_g

In addition to the simple Replace operation which  is  like  that
found  in  most editors, there is a Query Replace operation which
asks, for each occurrence of the pattern, whether to  replace  it
or not.

ESC R       _r_e_p_l_a_c_e-_s_t_r_i_n_g
7                                  Replace every occurrence of the
                                  string from point to the end of
                                  the buffer.
            _r_e_p_l_a_c_e-_i_n-_r_e_g_i_o_n
7                                  Replace every occurrence of the
                                  string within the region.
ESC Q       _q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g
7                                  Replace  occurrences   of   the
                                  string from point to the end of
                                  the buffer, but asking for con-
                                  firmation  before each replace-
                                  ment.

_7._2._1.  _G_l_o_b_a_l _r_e_p_l_a_c_e_m_e_n_t

To replace every occurrence of FOO after point with BAR, you  can
do,  ESC R  FOO<return>BAR<return> (_r_e_p_l_a_c_e-_s_t_r_i_n_g).  Replacement
takes place only between point and the end of the buffer,  so  if
you  want  to cover the whole buffer you must go to the beginning
first.

Another alternative is to use  _r_e_p_l_a_c_e-_i_n-_r_e_g_i_o_n  which  is  just
like _r_e_p_l_a_c_e-_s_t_r_i_n_g except it searches only within the region.

_7._2._2.  _Q_u_e_r_y _R_e_p_l_a_c_e

If you want to change only some of the occurrences  of  FOO,  not
all,  then  the  global _r_e_p_l_a_c_e-_s_t_r_i_n_g is inappropriate; instead,
use, e.g., ESC Q  FOO<return>BAR<return>  (_q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g).
This moves the cursor to each occurrence of FOO and waits for you
to say whether to replace it with BAR.  The things you  can  type
when you are shown an occurrence of FOO are:

Space or Y or y      to replace the FOO with BAR.

Period               to replace this FOO and then stop.



                         March 19, 1996





20                 JOVE Manual for UNIX Users


DEL or BS or N or n  to skip to the next  FOO  without  replacing
                     this one.

^R or R or r         to enter a recursive editing level, in  case
                     the  FOO needs to be edited rather than just
                     replaced with a BAR.   When  you  are  done,
                     exit  the recursive editing level with ^X ^C
                     (_e_x_i_t-_j_o_v_e)  and  the  next  FOO   will   be
                     displayed.

^W                   to delete the FOO, and  then  start  editing
                     the  buffer.   When you are finished editing
                     whatever is to replace  the  FOO,  exit  the
                     recursive  editing  level  with ^X ^C (_e_x_i_t-
                     _j_o_v_e) and the _q_u_e_r_y-_r_e_p_l_a_c_e will continue at
                     the next FOO.

^U or U or u         move to the last replacement  and  undo  all
                     changes made on that line.

! or P or p          to replace all remaining FOO's without  ask-
                     ing, as in _r_e_p_l_a_c_e-_s_t_r_i_n_g.

Return or Q or q     to stop without doing any more replacements.

^L                   redraw the screen.

_7._3.  _S_e_a_r_c_h_i_n_g _w_i_t_h _R_e_g_u_l_a_r _E_x_p_r_e_s_s_i_o_n_s

When we use the searching and  replacement  facilities  described
above,  JOVE  can  search for patterns using _r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s.
The handling of regular-expressions in JOVE is somewhat like that
of  _e_d(_1) or _v_i(_1), but with some notable additions.  The precise
behavior depends on the setting of  the  variable  _m_a_t_c_h-_r_e_g_u_l_a_r-
_e_x_p_r_e_s_s_i_o_n_s.   If  this  variable  is  _o_n,  we  use true _r_e_g_u_l_a_r-
_e_x_p_r_e_s_s_i_o_n_s.  If it is _o_f_f, we have just _s_i_m_p_l_e-_e_x_p_r_e_s_s_i_o_n_s.   In
what  follows,  the  term  _e_x_p_r_e_s_s_i_o_n  should  be  interpreted as
simple-expression or regular-expression according to the state of
that variable.

Another variable that affects  searching  is  _c_a_s_e-_i_g_n_o_r_e-_s_e_a_r_c_h.
If  this  variable  is  set  to _o_n then upper case and lower case
letters are considered equal (except, of course, within  regular-
expressions such as [A-Za-z]).

Note that the rules which follow are complex, arbitrary, and dif-
ferent  from  those  in other editors.  Hence they may be changed
significantly in future versions of JOVE.

_7._3._1.  _S_i_m_p_l_e _R_e_g_u_l_a_r _E_x_p_r_e_s_s_i_o_n_s

If the variable _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s is _o_f_f, the search pat-
tern is interpreted as follows:




                         March 19, 1996





                   JOVE Manual for UNIX Users                  21


^ (at the start of a pattern or sub-pattern)
              Matches the empty string  at  the  beginning  of  a
              line.

$ (at the end of a pattern or sub-pattern)
              Matches the empty string at the end of a line.

\<            Matches the empty string  at  the  beginning  of  a
              word.   What  makes  up a word depends on the major
              mode of the buffer that you are searching  in.   In
              all  modes a word is a contiguous sequence of char-
              acters which have some defined pattern, bounded  by
              characters  that  don't  fit that pattern or by the
              beginning or  end  of  the  line.   The  individual
              modes' word patterns are as follows:

              _F_u_n_d_a_m_e_n_t_a_l  upper  and  lower  case  letters   and
                          digits.

              _T_e_x_t        upper and lower case letters and digits
                          plus apostrophe (').

              _C           upper and lower case letters and digits
                          plus "$" and "_" (underscore).

              _L_i_s_p        upper and lower case letters and digits
                          plus "!$%&*+-/:<=>?^_{|}~" and Delete.

\>            Matches the empty string at the end of a word.

\_c            Matches the character _c where _c is not one of <, >,
              (,  ),  {,  }  or  |.  In particular, \^, \$ and \\
              match  the  characters  ^,  $  and  \.   When  full
              regular-expressions  are in use, \...., \* and \[ will
              also be required.

_c             Matches the character _c where _c is not \ or  ^  (at
              the  start of a pattern) or $ (at the end of a pat-
              tern) (plus a few further things if  _m_a_t_c_h-_r_e_g_u_l_a_r-
              _e_x_p_r_e_s_s_i_o_n_s is _o_n).

\{_c_1..._c_N\}   Matches   whatever   the   sequence   of   regular-
              expressions  _c_1.._c_N  would have matched.  Note that
              full regular-expression  capability  (even  the  \|
              construct   described  below)  is  provided  within
              \{...\}  whatever  the  setting  of  the   variable
              _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s.    \{...\}   provides  a
              grouping construct like  parentheses  in  algebraic
              expressions.   Thus  "aa\{xx\|yy\}bb"  searches for
              "aaxxbb" or "aayybb".

\(_c_1.._c_N\)    Matches whatever the sequence of expressions _c_1.._c_N
              would  have  matched, where the expressions are any
              of those described above (and also  the  additional



                         March 19, 1996





22                 JOVE Manual for UNIX Users


              full    regular-expressions    if    _m_a_t_c_h-_r_e_g_u_l_a_r-
              _e_x_p_r_e_s_s_i_o_n_s is _o_n).  This is used to  tag  part  of
              the  search  text  for  later reference via \nnnn (see
              below).   \(_c_1.._c_N\)  patterns   may   be   nested.
              Observe  that  use  of the \| construct (see below)
              directly within a \(...\) is precluded.

\_n            Matches the _n'th  \(_c_1.._c_N\)  pattern  where  _n  is
              between  1 and 9.  The \(_c_1.._c_N\) patterns are num-
              bered by counting the \(  sequences  starting  from
              the beginning of the search pattern, resetting to 1
              (or to the value  at  the  start  of  an  enclosing
              \{...\})  whenever  a  \| is encountered.  To avoid
              confusion in the counting, it is required that each
              alternative  (separated  by  \|)  within  a \{...\}
              should contain the same number  of  \(...\)s.   For
              example,  the  search  pattern "^\(\{ab\|cd\}\)\1$"
              searches for all non-empty lines which contain just
              "abab"  or "cdcd" (but not "abcd").  It is an error
              in the search pattern  to  reference  a  \(_c_1.._c_N\)
              pattern that follows the occurrence of \_n.

_c_1.._c_N        Matches the longest string matched by _c_1,  followed
              by  the  longest  string  matched by _c_2, and so on.
              The expressions _c_1.._c_N are any of  those  described
              above   (and  also  the  additional  full  regular-
              expressions if _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s is _o_n).

_c_1.._c_N\|_d_1.._d_NMatches the longest string matched  by  _c_1.._c_N,  if
              any,  and  otherwise  the longest string matched by
              _d_1.._d_N.  Multiple \| sequences may be used to indi-
              cate  more  alternatives.  The sequences _c_1.._c_N and
              _d_1.._d_N are any  of  those  described  above,  which
              means  that \| has lower precedence than any of the
              other operators.  Each alternative  must  have  the
              same   number   of   \(...\)   groups,  as  already
              explained.  Thus, "\<foo\|bar\|baz\>"  matches  any
              word  beginning  with  "foo", any occurrence of the
              string "bar", or any word ending in "baz".

In the replacement string:

\_n            Is replaced with the characters matched by the _n'th
              \(_c_1.._c_N\) in the search pattern where _n is between
              1  and  9.   For   example,   one   could   replace
              "\<\(\{FOO\|BAR\|BAZ\}\)\>"  with "[\1]" to enclose
              every occurrence of the  words  FOO,  BAR  and  BAZ
              within [...].

\0            Is replaced with  the  characters  matched  by  the
              entire search pattern.

\_c            Inserts the character _c where _c is not a digit.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  23


_c             Inserts the character _c where _c is not \.

_7._3._2.  _F_u_l_l _R_e_g_u_l_a_r _E_x_p_r_e_s_s_i_o_n_s

If the variable _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s is  _o_n,  the  following
additional special matching rules are used.  Observe that special
meanings now attach to the characters  ....,  *  and  [,  which  can
therefore no longer stand for themselves.

In the search pattern:

_c             Matches the character _c where _c is not one of ...., *,
              [,  \,  ^ (at the start of a line) or $ (at the end
              of a line).

....             Matches any character, but not a line-separator.

[_c_1.._c_N]      Matches any of the characters in  the  sequence  of
              characters  _c_1.._c_N  provided  circumflex (^) is not
              the first character of the  sequence  (see  below).
              The  only special characters recognized while pars-
              ing the sequence are "]", "-" and "\".  All may  be
              represented  by escaping them with a backslash (\):
              "\]", "\-", "\\".   Ranges  of  characters  may  be
              indicated  by _a-_b where _a is the first character of
              the range and _b is the last.  The  special  meaning
              of  -  is  lost  if it appears as the first or last
              character of the sequence.  The special meaning  of
              ]  is  lost if it appears as the first character of
              the sequence.

[^_c_1.._c_N]     Matches any character except those contained in the
              sequence  of characters _c_1.._c_N.  The circumflex (^)
              is not special  except  immediately  following  the
              left bracket.

_c*             Matches zero or more occurrences of the expression
              _c.   The expression _c may be any of the expressions
              covered above except for ^ and $ (which match  null
              strings),   \(_c_1.._c_N\)  and  _c_1.._c_N\|_d_1.._d_N  (which
              would not work), and \{_c_1..._c_N\} (arbitrarily  for-
              bidden).

_8.  _C_o_m_m_a_n_d_s _f_o_r _E_n_g_l_i_s_h _T_e_x_t

JOVE has many commands that work on the basic  units  of  English
text:  words, sentences and paragraphs.

_8._1.  _W_o_r_d _C_o_m_m_a_n_d_s

JOVE has commands for moving over or operating on words.  By con-
vention, they are all ESC commands.

ESC F       _f_o_r_w_a_r_d-_w_o_r_d          Move Forward over a word.



                         March 19, 1996





24                 JOVE Manual for UNIX Users


ESC B       _b_a_c_k_w_a_r_d-_w_o_r_d         Move Backward over a word.
ESC D       _k_i_l_l-_n_e_x_t-_w_o_r_d        Kill forward to the end of a word.
ESC DEL     _k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d    Kill backward to the beginning of a word.

Notice how  these  commands  form  a  group  that  parallels  the
character-based commands, ^F, ^B, ^D, and DEL.

The commands ESC F and  ESC B  move  forward  and  backward  over
words.   They  are  thus  analogous to ^F and ^B, which move over
single characters.  Like  their  Control-  analogues,  ESC F  and
ESC B  move  over  several words if given an argument (and in the
opposite direction  with  negative  arguments).   Forward  motion
stops  right  after  the last letter of the word; backward motion
stops right before the first letter.

ESC D kills the word after point.  To be precise, it kills every-
thing  from  point  to  the  place ESC F would move to.  Thus, if
point is in the middle of a word, only the part  after  point  is
killed.   If  some  punctuation comes after point, and before the
next word, it is killed along with the word.  If you wish to kill
only  the  next  word but not the punctuation, simply do ESC F to
get to the end, and kill the word backwards with ESC DEL.   ESC D
takes arguments just like ESC F.

ESC DEL kills the word before point.  It  kills  everything  from
point  back  to where ESC B would move to.  If point is after the
space in "FOO, BAR", then "FOO, " is killed.  If you wish to kill
just "FOO", then do an ESC B and an ESC D instead of an ESC DEL.

Note that the term "word" in all of these commands refers  simply
to  a sequence of upper and lower case letters and digits.  It is
not dependent on the major mode of the buffer  as  was  the  case
with  regular-expressions  involving  \<  and  \>.   Thus it will
require two uses of ESC D to remove a word such as "isn't",  even
if the major mode is Text mode.

_8._2.  _S_e_n_t_e_n_c_e _C_o_m_m_a_n_d_s

The JOVE commands for manipulating sentences and  paragraphs  are
mostly  ESC  commands,  so  as to resemble the word-handling com-
mands.

ESC A       _b_a_c_k_w_a_r_d-_s_e_n_t_e_n_c_e              Move back to the beginning of the sentence.
ESC E       _f_o_r_w_a_r_d-_s_e_n_t_e_n_c_e               Move forward to the end of the sentence.
ESC K       _k_i_l_l-_t_o-_e_n_d-_o_f-_s_e_n_t_e_n_c_e        Kill forward to the end of the sentence.
^X DEL      _k_i_l_l-_t_o-_b_e_g_i_n_n_i_n_g-_o_f-_s_e_n_t_e_n_c_e  Kill back to the beginning of the sentence.

The commands ESC A and ESC E move to the beginning and end of the
current  sentence, respectively.  They were chosen to resemble ^A
and ^E, which move to the beginning and end of  a  line.   Unlike
them, ESC A and ESC E if repeated or given numeric arguments move
over successive sentences.  JOVE  considers  a  sentence  to  end
wherever  there  is  a  ".", "?", or "!" followed by the end of a
line or by one or more spaces.  Neither  ESC A  nor  ESC E  moves



                         March 19, 1996





                   JOVE Manual for UNIX Users                  25


past  the  end  of  the line or the spaces which delimit the sen-
tence.

Just as ^A and ^E have a kill command, ^K, to go  with  them,  so
ESC A  and  ESC E  have  a corresponding kill command ESC K which
kills from point to the end of the sentence.  With minus  one  as
an  argument  it  kills  back  to  the beginning of the sentence.
Positive arguments serve as a repeat count.

There is a special command ^X DEL for killing back to the  begin-
ning  of  a sentence, because this is useful when you change your
mind in the middle of composing text.

_8._3.  _P_a_r_a_g_r_a_p_h _C_o_m_m_a_n_d_s

The JOVE commands for handling paragraphs are

            _b_a_c_k_w_a_r_d-_p_a_r_a_g_r_a_p_h    Move back to the start of the previous paragraph.
ESC ]       _f_o_r_w_a_r_d-_p_a_r_a_g_r_a_p_h     Move forward to the end of the next paragraph.

Note that "ESC [" is not bound to  _b_a_c_k_w_a_r_d-_p_a_r_a_g_r_a_p_h,  as  might
have  been  expected,  on  most  (i.e.  ANSI-compliant) terminals
because that sequence is used as a prefix for codes generated  by
the Function Keys.

_B_a_c_k_w_a_r_d-_p_a_r_a_g_r_a_p_h moves to the beginning of the current or  pre-
vious  paragraph, while _f_o_r_w_a_r_d-_p_a_r_a_g_r_a_p_h moves to the end of the
current or next paragraph.  Paragraphs are delimited by lines  of
differing indent, or lines with text formatter commands, or blank
lines.  JOVE knows how to  deal  with  most  indented  paragraphs
correctly, although it can get confused by one- or two-line para-
graphs delimited only by indentation.

_8._4.  _T_e_x_t _I_n_d_e_n_t_a_t_i_o_n _C_o_m_m_a_n_d_s


Tab         _h_a_n_d_l_e-_t_a_b            Indent "appropriately" in a mode-dependent fashion.
Linefeed    _n_e_w_l_i_n_e-_a_n_d-_i_n_d_e_n_t
7                                  Is the same as Return, except it copies the  indent
                                  of the line you just left.
ESC M       _f_i_r_s_t-_n_o_n-_b_l_a_n_k       Moves to the line's first non-blank character.

The way to request indentation is with the Tab command.  Its pre-
cise  effect depends on the major mode.  In _T_e_x_t mode, it indents
to the next tab stop (as determined by  the  variable  _t_a_b-_w_i_d_t_h,
whose default value is 8).  In _C mode or _L_i_s_p mode, it indents to
the "right" position for those programs (see later).

To move over the indentation on  a  line,  do  ESC M  (_f_i_r_s_t-_n_o_n-
_b_l_a_n_k).   This  command,  given anywhere on a line, positions the
cursor at the first non-blank, non-tab character on the line.

_8._5.  _T_e_x_t _F_i_l_l_i_n_g

            _a_u_t_o-_f_i_l_l-_m_o_d_e        Toggle the minor mode _a_u_t_o _f_i_l_l.



                         March 19, 1996





26                 JOVE Manual for UNIX Users


ESC J       _f_i_l_l-_p_a_r_a_g_r_a_p_h        Refill the paragraph containing the cursor.
            _f_i_l_l-_r_e_g_i_o_n           Refill the region.
            _f_i_l_l-_c_o_m_m_e_n_t          Refill a comment, depending on the major mode.
            _l_e_f_t-_m_a_r_g_i_n-_h_e_r_e      Sets the variable _l_e_f_t-_m_a_r_g_i_n from point.
            _r_i_g_h_t-_m_a_r_g_i_n-_h_e_r_e     Sets the variable _r_i_g_h_t-_m_a_r_g_i_n from point.

_A_u_t_o _F_i_l_l mode is a minor mode that  causes  text  to  be  _f_i_l_l_e_d
(broken  up  into  lines that fit in a specified width) automati-
cally as you type it in.  If you alter existing text so  that  it
is no longer properly filled, JOVE can fill it again if you ask.

Entering _A_u_t_o _F_i_l_l mode is done with ESC X _a_u_t_o-_f_i_l_l-_m_o_d_e.   From
then  on,  lines are broken automatically at spaces when they get
longer than the desired width.  To leave  _A_u_t_o  _F_i_l_l  mode,  once
again  execute  ESC X  _a_u_t_o-_f_i_l_l-_m_o_d_e.  When _A_u_t_o _F_i_l_l mode is in
effect, the word FFFFiiiillllllll appears in the mode line.

If you edit the middle of a paragraph, it may no longer be filled
correctly.   To  refill a paragraph, use the command ESC J (_f_i_l_l-
_p_a_r_a_g_r_a_p_h).  It causes the paragraph that point is inside  to  be
filled.   All  the  line breaks are removed and new ones inserted
where necessary.  Similarly, _f_i_l_l-_r_e_g_i_o_n may be used to refill  a
region  other than a paragraph.  The special command _f_i_l_l-_c_o_m_m_e_n_t
is only meaningful in those major modes,  currently  C  mode  and
Lisp mode, which support it.

The maximum line width for filling  is  in  the  variable  _r_i_g_h_t-
_m_a_r_g_i_n.   Both ESC J and auto-fill make sure that no line exceeds
this width.  The value of _r_i_g_h_t-_m_a_r_g_i_n is initially 78.

Normally ESC J figures out the indent of the paragraph  and  uses
that  same  indent when filling.  If you want to force some other
indent for a paragraph, you set _l_e_f_t-_m_a_r_g_i_n to the  new  position
and  type  ^U ESC J, since _f_i_l_l-_p_a_r_a_g_r_a_p_h uses the value of _l_e_f_t-
_m_a_r_g_i_n when supplied with a numeric argument.

If you know where you want to set the variable  _r_i_g_h_t-_m_a_r_g_i_n  but
you  don't  know  the actual value, move to where you want to set
the value and use the  _r_i_g_h_t-_m_a_r_g_i_n-_h_e_r_e  command.   _l_e_f_t-_m_a_r_g_i_n-
_h_e_r_e does the same for the _l_e_f_t-_m_a_r_g_i_n variable.

_8._6.  _C_a_s_e _C_o_n_v_e_r_s_i_o_n _C_o_m_m_a_n_d_s

ESC L       _c_a_s_e-_w_o_r_d-_l_o_w_e_r            Convert the following word to lower case.
ESC U       _c_a_s_e-_w_o_r_d-_u_p_p_e_r            Convert the following word to upper case.
ESC C       _c_a_s_e-_w_o_r_d-_c_a_p_i_t_a_l_i_z_e       Capitalize the following word.
            _c_a_s_e-_c_h_a_r_a_c_t_e_r-_c_a_p_i_t_a_l_i_z_e  Capitalize the character after point.
            _c_a_s_e-_r_e_g_i_o_n-_l_o_w_e_r          Convert the region to lower case.
            _c_a_s_e-_r_e_g_i_o_n-_u_p_p_e_r          Convert the region to upper case.

The word conversion commands are most useful.  ESC L converts the
word after point to lower case, moving past it.  Thus, successive
ESC L's convert successive words.  ESC U converts to all capitals
instead, while ESC C puts the first letter of the word into upper



                         March 19, 1996





                   JOVE Manual for UNIX Users                  27


case and the rest into lower case.  All  these  commands  convert
several  words at once if given an argument.  They are especially
convenient for converting a large amount of text from  all  upper
case  to  mixed case, because you can move through the text using
ESC L, ESC U or ESC C on each word as appropriate.

When given a negative argument, the word case conversion commands
apply to the appropriate number of words before point, but do not
move point.  This is convenient when you have just typed  a  word
in  the wrong case.  You can give the case conversion command and
continue typing.

If a word case conversion command is given in  the  middle  of  a
word,  it  applies only to the part of the word which follows the
cursor, treating it as a whole word.

_8._7.  _C_o_m_m_a_n_d_s _f_o_r _F_i_x_i_n_g _T_y_p_o_s

In this section we summarize the  commands  that  are  especially
useful  for  the times when you catch a mistake in your text just
after you have made it, or you change your mind  while  composing
text on a line.

DEL              _d_e_l_e_t_e-_p_r_e_v_i_o_u_s-_c_h_a_r_a_c_t_e_r      Delete last character.
ESC DEL          _k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d             Kill last word.
^X DEL           _k_i_l_l-_t_o-_b_e_g_i_n_n_i_n_g-_o_f-_s_e_n_t_e_n_c_e  Kill to beginning of sentence.
^T               _t_r_a_n_s_p_o_s_e-_c_h_a_r_a_c_t_e_r_s           Transpose two characters.
^X ^T            _t_r_a_n_s_p_o_s_e-_l_i_n_e_s                Transpose two lines.
ESC Minus ESC L                                 Convert last word to lower case.
ESC Minus ESC U                                 Convert last word to upper case.
ESC Minus ESC C                                 Convert last word to lower case with initial capital.


_8._7._1.  _K_i_l_l_i_n_g _Y_o_u_r _M_i_s_t_a_k_e_s

The DEL command is the most important correction  command.   When
used  among  printing  (self-inserting)  characters,  it  can  be
thought of as canceling the last character typed.

When your mistake is longer than a couple of characters, it might
be  more convenient to use ESC DEL or ^X DEL.  ^X DEL is particu-
larly useful when you are thinking of what to write as  you  type
it,  in  case  you  change your mind about phrasing.  ESC DEL and
^X DEL save the killed text for subsequent yanking.

ESC DEL is often useful even when you have typed only a few char-
acters  wrong,  if  you  know you are confused in your typing and
aren't sure what you typed.  At such a time, you  cannot  correct
with DEL except by looking at the screen to see what you did.  It
requires less thought to kill  the  whole  word  and  start  over
again.






                         March 19, 1996





28                 JOVE Manual for UNIX Users


_8._7._2.  _T_r_a_n_s_p_o_s_i_t_i_o_n

The common error of transposing two characters can be fixed  with
the  ^T  (_t_r_a_n_s_p_o_s_e-_c_h_a_r_a_c_t_e_r_s) command.  Normally, ^T transposes
the two characters on either side of the  cursor  and  moves  the
cursor  forward  one  character.   Repeating  the command several
times "drags" a character to the right.  When given at the end of
a line, rather than switching the last character of the line with
the line-separator, which would be  useless,  ^T  transposes  the
last  two characters on the line.  So, if you catch your transpo-
sition error right away, you can fix it with just a ^T.   If  you
don't  catch  it  so  quickly,  you  must move the cursor back to
between the two characters.

To transpose two lines, use the ^X ^T (_t_r_a_n_s_p_o_s_e-_l_i_n_e_s)  command.
The  line  containing the cursor is exchanged with the line above
it; the cursor is left at the beginning of the line following its
original position.

_8._8.  _C_h_e_c_k_i_n_g _a_n_d _C_o_r_r_e_c_t_i_n_g _S_p_e_l_l_i_n_g

When you write a paper, you should correct its spelling  at  some
point  close  to  finishing it.  To correct the entire buffer, do
ESC X _s_p_e_l_l-_b_u_f_f_e_r.  This invokes the UNIX _s_p_e_l_l  program,  which
prints a list of all the misspelled words.  JOVE catches the list
and places it in a JOVE buffer called SSSSppppeeeellllllll.  You  now  edit  the
SSSSppppeeeellllllll  buffer  (technically,  you are in a recursive edit at this
point) by deleting from that buffer any words that aren't  really
errors.   Next,  type ^X ^C (_e_x_i_t-_j_o_v_e) to escape from the recur-
sive edit, and JOVE now positions you  at  the  first  misspelled
word in the original buffer.  Correct that mistake with the usual
editor  commands.   Then  you  can  go  forward  to  each   other
misspelled  word  with  ^X ^N (_n_e_x_t-_e_r_r_o_r) or backward with ^X ^P
(_p_r_e_v_i_o_u_s-_e_r_r_o_r).  If, in the course of editing  a  mistake,  you
get  completely lost, the command _c_u_r_r_e_n_t-_e_r_r_o_r will put you back
at the error you were supposed to be correcting.

_9.  _B_u_f_f_e_r_s

When we speak of "the buffer", which contains the  text  you  are
editing, we may have given the impression that there is only one.
In fact, there may be many of them, each with  its  own  body  of
text.   At  any time only one buffer can be _c_u_r_r_e_n_t and available
for editing, but it is easy to switch to a different  one.   Each
buffer  individually remembers which file it contains, what modes
are in effect, and whether there are any changes that  need  sav-
ing.

^X B           _s_e_l_e_c_t-_b_u_f_f_e_r           Select or create a buffer.
^X ^B          _l_i_s_t-_b_u_f_f_e_r_s            List the existing buffers.
^X K           _d_e_l_e_t_e-_b_u_f_f_e_r           Delete the contents of a buffer and destroy it.
               _e_r_a_s_e-_b_u_f_f_e_r            Delete the contents of a buffer.
               _k_i_l_l-_s_o_m_e-_b_u_f_f_e_r_s       Destroy unwanted buffers.
               _r_e_n_a_m_e-_b_u_f_f_e_r           Rename the selected buffer.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  29


               _b_u_f_f_e_r-_p_o_s_i_t_i_o_n         Report the position of point within the buffer.
ESC ~          _m_a_k_e-_b_u_f_f_e_r-_u_n_m_o_d_i_f_i_e_d  Tell JOVE to forget that the buffer has been changed.
^X ^F          _f_i_n_d-_f_i_l_e               Read a file into its own buffer.
^X ^S or ^X \  _s_a_v_e-_f_i_l_e               Save the selected buffer.
^X ^M          _w_r_i_t_e-_m_o_d_i_f_i_e_d-_f_i_l_e_s    Save all modified buffers.

Each buffer in JOVE has a  single  name  which  normally  doesn't
change.   A  buffer's  name  can  be any length.  The name of the
currently selected buffer and the name of the file  contained  in
it  are  visible  in  the mode line of any window displaying that
buffer.  A newly started JOVE has only one  buffer,  named  MMMMaaaaiiiinnnn,
unless  you  specified  files  to  edit in the shell command that
started JOVE.

_9._1.  _C_r_e_a_t_i_n_g _a_n_d _S_e_l_e_c_t_i_n_g _B_u_f_f_e_r_s

To create a new buffer, you need only think  of  a  name  for  it
(say,  FOO) and then type ^X B FOO<return> (_s_e_l_e_c_t-_b_u_f_f_e_r).  This
makes a new, empty buffer (if one by that name didn't exist  pre-
viously)  and  selects  it  for editing.  The new buffer does not
contain any file, so if you try to save it you will be asked  for
the filename to use.  Each buffer has its own major mode; the new
buffer's major mode is Text mode by default.

To return to buffer FOO later after having switched  to  another,
the  same  command  ^X B FOO<return> is used, since ^X B can tell
whether  a  buffer  named  FOO  exists  already  or  not.    Just
^X B<return>    reselects    the   previous   buffer.    Repeated
^X B<return>'s alternate between the last two buffers selected.

_9._2.  _U_s_i_n_g _E_x_i_s_t_i_n_g _B_u_f_f_e_r_s

To get a list of all the buffers that exist,  type  ^X ^B  (_l_i_s_t-
_b_u_f_f_e_r_s).   Each  buffer's  type, name, and contained filename is
printed.  An asterisk before the buffer name indicates that there
are  changes  that  have  not  yet  been  saved.  The number that
appears at the beginning of a line in a  ^X ^B  listing  is  that
buffer's  _b_u_f_f_e_r  _n_u_m_b_e_r.   You can select a buffer by typing its
number in place of its  name.   If  a  buffer  with  that  number
doesn't  already  exist, a new buffer is created with that number
as its name.

If several buffers have modified text in them, you can save  them
with  ^X ^M  (_w_r_i_t_e-_m_o_d_i_f_i_e_d-_f_i_l_e_s).   This finds all the buffers
that need saving and then saves them.  Saving  the  buffers  this
way  is  much easier and more efficient (but more dangerous) than
selecting each one and typing ^X ^S  (_s_a_v_e-_f_i_l_e).   If  you  give
^X ^M  an  argument, JOVE will ask for confirmation before saving
each buffer.

ESC X _r_e_n_a_m_e-_b_u_f_f_e_r <new name><return> changes the  name  of  the
selected buffer.

ESC X _e_r_a_s_e-_b_u_f_f_e_r <buffer name><return> erases the  contents  of



                         March 19, 1996





30                 JOVE Manual for UNIX Users


<buffer name> without destroying it entirely.

ESC X _b_u_f_f_e_r-_p_o_s_i_t_i_o_n reports the position of  point  within  the
selected  buffer,  both  as lines/total-lines, chars/total-chars,
and as a percentage.

Sometimes you will change a buffer by accident.  Even if you undo
the  effect  of the change by editing, JOVE still knows that "the
buffer has been changed".  You can  tell  JOVE  to  pretend  that
there  have  been no changes with the ESC ~ command (_m_a_k_e-_b_u_f_f_e_r-
_u_n_m_o_d_i_f_i_e_d).  This command  simply  clears  the  "modified"  flag
which  says  that  the  buffer  contains changes which need to be
saved.  Even if the buffer really _i_s changed JOVE will still  act
as if it were not.

_9._2._1.  _K_i_l_l_i_n_g _B_u_f_f_e_r_s

After you use a JOVE for a while, it may  fill  up  with  buffers
which you no longer need.  Eventually you can reach a point where
trying to create any more results in an "out of memory"  or  "out
of lines" error.  When this happens you will want to destroy some
buffers with the ^X K (_d_e_l_e_t_e-_b_u_f_f_e_r) command.  You  can  destroy
the  buffer  FOO  by  doing  ^X K  FOO<return>.  If you type ^X K
<return> JOVE will kill the previously selected buffer.   If  you
try  to kill a buffer that needs saving JOVE will ask you to con-
firm it.

If you need to kill several buffers, use the  command  _k_i_l_l-_s_o_m_e-
_b_u_f_f_e_r_s.   This prompts you with the name of each buffer and asks
for confirmation before killing it.

_1_0.  _F_i_l_e _H_a_n_d_l_i_n_g

The basic unit of stored data is the file.   Each  program,  each
document,  lives  usually  in its own file.  To edit a program or
document, the file that contains it must first be brought into  a
buffer,  either  an  existing  one  (_v_i_s_i_t-_f_i_l_e)  or  one created
specifically for that file (_f_i_n_d-_f_i_l_e).  To make your changes  to
the file permanent on disk, you must _s_a_v_e the file.

_1_0._1.  _R_e_a_d_i_n_g _F_i_l_e_s

^X ^F       _f_i_n_d-_f_i_l_e             Read a file into its own buffer.
^X ^V       _v_i_s_i_t-_f_i_l_e            Visit a file.
^X ^R       _v_i_s_i_t-_f_i_l_e            An alternative to ^X ^V.
^X ^I       _i_n_s_e_r_t-_f_i_l_e           Insert a file at point.

JOVE remembers the name of the file that  is  contained  in  each
buffer  (remember the ^X ^B (_l_i_s_t-_b_u_f_f_e_r_s) command).  The name of
the buffer is visible in its mode line together with the name  of
its file.

You can read a file into its own newly created buffer  by  typing
^X ^F (_f_i_n_d-_f_i_l_e), followed by the filename.  The name of the new



                         March 19, 1996





                   JOVE Manual for UNIX Users                  31


buffer will be the last element of the file's pathname.  You  can
abort  the command by typing ^G, or edit the filename with any of
the standard JOVE commands (e.g., ^A, ^E,  ^F,  ESC F,  ESC DEL).
If  the  filename you wish to visit is similar to the filename in
the current mode line (the default filename), you can type ^R  to
insert  the  default  and  then edit it.  For more about this and
other special methods of constructing filenames, see the sections
on  _T_h_e  _M_e_s_s_a_g_e _L_i_n_e and _N_a_m_e _C_o_m_p_l_e_t_i_o_n earlier in this manual.
When you are satisfied type Return, and the new file's text  will
appear on the screen, and its name in the mode line.

The ^F in ^X ^F stands for "Find", because if the specified  file
already resides in some buffer, that buffer is simply reselected.
So you need not remember whether you have  brought  the  file  in
already  or  not.   A  buffer  created by ^X ^F can be reselected
later with ^X B or ^X ^F, whichever you find more convenient.

_V_i_s_i_t_i_n_g a file means  copying  its  contents  into  an  existing
buffer  so that you can edit them.  To visit a file, use the com-
mand ^X ^V or ^X ^R (_v_i_s_i_t-_f_i_l_e), followed by the filename.   The
name of the new file will appear in the mode line but the name of
the buffer will be unchanged.

If you alter one file and then visit another in the same  buffer,
JOVE  offers  to save the old one.  If you answer YES (or y), the
old file is saved; if you answer NO (or n), all the  changes  you
have  made  to  it  since the last save are lost.  You should not
type ahead after a file visiting command, because your type-ahead
might  answer  an  unexpected  question  in  a way that you would
regret.

^X ^I (_i_n_s_e_r_t-_f_i_l_e) followed by a filename  reads  the  file  and
inserts  it  into  the  buffer at point, leaving point before the
file contents and the mark at their end.

The changes you make with JOVE are made in a  copy  inside  JOVE.
The  file  itself  is  not changed.  The changed text is not per-
manent until you _s_a_v_e it in a file.  The first  time  you  change
the  text,  an  asterisk appears in the mode line; this indicates
that the text contains fresh changes which will  be  lost  unless
you save them.

What if you want to create a file?  Just read it  with  _f_i_n_d-_f_i_l_e
or  _v_i_s_i_t-_f_i_l_e.   JOVE  prints  (_N_e_w  _f_i_l_e)  but  aside from that
behaves as if you had read an existing empty file.  If  you  make
any changes and save them, the file is created then.  If you read
a nonexistent file unintentionally (because you typed  the  wrong
filename),  go  ahead  and read the file you meant.  The unwanted
file will not have been created.

_1_0._2.  _W_r_i_t_i_n_g _f_i_l_e_s

^X ^S or ^X ^\  _s_a_v_e-_f_i_l_e             Save the file in the selected buffer.
^X ^W           _w_r_i_t_e-_f_i_l_e            Write the selected buffer to a different file.



                         March 19, 1996





32                 JOVE Manual for UNIX Users


                _w_r_i_t_e-_r_e_g_i_o_n          Write the region to the specified file.
                _a_p_p_e_n_d-_r_e_g_i_o_n         Append the region to the specified file.

If you wish to save the file and  make  your  changes  permanent,
type  ^X ^S.   After  the  save  is  finished,  ^X ^S  prints the
filename and the number of characters and lines that it wrote  to
the  file.   If  there are no changes to save (no asterisk in the
mode line), the file is not  saved;  otherwise  the  changes  are
saved and the asterisk in the mode line disappears.

If JOVE is about to save a file and sees that  the  date  of  the
version on disk does not match what JOVE last read or wrote, JOVE
notifies you of this fact, and asks  what  to  do,  because  this
probably  means  that  something is wrong.  For example, somebody
else may have been editing the same file.  If this is  so,  there
is  a  good chance that your work or his work will be lost if you
don't take the proper steps.  You should first find  out  exactly
what  is going on.  If you determine that somebody else has modi-
fied the file, save your file under a different filename and then
DIFF  the  two  files  to  merge  the  two sets of changes.  (The
"patch" command is useful for applying  the  results  of  context
diffs directly).  Also get in touch with the other person so that
the files don't diverge any further.

^X ^W <filename><return> (_w_r_i_t_e-_f_i_l_e) writes the contents of  the
buffer  into  the  file <filename>, changing the name of the file
recorded in the mode line accordingly.  It can be thought of as a
way  of  "changing  the  name" of the file in the buffer.  Unlike
^X ^S, _w_r_i_t_e-_f_i_l_e saves even if the buffer has not been changed.

ESC X _w_r_i_t_e-_r_e_g_i_o_n <file><return> writes  the  region  (the  text
between  point  and  mark)  to  the  specified file.  It does not
change the buffer's filename.

ESC X _a_p_p_e_n_d-_r_e_g_i_o_n <file><return> appends the region to  <file>.
The text is added to the end of <file>.

_1_0._3.  _H_o_w _t_o _U_n_d_o _D_r_a_s_t_i_c _C_h_a_n_g_e_s _t_o _a _F_i_l_e

If you have made several extensive changes to  a  file  and  then
change  your mind about them, and you haven't yet saved them, you
can get rid of them by reading in the  previous  version  of  the
file.   You  can  do this with the ^X ^V (_v_i_s_i_t-_f_i_l_e) command, to
visit the unsaved version of the file.  Remember to tell  it  not
to save your existing changes when it asks.

_1_1.  _W_i_n_d_o_w_s

_1_1._1.  _M_u_l_t_i_p_l_e _W_i_n_d_o_w_s

JOVE allows you to split the screen into two or more _w_i_n_d_o_w_s  and
use  them  to  display  parts  of different buffers, or different
parts of the same buffer.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  33



8___________________________________________________________________________________________________________________________
 #define getchar()    getc(stdin)
 #define putchar(x)   putc((x), stdout)                       < first Window
8_____________________________________________________________
 JJJJOOOOVVVVEEEE ((((CCCC RRRROOOO))))   [[[[ssssttttddddiiiioooo....hhhh::::1111]]]]  """"////uuuussssrrrr////iiiinnnncccclllluuuuddddeeee////ssssttttddddiiiioooo....hhhh""""  --------        < the Mode Line
8_____________________________________________________________
 {
     printf("Hello world!\n");
     return 0;                                                < second Window
 }[]
8_____________________________________________________________
 JJJJOOOOVVVVEEEE ((((CCCC OOOOvvvvrrrrWWWWtttt))))   [[[[MMMMaaaaiiiinnnn::::1111]]]]  """"aaaalllloooohhhhaaaa....cccc""""  --------  ////hhhhoooommmmeeee////ffffoooooooo    11115555::::22228888 < the Mode Line
8_____________________________________________________________
 [Point pushed]                                               < the Message Line
8___________________________________________________________________________________________________________________________
7|8|7|7|7|7|7|7|7|7|7|7|999999999999999999999|8|7|7|7|7|7|7|7|7|7|7|









9                                                            |8|7|7|7|7|7|7|7|7|7|7|999999999999999999999|8|7|7|7|7|7|7|7|7|7|7|











9^X 2        _s_p_l_i_t-_c_u_r_r_e_n_t-_w_i_n_d_o_w   Divide the active window into two smaller ones.
^X 1        _d_e_l_e_t_e-_o_t_h_e_r-_w_i_n_d_o_w_s   Delete all windows but the current one.
^X D        _d_e_l_e_t_e-_c_u_r_r_e_n_t-_w_i_n_d_o_w  Delete the active window.
^X N        _n_e_x_t-_w_i_n_d_o_w            Switch to the next window.
^X P        _p_r_e_v_i_o_u_s-_w_i_n_d_o_w        Switch to the previous window.
^X O        _p_r_e_v_i_o_u_s-_w_i_n_d_o_w        Same as ^X P.
^X ^        _g_r_o_w-_w_i_n_d_o_w            Make this window bigger.
            _s_h_r_i_n_k-_w_i_n_d_o_w          Make this window smaller.
ESC ^V      _p_a_g_e-_n_e_x_t-_w_i_n_d_o_w       Scroll the other window.
^X 4        _w_i_n_d_o_w-_f_i_n_d            Combination window command.

When using _m_u_l_t_i_p_l_e _w_i_n_d_o_w mode, the window portion of the screen
is  divided  into  _w_i_n_d_o_w_s, which can display different pieces of
text.  Each window can display different  buffers,  or  different
parts  of  the  same  buffer.  Only one of the windows is _a_c_t_i_v_e,
viz.  the window which the cursor is in.  Editing normally  takes
place in that window alone.  To edit in another window, you would
give a command to move the cursor to the other window,  and  then
edit there.

Each window includes a mode line for the buffer it is displaying.
This  is  useful  to  keep track of which window corresponds with
which buffer and which file.  In addition, the mode  line  serves
as  a  separator  between  windows.  Normally, the variable _m_o_d_e-
_l_i_n_e-_s_h_o_u_l_d-_s_t_a_n_d_o_u_t is _o_n so that JOVE displays the mode-line in
reverse  video (assuming your particular terminal has the reverse
video capability).  However, if the variable _s_c_r_o_l_l-_b_a_r  is  also
_o_n,  a portion of the mode line is left clear to indicate how the
window is located within the buffer.

The command ^X 2 (_s_p_l_i_t-_c_u_r_r_e_n_t-_w_i_n_d_o_w) divides the active window
into  two.  A new mode line appears across the middle of the ori-
ginal window, dividing its display area into  two  halves.   Both
windows  contain the same buffer and display the same position in
it, namely where point was at the time you  issued  the  command.
The cursor moves to the second window.

To return to viewing  only  one  window,  use  the  command  ^X 1
(_d_e_l_e_t_e-_o_t_h_e_r-_w_i_n_d_o_w_s).   The  active  window expands to fill the
whole screen, and the other  windows  disappear  until  the  next



                         March 19, 1996





34                 JOVE Manual for UNIX Users


^X 2.   (The  buffers and their contents are unaffected by any of
the window operations).

While there is more than one window,  you  can  use  ^X N  (_n_e_x_t-
_w_i_n_d_o_w)  to switch to the next window, and ^X P (_p_r_e_v_i_o_u_s-_w_i_n_d_o_w)
to switch to the previous one.  If you are in the  bottom  window
and  you type ^X N, you will be placed in the top window, and the
opposite thing happens when you type  ^X P  in  the  top  window.
^X O  is the same as ^X P.  It stands for "other window" because,
when there are only two windows, repeated  use  of  this  command
will switch between them.

Often you will be editing one window while using the  other  just
for  reference.   Then,  the command ESC ^V (_p_a_g_e-_n_e_x_t-_w_i_n_d_o_w) is
very useful.  It scrolls the next  window  up,  just  as  if  you
switched to the next window, typed ^V, and switched back.  With a
negative argument, ESC ^V will scroll down.

When a window splits, both  halves  are  approximately  the  same
size.   You can redistribute the screen space between the windows
with the ^X ^ (_g_r_o_w-_w_i_n_d_o_w) command.  It makes the active  window
grow  one  line  bigger,  or as many lines as is specified with a
numeric argument.  Use ESC X _s_h_r_i_n_k-_w_i_n_d_o_w  to  make  the  active
window smaller.

_1_1._2.  _M_u_l_t_i_p_l_e _B_u_f_f_e_r_s _i_n _M_u_l_t_i_p_l_e _W_i_n_d_o_w_s

Buffers can be selected independently in each window.   The  ^X B
(_s_e_l_e_c_t-_b_u_f_f_e_r)  command selects a different buffer in the active
window (i.e. the one  containing  the  cursor).   Other  windows'
buffers  do  not change.  Likewise, the ^X ^F (_f_i_n_d-_f_i_l_e) command
reads a new file into a new buffer in the active window.

You can view the same buffer in more than one  window.   Although
the  same  buffer  appears  in  both windows, they have different
values of point, so you can move around in one window  while  the
other  window  continues  to  show  the  same  text.  If you make
changes in one window, and the same place in the  buffer  happens
to  be  visible  in  the  other  window, your changes will appear
simultaneously in both places.

If you have the same buffer in both windows, you must  beware  of
trying  to  visit  a  different  file  in one of the windows with
^X ^V, because if you bring a new file into this buffer  it  will
replace the old file in _b_o_t_h windows.  To view different files in
different windows, you must switch buffers in one of the  windows
first (with ^X B) or use ^X ^F (_f_i_n_d-_f_i_l_e).

A convenient  "combination"  command  for  viewing  something  in
another  window is ^X 4 (_w_i_n_d_o_w-_f_i_n_d).  With this command you can
ask to see any specified buffer, file or tag in the other window.
Follow  the  ^X 4  with  either  B  and  a  buffer  name, F and a
filename, or T and a tag name.  This switches to the other window
and  finds  there  what you specified.  If you were previously in



                         March 19, 1996





                   JOVE Manual for UNIX Users                  35


one-window mode, multiple-window mode  is  entered.   ^X 4  B  is
similar  to ^X 2 ^X B; ^X 4 F is similar to ^X 2 ^X ^F; ^X 4 T is
similar to ^X 2 ^X T.  The difference is one of  efficiency,  and
also  that  ^X 4  works equally well if you are already using two
windows.

_1_1._3.  _C_o_n_t_r_o_l_l_i_n_g _t_h_e _D_i_s_p_l_a_y

Since only part of a large file will fit in a window, JOVE  tries
to  show  the  portion  that  is  likely  to be interesting.  The
display control commands allow you to bring a  different  portion
of the buffer within the active window.

^L          _r_e_d_r_a_w-_d_i_s_p_l_a_y
7                                    Reposition point at a specified vertical
                                    position, OR clear and redraw the window
                                    with point in the same place.
ESC ^L      _c_l_e_a_r-_a_n_d-_r_e_d_r_a_w        Clear and redraw the entire screen.
^V          _n_e_x_t-_p_a_g_e               Scroll forwards (a page or a few lines).
ESC V       _p_r_e_v_i_o_u_s-_p_a_g_e           Scroll backwards.
^Z          _s_c_r_o_l_l-_u_p               Scroll forward some lines.
ESC Z       _s_c_r_o_l_l-_d_o_w_n             Scroll backwards some lines.
            _s_c_r_o_l_l-_l_e_f_t             Scroll the window to the left.
            _s_c_r_o_l_l-_r_i_g_h_t            Scroll the window to the right.
            _n_u_m_b_e_r-_l_i_n_e_s-_i_n-_w_i_n_d_o_w  Number the lines in the window.

A window is rarely large enough to display all of your file.   If
the whole buffer doesn't fit on the screen, JOVE shows a contigu-
ous portion of  it,  containing  point.   It  continues  to  show
approximately  the same portion until point moves outside of what
is displayed; then JOVE chooses a new portion centered  around  a
new  point.   This  is  JOVE's  guess  as  to  what  you are most
interested in seeing, but if the guess is wrong, you can use  the
display control commands to see a different portion.

If the window holds only a part of the buffer, and if  the  vari-
able  _s_c_r_o_l_l-_b_a_r  is _o_n, a clear patch in the (otherwise reverse-
videoed) mode line indicates what proportion is visible.  This is
especially useful for mouse-based versions of the editor, such as
_x_j_o_v_e.

First we describe how JOVE chooses a new window position  on  its
own.   The  goal is usually to place point half way down the win-
dow.  This is controlled by the variable _s_c_r_o_l_l-_s_t_e_p, whose value
is  the  number of lines above the bottom or below the top of the
window that the line containing point is placed.  A  value  of  0
(the initial value) means center point in the window.

The basic display control command is ^L (_r_e_d_r_a_w-_d_i_s_p_l_a_y).  In its
simplest  form,  with  no argument, it tells JOVE to choose a new
portion of the buffer, centering the existing point half way from
the top as usual.  ^L with a positive argument chooses a new por-
tion so as to put point that many lines from the top.   An  argu-
ment  of  zero  puts  point on the very top line.  Point does not
move with respect to the text; rather, the text  and  point  move



                         March 19, 1996





36                 JOVE Manual for UNIX Users


rigidly on the screen.

If during the ^L command point stays on the same line, the window
is  first  cleared and then redrawn.  Thus, two ^L's in a row are
guaranteed  to  clear  and  redraw  the  active  window.   ESC ^L
(_c_l_e_a_r-_a_n_d-_r_e_d_r_a_w) will clear and redraw the entire screen.

The _s_c_r_o_l_l_i_n_g commands ^V, ESC V, ^Z, and ESC Z let you move  the
whole  display  up  or down a few lines.  In fact, with a numeric
argument, ^V is identical to  ^Z  and  ESC V  to  ESC Z.   So  ^V
(_n_e_x_t-_p_a_g_e)  or  ^Z  (_s_c_r_o_l_l-_u_p)  with an argument shows you that
many more lines at the bottom of the screen, moving the text  and
point up together as ^L might.  ^V or ^Z with a negative argument
shows you more lines at the top of  the  screen,  as  does  ESC V
(_p_r_e_v_i_o_u_s-_p_a_g_e) or ESC Z (_s_c_r_o_l_l-_d_o_w_n) with a positive argument.

^V with no argument scrolls the buffer a window at  a  time.   It
takes  the  last  line at the bottom of the window and puts it at
the top, followed by nearly a whole window of lines  not  visible
before.   Point  is  put at the top of the window.  Thus, each ^V
shows the "next page of text", except for one line of overlap  to
provide  context.   To  move backward, use ESC V without an argu-
ment, which moves a whole window backwards (again with a line  of
overlap).

With no argument, ^Z and ESC Z scroll one line  forward  and  one
line  backward, respectively.  These are convenient for moving in
units of one line without having to type a numeric argument.

The commands _s_c_r_o_l_l-_l_e_f_t and _s_c_r_o_l_l-_r_i_g_h_t scroll the entire  win-
dow  in the specified direction by the amount of the argument (or
for 10 characters by default).  The argument may be negative.

The command _n_u_m_b_e_r-_l_i_n_e_s-_i_n-_w_i_n_d_o_w causes each line displayed  to
be  preceded  by  its  line-number  (and giving the command again
restores the former state).  Note that this state is  a  property
of the window, not of the buffer.

_1_2.  _P_r_o_c_e_s_s_e_s _U_n_d_e_r _J_O_V_E

An important feature of JOVE is  its  ability  to  interact  with
UNIX.  You can run UNIX commands from JOVE and catch their output
in  JOVE  buffers.   Two  mechanisms  are  provided,  _i_n_t_e_r_a_c_t_i_v_e
_p_r_o_c_e_s_s_e_s and _n_o_n-_i_n_t_e_r_a_c_t_i_v_e _p_r_o_c_e_s_s_e_s.

_1_2._1.  _I_n_t_e_r_a_c_t_i_v_e _P_r_o_c_e_s_s_e_s

With most modern UNIX systems, JOVE has the capability of running
interactive  processes,  accepting  your input and capturing your
output in a buffer.

            _s_h_e_l_l
7                                  Run a shell in  an  interactive
                                  process buffer.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  37


            _i-_s_h_e_l_l-_c_o_m_m_a_n_d
7                                  Run  a  UNIX  command   in   an
                                  interactive process buffer.

_1_2._1._1.  _H_o_w _t_o _R_u_n _a _S_h_e_l_l _i_n _a _W_i_n_d_o_w

Type ESC X _s_h_e_l_l<return> to start up a shell.  JOVE will create a
buffer,  called  **** sssshhhheeeellllllll **** ---- 1111,  and choose a window for this new
buffer.  The shell process is now said  to  be  attached  to  the
buffer.   The  program  that is now running in the buffer is that
specified by the variable _s_h_e_l_l, which is itself initialized from
your  SHELL  environment  variable.   The shell command is called
with the flag "-c", or whatever else the variable _s_h_e_l_l-_f_l_a_g_s has
been set to.

Use an argument (nnnn)  with  the  _s_h_e_l_l  command  to  create  other
buffers (****sssshhhheeeellllllll****----nnnn) running independent shells.

Once an interactive process is running  you  can  select  another
buffer  into  that  window,  or  you can delete that window alto-
gether.  You can go off and do some other editing while the  com-
mand  is  running.   This is useful for commands that do sporadic
output and run  for  fairly  long  periods  of  time.   When  you
reselect  that buffer later it will be up to date.  That is, even
though the buffer wasn't visible it was  still  receiving  output
from the process.  You don't have to worry about missing anything
when the buffer isn't visible.

_1_2._1._2.  _H_o_w _t_o _R_u_n _a _C_o_m_m_a_n_d _i_n _a _W_i_n_d_o_w

To run a UNIX command  interactively  from  JOVE  type  ESC X  _i-
_s_h_e_l_l-_c_o_m_m_a_n_d  <command-name><return>.   For  example, to run the
desk calculator, you do:
        ESC X i-shell-command dc<return>
Then JOVE picks a buffer in which the  output  from  the  command
will  be placed, named after the command (_d_c in this case).  Com-
pare this command to  the  non-interactive  _s_h_e_l_l-_c_o_m_m_a_n_d  to  be
described presently.

_1_2._1._3.  _F_a_c_i_l_i_t_i_e_s _a_v_a_i_l_a_b_l_e _i_n _i_n_t_e_r_a_c_t_i_v_e _w_i_n_d_o_w_s

What you type into an interactive process isn't seen  immediately
by  the process; instead JOVE waits until you type an entire line
before passing it on to the process to  read.   This  means  that
before  you  type  Return  all of JOVE's editing capabilities are
available for fixing errors on your input line.  If you  discover
an  error  at  the beginning of the line, rather than erasing the
whole line and starting over you can simply move  to  the  error,
correct it, move back, and continue typing.

In fact Return does different things depending on both your posi-
tion  in the buffer and on the state of the process.  In the nor-
mal case, when point is in the last line of  the  buffer,  Return
does  as  already described: it inserts a line-separator and then
sends the line to the process.  If you are somewhere else in  the



                         March 19, 1996





38                 JOVE Manual for UNIX Users


buffer,  possibly  positioned at a previous command that you want
to edit, Return will place a copy of that line at the end of  the
buffer  and move you there (the prompt will be discarded if there
is one - the variable _p_r_o_c_e_s_s-_p_r_o_m_p_t specifies what  to  discard)
Then you can edit the line and type Return as in the normal case.
If the process has died for some reason, Return does nothing.  It
doesn't  even  insert  itself.  If that happens unexpectedly, you
should type ESC X _l_i_s_t-_p_r_o_c_e_s_s_e_s<return> to get a  list  of  each
process  and  its  state.  If your process died abnormally, _l_i_s_t-
_p_r_o_c_e_s_s_e_s may help you figure out why.

Another feature is that you have the entire history of your  ses-
sion  in  the  JOVE buffer.  You don't have to worry about output
from a command moving past the top of the screen.  If you  missed
some  output  you  can  move back through it with ESC V and other
commands.  In addition, you can save yourself retyping a  command
(or  a  similar  one) by sending edited versions of previous com-
mands, or edit the output of one command to become a list of com-
mands to be executed ("immediate shell scripts").

There are several special commands available only in  interactive
windows.

Return      _p_r_o_c_e_s_s-_n_e_w_l_i_n_e              Send a line to a process.
            _p_r_o_c_e_s_s-_s_e_n_d-_d_a_t_a-_n_o-_r_e_t_u_r_n
7                                         Send a  line  to  a  process,  but  without  the  line-
                                         separator.
^C ^C       _i_n_t_e_r_r_u_p_t-_p_r_o_c_e_s_s            Send SIGINT to the process.
^C \        _q_u_i_t-_p_r_o_c_e_s_s                 Send SIGQUIT to the process.
^C ^Z       _s_t_o_p-_p_r_o_c_e_s_s                 Send SIGTSTP to the process.
^C ^Y       _d_s_t_o_p-_p_r_o_c_e_s_s                Send SIGTSTP when next the process tries to read input.
            _c_o_n_t_i_n_u_e-_p_r_o_c_e_s_s             Send SIGCONT to the process.
            _k_i_l_l-_p_r_o_c_e_s_s                 Send SIGKILL to the process in a specified buffer.
^C ^D       _e_o_f-_p_r_o_c_e_s_s                  Send EOF to the process.
            _p_r_o_c_e_s_s-_d_b_x-_o_u_t_p_u_t           Toggle the processing of output from _d_b_x.
Although Return is automatically bound  to  _p_r_o_c_e_s_s-_n_e_w_l_i_n_e,  the
various  ^C ...  must be explicitly bound in your (or your system
administrator's) customization.  The effects of Return  (_p_r_o_c_e_s_s-
_n_e_w_l_i_n_e)  in  various  circumstances  have already been described
above.  The effects of ^C ^xxxx for  various  xxxx  are  equivalent  to
sending  ^xxxx  to the shell, assuming the customary bindings as set
up by _s_t_t_y.  Observe that ^xxxx without a  preceding  ^C  will  have
some  other  effect  in  JOVE  (for example, ^D is still bound to
_d_e_l_e_t_e-_n_e_x_t-_c_h_a_r_a_c_t_e_r).

_1_2._1._4.  _D_B_X _i_n _i_n_t_e_r_a_c_t_i_v_e _w_i_n_d_o_w_s

If the debugging program _d_b_x is provided with your  UNIX  system,
you  may of course run it in an interactive window.  Before doing
this, you should type ESC X _p_r_o_c_e_s_s-_d_b_x-_o_u_t_p_u_t.   The  effect  of
this is that, every time _d_b_x halts with a message line specifying
a filename and linenumber (at  every  breakpoint,  for  example),
_f_i_n_d-_f_i_l_e  will automatically be called on that filename, it will
appear in a new window, and point will be  moved  to  that  line.
Thus  you  may  easily  follow  the progress of the program being



                         March 19, 1996





                   JOVE Manual for UNIX Users                  39


debugged.

_1_2._2.  _N_o_n-_i_n_t_e_r_a_c_t_i_v_e _P_r_o_c_e_s_s_e_s

The reason these are called non-interactive processes is that you
can't  type any input to them; you can't interact with them; they
can't ask you questions because  there  is  no  way  for  you  to
answer.   Remember  that  JOVE (not the process in the window) is
listening to your keyboard, and JOVE waits until the process dies
before it looks at what you type.

^X !        _s_h_e_l_l-_c_o_m_m_a_n_d               Run a UNIX command in a buffer.
            _s_h_e_l_l-_c_o_m_m_a_n_d-_n_o-_b_u_f_f_e_r     Run a UNIX command without any buffer.
            _s_h_e_l_l-_c_o_m_m_a_n_d-_t_o-_b_u_f_f_e_r     Run a UNIX command in a named buffer.
            _s_h_e_l_l-_c_o_m_m_a_n_d-_w_i_t_h-_t_y_p_e_o_u_t
7                                        Run a UNIX command sending  output  to
                                        the screen.

To run  a  UNIX  command  from  JOVE  just  type  ^X !  <command-
name><return>.   For  example,  to get a list of all the users on
the system, you do:
        ^X ! who<return>
Then JOVE picks a buffer in which the  output  from  the  command
will  be  placed,  named  after  the command.  E.g., "who" uses a
buffer called wwwwhhhhoooo; "ps alx" uses ppppssss; and "egrep -n foo *.c"  uses
eeeeggggrrrreeeepppp.   If  JOVE  wants  to  use a buffer that already exists it
first erases the old contents.  If the buffer it selects holds  a
file,  not  output  from a previous shell command, you must first
delete that buffer with ^X K (_d_e_l_e_t_e-_b_u_f_f_e_r).  There are variants
of  the command where there is no buffer, where you can name your
own buffer, and where the output is direct to the screen (see the
section on typeout at the start of this manual).

Once JOVE has picked a buffer it puts that buffer in a window  so
you  can  see the command's output as it is running.  If there is
only one window JOVE will automatically make another one.  Other-
wise,  JOVE  tries  to pick the most convenient window other than
the current one.

It is not a good idea to type anything while the command is  run-
ning  because  JOVE won't see the characters (and thus won't exe-
cute them) until the command finishes, so you may forget what you
have  typed.   If  you really want to carry on with other editing
tasks while it is running, it  is  better  to  use  the  _i-_s_h_e_l_l-
_c_o_m_m_a_n_d described previously.

If you want to interrupt the command for some reason (perhaps you
mistyped  it, or you changed your mind) you can type ^] (or what-
ever else has been  put  in  the  variable  _i_n_t_e_r_r_u_p_t-_c_h_a_r_a_c_t_e_r).
Typing this inside JOVE while a process is running is the same as
typing ^C when you are outside JOVE, namely the process is inter-
rupted.

When the command finishes, JOVE puts you back in  the  window  in
which  you  started.  Then it prints a message indicating whether



                         March 19, 1996





40                 JOVE Manual for UNIX Users


or not the command completed successfully in its (the  command's)
opinion.   That is, if the command had what it considers an error
(or you interrupt it with ^]) JOVE will print an appropriate mes-
sage.

_1_2._2._1.  _A_p_p_l_i_c_a_t_i_o_n_s _o_f _N_o_n-_I_n_t_e_r_a_c_t_i_v_e _P_r_o_c_e_s_s_e_s

^X ! (_s_h_e_l_l-_c_o_m_m_a_n_d) is useful for running commands that do  some
output  and  then  exit.  So you could type ^X ! spell <filename>
and it would create a buffer "spell", fill it with all the  spel-
ling mistakes in <filename> and display it in a window.  However,
as we have already seen, there is a built-in JOVE command  to  do
this job (and more) which, behind the scenes, issues exactly that
_s_h_e_l_l-_c_o_m_m_a_n_d.  Thus, the built in usage of this facility by JOVE
itself is as important as any use you might invent for yourself.

You could run a program through a compiler  using  _s_h_e_l_l-_c_o_m_m_a_n_d,
but  again  JOVE provides a special command for the job.  This is
the ^X ^E (_c_o_m_p_i_l_e-_i_t) command.  If you run  _c_o_m_p_i_l_e-_i_t  with  no
argument  it  runs  the  UNIX _m_a_k_e program into a buffer.  If you
need a special command or want to pass  arguments  to  _m_a_k_e,  run
_c_o_m_p_i_l_e-_i_t  with any argument (^U is good enough) and you will be
prompted for the command to execute.  If any error  messages  are
produced,  they are treated specially by JOVE.  That treatment is
the subject of the next section.

Another useful example of using the  _s_h_e_l_l-_c_o_m_m_a_n_d  would  be  to
type  ^X !  egrep -l  <identifier> *.c, to give you a list of all
your .c files containing that <identifier>.

_1_2._2._1._1.  _E_r_r_o_r _M_e_s_s_a_g_e _P_a_r_s_i_n_g

            _p_a_r_s_e-_e_r_r_o_r_s                     Prepare to exhibit the errors listed in the buffer.
            _p_a_r_s_e-_s_p_e_l_l_i_n_g-_e_r_r_o_r_s-_i_n-_b_u_f_f_e_r  Prepare to exhibit the listed spelling errors.
^X ^N       _n_e_x_t-_e_r_r_o_r                       Move to the next listed error.
^X ^P       _p_r_e_v_i_o_u_s-_e_r_r_o_r                   Move to the previous listed error.
            _c_u_r_r_e_n_t-_e_r_r_o_r                    Move to the current listed error.

When you have your error messages in a buffer as produced by  the
_s_h_e_l_l-_c_o_m_m_a_n_d,  you  run  the  _p_a_r_s_e-_e_r_r_o_r_s command (this happens
automatically after a _c_o_m_p_i_l_e-_i_t).   Each  line  in  this  buffer
should  specify  a  filename  and a linenumber (JOVE knows how to
interpret the error messages from many UNIX commands; in particu-
lar  from  _c_c, _g_r_e_p -_n and _l_i_n_t).  _P_a_r_s_e-_e_r_r_o_r_s then does a _f_i_n_d-
_f_i_l_e  on  the  first  such  filename  and  a  _g_o_t_o-_l_i_n_e  on   its
linenumber.   When  you  have  dealt  with the error on that line
(perhaps editing lines elsewhere in your program in the  process)
you  can  type  ^X ^N  (_n_e_x_t-_e_r_r_o_r)  to  move  to  the next error
(perhaps in a different file).  Or you can type ^X ^P  (_p_r_e_v_i_o_u_s-
_e_r_r_o_r)  or ESC X _c_u_r_r_e_n_t-_e_r_r_o_r.  The rules JOVE uses to interpret
error message in a buffer are specified in  the  variable  _e_r_r_o_r-
_f_o_r_m_a_t-_s_t_r_i_n_g.

The action following the JOVE command _s_p_e_l_l  is  similar,  except



                         March 19, 1996





                   JOVE Manual for UNIX Users                  41


that  it calls (automatically) the command _p_a_r_s_e-_s_p_e_l_l_i_n_g-_e_r_r_o_r_s-
_i_n-_b_u_f_f_e_r instead of _p_a_r_s_e-_e_r_r_o_r_s.

If you already have a file called _e_r_r_s containing,  say,  C  com-
piler messages then you can get JOVE to interpret the messages by
invoking it as:
        % _j_o_v_e -_p _e_r_r_s

_1_2._2._1._2.  _F_i_l_t_e_r_i_n_g

            _f_i_l_t_e_r-_r_e_g_i_o_n
7                                  Pass the region through a  com-
                                  mand  and  replace  it with the
                                  output.

Suppose your buffer contains a table.  You make  this  table  the
region  (put mark at the start of it and point at the end).  Type
ESC X _f_i_l_t_e_r-_r_e_g_i_o_n _s_o_r_t<return> (or  any  other  UNIX  command).
Your  table  will  be passed through the UNIX _s_o_r_t command and be
replaced by the sorted version of itself.   The  old  version  is
placed  in  the  kill ring, and you can restore the status quo by
obeying the _y_a_n_k-_p_o_p command.

_1_3.  _D_i_r_e_c_t_o_r_y _H_a_n_d_l_i_n_g

To save having to use absolute pathnames when you want to edit  a
nearby  file JOVE maintains a _c_u_r_r_e_n_t _d_i_r_e_c_t_o_r_y and allows you to
move around the UNIX filesystem just as a shell would.

            _c_d dir                Change to the specified directory.
            _p_u_s_h_d [dir]
7                                  Like _c_d, but saves the old directory on  the
                                  directory  stack.   With  no directory argu-
                                  ment, simply exchanges the  top  two  direc-
                                  tories on the stack and _c_ds to the new top.
            _p_u_s_h_l_i_b_d
7                                  Does a _p_u_s_h_d on the directory containing all
                                  of JOVE's standard customization files.
            _p_o_p_d
7                                  Take the current directory off the stack and
                                  restore the previous one.
            _d_i_r_s                  Display the contents of the directory stack.

The names and behavior of these commands  were  chosen  to  mimic
those in the c-shell.

_1_4.  _M_a_j_o_r _a_n_d _M_i_n_o_r _M_o_d_e_s

_1_4._1.  _M_a_j_o_r _M_o_d_e_s

To help with editing particular types of file, say a document  or
a  C  program,  JOVE  has several _m_a_j_o_r _m_o_d_e_s.  Each mode defines
rules as to which characters constitute a "word"  (for  the  pur-
poses  of  regular-expressions,  language  identifiers, abbrevia-
tions, and double-clicking in _x_j_o_v_e), how indentation  is  to  be
performed,  and  maybe  other  specialized  services.   These are
currently as follows:




                         March 19, 1996





42                 JOVE Manual for UNIX Users


_1_4._1._1.  _F_u_n_d_a_m_e_n_t_a_l _M_o_d_e

This is the simplest mode, with no frills, and is used  when  you
are operating within the message line at the bottom of the screen
(hence it is the mode of the Minibuf).

_1_4._1._2.  _T_e_x_t _m_o_d_e

This is the default major mode.  Nothing special is  done  beyond
making apostrophe (') be a word character.

_1_4._1._3.  _C _m_o_d_e

In this mode, "$" and "_" are word characters, and there are spe-
cial  facilities for indentation.  Using the _a_u_t_o-_e_x_e_c_u_t_e-_c_o_m_m_a_n_d
command, you can make JOVE enter _C _M_o_d_e whenever you edit a  file
whose name ends in ._c.

_1_4._1._3._1.  _I_n_d_e_n_t_a_t_i_o_n _C_o_m_m_a_n_d_s

To save having to lay out C programs "by hand", JOVE has an  idea
of  the  correct  indentation of a line, based on the surrounding
context.  When you are in C Mode, JOVE treats  tabs  specially  -
typing  a Tab at the beginning of a new line means "indent to the
right place" (actually, it just goes back to the line  containing
the  nearest  unmatched  "{",  and  indents  1 Tab more than that
line).  The indentation will be in multiples of the  variable  _c-
_i_n_d_e_n_t_a_t_i_o_n-_i_n_c_r_e_m_e_n_t  (which defaults to 8).  Closing braces are
also handled specially, and are indented to match the correspond-
ing open brace.

If you Tab in the middle of a (...)  (for  example,  you  call  a
function  whose  actual-parameters  stretch over many lines) then
you  have  a  choice  depending  on  the   variable   _c-_a_r_g_u_m_e_n_t-
_i_n_d_e_n_t_a_t_i_o_n.   If  its  value is -1, you will be aligned with the
corresponding actual-parameter on the line above.  Otherwise,  _c-
_a_r_g_u_m_e_n_t-_i_n_d_e_n_t_a_t_i_o_n  gives  the  extra  number  of characters by
which to indent this continuation line.

If you really want a Tab to mean a single Tab on some  particular
occasion, you can always precede it by a ^Q (_q_u_o_t_e_d-_i_n_s_e_r_t).

_1_4._1._3._2.  _P_a_r_e_n_t_h_e_s_i_s _a_n_d _B_r_a_c_e _M_a_t_c_h_i_n_g

            _s_h_o_w-_m_a_t_c_h-_m_o_d_e       Toggle the _S_h_o_w _M_a_t_c_h minor mode.
ESC ^N      _f_o_r_w_a_r_d-_l_i_s_t          Move forwards over a (...).
ESC ^P      _b_a_c_k_w_a_r_d-_l_i_s_t         Move backwards over a (...).
ESC ^D      _d_o_w_n-_l_i_s_t             Move forward to just inside the next (...).
ESC ^U      _b_a_c_k_w_a_r_d-_u_p-_l_i_s_t
7                                  Move backwards to the start of the  enclos-
                                  ing (...).

To check that parentheses and braces match the way you think they
do,  turn  on  the _S_h_o_w _M_a_t_c_h minor mode (ESC X _s_h_o_w-_m_a_t_c_h-_m_o_d_e).
Then, whenever you type a close brace or parenthesis, the  cursor



                         March 19, 1996





                   JOVE Manual for UNIX Users                  43


moves  momentarily  to  the  matching  opener, if it is currently
visible.  If it's not visible, JOVE displays the line  containing
the matching opener on the message line.

If your parenthesized expressions are already typed, then you may
find  ESC ^N  and  ESC ^P useful to find a closing parenthesis to
match an opening one somewhere just after point, or a closing one
to  match  an opening one somewhere just before point.  Note that
these commands handle all kinds of parentheses ((...), [...]  and
{...})  and  properly  matched  internal  pairs are skipped over.
These two commands take arguments and go in the  opposite  direc-
tion  if  the argument is negative.  Likewise, the commands ESC D
(_d_o_w_n-_l_i_s_t) and ESC U (_b_a_c_k_w_a_r_d-_u_p-_l_i_s_t) may be used to find more
or less (respectively) deeply nested parentheses.

_1_4._1._3._3.  _C _T_a_g_s

Often when you are editing a C program, especially someone else's
code, you see a function call and wonder what that function does.
So you have to suspend the edit, _g_r_e_p for  the  function-name  in
every  .c  file  that  might  contain  it,  and finally visit the
appropriate file.

To avoid this diversion or the need to remember which function is
defined in which file, many UNIX systems provide a program called
_c_t_a_g_s(_1), which takes a set of source files and looks  for  func-
tion definitions, producing a file called _t_a_g_s as its output.

^X T        _f_i_n_d-_t_a_g              Find the file/line where the specified tag is declared.
            _f_i_n_d-_t_a_g-_a_t-_p_o_i_n_t     Find the tag immediately following point.

JOVE has a command called ^X T (_f_i_n_d-_t_a_g) that  prompts  you  for
the name of a function (a _t_a_g), looks up the tag reference in the
previously constructed _t_a_g_s file, then performs  a  _f_i_n_d-_f_i_l_e  on
the file containing that tag, with point positioned at the defin-
ition of the function.  There is another version of this command,
_f_i_n_d-_t_a_g-_a_t-_p_o_i_n_t, that uses the identifier at point.

So, when you've added new functions to a module,  or  moved  some
old  ones  around,  run  the _c_t_a_g_s program to regenerate the _t_a_g_s
file.  JOVE looks in the file specified by the variable _t_a_g-_f_i_l_e.
The  default is "..../tags", i.e. the tag file in the current direc-
tory.  If you wish to use an alternate tag file you  use  ^U ^X T
and JOVE will prompt for a file name.

To begin an editing session looking for a particular tag, use the
- _t _t_a_g command line option to JOVE.  For example, say you wanted
to look at the file containing the tag _S_k_i_p_C_h_a_r, you would invoke
JOVE as:
        % _j_o_v_e -_t _S_k_i_p_C_h_a_r

_1_4._1._4.  _L_i_s_p _m_o_d_e

In this mode, any of the characters "!$%&* + - /:<=>?^_{|}~"  and



                         March 19, 1996





44                 JOVE Manual for UNIX Users


Delete  are  word  characters  (in  other words, "words" are Lisp
atoms).  The mode is analogous to _C _M_o_d_e, but performs the inden-
tation needed to lay out Lisp programs properly.

_1_4._1._4._1.  _P_a_r_e_n_t_h_e_s_i_s _M_a_t_c_h_i_n_g

In addition to the parenthesis matching commands available  under
C mode, we have:

ESC ^F      _f_o_r_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n   Move backward over an atom or list.
ESC ^B      _b_a_c_k_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n  Move forward over an atom or a list.
            _g_r_i_n_d-_s-_e_x_p_r_e_s_s_i_o_n     Re-indent an s-expression.
ESC ^K      _k_i_l_l-_s-_e_x_p_r_e_s_s_i_o_n      Kill from point to the end of an s-expression.

In fact the first two of these commands work in other modes also,
but for "atom" read "identifier".

_1_4._2.  _M_i_n_o_r _M_o_d_e_s

In addition to the major modes, JOVE has a  set  of  minor  modes
whose state is controlled by the following commands:

            _a_u_t_o-_i_n_d_e_n_t-_m_o_d_e
            _a_u_t_o-_f_i_l_l-_m_o_d_e
            _o_v_e_r-_w_r_i_t_e-_m_o_d_e
            _r_e_a_d-_o_n_l_y-_m_o_d_e
            _s_h_o_w-_m_a_t_c_h-_m_o_d_e
            _w_o_r_d-_a_b_b_r_e_v-_m_o_d_e

With no argument, these commands toggle the mode.   With  a  zero
argument  they turn it _o_f_f, and with any other argument they turn
it _o_n.

_1_4._2._1.  _A_u_t_o _I_n_d_e_n_t

In this mode, JOVE indents each line the same way as  that  above
it.   That  is,  the Return key in this mode acts as the Linefeed
key ordinarily does.  This mode is only likely to  be  useful  if
you are afflicted with a keyboard without a Linefeed key.

_1_4._2._2.  _A_u_t_o _F_i_l_l

In _A_u_t_o _F_i_l_l mode, a newline is automatically inserted  when  the
line  length  exceeds the right margin.  This way, you can type a
whole paragraph without having to use the Return key.

_1_4._2._3.  _O_v_e_r _W_r_i_t_e

In this mode, any text typed in will replace  the  previous  con-
tents  (the default is for new text to be inserted and "push" the
old along).  This is  useful  for  editing  an  already-formatted
diagram  in  which  you want to change some things without moving
other things around on the screen.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  45


_1_4._2._4.  _R_e_a_d _O_n_l_y

In this mode, modifying the buffer is inhibited.   This  mode  is
set  automatically on any attempt to read a file for which you do
not have write permission.

_1_4._2._5.  _S_h_o_w _M_a_t_c_h

Move the cursor momentarily to the matching  opening  parenthesis
when a closing parenthesis is typed.

_1_4._2._6.  _W_o_r_d _A_b_b_r_e_v

In this mode, every word you type is compared to a list  of  word
abbreviations;  whenever you type an abbreviation, it is replaced
by the text that it abbreviates.  This can save typing if a  par-
ticular  word or phrase must be entered many times.  For example,
your programming language might have reserved words that you cus-
tomarily  type  in  upper  case  (identifiers etc. being in lower
case).  So you might define B as an abbreviation for BEGIN, E for
END, P for PROCEDURE, and so on.

            _d_e_f_i_n_e-_g_l_o_b_a_l-_w_o_r_d-_a_b_b_r_e_v  Define a new global abbreviation.
            _d_e_f_i_n_e-_w_o_r_d-_a_b_b_r_e_v
7                                       Define  a  new  abbreviation  within   the
                                       current major mode.
            _e_d_i_t-_w_o_r_d-_a_b_b_r_e_v           Edit the list of abbreviations.
            _w_r_i_t_e-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e     Write the list of abbreviations to a file.
            _r_e_a_d-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e      Read a list of abbreviations from a file.

The abbreviations and their expansions are held in  a  list  that
looks like:
        abbrev:phrase
for example
        jove:jonathan's own version of EMACS
Use _d_e_f_i_n_e-_g_l_o_b_a_l-_w_o_r_d-_a_b_b_r_e_v to add  an  entry  that  is  to  be
effective in all buffers and _d_e_f_i_n_e-_w_o_r_d-_a_b_b_r_e_v for an entry that
is to be effective only in buffers of the same major mode as  the
selected  buffer.   Use  _e_d_i_t-_w_o_r_d-_a_b_b_r_e_v  to  edit  the list (it
enters a recursive edit on a buffer containing  the  list  -  use
^X ^C  (_e_x_i_t  _j_o_v_e)  when  you  are  finished).   Use _w_r_i_t_e-_w_o_r_d-
_a_b_b_r_e_v-_f_i_l_e to write the list to a file and _r_e_a_d-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e
to read it back again (this command might be used in your ....jjjjoooovvvveeeerrrrcccc
file) .

If the variable _a_u_t_o-_c_a_s_e-_a_b_b_r_e_v is _o_n, and the abbreviations  in
the  list  are all in lower case (as in the "jove" example above)
then, whenever you type "jove" you will get
        jonathan's own version of EMACS
but if you type "Jove" you will get
        Jonathan's own version of EMACS
and if you type "JOVE" (with at least 2 upper case  letters)  you
will get
        Jonathan's Own Version Of EMACS




                         March 19, 1996





46                 JOVE Manual for UNIX Users


On the other hand, if the variable _a_u_t_o-_c_a_s_e-_a_b_b_r_e_v is _o_f_f (as it
should be for the reserved word example) the case of the abbrevi-
ation is significant and must be matched exactly.

_1_5.  _M_a_c_r_o_s

^X (        _b_e_g_i_n-_k_b_d-_m_a_c_r_o            Start recording your commands.
^X )        _e_n_d-_k_b_d-_m_a_c_r_o              Stop recording your commands.
ESC I       _m_a_k_e-_m_a_c_r_o-_i_n_t_e_r_a_c_t_i_v_e     Call for a parameter to be typed at this point.
^X E        _e_x_e_c_u_t_e-_k_b_d-_m_a_c_r_o          Replay the recording.
            _n_a_m_e-_k_b_d-_m_a_c_r_o             Name the recording.
            _d_e_f_i_n_e-_m_a_c_r_o               Define a named macro.
            _e_x_e_c_u_t_e-_m_a_c_r_o              Execute a named macro.
            _w_r_i_t_e-_m_a_c_r_o_s-_t_o-_f_i_l_e       Write all named macros to a file.
            _b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y          Bind named macro to a key-sequence.
            _b_i_n_d-_m_a_c_r_o-_t_o-_w_o_r_d-_a_b_b_r_e_v  Bind named macro to an abbrev.

Although JOVE has many powerful commands, you often find that you
have  a  task that no individual command can do.  JOVE allows you
to define your own commands from sequences of existing ones.  The
easiest way to do this is "by example".

_1_5._1.  _K_e_y_b_o_a_r_d _M_a_c_r_o_s

First you type ^X ( (_b_e_g_i_n-_k_b_d-_m_a_c_r_o).  Next  you  "perform"  the
commands  which  will  constitute the body of the macro (they are
executed as well as being remembered).  Then you type ^X )  (_e_n_d-
_k_b_d-_m_a_c_r_o).  You now have a _k_e_y_b_o_a_r_d _m_a_c_r_o.

To run this command sequence again, type ^X E  (_e_x_e_c_u_t_e-_k_e_y_b_o_a_r_d-
_m_a_c_r_o).

If your macro  needs  a  parameter  (a  filename  to  be  opened,
perhaps),  include the command needing the parameter (e.g. ^X ^F)
at the appropriate place in the  macro  followed  immediately  by
ESC I  (_m_a_k_e-_m_a_c_r_o-_i_n_t_e_r_a_c_t_i_v_e).  When the macro is executed, you
will be given an opportunity to type in the  actual-parameter  at
this point.

_1_5._2.  _N_a_m_e_d _M_a_c_r_o_s

You may give the keyboard macro a name using  the  _n_a_m_e-_k_e_y_b_o_a_r_d-
_m_a_c_r_o command (or you may create a named macro from scratch using
the _d_e_f_i_n_e-_m_a_c_r_o command).  We're still not finished because  all
this  hard work will be lost if you leave JOVE.  What you do next
is to save your macros into a file with the  _w_r_i_t_e-_m_a_c_r_o_s-_t_o-_f_i_l_e
command.   To  retrieve  your macros in the next editing session,
you can simply execute  the  _s_o_u_r_c_e  command  on  that  file,  or
include that file in your personal ....jjjjoooovvvveeeerrrrcccc file.

A named macro can  be  executed  by  typing  ESC X  _e_x_e_c_u_t_e-_m_a_c_r_o
<macro-name><return>.   It  is  unfortunate  that macro names are
kept in a different name space than command names,  so  that  you
cannot  type  ESC X  <macro-name>.  This may well be changed in a



                         March 19, 1996





                   JOVE Manual for UNIX Users                  47


future release.

_1_5._3.  _B_i_n_d_i_n_g

Finally, if you find all this bothersome  to  type  and  re-type,
there  is  a way to bind the macro to a key.  The binding is made
with the _b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y command, or  alternatively  the  _b_i_n_d-
_m_a_c_r_o-_t_o-_w_o_r_d-_a_b_b_r_e_v  command  (in  which  case the macro will be
executed upon typing the abbrev word you have specified - it will
get expanded as well unless it was an abbreviation for nothing).

_1_6.  _C_u_s_t_o_m_i_z_i_n_g _J_o_v_e

_1_6._1.  _T_h_e _j_o_v_e._r_c _a_n_d ._j_o_v_e_r_c _f_i_l_e_s

JOVE is aware of a directory, the _s_h_a_r_e_d_i_r, in which  system-wide
customization  files  are  kept.  Chief amongst these is the file
jjjjoooovvvveeee....rrrrcccc which is read each time JOVE is started up  (jjjjoooovvvveeee....rrrrcccc  may
then initiate the reading of other files in the sharedir, such as
initialization files for specific terminals).  After  that,  JOVE
reads  your personal ....jjjjoooovvvveeeerrrrcccc in your $HOME directory, if you have
one.  And if all that is not enough, you may  at  any  time  read
other customization files using the _s_o_u_r_c_e command.

The JOVE distribution  comes  with  a  recommended  jjjjoooovvvveeee....rrrrcccc  file
together  with specific jjjjoooovvvveeee....rrrrcccc....TTTTEEEERRRRMMMM files for various terminals.
It is up to system administrators to decide whether to use  these
as they stand or to modify them to accord with local conventions.
Note that these files are well commented and worthy of  study  by
those who decide to "roll their own".

There are command-line options that can  be  used  when  JOVE  is
started to substitute a different _s_h_a_r_e_d_i_r or to suppress reading
of the jjjjoooovvvveeee....rrrrcccc or ....jjjjoooovvvveeeerrrrcccc files or both - see the  Man  page  for
JOVE.   Thus  everything  is  ultimately under the control of the
individual JOVE user.

_1_6._2.  _T_h_e _s_o_u_r_c_e _C_o_m_m_a_n_d

Type ESC X _s_o_u_r_c_e <filename><return> to read and  obey  the  com-
mands  in  <filename>.   If  a  numeric  argument  is supplied to
_s_o_u_r_c_e, it will silently ignore a request for a non-existent file
(otherwise an error message will be produced).  The format of the
_s_o_u_r_c_ed file, as of the jjjjoooovvvveeee....rrrrcccc and ....jjjjoooovvvveeeerrrrcccc files, is as follows.

Each line consists of a command name (no need to precede it  with
ESC X) followed by whatever parameters that command requires.  To
give a numeric argument to the command, simply precede  the  com-
mand  name  by  a  number.  Thus it is possible to to do anything
that the user could do while JOVE is running.







                         March 19, 1996





48                 JOVE Manual for UNIX Users


But there is more than this.  You can say
     _i_f <shell-command>
          <command>
          <command>
     _e_l_s_e
          <command>
          <command>
     _e_n_d_i_f
The <shell-command> is run, and if it succeeds the first  lot  of
<command>s is obeyed, and otherwise the second lot (the _e_l_s_e part
is optional).  Another variant of this feature allows you to say,
in  place  of  _i_f  <shell-command>,  _i_f_e_n_v <environment-variable>
<pattern>, which succeeds if <environment-variable> exists and if
its  value  matches <pattern>.  These conditional commands can be
nested in the usual way; also indentation and empty lines have no
effect.   Finally,  you  can  include  comments  on any line that
starts with a "#".

Here are some examples taken from the provided jjjjoooovvvveeee....rrrrcccc.
     pushlibd
9     # This is for the shell window.  Supports sh, csh and ksh.
     set process-prompt ^[^%$#]*[%$#]
9     # Modern terminals do not need ^S/^Q for flow control.
     # The exceptions (e.g. vt100) should turn it  off  again  in
     jove.rc.TERM.
     set allow-^S-and-^Q on
9     # source any TERMinal-specific rc file
     1 source jove.rc.$TERM
9     popd

The _p_u_s_h_l_i_b_d ensures that any files it  tries  to  read  will  be
taken  from  the _s_h_a_r_e_d_i_r (observe the matching _p_o_p_d at the end).
Then follow some settings of  variables  such  as  _p_r_o_c_e_s_s-_p_r_o_m_p_t
(see  the  discussion  of  interactive  processes earlier in this
manual).  Observe how environment variables  such  as  $TERM  are
honored  within  parameters, and note how that _s_o_u_r_c_e command was
given a numeric argument so that there would be no  complaint  if
the file jjjjoooovvvveeee....rrrrcccc....$$$$TTTTEEEERRRRMMMM did not exist.

On the other hand, if jjjjoooovvvveeee....rrrrcccc....$$$$TTTTEEEERRRRMMMM does exist for the particular
terminal  specified  in $TERM, that file will now be _s_o_u_r_c_ed.  It
will likely set many key bindings particular  to  that  terminal,
and then say
     define-macro keychart ^[xpushlibd^M
          ^U^[Xshell-command-with-typeout cat keychart.$TERM^M
          ^[Xpopd^M
     # except that should really have been all on one line
     bind-macro-to-key keychart ^[[~

Quite some mouthful! What it does is to define a  macro  _k_e_y_c_h_a_r_t
(the  hard way) and bind it to ESC [ ~.  In general, any terminal
for which extensive key bindings are  provided  ought  to  define



                         March 19, 1996





                   JOVE Manual for UNIX Users                  49


this  macro  and  bind  it  to a suitable key (preferably the one
inscribed "Help").  When this key is pressed, it will  cause  the
file  kkkkeeeeyyyycccchhhhaaaarrrrtttt....$$$$TTTTEEEERRRRMMMM  to  be  displayed  on the screen in _t_y_p_e_o_u_t
style.  This file should exhibit a map  of  the  terminal's  key-
board,  showing  what  has  been bound to each key.  The _s_h_a_r_e_d_i_r
contains several such keychart files.

Although Control characters may be stored as themselves in  these
files (as produced by the _q_u_o_t_e_d-_i_n_s_e_r_t command, for example), it
is better to store them using an explicit "^" (e.g. as ^C), since
this form is accepted by the _s_o_u_r_c_e command, and editing files in
this form is much easier.

_1_6._3.  _K_e_y _R_e-_b_i_n_d_i_n_g

Many of the commands built into JOVE are not  bound  to  specific
keys.  You must type ESC X <command-name> (_e_x_e_c_u_t_e-_n_a_m_e_d-_c_o_m_m_a_n_d)
in order to invoke these commands.  Also, many  of  the  keys  to
which  commands _a_r_e bound are hard to remember (although at least
compatible across all terminals) whilst all sorts of  interesting
keys  on  the  particular keyboard remain unused.  For both these
reasons, JOVE makes it possible to _b_i_n_d commands to keys.

            _b_i_n_d-_t_o-_k_e_y                 Bind a command to a key-sequence.
            _b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y           Bind a named macro to a key-sequence.
            _b_i_n_d-_m_a_c_r_o-_t_o-_w_o_r_d-_a_b_b_r_e_v   Bind a named macro to an abbrev.
            _b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y          Bind an extra key-sequence to a keymap.
            _d_e_s_c_r_i_b_e-_b_i_n_d_i_n_g_s           Exhibit all key bindings as a screen typeout.

            _l_o_c_a_l-_b_i_n_d-_t_o-_k_e_y
7                                        As  bind-to-key,  for  use  in  the  selected
                                        buffer only.
            _l_o_c_a_l-_b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y
7                                        As bind-macro-to-key, for use in the selected
                                        buffer only.
            _l_o_c_a_l-_b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y
7                                        As  bind-keymap-to-key,  for   use   in   the
                                        selected buffer only.

            _p_r_o_c_e_s_s-_b_i_n_d-_t_o-_k_e_y
7                                        Bind interactive process command  to  a  key-
                                        sequence.
            _p_r_o_c_e_s_s-_b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y
7                                        Bind a  macro  within  interactive  processes
                                        only.
            _p_r_o_c_e_s_s-_b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y
7                                        Bind a keymap  within  interactive  processes
                                        only.

Although these commands can be typed in by  the  user,  they  are
mostly  intended  for  use  in _s_o_u_r_c_ed files.  Here are some more
examples from jjjjoooovvvveeee....rrrrcccc.











                         March 19, 1996





50                 JOVE Manual for UNIX Users


     # if you have job control, this puts Jove  out  of  the  way
     temporarily.
     bind-to-key pause-jove ^[S
     bind-to-key pause-jove ^[s
9     # The following apply to shell windows.   Note  the  use  of
     ^C^C, ^C^D etc.,
     process-bind-to-key interrupt-process ^C^C
     process-bind-to-key eof-process ^C^D
9     # This makes the arrow keys work on most terminals.
     bind-to-key previous-line ^[[A
     bind-to-key next-line ^[[B

When a command is _b_o_u_n_d to a key any future hits on that key will
invoke  that  command.  All the printing characters are initially
bound to the command  _s_e_l_f-_i_n_s_e_r_t.   Thus,  typing  any  printing
character  causes  it  to be inserted into the text.  To unbind a
key, simply bind it to the fictitious command _u_n_b_o_u_n_d.

Observe how key-sequences are often derived from common prefixes,
such  as  ^X ...,  ESC ... (to be typed as ^[ ... in binding com-
mands) and ESC [ ... (or  ^[ [ ...).   Internally,  JOVE  creates
tables  for  each  prefix encountered, but it cannot create a new
prefix from a manually entered _b_i_n_d- command (it  does  not  know
when you have finished your binding).  To overcome this, give the
_b_i_n_d- command an argument and terminate it with  a  Return  (this
applies automatically within _s_o_u_r_c_ed files).  Obviously, you must
not have two bindings where one is a prefix of the other.

Very rarely,  you  may  want  two  prefixes  to  be  regarded  as
equivalent  for  all  commands  (for example, you have a keyboard
with no ESC key, and it would be tedious to have to rebind  every
command  in  the  system with a different prefix).  In this case,
you can type  ESC X  _b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y  <named-keymap>  <prefix-
key-sequence>.  The only recognized <named-keymap>s are "ESC-map"
and "Ctlx-map", and the customary replacement for ESC is "`".

For historical reasons, the Escape key is often  referred  to  as
"Meta".  Indeed, if your terminal has a Meta-key which forces the
8th-bit of a character, and if the variable _m_e_t_a-_k_e_y is  _o_n,  you
may  type  Y whilst holding the Meta-key down to achieve the same
effect as when typing ESC Y.

_1_6._3._1.  _T_h_e _P_r_o_v_i_d_e_d _T_e_r_m_i_n_a_l _B_i_n_d_i_n_g_s

The terminals for which keybindings  have  been  provided  are  a
mixed bunch (we would welcome suggestions for other common termi-
nals).  However, there are certain principles which were followed
in setting them up.

1.   Groupings of keys that are found in bindings for other  ter-
     minals were adhered to so far as possible.  Rather than say-
     ing that the F1 key  always  does  so-and-so,  groupings  of
     Function Keys that are physically associated on the keyboard



                         March 19, 1996





                   JOVE Manual for UNIX Users                  51


     were mapped onto similar groupings on other keyboards,  even
     though the engravings on them might be quite different.

2    Keys which do related things should be close together.

3    Keys which customarily do certain things under other editors
     normally  used  with  that  keyboard  should do the same (or
     similar) things under JOVE.

4    Keys which have suggestive engravings on them should do what
     the  engravings  suggest.   Sometimes, this necessitated the
     creation of a macro where no JOVE command existed to do pre-
     cisely that job (for example, the macro _k_i_l_l-_l_i_n_e).

_1_6._4.  _A_u_t_o-_e_x_e_c_u_t_i_o_n _o_f _C_o_m_m_a_n_d_s

It is useful, when a file is recognized as being in a  particular
programming  language,  for  the appropriate major mode and other
relevant facilities to be set up automatically in any buffer into
which such a file is read.

            _a_u_t_o-_e_x_e_c_u_t_e-_c_o_m_m_a_n_d
7                                  Obey the given command for each
                                  filename  matched  by the given
                                  regular-expression.
            _a_u_t_o-_e_x_e_c_u_t_e-_m_a_c_r_o    Obey the given macro likewise.

Here is an example taken from jjjjoooovvvveeee....rrrrcccc.
     # set various language modes.
     1 auto-execute-command c-mode .*.[chy]$
     1 auto-execute-command lisp-mode .*.l$.*.lisp$.*.scm$
     # all the languages need show-match-mode.
     1 auto-execute-command show-match-mode .*.[lchyfp]$.*.lisp$.
     *.scm$

The effect of this  is  that  whenever  a  filename  matches  the
regular-expression  ". * .[chy]$" the command _c-_m_o_d_e is obeyed in
the buffer into which the file is being read, and  similarly  for
_l_i_s_p-_m_o_d_e.   An  attempt  is then made to set _s_h_o_w-_m_a_t_c_h-_m_o_d_e for
both C and Lisp programs.  Observe  that  all  the  _a_u_t_o-_e_x_e_c_u_t_e-
_c_o_m_m_a_n_ds in this example have an argument of 1.  This argument is
passed on to the obeyed command  so  that,  for  example,  it  is
ensured  that  _c-_m_o_d_e  is  definitely  set  to be _o_n, rather than
merely being toggled.

_1_6._5.  _C_u_s_t_o_m_i_z_i_n_g _t_h_e _M_o_d_e _L_i_n_e

The format of the mode line is controlled by the  variable  _m_o_d_e-
_l_i_n_e.  Here is a suggested setting.
     set mode-line %[Jove%]%w%w%c(%M)%3c[%b:%n]%2c"%f"%2c%m*-%m *
     -%2c%p%2s%(%d%e(%t)%)

and here is what it all means.

%[...%]     Puts brackets around Jove when in a recursive edit.



                         March 19, 1996





52                 JOVE Manual for UNIX Users


%w%w        Warns with >> if the window is scrolled left.

(%M)        Gives the current major and minor modes.

[%b:%n]     Shows the buffer name and number.

"%f"        Shows the filename.

%m*-%m*-         Displays ** if the buffer is  modified,  - -  if
            not.

%p          In process windows only, shows the status of the pro-
            cess.

%d          Shows the current directory.

(%t)        Shows the time of day.

Everything else is layout.   See  the  full  description  of  the
_m_o_d_e-_l_i_n_e variable for further details.

_1_7.  _X_j_o_v_e _a_n_d _X_t_e_r_m

If you run JOVE on a workstation equipped with the X-Windows sys-
tem  from M.I.T., then it is advised to run JOVE under one of the
terminal emulators _x_j_o_v_e or _x_t_e_r_m.  _X_t_e_r_m is provided as a  stan-
dard  part  of  the X-Windows system, but the facilities provided
are a small subset of those available with _x_j_o_v_e, which was writ-
ten  especially to support JOVE.  However, _x_j_o_v_e suffers from the
disadvantage that it must be compiled  under  the  XView  Toolkit
which,  although available free from M.I.T., may not be available
on your system.  Note that, in either case,  special  keybindings
must   be   provided   (see   the   files   jjjjoooovvvveeee....rrrrcccc....ssssuuuunnnn----ccccmmmmdddd   and
jjjjoooovvvveeee....rrrrcccc....xxxxtttteeeerrrrmmmm).  See the Man page for _x_j_o_v_e for how  to  call  it
and the flags and options available.

_1_7._1.  _B_a_s_i_c _M_o_u_s_e _O_p_e_r_a_t_i_o_n_s

When running under _x_j_o_v_e or _x_t_e_r_m you may click  the  LEFT  mouse
button  in  order  to  set  the position of point, and the MIDDLE
mouse button to set the position of point and mark.  If you  hold
the  MIDDLE  button  down,  you  may sweep it along, leaving mark
where you started and point where you finished, thus defining the
region.   If  you  hold  the Control key down while you are doing
this, the region is copied to the kill ring, as  with  the  _c_o_p_y-
_r_e_g_i_o_n  command,  and if you hold both the Control and Shift keys
down, the region is killed (and sent to the kill  ring)  as  with
the  _k_i_l_l-_r_e_g_i_o_n command.  To have the killed text yanked at some
other point, click the LEFT mouse button there, holding the  Con-
trol key down at the same time.

To switch to a different window, simply click  either  button  in
the  window  you  want  to  be in (note that this does not affect
point or mark in that window - it  takes  two  clicks  to  change



                         March 19, 1996





                   JOVE Manual for UNIX Users                  53


windows and then change point).

To scroll rapidly to a different part of the buffer, simply click
either  mouse button in the mode line at a position corresponding
to the percentage way down the file you want to be.  It helps  to
have  set  the  variable _s_c_r_o_l_l-_b_a_r _o_n so that you can see by the
uninverted part of the mode line which  part  of  the  buffer  is
currently  visible  in  the  window.  When you have finished, the
mouse pointer should be exactly in the middle of  the  uninverted
region.

_1_7._2.  _A_d_d_i_t_i_o_n_a_l _X_j_o_v_e _F_e_a_t_u_r_e_s

When running under _x_j_o_v_e there are  some  additional  facilities.
Firstly,  the  setting  when  pointing into the mode line is more
sensitive, because it notes the mouse  position  to  the  nearest
pixel  instead  of  the  nearest character, and it is possible to
hold the mouse button down and watch the window scrolling as  you
drag it (although this can consume considerable machine resources
and it may have difficulty in keeping up).  Also, it is  possible
to  follow  the  position  of  point in real time as you drag the
mouse around when delineating a region.

If you do a double click with the MIDDLE button in _x_j_o_v_e, it will
set  the  region spanning the word you were over (or spanning the
gap if you were between words).   Note  that  the  definition  of
"word" here follows the major mode.  If you do a triple click, it
will likewise select the whole line.   These  operations  may  be
combined  with  the  Control  key,  or the Control and Shift keys
together, to obtain copying and killing as before.

If your keyboard has keys marked Paste and Cut, it is possible to
bring text from another part of the buffer (even from a different
window) without changing the position of point (this is useful if
you  are  constructing  text at some point, bringing in fragments
from other places - you would prefer not to have to  keep  moving
point  to  those  other  places to acquire some text for the kill
ring, only to have to move it back again before yanking).  To  do
this, with point where you want the text to be inserted, you hold
the Paste key down while you select a region with the MIDDLE but-
ton  (multi-clicking  or  dragging as usual).  When you have fin-
ished, a copy of the region you selected will  appear  at  point,
with point moved beyond it (since it went via the kill ring, this
text is also available for  conventional  yanking  subsequently).
If  you  change  your  mind in mid stream, let go of Paste before
releasing MIDDLE.  Likewise, if you do the same thing holding the
Cut  key  down,  the  text  will also be killed from its original
position.

Finally, if you press the RIGHT mouse button, you will be offered
a  menu  which  enables  you to issue any JOVE command or set any
JOVE variable.  Particularly useful if you need some obscure  and
rarely  used  command,  and  cannot  remember  exactly what it is
called.



                         March 19, 1996





54                 JOVE Manual for UNIX Users


_1_8.  _R_e_c_o_v_e_r_i_n_g _f_r_o_m _s_y_s_t_e_m/_e_d_i_t_o_r _c_r_a_s_h_e_s

JOVE does not have an _A_u_t_o _S_a_v_e mode, but it does provide  a  way
to  recover  your  work in the event of a system or editor crash.
JOVE saves information about the  files  you  are  editing  every
_s_y_n_c-_f_r_e_q_u_e_n_c_y  changes  to  a  special  buffer,  so  as  to make
recovery possible.  Since a relatively small amount  of  informa-
tion  is  involved  it  is  hardly even noticeable when JOVE does
this.  The variable _s_y_n_c-_f_r_e_q_u_e_n_c_y says how  often  to  save  the
necessary  information,  and the default is every 50 changes.  50
is a very reasonable number: if you are writing a paper you  will
not  lose  more  than  the last 50 characters you typed, which is
less than the average length of a line.

If JOVE, or the operating system, crashes, you may  now  use  the
JOVE  _r_e_c_o_v_e_r program to get back your files.  You invoke this by
running JOVE with the -r flag.  See the Man  page  for  JOVE  for
further details.

Another worthwhile precaution you can take is to set the variable
_m_a_k_e-_b_a_c_k_u_p-_f_i_l_e_s  _o_n.  Then, whenever you save a file with _s_a_v_e-
_f_i_l_e it will leave behind the original version of that file  with
the name "#_f_i_l_e_n_a_m_e~".


































                         March 19, 1996





                   JOVE Manual for UNIX Users                  55


_1_9.  _A_l_p_h_a_b_e_t_i_c_a_l _L_i_s_t _o_f _C_o_m_m_a_n_d_s _a_n_d _V_a_r_i_a_b_l_e_s

In this chapter, the standard binding is shown for  each  command
which  has  one.  Generally, these are the built-in bindings, but
occasionally they are ones taken from the provided jjjjoooovvvveeee....rrrrcccc file.

_1_9._1.  _a_b_o_r_t-_c_h_a_r (_v_a_r_i_a_b_l_e)

This variable defines JOVE'S'S abort character.  When JOVE  reads
this  character  from  the  keyboard,  it  stops what it is doing
(unless the character is quoted  in  some  way).   Unfortunately,
JOVE won't notice the character until it reads from the keyboard.
The default value is ^G.  See also _i_n_t_e_r_r_u_p_t-_c_h_a_r_a_c_t_e_r.

_1_9._2.  _a_d_d-_l_i_s_p-_s_p_e_c_i_a_l (_N_o_t _B_o_u_n_d)

This command is to tell JOVE  what  identifiers  require  special
indentation  in lisp mode.  Lisp functions like _d_e_f_u_n and _l_e_t are
two of the default functions that get treated specially.  This is
just  a  kludge  to  define some of your own.  It prompts for the
function name.

_1_9._3.  _a_l_l_o_w-^_S-_a_n_d-^_Q (_v_a_r_i_a_b_l_e)

This variable, when set, tells JOVE that your terminal  will  not
need  to  use the characters ^S and ^Q for flow control, in which
case JOVE will instruct the system's  tty  driver  to  pass  them
through  as  normal characters.  Otherwise, if the tty driver was
already using these characters for flow control, it will continue
to  do  so.  Certain terminals and communications systems require
that this variable be set  _o_f_f;  in  other  circumstances  it  is
better set _o_n.

_1_9._4.  _a_l_l_o_w-_b_a_d-_c_h_a_r_a_c_t_e_r_s-_i_n-_f_i_l_e_n_a_m_e_s (_v_a_r_i_a_b_l_e)

If set, this variable permits the  creation  of  filenames  which
contain  "bad"  characters such as those from the set *&%!"`[]{}.
These files are harder to deal with, because the characters  mean
something to the shell.  The default value is _o_f_f.

_1_9._5.  _a_l_l_o_w-_b_a_d-_f_i_l_e_n_a_m_e_s (_v_a_r_i_a_b_l_e)

This is the obsolete name for _a_l_l_o_w-_b_a_d-_c_h_a_r_a_c_t_e_r_s-_i_n-_f_i_l_e_n_a_m_e_s.

_1_9._6.  _a_p_p_e_n_d-_r_e_g_i_o_n (_N_o_t _B_o_u_n_d)

This appends the region to a specified file.  If  the  file  does
not already exist it is created.

_1_9._7.  _a_p_r_o_p_o_s (_N_o_t _B_o_u_n_d)

This types out each command, variable and macro with  the  speci-
fied  string in its name ("?" matches every name).  For each com-
mand and macro that contains the string, the  key  sequence  that



                         March 19, 1996





56                 JOVE Manual for UNIX Users


can  be  used  to  execute  the command or macro is printed; with
variables, the current value is printed.  So,  to  find  all  the
commands that are related to windows, you type
        : apropos window<Return> .

_1_9._8.  _a_u_t_o-_c_a_s_e-_a_b_b_r_e_v (_v_a_r_i_a_b_l_e)

When this variable is _o_n (the default),  word  abbreviations  are
adjusted  for  case  automatically.  If the abbreviation is typed
with no uppercase letter, the expansion is not changed; if it  is
typed  with one or more uppercase letters, the first character in
the expansion is capitalized; additionally, if  the  abbreviation
is  typed with more than one uppercase letter, each letter in the
expansion immediately preceded by whitespace or - is capitalized.
For  example, if "jove" were the abbreviation for "jonathan's own
version of EMACS", the following table shows how the abbreviation
would be expanded.
        jove   jonathan's own version of EMACS
        Jove   Jonathan's own version of EMACS
        JOVE   Jonathan's Own Version Of EMACS
        JoVe   Jonathan's Own Version Of EMACS
When this variable is _o_f_f, upper and lower case are distinguished
when  looking  for  the abbreviation, i.e., in the example above,
"JOVE" and "Jove" would not be expanded unless they were  defined
separately.  See also the _w_o_r_d-_a_b_b_r_e_v-_m_o_d_e command.

_1_9._9.  _a_u_t_o-_e_x_e_c_u_t_e-_c_o_m_m_a_n_d (_N_o_t _B_o_u_n_d)

This tells JOVE to execute a command automatically  when  a  file
whose  name matches a specified pattern is read.  The first argu-
ment is the command you wish to have executed.  The second  argu-
ment is the pattern, a regular expression that is matched against
the start of the file name.  If you wish to match a suffix, start
the pattern with ".*"; to match every file, use that as the whole
pattern.  Any numeric argument will be passed on to  the  command
when  it  is executed (this is useful when combined with commands
that adjust a minor mode).  For example, if you  want  to  be  in
_s_h_o_w-_m_a_t_c_h-_m_o_d_e when you edit C source files (that is, files that
end with or you can type
        : auto-execute-command show-match-mode .*\.[ch]$
Actually, this command toggles the Show  Match  minor  mode,  but
since  it is initially off, it will have the desired effect.  For
more certain control, give the  _a_u_t_o-_e_x_e_c_u_t_e-_c_o_m_m_a_n_d  a  non-zero
numeric argument: this will be passed on to the _s_h_o_w-_m_a_t_c_h-_m_o_d_e.

_1_9._1_0.  _a_u_t_o-_e_x_e_c_u_t_e-_m_a_c_r_o (_N_o_t _B_o_u_n_d)

This is like _a_u_t_o-_e_x_e_c_u_t_e-_c_o_m_m_a_n_d except you use  it  to  execute
macros automatically instead of built-in commands.

_1_9._1_1.  _a_u_t_o-_f_i_l_l-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on or off the Auto Fill minor  mode  in  the  selected
buffer.   Without  a  numeric  argument,  the command toggles the



                         March 19, 1996





                   JOVE Manual for UNIX Users                  57


mode; with a zero argument, the mode is turned off; with  a  non-
zero  argument, the mode is turned on.  When JOVE is in Auto Fill
mode it automatically breaks lines for you  when  you  reach  the
right  margin  so you don't have to remember to hit Return.  JOVE
uses 78 as the right margin but you can change  that  by  setting
the variable _r_i_g_h_t-_m_a_r_g_i_n to another value.

_1_9._1_2.  _a_u_t_o-_i_n_d_e_n_t-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on or off Auto  Indent  minor  mode  in  the  selected
buffer.   Without  a  numeric  argument,  the command toggles the
mode; with a zero argument, the mode is turned off; with  a  non-
zero  argument,  the  mode  is  turned  on.  When JOVE is in Auto
Indent mode, the _n_e_w_l_i_n_e command  (which  is  normally  bound  to
Return)  acts identically to _n_e_w_l_i_n_e-_a_n_d-_i_n_d_e_n_t:  the new line is
indented to the same position as the line you were just on.  This
is  useful  for lining up C code (or any other language (but what
else is there besides C?)).  Furthermore, if  a  line  is  broken
because  of  Auto  Fill mode, and Auto Indent mode is on, the new
line will be indented as the old line was.

_1_9._1_3.  _b_a_c_k_w_a_r_d-_c_h_a_r_a_c_t_e_r (^_B)

This moves point  backward  over  a  single  character  or  line-
separator.   Thus  if  point  is  at the beginning of the line it
moves to the end of the previous line.

_1_9._1_4.  _b_a_c_k_w_a_r_d-_l_i_s_t (_E_S_C ^_P)

This moves point backward over a list, which is any text  between
properly matching (...), [...] or {...}.  It first searches back-
ward for a ")" and then moves to the matching "(".  This is  use-
ful  when  you are trying to find unmatched parentheses in a pro-
gram.  Arguments are accepted, and negative arguments search for-
wards.  See also _b_a_c_k_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n.

_1_9._1_5.  _b_a_c_k_w_a_r_d-_p_a_r_a_g_r_a_p_h (_U_s_u_a_l_l_y _N_o_t _B_o_u_n_d)

This moves point backward to the beginning of the current or pre-
vious  paragraph.   Paragraphs  are  bounded  by lines that match
_p_a_r_a_g_r_a_p_h-_d_e_l_i_m_i_t_e_r-_p_a_t_t_e_r_n (by default, those that are empty  or
look  like  troff  or TeX commands).  A change in indentation may
also signal a break between paragraphs, except that  JOVE  allows
the first line of a paragraph to be indented differently from the
other lines.  Arguments  are  accepted,  and  negative  arguments
search forwards.

_1_9._1_6.  _b_a_c_k_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n (_E_S_C ^_B)

This moves point backward over an s-expression, that  is  over  a
Lisp  atom or a C identifier (depending on the major mode) ignor-
ing punctuation and whitespace; or, if the nearest preceding sig-
nificant  character  is one of ")]}", over a list as in _b_a_c_k_w_a_r_d-
_l_i_s_t.  Arguments are  accepted,  and  negative  arguments  search



                         March 19, 1996





58                 JOVE Manual for UNIX Users


forwards.

_1_9._1_7.  _b_a_c_k_w_a_r_d-_s_e_n_t_e_n_c_e (_E_S_C _A)

This moves point backward to the beginning of the current or pre-
vious  sentence.   JOVE considers the end of a sentence to be the
characters ".", "!" or "?" followed by a Return or by one or more
spaces.   Arguments  are  accepted, and negative arguments search
forwards.

_1_9._1_8.  _b_a_c_k_w_a_r_d-_u_p-_l_i_s_t (_E_S_C ^_U)

This is similar to _b_a_c_k_w_a_r_d-_l_i_s_t except it backs up  and  OUT  of
the  enclosing list.  In other words, it moves backward to which-
ever of "([{" would match one of ")]}" if you  were  to  type  it
right  then.   Arguments  are  accepted,  and  negative arguments
search forwards as in _d_o_w_n-_l_i_s_t.

_1_9._1_9.  _b_a_c_k_w_a_r_d-_w_o_r_d (_E_S_C _B)

This moves point backward to the beginning of the current or pre-
vious  word.   Arguments  are  accepted,  and  negative arguments
search forwards.

_1_9._2_0.  _b_a_d-_f_i_l_e_n_a_m_e-_e_x_t_e_n_s_i_o_n_s (_v_a_r_i_a_b_l_e)

This contains a list of words separated by spaces which are to be
considered  bad  filename extensions, and so will not be included
in filename completion.  The default contains, amongst much else,
so  if  you  have  jjjjoooovvvveeee....cccc  and  jjjjoooovvvveeee....oooo in the same directory, the
filename completion will not complain of an ambiguity because  it
will ignore jjjjoooovvvveeee....oooo.

_1_9._2_1.  _b_e_g_i_n-_k_b_d-_m_a_c_r_o (^_X ()

This starts defining the keyboard macro by remembering  all  your
key  strokes  until  you execute _e_n_d-_k_b_d-_m_a_c_r_o, by typing "^X )".
Because of a bug in JOVE you shouldn't  terminate  the  macro  by
typing  "ESC X  end-kbd-macro";  _e_n_d-_k_b_d-_m_a_c_r_o  must  be bound to
"^X )" in order to make things work correctly.  The  _e_x_e_c_u_t_e-_k_b_d-
_m_a_c_r_o command will execute the remembered key strokes.  Sometimes
you may want a macro to accept different input each time it runs.
To see how to do this, see the _m_a_k_e-_m_a_c_r_o-_i_n_t_e_r_a_c_t_i_v_e command.

_1_9._2_2.  _b_e_g_i_n_n_i_n_g-_o_f-_f_i_l_e (_E_S_C <)

This moves point backward to the beginning of the  buffer.   This
sometimes  prints  the  "[Point pushed]" message to indicate that
JOVE has set the mark so you can go back to where you were if you
want.  See also the variable _m_a_r_k-_t_h_r_e_s_h_o_l_d.

_1_9._2_3.  _b_e_g_i_n_n_i_n_g-_o_f-_l_i_n_e (^_A)

This moves point to the beginning of the current line.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  59


_1_9._2_4.  _b_e_g_i_n_n_i_n_g-_o_f-_w_i_n_d_o_w (_E_S_C ,)

This moves point to the beginning of the active window.  If there
is  a numeric argument, point moves that many lines below the top
line.  With the default bindings, the  sequence  "ESC ,"  is  the
same  as "ESC <" (_b_e_g_i_n_n_i_n_g-_o_f-_f_i_l_e) but without the shift key on
the "<", and can thus easily be remembered.

_1_9._2_5.  _b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _b_i_n_d-_t_o-_k_e_y except that you use it to attach  a  key
sequence  to  a named keymap.  The only reasonable use is to bind
some extra key to _E_S_C-_m_a_p for  keyboards  that  make  typing  ESC
painful.

_1_9._2_6.  _b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _b_i_n_d-_t_o-_k_e_y except  you  use  it  to  attach  a  key
sequence to a named macro.

_1_9._2_7.  _b_i_n_d-_m_a_c_r_o-_t_o-_w_o_r_d-_a_b_b_r_e_v (_N_o_t _B_o_u_n_d)

This command allows you to bind a macro to a  previously  defined
word  abbreviation.   Whenever you type the abbreviation, it will
first be expanded as an abbreviation (which could  be  empty,  of
course),  and  then the macro will be executed.  Note that if the
macro moves point around, you  should  first  _s_e_t-_m_a_r_k  and  then
_e_x_c_h_a_n_g_e-_p_o_i_n_t-_a_n_d-_m_a_r_k.

_1_9._2_8.  _b_i_n_d-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This attaches a key sequence to an internal JOVE command so  that
future  hits  on  that key sequence invoke that command.  This is
called a global binding, as compared to local bindings  and  pro-
cess  bindings.  Any previous global binding of this key sequence
is discarded.  For example, to make "^W" erase the previous word,
you type
        : bind-to-key kill-previous-word ^W .
It isn't possible to have two globally bound key sequences  where
one  is a prefix of the other: JOVE wouldn't know whether to obey
the shorter sequence or wait for the longer sequence.   Normally,
when  the  _b_i_n_d-_t_o-_k_e_y  command  is issued interactively, the key
sequence is taken to end one keystroke after the longest sequence
matching any proper prefix of another binding (thus no new prefix
can be created).  If the command is given a numeric argument, the
key  sequence is taken up to the next Return keystroke (kludge!);
bindings to any prefix of the sequence are discarded.   When  the
command  is issued from a _s_o_u_r_c_ed file, the key sequence is taken
up to the end of the line (it is also processed so  that  control
characters can and should be entered using the ^A notation).

Note that neither process nor local bindings are changed by  this
command,  although  they can be eclipsed.  Given a choice between
bindings, the shortest is executed; if there is still a choice, a



                         March 19, 1996





60                 JOVE Manual for UNIX Users


process  binding  is  preferred  to  a local binding, and a local
binding is preferred to a global binding.

_1_9._2_9.  _b_u_f_f_e_r-_p_o_s_i_t_i_o_n (_N_o_t _B_o_u_n_d)

This displays the current file name, current line  number,  total
number  of lines, current character number, total number of char-
acters, percentage of the way through the file, and the  position
of the cursor in the current line.

_1_9._3_0.  _c-_a_r_g_u_m_e_n_t-_i_n_d_e_n_t_a_t_i_o_n (_v_a_r_i_a_b_l_e)

This variable describes how to indent lines  which  are  part  of
nested  expressions  in  C.   The  default  is -1, which means to
indent a continued line by lining it up with the  first  argument
of  the current expression.  Otherwise, the line will be indented
by _c-_a_r_g_u_m_e_n_t-_i_n_d_e_n_t_a_t_i_o_n characters past the indent of the first
line of the expression.  For example, the default value produces:

                Typeout(fmt, itoa(bcount++), line_cnt(b, nbuf),
                        TypeNames[b->b_type],
                        IsModified(b) ? "*" : b->b_ntbf ? "+" : NullStr,
                        buf_width, b->b_name, filename(b));

_1_9._3_1.  _c-_i_n_d_e_n_t_a_t_i_o_n-_i_n_c_r_e_m_e_n_t (_v_a_r_i_a_b_l_e)

This defines a set of tabstops independent of the value  of  _t_a_b-
_w_i_d_t_h.   This  value will be used in C mode, and JOVE will insert
the correct number of Spaces and Tabs to get the right  behavior.
For programmers that like to indent with 4 spaces, set this value
to 4.  Some people prefer to set this to 4  and  leave  tab-width
set  to  8.  This will create files whose indentation steps in 4-
space increments, and which look the same anywhere that tabs  are
expanded  to  8 spaces (i.e. in most settings).  Others prefer to
have one tab character per indentation level, then fiddle the tab
expansion width to get the appearance they like.  They should set
both _c-_i_n_d_e_n_t_a_t_i_o_n-_i_n_c_r_e_m_e_n_t and _t_a_b-_w_i_d_t_h to 4.  Whenever  using
a non-standard tab width (_t_a_b-_w_i_d_t_h) you should only use tabs for
indentation, and use spaces for all columnar alignment  later  in
the lines.

_1_9._3_2.  _c-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on the C major mode in the currently selected  buffer.
When  in  C  or Lisp mode, Tab, "}", and ")" behave a little dif-
ferently from usual: They are indented to the "right" place for C
(or Lisp) programs.  In JOVE, the "right" place is simply the way
the author likes it (but I've got good taste).

_1_9._3_3.  _c_a_s_e-_c_h_a_r_a_c_t_e_r-_c_a_p_i_t_a_l_i_z_e (_N_o_t _B_o_u_n_d)

This capitalizes the character after point, i.e.,  the  character
under  the  cursor.  If a negative argument is supplied that many
characters before point are upper cased.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  61


_1_9._3_4.  _c_a_s_e-_i_g_n_o_r_e-_s_e_a_r_c_h (_v_a_r_i_a_b_l_e)

This variable, when _o_n, tells JOVE to treat upper and lower  case
the  same  when  searching.   Thus "jove" would match "JOVE", and
"JoVe" would match either.  The default value of this variable is
_o_f_f.

_1_9._3_5.  _c_a_s_e-_r_e_g_i_o_n-_l_o_w_e_r (_N_o_t _B_o_u_n_d)

This changes all the upper case letters in the  region  to  their
lower case equivalents.

_1_9._3_6.  _c_a_s_e-_r_e_g_i_o_n-_u_p_p_e_r (_N_o_t _B_o_u_n_d)

This changes all the lower case letters in the  region  to  their
upper case equivalents.

_1_9._3_7.  _c_a_s_e-_w_o_r_d-_c_a_p_i_t_a_l_i_z_e (_E_S_C _C)

This capitalizes the current word by making  the  current  letter
upper  case and making the rest of the word lower case.  Point is
moved to the end of the word.  If point is not  positioned  on  a
word it is first moved forward to the beginning of the next word.
If a negative argument is supplied that many words  before  point
are  capitalized.   This  is  useful for correcting the word just
typed without having to move point to the beginning of  the  word
yourself.

_1_9._3_8.  _c_a_s_e-_w_o_r_d-_l_o_w_e_r (_E_S_C _L)

This lower-cases the current word and leaves point at the end  of
it.   If point is in the middle of a word the rest of the word is
converted.  If point is not in a word it is first  moved  forward
to  the  beginning  of  the next word.  If a negative argument is
supplied that many words before  point  are  converted  to  lower
case.   This is useful for correcting the word just typed without
having to move point to the beginning of the word yourself.

_1_9._3_9.  _c_a_s_e-_w_o_r_d-_u_p_p_e_r (_E_S_C _U)

This upper-cases the current word and leaves point at the end  of
it.   If point is in the middle of a word the rest of the word is
converted.  If point is not in a word it is first  moved  forward
to  the  beginning  of  the next word.  If a negative argument is
supplied that many words before  point  are  converted  to  upper
case.   This is useful for correcting the word just typed without
having to move point to the beginning of the word yourself.

_1_9._4_0.  _c_d (_N_o_t _B_o_u_n_d)

This changes the current directory.






                         March 19, 1996





62                 JOVE Manual for UNIX Users


_1_9._4_1.  _c_h_a_r_a_c_t_e_r-_t_o-_o_c_t_a_l-_i_n_s_e_r_t (_N_o_t _B_o_u_n_d)

This inserts a Back-slash followed by the ascii value of the next
character typed.  For example, "^G" inserts the string "\007".

_1_9._4_2.  _c_l_e_a_r-_a_n_d-_r_e_d_r_a_w (_E_S_C ^_L)

This clears the entire screen and redraws all the  windows.   Use
this  when JOVE gets confused about what's on the screen, or when
the screen gets filled with garbage  characters  or  output  from
another program.

_1_9._4_3.  _c_o_m_m_e_n_t-_f_o_r_m_a_t (_v_a_r_i_a_b_l_e)

This variable tells JOVE how to format your comments when you run
the command _f_i_l_l-_c_o_m_m_e_n_t.  Its format is this:
        <open pattern>%!<line header>%c<line trailer>%!<close pattern>
The %!, %c, and %! must appear in the format; everything else  is
optional.   A  newline (represented by %n) may appear in the open
or close patterns.  %% is the representation for %.  The  default
comment  format  is  for  C  comments.  See _f_i_l_l-_c_o_m_m_e_n_t for more
details.

_1_9._4_4.  _c_o_m_p_i_l_e-_i_t (^_X ^_E)

This compiles your program by running the UNIX command _m_a_k_e  into
a  buffer,  and automatically parsing the error messages that are
created (if any).  See the _p_a_r_s_e-_e_r_r_o_r_s command.   If  _c_o_m_p_i_l_e-_i_t
is  given a numeric argument, it will prompt for a command to run
in place of the plain make and the command you enter will  become
the  new  default.   See  also _e_r_r_o_r-_f_o_r_m_a_t-_s_t_r_i_n_g which makes it
possible to parse errors of a different format and see  also  the
variable _e_r_r_o_r-_w_i_n_d_o_w-_s_i_z_e.

_1_9._4_5.  _c_o_n_t_i_n_u_e-_p_r_o_c_e_s_s (_N_o_t _B_o_u_n_d)

This sends the signal SIGCONT to the interactive process  in  the
current buffer, IF the process is currently stopped.

_1_9._4_6.  _c_o_p_y-_r_e_g_i_o_n (_E_S_C _W)

This takes all the text in the region and copies it onto the kill
ring  buffer.   This is just like running _k_i_l_l-_r_e_g_i_o_n followed by
the _y_a_n_k command.  See the _k_i_l_l-_r_e_g_i_o_n and _y_a_n_k commands.

_1_9._4_7.  _c_u_r_r_e_n_t-_e_r_r_o_r (_N_o_t _B_o_u_n_d)

This moves to the current error in the  list  of  parsed  errors.
See  the _n_e_x_t-_e_r_r_o_r and _p_r_e_v_i_o_u_s-_e_r_r_o_r commands for more detailed
information.

_1_9._4_8.  _d_a_t_e (_N_o_t _B_o_u_n_d)

This prints the date on the message line.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  63


_1_9._4_9.  _d_b_x-_f_o_r_m_a_t-_s_t_r_i_n_g (_v_a_r_i_a_b_l_e)

This is the default regular-expression search string used by JOVE
to  parse  output  from  _d_b_x  running in a shell process (see the
_p_r_o_c_e_s_s-_d_b_x-_o_u_t_p_u_t command).  You shouldn't have to  change  this
unless you are using _g_d_b or some other symbolic debugger.

_1_9._5_0.  _d_e_f_i_n_e-_g_l_o_b_a_l-_w_o_r_d-_a_b_b_r_e_v (_N_o_t _B_o_u_n_d)

This defines a global  abbreviation.   See  the  _w_o_r_d-_a_b_b_r_e_v-_m_o_d_e
command.

_1_9._5_1.  _d_e_f_i_n_e-_m_a_c_r_o (_N_o_t _B_o_u_n_d)

This provides a different mechanism for defining keyboard macros.
Instead  of  gathering  keystrokes  and  storing  them  into  the
"keyboard-macro" (which is how  _b_e_g_i_n-_k_b_d-_m_a_c_r_o  works),  _d_e_f_i_n_e-
_m_a_c_r_o  prompts  for  a macro name (terminated with Space, or New-
line) and then for the actual macro body.  If you wish to specify
control  characters  in  the  macro,  you  may simply insert them
(using the _q_u_o_t_e_d-_i_n_s_e_r_t command) or by inserting  the  character
'^'  followed by the appropriate letter for that character (e.g.,
^A would be the two characters '^' followed by 'A').  You may use
Back-slash to prevent the '^' from being interpreted as part of a
control character when you really wish to  insert  one  (e.g.,  a
macro  body  "\^foo"  would  insert  the  string  "^foo" into the
buffer, whereas the body "^foo" would be the same  as  typing  ^F
and then inserting the string "oo").  See _w_r_i_t_e-_m_a_c_r_o_s-_t_o-_f_i_l_e to
see how to save macros.

_1_9._5_2.  _d_e_f_i_n_e-_m_o_d_e-_w_o_r_d-_a_b_b_r_e_v (_N_o_t _B_o_u_n_d)

This defines a mode-specific abbreviation.  See the  _w_o_r_d-_a_b_b_r_e_v-
_m_o_d_e command.

_1_9._5_3.  _d_e_l_e_t_e-_b_l_a_n_k-_l_i_n_e_s (^_X ^_O)

This deletes all the blank lines around point.   This  is  useful
when you previously opened many lines with the _n_e_w_l_i_n_e-_a_n_d-_b_a_c_k_u_p
command and now wish to delete the unused ones.

_1_9._5_4.  _d_e_l_e_t_e-_b_u_f_f_e_r (^_X _K)

This deletes a buffer and frees up all the memory associated with
it.   Be  careful(!)  - once a buffer has been deleted it is gone
forever.  JOVE will ask you to confirm if you  try  to  delete  a
buffer  that  needs saving.  This command is useful for when JOVE
runs out of space to store new  buffers.   See  also  the  _e_r_a_s_e-
_b_u_f_f_e_r command and the _k_i_l_l-_s_o_m_e-_b_u_f_f_e_r_s command.

_1_9._5_5.  _d_e_l_e_t_e-_c_u_r_r_e_n_t-_w_i_n_d_o_w (^_X _D))

This deletes the active window and moves point into  one  of  the
remaining  ones.   It  is  an  error  to  try  to delete the only



                         March 19, 1996





64                 JOVE Manual for UNIX Users


remaining window.

_1_9._5_6.  _d_e_l_e_t_e-_n_e_x_t-_c_h_a_r_a_c_t_e_r (^_D)

This deletes the character that's just after point (that is,  the
character  under  the cursor).  If point is at the end of a line,
the line-separator is deleted and the next line  is  joined  with
the  current  one.  If an argument is given, that many characters
are deleted and placed on the kill  ring.   If  the  argument  is
negative the deletion is forwards.

_1_9._5_7.  _d_e_l_e_t_e-_o_t_h_e_r-_w_i_n_d_o_w_s (^_X _1)

This deletes all the other windows except the current one.   This
can be thought of as going back into One Window mode.

_1_9._5_8.  _d_e_l_e_t_e-_p_r_e_v_i_o_u_s-_c_h_a_r_a_c_t_e_r (_D_E_L _a_n_d ^_H)

This deletes the character that's just before point (that is, the
character  before  the  cursor).  If point is at the beginning of
the line, the line separator is deleted and that line  is  joined
with  the previous one.  If an argument is given, that many char-
acters are deleted and placed on the kill ring.  If the  argument
is negative the deletion is backwards.

_1_9._5_9.  _d_e_l_e_t_e-_w_h_i_t_e-_s_p_a_c_e (_E_S_C \)

This deletes all the Tabs and Spaces around point.

_1_9._6_0.  _d_e_s_c_r_i_b_e-_b_i_n_d_i_n_g_s (_N_o_t _B_o_u_n_d)

This types out a list containing each bound key and  the  command
that  gets  invoked every time that key is typed.  To make a wall
chart of JOVE commands, set _s_e_n_d-_t_y_p_e_o_u_t-_t_o-_b_u_f_f_e_r to _o_n and JOVE
will  store  the key bindings in a buffer which you can save to a
file and then print.

_1_9._6_1.  _d_e_s_c_r_i_b_e-_c_o_m_m_a_n_d (_E_S_C ?)

This waits for you to type a command and then prints an  explana-
tion of that command, together with its current bindings.

_1_9._6_2.  _d_e_s_c_r_i_b_e-_k_e_y (^_X ?)

This waits for you to type a key and then tells the name  of  the
command  that  gets invoked every time that key is hit.  Once you
have the name of the command you  can  use  the  _d_e_s_c_r_i_b_e-_c_o_m_m_a_n_d
command to find out exactly what it does.

_1_9._6_3.  _d_e_s_c_r_i_b_e-_v_a_r_i_a_b_l_e (_N_o_t _B_o_u_n_d)

This prints an explanation of a specified variable.





                         March 19, 1996





                   JOVE Manual for UNIX Users                  65


_1_9._6_4.  _d_i_g_i_t (_E_S_C _0 _t_h_r_o_u_g_h _E_S_C _9)

Starts or continues the entry of  a  numeric  argument  with  the
digit  typed.   It  continues  reading digits until you type some
other command.  Then that command is executed  with  the  numeric
argument you specified.

_1_9._6_5.  _d_i_g_i_t-_0 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  0.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 0 key
on the numeric keypad.

_1_9._6_6.  _d_i_g_i_t-_1 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  1.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 1 key
on the numeric keypad.

_1_9._6_7.  _d_i_g_i_t-_2 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  2.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 2 key
on the numeric keypad.

_1_9._6_8.  _d_i_g_i_t-_3 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  3.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 3 key
on the numeric keypad.

_1_9._6_9.  _d_i_g_i_t-_4 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  4.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 4 key
on the numeric keypad.

_1_9._7_0.  _d_i_g_i_t-_5 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  5.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 5 key
on the numeric keypad.



                         March 19, 1996





66                 JOVE Manual for UNIX Users


_1_9._7_1.  _d_i_g_i_t-_6 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  6.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 6 key
on the numeric keypad.

_1_9._7_2.  _d_i_g_i_t-_7 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  7.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 7 key
on the numeric keypad.

_1_9._7_3.  _d_i_g_i_t-_8 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  8.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 8 key
on the numeric keypad.

_1_9._7_4.  _d_i_g_i_t-_9 (_N_o_t _B_o_u_n_d)

Starts or continues the entry of  a  numeric  argument  with  the
digit  9.   It continues reading digits until you type some other
command.  Then that command is executed with the numeric argument
you  specified.   Sometimes it is handy to bind this to the 9 key
on the numeric keypad.

_1_9._7_5.  _d_i_g_i_t-_m_i_n_u_s (_E_S_C -)

Starts the entry of a numeric argument with  a  minus  sign.   It
continues reading digits until you type some other command.  Then
that command is executed with the numeric argument you specified.
Sometimes  it  is  handy  to  bind this to the - key on a numeric
keypad.  In the absence of further digits  and  unless  otherwise
stated (e.g.  _n_e_x_t-_p_a_g_e), the argument -1 is assumed.

_1_9._7_6.  _d_i_r_s (_N_o_t _B_o_u_n_d)

This prints out the directory stack.  See the _c_d, _p_u_s_h_d, _p_u_s_h_l_i_b_d
and _p_o_p_d commands for more information.

_1_9._7_7.  _d_i_s_a_b_l_e-_b_i_f_f (_v_a_r_i_a_b_l_e)

When this is set, JOVE disables  biff  when  you're  editing  and
enables  it  again when you get out of JOVE, or when you pause to
the parent shell or push to a new shell.  (This means arrival  of
new  mail  will  not  be  immediately apparent but will not cause
indiscriminate writing on the  display).   The  default  is  _o_f_f,
although  it is always safe to set it _o_n, even on systems that do



                         March 19, 1996





                   JOVE Manual for UNIX Users                  67


not provide the biff facility.  Note that the variable  _m_o_d_e-_l_i_n_e
can  be  set up to announce the arrival of new mail during a JOVE
session.

_1_9._7_8.  _d_i_s_p_l_a_y-_b_a_d-_f_i_l_e_n_a_m_e_s (_v_a_r_i_a_b_l_e)

This  is  the  obsolete  name   for   _d_i_s_p_l_a_y-_f_i_l_e_n_a_m_e_s-_w_i_t_h-_b_a_d-
_e_x_t_e_n_s_i_o_n_s.

_1_9._7_9.  _d_i_s_p_l_a_y-_f_i_l_e_n_a_m_e_s-_w_i_t_h-_b_a_d-_e_x_t_e_n_s_i_o_n_s (_v_a_r_i_a_b_l_e)

This variable affects only filename  completion,  in  particular,
what  happens when "?" is typed while prompting for a file.  When
this variable is _o_n, any files that end with one  of  the  exten-
sions  defined  by  the  variable _b_a_d-_f_i_l_e_n_a_m_e-_e_x_t_e_n_s_i_o_n_s will be
displayed with an "!" in front of  their  names.   When  _d_i_s_p_l_a_y-
_f_i_l_e_n_a_m_e_s-_w_i_t_h-_b_a_d-_e_x_t_e_n_s_i_o_n_s  is  _o_f_f  the  files  will  not  be
displayed at all.  The default value is _o_n.

_1_9._8_0.  _d_o_w_n-_l_i_s_t (_E_S_C ^_D)

This is the opposite of _b_a_c_k_w_a_r_d-_u_p-_l_i_s_t.   It  enters  the  next
list.   In other words, it moves forward to whichever of "([{" it
first encounters.  Arguments are accepted, and negative arguments
search backwards as in _b_a_c_k_w_a_r_d-_u_p-_l_i_s_t.

_1_9._8_1.  _d_s_t_o_p-_p_r_o_c_e_s_s (_P_r_o_c: ^_C ^_Y)

Send the  signal  SIGTSTP  to  the  interactive  process  in  the
selected  buffer  when  next  it  tries  to  read input.  This is
equivalent to sending the "dsusp" character  (which  most  people
have  set to ^Y) to the process.  This only works if you are in a
buffer bound to an interactive process.

_1_9._8_2.  _e_d_i_t-_w_o_r_d-_a_b_b_r_e_v_s (_N_o_t _B_o_u_n_d)

This creates (if necessary) a buffer with a list of each abbrevi-
ation and the phrase it expands into, and enters a recursive edit
to let you change the abbreviations or add some more.  The format
of this list is "abbreviation:phrase" so if you add some more you
should follow that format.  It's probably simplest just  to  copy
some  already  existing  abbreviations  and  edit  them.  Use the
_e_x_i_t-_j_o_v_e command to exit the recursive edit.

_1_9._8_3.  _e_n_d-_k_b_d-_m_a_c_r_o (^_X ))

This stops the definition of the keyboard macro.   Because  of  a
bug  in  JOVE, this must be bound to "^X )", or some key sequence
which is one or two characters long.  Anything else will not work
properly.  See _b_e_g_i_n-_k_b_d-_m_a_c_r_o for more details.

_1_9._8_4.  _e_n_d-_o_f-_f_i_l_e (_E_S_C >)

This moves  point  forward  to  the  end  of  the  buffer.   This



                         March 19, 1996





68                 JOVE Manual for UNIX Users


sometimes  prints  the  "[Point pushed]" message to indicate that
JOVE has set the mark so you can go back to where you were if you
want.  See also the variable _m_a_r_k-_t_h_r_e_s_h_o_l_d.

_1_9._8_5.  _e_n_d-_o_f-_l_i_n_e (^_E)

This moves point to the end of the current line.  If the line  is
too  long to fit on the screen, it will be scrolled horizontally.
This is described with the  variables  _s_c_r_o_l_l-_w_i_d_t_h  and  _s_c_r_o_l_l-
_a_l_l-_l_i_n_e_s.

_1_9._8_6.  _e_n_d-_o_f-_w_i_n_d_o_w (_E_S_C .)

This moves point to the last character in the active window.   If
there  is  a  numeric  argument,  the point moves that many lines
above the bottom line.  With the default bindings,  the  sequence
"ESC ."  is  the  same as "ESC >" (_b_e_g_i_n_n_i_n_g-_o_f-_f_i_l_e) but without
the shift key on the ">", and can thus easily be remembered.

_1_9._8_7.  _e_n_h_a_n_c_e_d-_k_e_y_b_o_a_r_d (_v_a_r_i_a_b_l_e)

(IBM PC version only) This is a boolean variable which can be set
to  enable the enhanced AT-style keyboard.  The enhanced keyboard
contains function keys and key combinations  that  are  not  sup-
ported  on  the  original  IBM PCs and XTs.  The default value is
determined by a bit in  the  BIOS  data  area,  but  this  method
apparently  does not work with a few BIOS implementations.  WARN-
ING: setting enhanced-keyboard _o_n on systems without an  enhanced
keyboard will lock up your system and require you to reboot.

_1_9._8_8.  _e_o_f-_p_r_o_c_e_s_s (^_C ^_D)

Sends EOF to the current interactive process.  This only works on
versions of JOVE running under versions of UNIX with pty's.

_1_9._8_9.  _e_r_a_s_e-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This erases the contents of the specified buffer.  This  is  like
_d_e_l_e_t_e-_b_u_f_f_e_r  except  it only erases the contents of the buffer,
not the buffer itself.  If you try to erase a buffer  that  needs
saving you will be asked to confirm it.

_1_9._9_0.  _e_r_r_o_r-_f_o_r_m_a_t-_s_t_r_i_n_g (_v_a_r_i_a_b_l_e)

This is the error format string that is used by  _p_a_r_s_e-_e_r_r_o_r_s  to
find  the  error  messages  in  a buffer.  The way it works is by
using this string as a JOVE  regular  expression  search  string,
where  the \(...\) regular expression feature is used to pick out
the file name and line number from the line containing  an  error
message.   For  instance, a typical error message might look like
this:

        "file.c", line 540: missing semi-colon




                         March 19, 1996





                   JOVE Manual for UNIX Users                  69


For strings of this  format,  an  appropriate  value  for  _e_r_r_o_r-
_f_o_r_m_a_t-_s_t_r_i_n_g would be something like this:

        ^"\([^"]*\)", line \([0-9]*\):

What this means is, to find an error message, search for  a  line
beginning with a double-quote.  Then it says that all the follow-
ing characters up to another double-quote should be remembered as
one  unit,  namely the filename that the error is in (that is why
the first set of parentheses is surrounding it).   Then  it  says
that  after  the filename there will be the string ", line " fol-
lowed by a line number, which should be remembered  as  a  single
unit (which is why the second set of parentheses is around that).
The only constraint on the error messages is that the  file  name
and  line number appear on the same line.  Most compilers seem to
do this anyway, so this is not an unreasonable restriction.

If you do not know how to use regular expressions then this vari-
able will be hard for you to use.  Also note that you can look at
the default value of this variable by printing it out, but it  is
a  really  complicated string because it is trying to accommodate
the outputs of more than one compiler.

_1_9._9_1.  _e_r_r_o_r-_w_i_n_d_o_w-_s_i_z_e (_v_a_r_i_a_b_l_e)

This is the percentage of the screen to use for the  error-window
on  the  screen.   When  you  execute _c_o_m_p_i_l_e-_i_t or _s_p_e_l_l-_b_u_f_f_e_r,
_e_r_r_o_r-_w_i_n_d_o_w-_s_i_z_e percent of the screen will go to the error win-
dow.  If the window already exists and is a different size, it is
made to be this size.  The default value is 20%.

_1_9._9_2.  _e_x_c_h_a_n_g_e-_p_o_i_n_t-_a_n_d-_m_a_r_k (^_X ^_X)

This moves point to mark and makes mark the old point.   This  is
for quickly moving from one end of the region to the other.

_1_9._9_3.  _e_x_e_c_u_t_e-_k_b_d-_m_a_c_r_o (^_X _E)

This executes the keyboard macro.  If you supply a numeric  argu-
ment  the  macro is executed that many times.  See the _b_e_g_i_n-_k_b_d-
_m_a_c_r_o command for more details.

_1_9._9_4.  _e_x_e_c_u_t_e-_m_a_c_r_o (_N_o_t _B_o_u_n_d)

This executes a specified macro.  If you supply a  numeric  argu-
ment the macro is executed that many times.

_1_9._9_5.  _e_x_e_c_u_t_e-_n_a_m_e_d-_c_o_m_m_a_n_d (_E_S_C _X)

This is the way to execute a command that isn't bound to any key.
When you are prompted with ": " you can type the name of the com-
mand.  You don't have to type the entire name.   After  typing  a
few  characters, Tab will fill in as many more as it can (as will
Space, but  that  will  also  obey  the  command  if  it  is  now



                         March 19, 1996





70                 JOVE Manual for UNIX Users


unambiguous).   If  you  are not sure of the name of the command,
type "?" and JOVE will print a list of all the commands that  you
could  possibly  match given what you've already typed.  Once the
command is unambiguous, typing Return will cause it to be obeyed.

If you don't have any idea what the command's  name  is  but  you
know  it  has something to do with windows (for example), you can
do "ESC X apropos window" and JOVE will print a list of  all  the
commands  that are related to windows.  If you find yourself con-
stantly executing the same commands this way you probably want to
bind them to keys so that you can execute them more quickly.  See
the _b_i_n_d-_t_o-_k_e_y command.

_1_9._9_6.  _e_x_i_t-_j_o_v_e (^_X ^_C)

This exits JOVE.  If any buffers need saving JOVE  will  print  a
warning  message  and ask for confirmation.  If you leave without
saving your buffers all your work will be lost.  If  you  made  a
mistake  and  really  do want to exit then you can.  If there are
any interactive processes running, JOVE  will  also  ask  whether
they should be terminated.

If you are in a recursive editing level _e_x_i_t-_j_o_v_e will return you
from  that.   The  selected buffer will be set back to the buffer
that was current when the recursive edit was entered.   Normally,
point  will be returned to its position at the time of entry, but
if the _e_x_i_t-_j_o_v_e command is given a numeric  argument,  point  is
left at its most recent position within that buffer.

_1_9._9_7.  _e_x_p_a_n_d-_e_n_v_i_r_o_n_m_e_n_t-_v_a_r_i_a_b_l_e_s (_v_a_r_i_a_b_l_e)

When this variable is _o_n JOVE will try to expand any  strings  of
the  form "$var" into the value of the environment variable "var"
when  asking  for  a  filename.   For  example,   if   you   type
$$$$HHHHOOOOMMMMEEEE////....jjjjoooovvvveeeerrrrcccc, "$HOME" will be replaced with your home directory.
The default value is _o_n.

_1_9._9_8.  _f_i_l_e-_c_r_e_a_t_i_o_n-_m_o_d_e (_v_a_r_i_a_b_l_e)

This variable has an octal value.   It  contains  the  mode  (see
_c_h_m_o_d(1))  with  which  files  should be created.  This mode gets
modified by your  current  umask  setting  (see  _u_m_a_s_k(1)).   The
default value is usually 0666 or 0644.

_1_9._9_9.  _f_i_l_e_s-_s_h_o_u_l_d-_e_n_d-_w_i_t_h-_n_e_w_l_i_n_e (_v_a_r_i_a_b_l_e)

This variable indicates that all files should always have a  new-
line  at  the end.  This is often necessary for line printers and
the like.  When set, if JOVE is writing a file whose last charac-
ter is not a newline, it will add one automatically.  The default
value is _o_n.






                         March 19, 1996





                   JOVE Manual for UNIX Users                  71


_1_9._1_0_0.  _f_i_l_l-_c_o_m_m_e_n_t (_N_o_t _B_o_u_n_d)

This command fills in your C comments to  make  them  pretty  and
readable.   This  filling is done according the variable _c_o_m_m_e_n_t-
_f_o_r_m_a_t.
        /*
         * the default format makes comments like this.
         */
This can be changed  by  changing  the  _f_o_r_m_a_t-_c_o_m_m_e_n_t  variable.
Other  languages may be supported by changing the format variable
appropriately.  The formatter looks backwards from point  for  an
open  comment symbol.  If found, all indentation is done relative
to the position of the first character of the  open  symbol.   If
there  is  a matching close symbol, the entire comment is format-
ted.  If not, the region between the open  symbol  and  point  is
reformatted.   The  original  text  is  saved in the kill ring; a
_y_a_n_k-_p_o_p command will undo the formatting.

_1_9._1_0_1.  _f_i_l_l-_p_a_r_a_g_r_a_p_h (_E_S_C _J)

This rearranges words between lines so that all the lines in  the
current  paragraph  extend as close to the right margin as possi-
ble, ensuring that none of the lines will  be  greater  than  the
right  margin.  The default value for _r_i_g_h_t-_m_a_r_g_i_n is 78, but can
be changed with the _s_e_t and _r_i_g_h_t-_m_a_r_g_i_n-_h_e_r_e commands.

The rearrangement may cause an end of line to be replaced by whi-
tespace.   Normally, this whitespace is a single space character.
If the variable _s_p_a_c_e-_s_e_n_t_e_n_c_e-_2 is _o_n, and the end of  the  line
was  apparently  the  end  of a sentence or the line ended with a
colon, two spaces will be used.  However,  a  sentence  or  colon
followed  by  a  single  space  already within a line will not be
altered.

JOVE has a complicated algorithm for  determining  the  beginning
and  end of the paragraph.  In the normal case JOVE will give all
the lines the same indent as they currently have, but if you wish
to  force a new indent you can supply a numeric argument to _f_i_l_l-
_p_a_r_a_g_r_a_p_h and JOVE will indent each line to the column  specified
by  the  _l_e_f_t-_m_a_r_g_i_n variable.  See also the _l_e_f_t-_m_a_r_g_i_n variable
and _l_e_f_t-_m_a_r_g_i_n-_h_e_r_e command.

_1_9._1_0_2.  _f_i_l_l-_r_e_g_i_o_n (_N_o_t _B_o_u_n_d)

This is like _f_i_l_l-_p_a_r_a_g_r_a_p_h,  except  it  operates  on  a  region
instead of just a paragraph.

_1_9._1_0_3.  _f_i_l_t_e_r-_r_e_g_i_o_n (_N_o_t _B_o_u_n_d)

This sends the text in the region to a UNIX command, and replaces
the  region  with  the output from that command.  For example, if
you are lazy and don't like to take the time  to  write  properly
indented  C  code,  you can put the region around your C file and
_f_i_l_t_e_r-_r_e_g_i_o_n it through _c_b, the UNIX C beautifier.  If you  have



                         March 19, 1996





72                 JOVE Manual for UNIX Users


a  file that contains a bunch of lines that need to be sorted you
can do that from inside JOVE too, by filtering the region through
the  UNIX  _s_o_r_t command.  Before output from the command replaces
the region JOVE stores the old text in the kill ring.  If you are
unhappy with the results a _y_a_n_k-_p_o_p command will get back the old
text.

_1_9._1_0_4.  _f_i_n_d-_f_i_l_e (^_X ^_F)

This reads a specified file into its own buffer and then  selects
that  buffer.   If  you've  already read this file into a buffer,
that buffer is simply selected.  If the file doesn't  yet  exist,
JOVE  will print "(New file)" so that you know.  If possible, the
buffer is named after the filename (ignoring any directory part).

_1_9._1_0_5.  _f_i_n_d-_t_a_g (^_X _T)

This finds the file that contains the specified tag.  JOVE  looks
up  tags by default in the ttttaaaaggggssss file in the current directory, as
created by the UNIX command _c_t_a_g_s(_1).  You can change the default
tag  name  by  setting the _t_a_g-_f_i_l_e variable to another name.  If
you specify a numeric argument  to  this  command,  you  will  be
prompted  for  a tag file.  This is a good way to specify another
tag file without changing the default.

_1_9._1_0_6.  _f_i_n_d-_t_a_g-_a_t-_p_o_i_n_t (_N_o_t _B_o_u_n_d)

This finds the file that contains the tag that point is currently
in.  See _f_i_n_d-_t_a_g.

_1_9._1_0_7.  _f_i_r_s_t-_n_o_n-_b_l_a_n_k (_E_S_C _M)

This moves point (backwards or forwards) to  the  indent  of  the
current line.

_1_9._1_0_8.  _f_o_r_w_a_r_d-_c_h_a_r_a_c_t_e_r (^_F)

This moves  point  forward  over  a  single  character  or  line-
separator.   Thus  if point is at the end of the line it moves to
the beginning of the next one.

_1_9._1_0_9.  _f_o_r_w_a_r_d-_l_i_s_t (_E_S_C ^_N)

This moves point forward over a list, which is any  text  between
properly  matching (...), [...] or {...}.  It first searches for-
ward for a "(" and then moves to the matching ")".  This is  use-
ful  when  you are trying to find unmatched parentheses in a pro-
gram.  Arguments are  accepted,  and  negative  arguments  search
backwards.  See also _f_o_r_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n.

_1_9._1_1_0.  _f_o_r_w_a_r_d-_p_a_r_a_g_r_a_p_h (_E_S_C ])

This moves point forward to the end of the current or next  para-
graph.   Paragraphs  are  bounded  by lines that match _p_a_r_a_g_r_a_p_h-



                         March 19, 1996





                   JOVE Manual for UNIX Users                  73


_d_e_l_i_m_i_t_e_r-_p_a_t_t_e_r_n (by default, those that are empty or look  like
troff  or TeX commands).  A change in indentation may also signal
a break between paragraphs, except that  JOVE  allows  the  first
line  of  a  paragraph  to be indented differently from the other
lines.  Arguments are accepted,  and  negative  arguments  search
backwards.

_1_9._1_1_1.  _f_o_r_w_a_r_d-_s-_e_x_p_r_e_s_s_i_o_n (_E_S_C ^_F)

This moves point forward over an s-expression,  that  is  over  a
Lisp  atom or a C identifier (depending on the major mode) ignor-
ing punctuation and whitespace; or,  if  the  nearest  succeeding
significant  character  is  one  of  "([{",  over  a  list  as in
_f_o_r_w_a_r_d-_l_i_s_t.  Arguments are  accepted,  and  negative  arguments
search backwards.

_1_9._1_1_2.  _f_o_r_w_a_r_d-_s_e_n_t_e_n_c_e (_E_S_C _E)

This moves point forward to the end of the current or  next  sen-
tence.  JOVE considers the end of a sentence to be the characters
".", "!" or "?", followed possibly by "'", "''", or """, followed
by  a Return or whitespace.  Arguments are accepted, and negative
arguments search backwards.

_1_9._1_1_3.  _f_o_r_w_a_r_d-_w_o_r_d (_E_S_C _F)

This moves point forward to the end of the current or next word.

_1_9._1_1_4.  _f_u_n_d_a_m_e_n_t_a_l-_m_o_d_e (_N_o_t _B_o_u_n_d)

This sets the major mode to Fundamental.  Fundamental mode is the
mode  of  the Minibuf, and hence of anything typed in the message
line.

_1_9._1_1_5.  _g_a_t_h_e_r-_n_u_m_e_r_i_c-_a_r_g_u_m_e_n_t (^_U)

This command is one of two ways to specify a numeric argument  to
a command.  Typing this command once means, Do the next command 4
times.  Typing it twice will do the next command 16 times, and so
on.   If at any point you type a number, then that number will be
used instead of 4.  For instance, ^U 3 5 means do the  next  com-
mand 35 times (assuming _g_a_t_h_e_r-_n_u_m_e_r_i_c-_a_r_g_u_m_e_n_t is bound to ^U).

_1_9._1_1_6.  _g_o_t_o-_l_i_n_e (_E_S_C _G)

If a positive numeric argument is supplied, point  moves  to  the
beginning  of  that  line.  If the argument is negative, it indi-
cates how many lines from the end of the buffer to move point to.
If no argument is supplied one is prompted for.

_1_9._1_1_7.  _g_o_t_o-_w_i_n_d_o_w-_w_i_t_h-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This command prompts for a buffer  name  and  then  selects  that
buffer.  If the buffer is currently being displayed in one of the



                         March 19, 1996





74                 JOVE Manual for UNIX Users


windows, that window is selected instead.

_1_9._1_1_8.  _g_r_i_n_d-_s-_e_x_p_r (_N_o_t _B_o_u_n_d)

When point is positioned on a  "(",  this  re-indents  that  LISP
expression.

_1_9._1_1_9.  _g_r_o_w-_w_i_n_d_o_w (^_X ^)

This makes the active window one line bigger.   This  only  works
when  there is more than one window and provided there is room to
change the size.  See also _s_h_r_i_n_k-_w_i_n_d_o_w.

_1_9._1_2_0.  _h_a_n_d_l_e-_t_a_b (_T_a_b)

This handles indenting to the "right" place in C and  Lisp  mode,
and just inserts itself in Text mode.

_1_9._1_2_1.  _h_i_g_h_l_i_g_h_t-_a_t_t_r_i_b_u_t_e (_v_a_r_i_a_b_l_e)

(IBM PC version only) This specifies how the attribute (color) of
a  character is to be changed when it is highlighted.  Highlight-
ing is indicated by exclusive oring this value  with  the  normal
attribute for the character.  The default is 16.

_1_9._1_2_2.  _h_i_g_h_l_i_g_h_t-_m_a_r_k (_v_a_r_i_a_b_l_e)

When this is on, jove will highlight the mark if currently  visi-
ble.  The mark is highlighted with an underscore.

_1_9._1_2_3.  _i-_s_e_a_r_c_h-_f_o_r_w_a_r_d (_N_o_t _B_o_u_n_d)

Incremental search.  Like search-forward except that  instead  of
prompting for a string and searching for that string all at once,
it accepts the string one character at a time.  After each  char-
acter  you type as part of the search string, it searches for the
entire string so far.  When you like what it found,  type  Return
to finish the search.  You can take back a character with DEL and
the search will back up to the position before that character was
typed.  ^G aborts the search.

_1_9._1_2_4.  _i-_s_e_a_r_c_h-_r_e_v_e_r_s_e (_N_o_t _B_o_u_n_d)

Incremental search.  Like search-reverse except that  instead  of
prompting for a string and searching for that string all at once,
it accepts the string one character at a time.  After each  char-
acter  you type as part of the search string, it searches for the
entire string so far.  When you like what it found,  type  Return
to finish the search.  You can take back a character with DEL and
the search will back up to the position before that character was
typed.  ^G aborts the search.






                         March 19, 1996





                   JOVE Manual for UNIX Users                  75


_1_9._1_2_5.  _i-_s_h_e_l_l-_c_o_m_m_a_n_d (_N_o_t _B_o_u_n_d)

This is like _s_h_e_l_l-_c_o_m_m_a_n_d except that it launches an interactive
process and so lets you continue with your editing while the com-
mand is running.  This is really useful for long running commands
with sporadic output.  See also the variable _w_r_a_p-_p_r_o_c_e_s_s-_l_i_n_e_s.

_1_9._1_2_6.  _i_n_s_e_r_t-_f_i_l_e (^_X ^_I)

This inserts a specified file into the selected buffer at  point.
Point is positioned at the beginning of the inserted file.

_1_9._1_2_7.  _i_n_t_e_r_n_a_l-_t_a_b_s_t_o_p (_v_a_r_i_a_b_l_e)

This is the obsolete name for _t_a_b-_w_i_d_t_h.

_1_9._1_2_8.  _i_n_t_e_r_r_u_p_t-_c_h_a_r_a_c_t_e_r (_v_a_r_i_a_b_l_e)

This specifies what character should be  used  as  the  operating
system's  tty driver interrupt character.  When this character is
typed, the tty driver generates SIGINT signal.  This will  inter-
rupt  a  non-interactive process.  If no such process is running,
JOVE'S will offer you  the  option  of  continuing,  or  crashing
JOVE'S (trying to save your work).  This is a crude and desperate
way to stop JOVE'S.  Unfortunately there is no way  to  turn  off
the  interrupt  character.   The  default is ^].  See also _a_b_o_r_t-
_c_h_a_r.

_1_9._1_2_9.  _i_n_t_e_r_r_u_p_t-_p_r_o_c_e_s_s (_P_r_o_c: ^_C ^_C)

This sends the signal SIGINT to the interactive  process  in  the
selected  buffer.   This  only  works  if you are inside a buffer
bound to an interactive process.

_1_9._1_3_0.  _k_i_l_l-_n_e_x_t-_w_o_r_d (_E_S_C _D)

This kills the text from point to the end of the current or  next
word.  The killed text is sent to the kill ring.

_1_9._1_3_1.  _k_i_l_l-_p_r_e_v_i_o_u_s-_w_o_r_d (_E_S_C _D_E_L)

This kills the text from point to the beginning of the current or
previous word.  The killed text is sent to the kill ring.

_1_9._1_3_2.  _k_i_l_l-_p_r_o_c_e_s_s (_N_o_t _B_o_u_n_d)

This command prompts for a buffer name or buffer number (just  as
_s_e_l_e_c_t-_b_u_f_f_e_r does) and then sends the process in that buffer the
signal SIGKILL.

_1_9._1_3_3.  _k_i_l_l-_r_e_g_i_o_n (^_W)

This deletes the text in the region and  saves  it  on  the  kill
ring.  Commands that delete text but save it on the kill ring all



                         March 19, 1996





76                 JOVE Manual for UNIX Users


have the word "kill" in their names.  Use the _y_a_n_k command to get
back the most recent kill.

_1_9._1_3_4.  _k_i_l_l-_s-_e_x_p_r_e_s_s_i_o_n (_E_S_C ^_K)

This kills the text from point to the end of the current or  next
s-expression.  The killed text is sent to the kill ring.

_1_9._1_3_5.  _k_i_l_l-_s_o_m_e-_b_u_f_f_e_r_s (_N_o_t _B_o_u_n_d)

This goes through all the existing buffers and  asks  whether  or
not to delete each one.  If you decide to delete a buffer, and it
turns out that the buffer is modified, JOVE will offer to save it
first.   This is useful for when JOVE runs out of memory to store
lines (this only happens  on  PDP-11's)  and  you  have  lots  of
buffers that you are no longer using.  See also the _d_e_l_e_t_e-_b_u_f_f_e_r
command.

_1_9._1_3_6.  _k_i_l_l-_t_o-_b_e_g_i_n_n_i_n_g-_o_f-_s_e_n_t_e_n_c_e (^_X _D_E_L)

This kills from point to the beginning of the current or previous
sentence.   If  a  negative numeric argument is supplied it kills
from point to the end of  the  current  or  next  sentence.   The
killed text is sent to the kill ring.

_1_9._1_3_7.  _k_i_l_l-_t_o-_e_n_d-_o_f-_l_i_n_e (^_K)

This kills from point to the end of the current line.  When point
is  at  the  end  of  the  line (discounting any white space) the
line-separator is also deleted and the next line is  joined  with
current  one.   If a numeric argument is supplied that many lines
are killed; if the argument is negative that  many  lines  before
point  are killed; if the argument is zero the text from point to
the beginning of the line is killed.  The killed text is sent  to
the kill ring.

_1_9._1_3_8.  _k_i_l_l-_t_o-_e_n_d-_o_f-_s_e_n_t_e_n_c_e (_E_S_C _K)

This kills from point to the end of the current or next sentence.
If a negative numeric argument is supplied it kills from point to
the beginning of the current or previous  sentence.   The  killed
text is sent to the kill ring.

_1_9._1_3_9.  _l_c-_c_t_y_p_e (_v_a_r_i_a_b_l_e)

This string variable  determines  how  non-ASCII  characters  are
displayed,  and  which  characters are to be considered as upper-
case,  lower-case,  printable,   etc.    The   default   is   the
implementation-defined  native  environment;  under  POSIX, it is
determined by whichever  of  the  environment  variables  LC_ALL,
LC_CTYPE  or LANG is first found to be set, and is otherwise "C".
Some useful values of _l_c-_c_t_y_p_e might be:





                         March 19, 1996





                   JOVE Manual for UNIX Users                  77


        ""             Default: the native environment.
        "C"            Strict ASCII.  All other characters greater than \177
                       rendered in octal.
        "iso_8859_1"   Latin-1 alphabet.

_1_9._1_4_0.  _l_e_f_t-_m_a_r_g_i_n (_v_a_r_i_a_b_l_e)

This is how far lines should be indented when Auto Indent mode is
on,  or  when  the  _n_e_w_l_i_n_e-_a_n_d-_i_n_d_e_n_t command is run (usually by
typing Linefeed).  It is also used  by  _f_i_l_l-_p_a_r_a_g_r_a_p_h  and  Auto
Fill mode.  If the value is zero (the default) then the left mar-
gin is determined from the surrounding lines.

_1_9._1_4_1.  _l_e_f_t-_m_a_r_g_i_n-_h_e_r_e (_N_o_t _B_o_u_n_d)

This sets the _l_e_f_t-_m_a_r_g_i_n variable to  the  current  position  of
point.   This  is an easy way to say, "Make the left margin begin
here," without having to count the number of spaces over it actu-
ally is.

_1_9._1_4_2.  _l_i_s_p-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on the Lisp major mode.  In Lisp mode, the  characters
Tab  and  ")"  are treated specially, similar to the way they are
treated in C mode.  Also, Auto Indent mode is affected, and  han-
dled specially.  See also the _c-_m_o_d_e command.

_1_9._1_4_3.  _l_i_s_t-_b_u_f_f_e_r_s (^_X ^_B)

This types out a list containing various information  about  each
buffer.  The list looks like this:
         (* means the buffer needs saving)
         NO  Lines Type        Name           File
         --  ----- ----        ----           ----
         1   1     File        Main           [No file]
         2   1     Scratch   * Minibuf        [No file]
         3   519   File      * commands.doc   commands.doc
The first column lists the buffer's number.   When  JOVE  prompts
for  a  buffer  name you can either type in the full name, or you
can simply type the buffer's number.  The second  column  is  the
number  of  lines  in  the  buffer.   The third says what type of
buffer.  There are four types:  File,  Scratch,  Process  and  I-
Process.   "File" is simply a buffer that holds a file; "Scratch"
is for buffers that JOVE uses internally; "Process" is  one  that
holds the output from a UNIX command; "I-Process" is one that has
an interactive process attached to it.  The next column  contains
the  name  of the buffer.  And the last column is the name of the
file that's attached to the buffer.  In this case,  both  Minibuf
and  commands.doc  have  been changed but not yet saved.  In fact
Minibuf won't be saved since it's a Scratch buffer.

_1_9._1_4_4.  _l_i_s_t-_p_r_o_c_e_s_s_e_s (_N_o_t _B_o_u_n_d)

This makes a list somewhat like "list-buffers" does,  except  its



                         March 19, 1996





78                 JOVE Manual for UNIX Users


list  consists  of  the  current interactive processes.  The list
looks like this:
         Buffer           Status           Pid       Command
         ------           ------           ---       -------
         *shell*          Running          18415     shell
         fgrep            Done             18512     fgrep -n Buffer *.c
The first column has the name of the buffer to which the  process
is attached.  The second has the status of the process; if a pro-
cess has exited normally the status is "Done" as in fgrep; if the
process  exited  with  an error the status is "Exit N" where N is
the value of the exit code; if the process  was  killed  by  some
signal the status is the name of the signal that was used; other-
wise the process is running.  The last column is the name of  the
command that is being run.

_1_9._1_4_5.  _l_o_c_a_l-_b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _l_o_c_a_l-_b_i_n_d-_t_o-_k_e_y except that you use it to attach a
key  sequence  to  a named keymap.  The only reasonable use is to
bind some extra key to _E_S_C-_m_a_p for keyboards that make typing ESC
painful.

_1_9._1_4_6.  _l_o_c_a_l-_b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _l_o_c_a_l-_b_i_n_d-_t_o-_k_e_y except you use it to attach a  key
sequence to a named macro.

_1_9._1_4_7.  _l_o_c_a_l-_b_i_n_d-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _b_i_n_d-_t_o-_k_e_y, except that the binding is only enabled
when  the selected buffer is the buffer that was current when the
command was executed.  In other words, the binding  only  applies
to the selected buffer.

_1_9._1_4_8.  _m_a_c_i_f_y (_v_a_r_i_a_b_l_e)

(Mac version only) When this variable is on, JOVE  will  use  the
standard  Macintosh  file-selector  dialog in place of the tradi-
tional JOVE Minibuffer.

_1_9._1_4_9.  _m_a_i_l-_c_h_e_c_k-_f_r_e_q_u_e_n_c_y (_v_a_r_i_a_b_l_e)

This is how often (in seconds) JOVE should check your mailbox for
incoming  mail.  If you set this to zero JOVE won't check for new
mail.  See also the _m_o_d_e-_l_i_n_e,  _m_a_i_l_b_o_x  and  _d_i_s_a_b_l_e-_b_i_f_f  vari-
ables.  The default is 60.

_1_9._1_5_0.  _m_a_i_l_b_o_x (_v_a_r_i_a_b_l_e)

Set this to the full pathname of your mailbox.   JOVE  will  look
here  to  decide  whether  or not you have any unread mail.  This
defaults to ////uuuussssrrrr////ssssppppoooooooollll////mmmmaaaaiiiillll////$$$$UUUUSSSSEEEERRRR, where "$USER" is set  to  your
login name.




                         March 19, 1996





                   JOVE Manual for UNIX Users                  79


_1_9._1_5_1.  _m_a_k_e-_b_a_c_k_u_p-_f_i_l_e_s (_v_a_r_i_a_b_l_e)

If this variable is set, then whenever JOVE writes out a file, it
will  move the previous version of the file (if there was one) to
"#filename~".  This is often convenient if you  save  a  file  by
accident.  The default value of this variable is _o_f_f.

_1_9._1_5_2.  _m_a_k_e-_b_u_f_f_e_r-_u_n_m_o_d_i_f_i_e_d (_E_S_C ~)

This makes JOVE think the selected  buffer  hasn't  been  changed
even if it has.  Use this when you accidentally change the buffer
but don't want it considered changed.  Watch the mode line to see
the * disappear when you use this command.

_1_9._1_5_3.  _m_a_k_e-_m_a_c_r_o-_i_n_t_e_r_a_c_t_i_v_e (_E_S_C _I)

This command is meaningful only while you are defining a keyboard
macro,  and  when  you  are  expecting input in the message line.
Ordinarily, when a command  in  a  macro  definition  requires  a
trailing  text  argument  (file  name,  search string, etc.), the
argument you supply becomes part of the macro definition.  If you
want  to  be  able  to  supply a different argument each time the
macro is used, then while you are defining it,  you  should  give
the  _m_a_k_e-_m_a_c_r_o-_i_n_t_e_r_a_c_t_i_v_e  command just before typing the argu-
ment which will be used during the definition process.  Note: you
must bind this command to a key in order to use it; you can't say
"ESC X make-macro-interactive".

_1_9._1_5_4.  _m_a_r_k-_t_h_r_e_s_h_o_l_d (_v_a_r_i_a_b_l_e)

This variable contains the number of  lines  point  may  move  by
before  the  mark  is set.  If, in a search or some other command
that may move point, point moves by more than  this  many  lines,
the mark is set so that you may return easily.  The default value
of this variable is 22 (one screenful, on most  terminals).   See
also  the  commands _s_e_a_r_c_h-_f_o_r_w_a_r_d, _s_e_a_r_c_h-_r_e_v_e_r_s_e, _b_e_g_i_n_n_i_n_g-_o_f-
_f_i_l_e and _e_n_d-_o_f-_f_i_l_e.

_1_9._1_5_5.  _m_a_t_c_h-_r_e_g_u_l_a_r-_e_x_p_r_e_s_s_i_o_n_s (_v_a_r_i_a_b_l_e)

When set, JOVE will match regular expressions in search patterns.
This  makes  special  the characters ., *, [ and ].  See the JOVE
Manual for a full discussion of regular-expressions.

_1_9._1_5_6.  _m_e_t_a-_k_e_y (_v_a_r_i_a_b_l_e)

You should set this variable to _o_n if your terminal  has  a  real
Meta  key  which  forces  the 8th bit of each character.  If your
terminal has such a key, then a key sequence like  ESC Y  can  be
entered  by  holding down Meta and typing Y.  On the IBM PC, this
variable affects how ALT is interpreted.  On  the  Macintosh,  it
affects how Option is interpreted.  NOTE: In some older UNIX sys-
tems, JOVE must switch the tty to raw mode to  accept  the  8-bit
characters   generated   by   a  meta  key.   Unfortunately,  the



                         March 19, 1996





80                 JOVE Manual for UNIX Users


_i_n_t_e_r_r_u_p_t-_c_h_a_r_a_c_t_e_r does not generate an interrupt in raw mode.

_1_9._1_5_7.  _m_o_d_e-_l_i_n_e (_v_a_r_i_a_b_l_e)

The format of the mode line can be  determined  by  setting  this
variable.   The  items  in  the line are specified using a format
similar to that used by _p_r_i_n_t_f(_3), with the special things  being
marked  as  "%x".  Digits may be used between the '%' and the 'x'
to mean repeat that many times.  'x' may be:
             C    checks for new mail, and displays "[New mail]" if there is any
                  (see also the _m_a_i_l-_c_h_e_c_k-_f_r_e_q_u_e_n_c_y and _m_a_i_l_b_o_x variables)
             F    the current file name, with leading path stripped
             M    the current list of major and minor modes
             b    the selected buffer name
             c    the fill character (-)
             d    the current directory
             e    extra space in mode line is distributed evenly
                  among the places %e is used (used for justifying,
                  separating, or centering parts of the mode line)
             f    the current file name
             ixy  x, when the buffer's file has been changed behind JOVE's back,
                  y, when not
             mxy  x, when the buffer is modified or y, when not
             n    the selected buffer number
             p    interactive process status for process windows
             s    space, but only if previous character is not a space
             t    the current time (updated automatically)
             w    a '>' for windows which are scrolled left
             [ ]  the square brackets printed when in a recursive edit
             ( )  items enclosed in %( ... %) will only be printed on
                  the bottom mode line, rather than copied when the
                  window is split
In addition, any other character is simply copied into  the  mode
line.  Characters may be escaped with a backslash.  To get a feel
for all this, try typing "ESC X print mode-line" and compare  the
result with your current mode line.

_1_9._1_5_8.  _m_o_d_e-_l_i_n_e-_a_t_t_r_i_b_u_t_e (_v_a_r_i_a_b_l_e)

(IBM PC version only) This specifies the screen attribute (color)
for  characters  in  the mode line.  The default is 112 (black on
white).

_1_9._1_5_9.  _m_o_d_e-_l_i_n_e-_s_h_o_u_l_d-_s_t_a_n_d_o_u_t (_v_a_r_i_a_b_l_e)

If set, the mode line will be printed in reverse video,  if  your
terminal supports it.  The default for this variable is _o_n.

_1_9._1_6_0.  _n_a_m_e-_k_b_d-_m_a_c_r_o (_N_o_t _B_o_u_n_d)

This copies the keyboard macro and gives it a name freeing up the
keyboard macro so you can define some more.  Keyboard macros with
their own names can be bound to keys just like built in  commands
can.   See  the  _d_e_f_i_n_e-_m_a_c_r_o,  _s_o_u_r_c_e  and  _w_r_i_t_e-_m_a_c_r_o_s-_t_o-_f_i_l_e



                         March 19, 1996





                   JOVE Manual for UNIX Users                  81


commands.

_1_9._1_6_1.  _n_e_w_l_i_n_e (_R_e_t_u_r_n)

This divides the current line at point moving all the text to the
right  of  point  down  onto the newly created line.  Point moves
down to the beginning of the new line.  In Auto Indent mode,  the
new line will be indented to match the old line.

_1_9._1_6_2.  _n_e_w_l_i_n_e-_a_n_d-_b_a_c_k_u_p (^_O)

This divides the current line at point moving all the text to the
right  of point down onto the newly created line.  The difference
between this and _n_e_w_l_i_n_e is that point does not move down to  the
beginning of the new line.

_1_9._1_6_3.  _n_e_w_l_i_n_e-_a_n_d-_i_n_d_e_n_t (_L_i_n_e_f_e_e_d)

This behaves in any mode the same way as  _n_e_w_l_i_n_e  does  in  Auto
Indent mode.

_1_9._1_6_4.  _n_e_x_t-_e_r_r_o_r (^_X ^_N)

This moves to the next error in the  list  of  errors  that  were
parsed  with  _p_a_r_s_e-_e_r_r_o_r_s.   In one window the list of errors is
shown with the current one always at the top.  If the  file  that
contains  the  error  is  not already in a buffer, it is read in.
Its buffer is displayed in another window and point is positioned
in this window on the line where the error occurred.

_1_9._1_6_5.  _n_e_x_t-_l_i_n_e (^_N)

This moves point down to the corresponding position on  the  next
line (or the end of that line if it does not extend so far).

_1_9._1_6_6.  _n_e_x_t-_p_a_g_e (^_V)

This displays the next page of the selected buffer by taking  the
bottom line of the window and redrawing the window with it at the
top.  If there isn't another page in the buffer  JOVE  rings  the
bell.   If  a numeric argument of only - (with no digits) is sup-
plied, the previous page is displayed.  Otherwise, if  a  numeric
argument  is  supplied the screen is scrolled up that many lines,
exactly as in the _s_c_r_o_l_l-_u_p command; if the argument is  negative
the screen is scrolled down.

_1_9._1_6_7.  _n_e_x_t-_w_i_n_d_o_w (^_X _N)

This moves into the next window.  Windows live in a circular list
so  when  you're  in the bottom window and you try to move to the
next one you are moved to the top window.  It is an error to  use
this command with only one window.





                         March 19, 1996





82                 JOVE Manual for UNIX Users


_1_9._1_6_8.  _n_u_m_b_e_r-_l_i_n_e_s-_i_n-_w_i_n_d_o_w (_N_o_t _B_o_u_n_d)

This displays the line numbers for each line in the buffer  being
displayed.  The number isn't actually part of the text; it's just
printed before the actual buffer line is.  To turn this  off  you
run the command again; it toggles.

_1_9._1_6_9.  _o_n_e-_k_e_y-_c_o_n_f_i_r_m_a_t_i_o_n (_v_a_r_i_a_b_l_e)

If this variable is set, a single keystroke of y or n is expected
in  answer to yes/no questions.  Normally, a yes/no question must
be answered with any non-empty prefix of yes or no, followed by a
Return

_1_9._1_7_0.  _o_v_e_r-_w_r_i_t_e-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns Over Write minor  mode  on  in  the  selected  buffer.
Without  a numeric argument, the command toggles the mode; with a
zero argument, the mode is turned off; with a non-zero  argument,
the  mode  is  turned on.  When on, this mode changes the way the
self-inserting characters work.  Instead of inserting  themselves
and  pushing the rest of the line over to the right, they replace
or over-write the existing character.   Also,  DEL  replaces  the
character before point with a space instead of deleting it.  When
Over Write mode is on "OvrWt" is displayed in the mode line.

_1_9._1_7_1.  _p_a_g_e-_n_e_x_t-_w_i_n_d_o_w (_E_S_C ^_V)

This displays the next page in the next window.  It  switches  to
the  next  window, performs a _n_e_x_t-_p_a_g_e command (with any numeric
argument), and switches back to the original window.   Note  that
an argument of just "-" will thus display the previous page.

_1_9._1_7_2.  _p_a_r_e_n-_f_l_a_s_h () } ])

This command causes the characters bound to it  to  be  inserted,
and  then to partake in C mode curly brace indentation, Lisp mode
parenthesis indentation, and the  Show  Match  mode  paren/curly-
brace/square-bracket flashing.

_1_9._1_7_3.  _p_a_r_a_g_r_a_p_h-_d_e_l_i_m_i_t_e_r-_p_a_t_t_e_r_n (_v_a_r_i_a_b_l_e)

When JOVE is searching for a paragraph boundary, if this  pattern
(a  regular expression) matches the start of a line, that line is
treated as a paragraph delimiter.  The default pattern recognizes
blank  lines,  troff control lines, and lines starting with a TeX
control sequence.

There is a special provision for TeX: if a line is matched by the
pattern,  and  the match is of exactly an initial \, that line is
only treated as a delimiter if the next line also starts with \.






                         March 19, 1996





                   JOVE Manual for UNIX Users                  83


_1_9._1_7_4.  _p_a_r_e_n-_f_l_a_s_h-_d_e_l_a_y (_v_a_r_i_a_b_l_e)

How long, in tenths of a second, JOVE should pause on a  matching
parenthesis in Show Match mode.  The default is 5.

_1_9._1_7_5.  _p_a_r_s_e-_e_r_r_o_r_s (_N_o_t _B_o_u_n_d)

This takes the list of C compilation errors (or the  output  from
another  program  in an acceptable format) in the selected buffer
and parses them for use with the _n_e_x_t-_e_r_r_o_r,  _p_r_e_v_i_o_u_s-_e_r_r_o_r  and
_c_u_r_r_e_n_t-_e_r_r_o_r  commands.   This  is  a very useful tool and helps
with compiling C programs or, when used in conjunction  with  the
UNIX _g_r_e_p command, with making changes to a bunch of files.  JOVE
finds each file that has an error and remembers  each  line  that
contains  an  error.   It  doesn't  matter if later you insert or
delete  some  lines  in  the  buffers  containing  errors;   JOVE
remembers  where they are regardless.  _c_u_r_r_e_n_t-_e_r_r_o_r is automati-
cally executed after one of the parse commands, so you end up  at
the  first error.  The variable _e_r_r_o_r-_f_o_r_m_a_t-_s_t_r_i_n_g specifies, by
means of regular-expressions, the format of errors to  be  recog-
nized.   Its default value can handle messages from _c_c, _c_p_p, _l_i_n_t
and _g_r_e_p -_n.

_1_9._1_7_6.  _p_a_r_s_e-_s_p_e_l_l_i_n_g-_e_r_r_o_r_s-_i_n-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This parses a list of words in the selected buffer and looks them
up  in  another buffer that you specify.  It is invoked automati-
cally by the _s_p_e_l_l-_b_u_f_f_e_r command.

_1_9._1_7_7.  _p_a_u_s_e-_j_o_v_e (_E_S_C _S)

This stops JOVE and returns control to the  parent  shell.   This
only  works  on  systems  that have the job control facility.  To
return to JOVE you type "fg" to the shell.

_1_9._1_7_8.  _p_o_p-_m_a_r_k (_N_o_t _B_o_u_n_d)

JOVE remembers the last eight marks and you use  _p_o_p-_m_a_r_k  to  go
backward  through  the  ring  of  marks.  If you execute _p_o_p-_m_a_r_k
enough times you will eventually get back to where  you  started.
This  command  is  also  executed  when  you  run _s_e_t-_m_a_r_k with a
numeric argument.

_1_9._1_7_9.  _p_o_p_d (_N_o_t _B_o_u_n_d)

This pops one entry off the directory stack.  Entries are  pushed
with  the _p_u_s_h_d or _p_u_s_h_l_i_b_d commands.  The names were stolen from
the C-shell and the behavior is the same.

_1_9._1_8_0.  _p_r_e_v_i_o_u_s-_e_r_r_o_r (^_X ^_P)

This is the same as _n_e_x_t-_e_r_r_o_r except it  goes  to  the  previous
error.  See _n_e_x_t-_e_r_r_o_r for documentation.




                         March 19, 1996





84                 JOVE Manual for UNIX Users


_1_9._1_8_1.  _p_r_e_v_i_o_u_s-_l_i_n_e (^_P)

This moves point up to the corresponding position on the previous
line (or the end of that line if it does not extend so far).

_1_9._1_8_2.  _p_r_e_v_i_o_u_s-_p_a_g_e (_E_S_C _V)

This displays the previous page of the selected buffer by  taking
the  top line and redrawing the window with it at the bottom.  If
a numeric argument of only - (with no digits)  is  supplied,  the
next page is displayed.  Otherwise, if a numeric argument is sup-
plied the screen is scrolled down that many lines, exactly as  in
the  _s_c_r_o_l_l-_d_o_w_n  command; if the argument is negative the screen
is scrolled up.

_1_9._1_8_3.  _p_r_e_v_i_o_u_s-_w_i_n_d_o_w (^_X _P _o_r ^_X _O)

This moves into the previous window.  Windows live in a  circular
list  so when you're in the top window and you try to move to the
previous one you are moved to the bottom window.  It is an  error
to use this command with only one window.

_1_9._1_8_4.  _p_r_i_n_t (_N_o_t _B_o_u_n_d)

This displays the value of a JOVE variable in the message line.

_1_9._1_8_5.  _p_r_o_c_e_s_s-_b_i_n_d-_k_e_y_m_a_p-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _p_r_o_c_e_s_s-_b_i_n_d-_t_o-_k_e_y except that you use it to attach
a  key  sequence  to named keymap.  The only reasonable use is to
bind some extra key to _E_S_C-_m_a_p for  keyboards  that  make  typing
ESC painful.

_1_9._1_8_6.  _p_r_o_c_e_s_s-_b_i_n_d-_m_a_c_r_o-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This is like _p_r_o_c_e_s_s-_b_i_n_d-_t_o-_k_e_y except you use it  to  attach  a
key sequence to a named macro.

_1_9._1_8_7.  _p_r_o_c_e_s_s-_b_i_n_d-_t_o-_k_e_y (_N_o_t _B_o_u_n_d)

This command is identical to _b_i_n_d-_t_o-_k_e_y,  except  that  it  only
affects  your  bindings  when  you are in a buffer attached to an
interactive process.  When you enter the process buffer, any keys
bound with this command will automatically take their new values.
When you switch to a non-process buffer,  the  old  bindings  for
those keys will be restored.  For example, you might want to exe-
cute
        process-bind-to-key stop-process ^C ^Z
        process-bind-to-key interrupt-process ^C ^C
Then, when you start up an interactive process  and  switch  into
that  buffer, ^C ^Z will execute _s_t_o_p-_p_r_o_c_e_s_s and ^C ^C will exe-
cute _i_n_t_e_r_r_u_p_t-_p_r_o_c_e_s_s.  Bindings effective only in process  win-
dows  are  shown  with a "Proc:" prefix in this manual and by the
_a_p_r_o_p_o_s and _d_e_s_c_r_i_b_e-_b_i_n_d_i_n_g_s commands.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  85


_1_9._1_8_8.  _p_r_o_c_e_s_s-_d_b_x-_o_u_t_p_u_t (_N_o_t _B_o_u_n_d)

This command only makes sense in a buffer running an  interactive
shell  process.   If  you  are running _d_b_x in a window, JOVE will
automatically find the file you are  currently  stepping  through
and  display  it  in  another window whenever you type "where" or
while you're stepping through a program,  or  when  you  reach  a
breakpoint.   The  string  DBX will appear in the mode line along
with the process status when this feature is enabled.   See  also
the variable _d_b_x-_f_o_r_m_a_t-_s_t_r_i_n_g.

_1_9._1_8_9.  _p_r_o_c_e_s_s-_n_e_w_l_i_n_e (_P_r_o_c: _R_e_t_u_r_n)

This command is normally bound to Return  as  if  by  a  _p_r_o_c_e_s_s-
_b_i_n_d-_t_o-_k_e_y  so  that  it will only be bound in a process window.
JOVE does two different things depending on where  you  are  when
you  hit Return.  When you're in the last line of the interactive
process buffer, point moves to the end of the line, the  line  is
terminated,  and  the line is made available as input to the pro-
cess.  When point is positioned in some other line, that line  is
copied  to  the  end of the buffer (with the prompt stripped) and
point is moved there with it, so you  can  then  edit  that  line
before  sending it to the process.  This command must be bound to
the key you usually use to enter shell commands (Return), or else
you won't be able to enter any.  See the variable _p_r_o_c_e_s_s-_p_r_o_m_p_t.

_1_9._1_9_0.  _p_r_o_c_e_s_s-_p_r_o_m_p_t (_v_a_r_i_a_b_l_e)

What a prompt looks  like  from  the  _s_h_e_l_l  and  _i-_s_h_e_l_l-_c_o_m_m_a_n_d
processes.   The  default  is  "%  ", the default C-shell prompt.
This is actually a regular expression search string.  So you  can
set  it  to be more than one thing at once using the \| operator.
For instance, for LISP hackers, the prompt can be
        "% \|-> \|<[0-9]>: ".

_1_9._1_9_1.  _p_r_o_c_e_s_s-_s_e_n_d-_d_a_t_a-_n_o-_r_e_t_u_r_n (_N_o_t _B_o_u_n_d)

This is like _p_r_o_c_e_s_s-_n_e_w_l_i_n_e except it sends  everything  to  the
process without the newline.  Normally, when you type return in a
process buffer  it  sends  everything  you  typed  including  the
Return.   This  command  just  provides a way to send data to the
process without having to send a newline as well.

_1_9._1_9_2.  _p_u_s_h-_s_h_e_l_l (_N_o_t _B_o_u_n_d)

This spawns a child shell and relinquishes control to it.  Within
this  shell,  $1 can be used to refer to the filename (if any) of
the selected buffer.  This works on any version of UNIX, but this
isn't as good as _p_a_u_s_e-_j_o_v_e because it takes time to start up the
new shell and you get a brand new  environment  every  time.   To
return to JOVE, simply exit the shell.






                         March 19, 1996





86                 JOVE Manual for UNIX Users


_1_9._1_9_3.  _p_u_s_h_d (_N_o_t _B_o_u_n_d)

This pushes a directory onto the directory stack  and  cd's  into
it.   It asks for the directory name but if you don't specify one
it switches the top two  entries  on  the  stack.   It  purposely
behaves the same as C-shell's _p_u_s_h_d.

_1_9._1_9_4.  _p_u_s_h_l_i_b_d (_N_o_t _B_o_u_n_d)

Performs same function as _p_u_s_h_d except that it  pushes  the  Jove
sharable library directory.  This directory holds the system-wide
jjjjoooovvvveeee....rrrrcccc and the text used by the _d_e_s_c_r_i_b_e-_c_o_m_m_a_n_d  and  _d_e_s_c_r_i_b_e-
_v_a_r_i_a_b_l_e  commands.   It  is  mainly  intended  for  use with the
jjjjoooovvvveeee....rrrrcccc file.

_1_9._1_9_5.  _p_w_d (_N_o_t _B_o_u_n_d)

This prints the pathname of the working directory, as in the UNIX
_p_w_d command.

_1_9._1_9_6.  _q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g (_E_S_C _Q)

This replaces strings  matching  a  specified  regular-expression
with  a  specified  replacement  string.   When a match is found,
point is moved to it and then JOVE asks what to do.  The  options
are:
        Space or Y or y     to replace this match and go on to the next one.
        Period              to replace this match and then stop.
        DEL, BS, or N or n  to skip this match and go on to the next one.
        ^R or R or r        to enter a recursive edit.  This lets you temporarily
                            suspend the replace, do some editing, and then return
                            to continue where you left off.  To continue with the
                            _q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g, use the _e_x_i_t-_j_o_v_e command.
        ^W                  to delete the match and then enter a recursive edit.
        ^U or U or u        to undo all changes to the last modified line and
                            continue the search from the start of that line.
        ! or P or p         to go ahead and replace the remaining matches without
                            asking, as in _r_e_p_l_a_c_e-_s_t_r_i_n_g.
        Return or Q or q    to stop the _q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g.
        ^L                  to redraw the screen
It is often useful to include a piece of the  matched  string  in
the  replacement,  especially  if  the  piece  was not matched by
literal text.  To select which part of the matched string  is  to
be  used, the corresponding part of the pattern is bracketed with
\( and \).  More than one set of brackets may be used, as long as
they  are properly nested.  The matching substring is selected in
the replacement string using \ followed by a digit:  \1  for  the
first,  \2  for  the  second, and so on.  Conveniently, \0 always
stands for the complete matched string, as if the  whole  regular
expression  were  bracketed.   For example, the following command
will reverse pairs of comma-separated numbers:
        : query-replace-string \([0-9]*\),\([0-9]*\) with \2,\1
The search for a match starts at point and goes to the end of the
buffer,  so  to replace in the entire buffer you must first go to



                         March 19, 1996





                   JOVE Manual for UNIX Users                  87


the beginning.  Each subsequent search  starts  at  the  position
after  the  previous  match;  if  the previous match was an empty
string, the search is first advanced  one  character  to  prevent
unbounded repetition.

_1_9._1_9_7.  _q_u_i_t-_p_r_o_c_e_s_s (_P_r_o_c: ^_C ^\)

Send the  signal  SIGQUIT  to  the  interactive  process  in  the
selected  buffer.  This is equivalent to sending the "quit" char-
acter (which most people have bound to ^\) to the process.   This
only  works  if  you are in a buffer bound to an interactive pro-
cess.

_1_9._1_9_8.  _q_u_o_t_e_d-_i_n_s_e_r_t (^_Q _o_r ^^)

This lets you insert characters that normally would  be  executed
as other JOVE commands.  For example, to insert "^F" you type "^Q
^F" (assuming _q_u_o_t_e_d-_i_n_s_e_r_t is  bound  to  ^Q).   NUL  cannot  be
represented  in  the buffer, so _q_u_o_t_e_d-_i_n_s_e_r_t will insert "^@" in
its stead.  On the IBM PC under  DOS,  non-ASCII  keystrokes  are
seen by JOVE as a hex FF character followed by another character;
_q_u_o_t_e_d-_i_n_s_e_r_t will quote both characters.

_1_9._1_9_9.  _r_e_a_d-_o_n_l_y-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on or off the Read-only minor mode.  Without a numeric
argument, the command toggles the mode; with a zero argument, the
mode is turned off; with a non-zero argument, the mode is  turned
on.   When  a  buffer is in Read-only mode, any attempt to modify
the buffer will fail.  When a file is found,  and  it's  not  got
write permission, JOVE automatically puts the buffer in read-only
mode.  This is very helpful when you are  in  environments  which
use  source  control  programs  like  RCS  and SCCS.  It prevents
accidents like making a bunch of changes and only THEN  discover-
ing that you haven't checked the file out for making changes.

_1_9._2_0_0.  _r_e_a_d-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e (_N_o_t _B_o_u_n_d)

This reads a specified file that contains a bunch of abbreviation
definitions,  and  makes  those abbreviations available.  See the
_w_o_r_d-_a_b_b_r_e_v-_m_o_d_e command.

_1_9._2_0_1.  _r_e_c_u_r_s_i_v_e-_e_d_i_t (_N_o_t _B_o_u_n_d)

This enters a recursive editing level.  This  isn't  really  very
useful.  I don't know why it's available for public use.  I think
I'll delete it some day.

_1_9._2_0_2.  _r_e_d_r_a_w-_d_i_s_p_l_a_y (^_L)

This vertically centers the line containing point within the win-
dow.   If  that  line  is  already  in place, the screen is first
cleared and then redrawn.  If a numeric argument is supplied, the
line  is  positioned  at  that offset from the top of the window.



                         March 19, 1996





88                 JOVE Manual for UNIX Users


For example, "ESC 0 ^L" positions the line  containing  point  at
the top of the window (assuming _r_e_d_r_a_w-_d_i_s_p_l_a_y is bound to ^L).

_1_9._2_0_3.  _r_e_n_a_m_e-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This lets you rename the selected buffer.

_1_9._2_0_4.  _r_e_p_l_a_c_e-_i_n-_r_e_g_i_o_n (_N_o_t _B_o_u_n_d)

This is the same as _r_e_p_l_a_c_e-_s_t_r_i_n_g except that it  is  restricted
to occurrences between point and the mark.

_1_9._2_0_5.  _r_e_p_l_a_c_e-_s_t_r_i_n_g (_E_S_C _R)

This replaces all occurrences of a specified string with a speci-
fied  replacement string.  This is just like _q_u_e_r_y-_r_e_p_l_a_c_e-_s_t_r_i_n_g
except that it replaces without asking.

_1_9._2_0_6.  _r_i_g_h_t-_m_a_r_g_i_n (_v_a_r_i_a_b_l_e)

Where the right margin is  for  Auto  Fill  mode  and  the  _f_i_l_l-
_p_a_r_a_g_r_a_p_h and _f_i_l_l-_r_e_g_i_o_n commands.  The default is 78.

_1_9._2_0_7.  _r_i_g_h_t-_m_a_r_g_i_n-_h_e_r_e (_N_o_t _B_o_u_n_d)

This sets the _r_i_g_h_t-_m_a_r_g_i_n variable to the  current  position  of
point.   This is an easy way to say, "Make the right margin begin
here," without having to count the number of spaces over it actu-
ally is.

_1_9._2_0_8.  _s_a_v_e-_f_i_l_e (^_X ^_S _o_r ^_X _S _o_r ^_X \)

This saves the selected buffer  to  the  associated  file.   This
makes  your  changes  permanent  so you should be sure you really
want to do it.  If the buffer has  not  been  modified  _s_a_v_e-_f_i_l_e
refuses  to do the save.  If you really do want to write the file
you must use _w_r_i_t_e-_f_i_l_e.

_1_9._2_0_9.  _s_c_r_o_l_l-_a_l_l-_l_i_n_e_s (_v_a_r_i_a_b_l_e)

When this is _o_f_f, (the default) horizontal  scrolling  will  only
affect  the  line  containing  point.   When it is _o_n, horizontal
scrolling will affect the whole window.   See  also  the  _s_c_r_o_l_l-
_w_i_d_t_h variable.

_1_9._2_1_0.  _s_c_r_o_l_l-_b_a_r (_v_a_r_i_a_b_l_e)

When this is turned _o_n, a section of the mode line at the foot of
each window is left in not-reverse-video, to show the position of
the window relative to the whole of the file represented by  that
buffer (however, if the whole of the buffer is within the window,
the whole mode line remains inverted).





                         March 19, 1996





                   JOVE Manual for UNIX Users                  89


_1_9._2_1_1.  _s_c_r_o_l_l-_d_o_w_n (_E_S_C _Z)

This scrolls the screen one line down.  If  the  line  containing
point  moves  past the bottom of the window, point is moved up to
the top of the window.  If a numeric argument  is  supplied  that
many  lines  are scrolled; if the argument is negative the screen
is scrolled up instead.  See the _p_r_e_v_i_o_u_s-_p_a_g_e command.

_1_9._2_1_2.  _s_c_r_o_l_l-_l_e_f_t (_N_o_t _B_o_u_n_d)

This scrolls the text in the active window to  the  left.   If  a
numeric  argument  is  specified  then  the text is scrolled that
number of columns.  Otherwise, the text is scrolled by the number
of  columns specified by the variable _s_c_r_o_l_l-_w_i_d_t_h.  If the vari-
able _s_c_r_o_l_l-_a_l_l-_l_i_n_e_s is ON  then  _s_c_r_o_l_l-_l_e_f_t  may  actually  do
nothing  if the scrolling would cause point not to be visible.  A
negative argument scrolls right.  If the  _m_o_d_e-_l_i_n_e  variable  is
suitably  set,  an  indication  that the text is scrolled will be
given in the mode line.

_1_9._2_1_3.  _s_c_r_o_l_l-_r_i_g_h_t (_N_o_t _B_o_u_n_d)

This scrolls the text in the active window to the  right.   If  a
numeric  argument  is  specified  then  the text is scrolled that
number of columns.  Otherwise, the text is scrolled by the number
of  columns specified by the variable _s_c_r_o_l_l-_w_i_d_t_h.  If the vari-
able _s_c_r_o_l_l-_a_l_l-_l_i_n_e_s is ON then  _s_c_r_o_l_l-_r_i_g_h_t  may  actually  do
nothing  if the scrolling would cause point not to be visible.  A
negative argument scrolls left.

_1_9._2_1_4.  _s_c_r_o_l_l-_s_t_e_p (_v_a_r_i_a_b_l_e)

How many lines should be scrolled if the _p_r_e_v_i_o_u_s-_l_i_n_e  or  _n_e_x_t-
_l_i_n_e  commands move you off the top or bottom of the screen.  You
may wish to decrease this variable if you are on a slow terminal.
The default value is 0, which means to center the current line in
the window.  If the value is negative, the behavior  is  slightly
different.   If  you  move off the top of the window, and _s_c_r_o_l_l-
_s_t_e_p is, say, -5 then the new line will be displayed 5 lines from
the bottom of the window.  If you move off the bottom of the win-
dow, the new line will be positioned 5 lines from the top of  the
window.

_1_9._2_1_5.  _s_c_r_o_l_l-_u_p (^_Z)

This scrolls the screen one line  up.   If  the  line  containing
point  moves  past  the top of the window, point is moved down to
the top of the window.  If a numeric argument  is  supplied  that
many  lines  are scrolled; if the argument is negative the screen
is scrolled down instead.  See also the _n_e_x_t-_p_a_g_e command.

_1_9._2_1_6.  _s_c_r_o_l_l-_w_i_d_t_h (_v_a_r_i_a_b_l_e)

Just as a buffer may be too long to be completely displayed in  a



                         March 19, 1996





90                 JOVE Manual for UNIX Users


window,  a line may be too wide.  JOVE handles wide lines through
horizontal scrolling, displaying only  a  portion  of  the  line.
This  variable affects horizontal scrolling.  If point is outside
the displayed portion of its line, but is  within  the  specified
number  of  columns beyond either side, the line is scrolled that
much.  Otherwise, the line will be scrolled to center point.  The
default value is 10.  If the variable is 0, centering will always
be used.  See also the _s_c_r_o_l_l-_a_l_l-_l_i_n_e_s variable.

_1_9._2_1_7.  _s_e_a_r_c_h-_e_x_i_t-_c_h_a_r (_v_a_r_i_a_b_l_e)

Set this to the character you want to  use  to  exit  incremental
search.   The  default  is Newline, which makes _i-_s_e_a_r_c_h commands
compatible with normal string search.

_1_9._2_1_8.  _s_e_a_r_c_h-_f_o_r_w_a_r_d (^_S _o_r ^\)

This searches forward for a specified search string and positions
point  at  the end of the string if it's found.  If the string is
not found point remains unchanged.  This searches from  point  to
the  end  of  the  buffer,  so  any  matches before point will be
missed.  If point is  moved  by  more  than  the  variable  _m_a_r_k-
_t_h_r_e_s_h_o_l_d, the old point will be pushed.

_1_9._2_1_9.  _s_e_a_r_c_h-_f_o_r_w_a_r_d-_n_d (_N_o_t _B_o_u_n_d)

This is just like _s_e_a_r_c_h-_f_o_r_w_a_r_d except that it doesn't assume  a
default  search  string,  and  it  doesn't set the default search
string.  This is useful for defining macros,  when  you  want  to
search for something, but you don't want it to affect the current
default search string.

_1_9._2_2_0.  _s_e_a_r_c_h-_r_e_v_e_r_s_e (^_R)

This searches backward for a specified search  string  and  posi-
tions point at the beginning if the string if it's found.  If the
string is not found point remains unchanged.  This searches  from
point  to the beginning of the buffer, so any matches after point
will be missed.  If point is moved  by  more  than  the  variable
_m_a_r_k-_t_h_r_e_s_h_o_l_d, the old point will be pushed.

_1_9._2_2_1.  _s_e_a_r_c_h-_r_e_v_e_r_s_e-_n_d (_N_o_t _B_o_u_n_d)

This is just like _s_e_a_r_c_h-_r_e_v_e_r_s_e except that it doesn't assume  a
default  search  string,  and  it  doesn't set the default search
string.  This is useful for defining macros,  when  you  want  to
search for something, but you don't want it to affect the current
default search string.

_1_9._2_2_2.  _s_e_l_e_c_t-_b_u_f_f_e_r (^_X _B)

This selects a new or  already  existing  buffer  making  it  the
current  one.  You can type either the buffer name or number.  If
you type in the name you need only type  the  name  until  it  is



                         March 19, 1996





                   JOVE Manual for UNIX Users                  91


unambiguous,  at which point typing Tab or Space will complete it
for you.  If you want to create a new buffer you can type  Return
instead of Space, and a new empty buffer will be created.

_1_9._2_2_3.  _s_e_l_e_c_t-_b_u_f_f_e_r-_1 (_N_o_t _B_o_u_n_d)

This selects buffer number 1, if it exists.

_1_9._2_2_4.  _s_e_l_e_c_t-_b_u_f_f_e_r-_1_0 (_N_o_t _B_o_u_n_d)

This selects buffer number 10, if it exists.

_1_9._2_2_5.  _s_e_l_e_c_t-_b_u_f_f_e_r-_2 (_N_o_t _B_o_u_n_d)

This selects buffer number 2, if it exists.

_1_9._2_2_6.  _s_e_l_e_c_t-_b_u_f_f_e_r-_3 (_N_o_t _B_o_u_n_d)

This selects buffer number 3, if it exists.

_1_9._2_2_7.  _s_e_l_e_c_t-_b_u_f_f_e_r-_4 (_N_o_t _B_o_u_n_d)

This selects buffer number 4, if it exists.

_1_9._2_2_8.  _s_e_l_e_c_t-_b_u_f_f_e_r-_5 (_N_o_t _B_o_u_n_d)

This selects buffer number 5, if it exists.

_1_9._2_2_9.  _s_e_l_e_c_t-_b_u_f_f_e_r-_6 (_N_o_t _B_o_u_n_d)

This selects buffer number 6, if it exists.

_1_9._2_3_0.  _s_e_l_e_c_t-_b_u_f_f_e_r-_7 (_N_o_t _B_o_u_n_d)

This selects buffer number 7, if it exists.

_1_9._2_3_1.  _s_e_l_e_c_t-_b_u_f_f_e_r-_8 (_N_o_t _B_o_u_n_d)

This selects buffer number 8, if it exists.

_1_9._2_3_2.  _s_e_l_e_c_t-_b_u_f_f_e_r-_9 (_N_o_t _B_o_u_n_d)

This selects buffer number 9, if it exists.

_1_9._2_3_3.  _s_e_l_f-_i_n_s_e_r_t (_M_o_s_t _P_r_i_n_t_i_n_g _C_h_a_r_a_c_t_e_r_s)

This inserts the character that invoked it  into  the  buffer  at
point.   Initially  all  but a few of the printing characters are
bound to _s_e_l_f-_i_n_s_e_r_t.  See also _p_a_r_e_n-_f_l_a_s_h.

_1_9._2_3_4.  _s_e_n_d-_t_y_p_e_o_u_t-_t_o-_b_u_f_f_e_r (_v_a_r_i_a_b_l_e)

When this is _o_n JOVE will send output  that  normally  overwrites
the  screen  (temporarily)  to  a  buffer  instead.  This affects



                         March 19, 1996





92                 JOVE Manual for UNIX Users


commands like _l_i_s_t-_b_u_f_f_e_r_s,  _l_i_s_t-_p_r_o_c_e_s_s_e_s,  _s_h_e_l_l-_c_o_m_m_a_n_d-_w_i_t_h-
_t_y_p_e_o_u_t,  and commands that use completion.  The default value is
_o_f_f.

_1_9._2_3_5.  _s_e_t (_N_o_t _B_o_u_n_d)

This sets a specified variable to a new value.

_1_9._2_3_6.  _s_e_t-_m_a_r_k (^@)

This sets the mark at the current position  in  the  buffer.   It
prints the message "[Point pushed]" on the message line.  It says
that instead of "[Mark set]" because when you set  the  mark  the
previous  mark  is still remembered on a ring of eight marks.  So
"[Point pushed]" means point is pushed onto the ring of marks and
becomes  the  value  of  "the  mark".   To go through the ring of
marks, use the _p_o_p-_m_a_r_k command.  If you type this  enough  times
you will get back to where you started.  If a _s_e_t-_m_a_r_k command is
given a numeric argument, it acts like a _p_o_p-_m_a_r_k command.

_1_9._2_3_7.  _s_h_e_l_l (_v_a_r_i_a_b_l_e)

The shell to be used with all the shell-* commands  command.   If
your SHELL environment variable is set, it is used as the default
value of _s_h_e_l_l; otherwise "/bin/csh" is the  default.   See  also
the  description of the _s_h_e_l_l-_f_l_a_g_s variable to see how to change
the flags passed to this shell.

_1_9._2_3_8.  _s_h_e_l_l (_N_o_t _B_o_u_n_d)

This starts up an interactive shell in  a  window;  if  there  is
already  an interactive shell, it just selects that buffer.  JOVE
uses "*shell-n*" (where nnnn is the argument of the command) as  the
name  of  the  buffer in which the interacting takes place.  Thus
different argument values refer to different interactive  shells.
See  the  JOVE  manual  for information on how to use interactive
processes.  See also the variable _w_r_a_p-_p_r_o_c_e_s_s-_l_i_n_e_s.

_1_9._2_3_9.  _s_h_e_l_l-_c_o_m_m_a_n_d (^_X !)

This runs a UNIX command and places the output from that  command
in a buffer.  Within the command, $1 can be used to refer the the
filename (if any) of the selected buffer.  JOVE creates a  buffer
that  matches  the  name  of  the  command  you  specify and then
attaches that buffer to a window.  So, when  you  have  only  one
window  running, this command will cause JOVE to split the window
and attach the new buffer to that window.  Otherwise, JOVE  finds
the  most  convenient  of the available windows and uses that one
instead.  If the  buffer  already  exists  it  is  first  emptied
(unless  a numeric argument is specified).  If it's already hold-
ing a file, not some output from a previous  command,  JOVE  asks
permission  before  emptying  the  buffer.  Beware that if you go
ahead, not only do you lose any unsaved changes that you made  to
the  buffer,  but  the  buffer's file name remains set, making it



                         March 19, 1996





                   JOVE Manual for UNIX Users                  93


easy to later accidentally overwrite the original file.  See also
the variable _w_r_a_p-_p_r_o_c_e_s_s-_l_i_n_e_s.

_1_9._2_4_0.  _s_h_e_l_l-_c_o_m_m_a_n_d-_n_o-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This is just like _s_h_e_l_l-_c_o_m_m_a_n_d except it just runs  the  command
without saving the output to any buffer.  It will report the suc-
cess of the command in the usual way.

_1_9._2_4_1.  _s_h_e_l_l-_c_o_m_m_a_n_d-_t_o-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This is just like _s_h_e_l_l-_c_o_m_m_a_n_d except it lets  you  specify  the
buffer to use.

_1_9._2_4_2.  _s_h_e_l_l-_c_o_m_m_a_n_d-_w_i_t_h-_t_y_p_e_o_u_t (_N_o_t _B_o_u_n_d)

This is just like _s_h_e_l_l-_c_o_m_m_a_n_d except that instead of saving the
output  to  a  buffer,  and  displaying it in a window, this just
types out the output in the  same  way  that  _l_i_s_t-_b_u_f_f_e_r_s  does.
Actually,  how  this behaves depends on the value of the variable
_s_e_n_d-_t_y_p_e_o_u_t-_t_o-_b_u_f_f_e_r.  If it  is  _o_n  then  _s_h_e_l_l-_c_o_m_m_a_n_d-_w_i_t_h-
_t_y_p_e_o_u_t  will behave just like _s_h_e_l_l-_c_o_m_m_a_n_d.  If a numeric argu-
ment is given, the "completed successfully" message at the end is
suppressed.

_1_9._2_4_3.  _s_h_e_l_l-_f_l_a_g_s (_v_a_r_i_a_b_l_e)

This specifies a flag argument that directs the shell to take the
next  argument  as a command to be executed.  The default is "-c"
(suitable for all known UNIX shells).  Under MSDOS,  the  default
is  "/c"  (suitable  for  command.com  and similar MSDOS shells).
Other MSDOS shells, such as MKS KSH require that this be  changed
to  "-c".  Under MSDOS, JOVE puts quotes around the command argu-
ment if _s_h_e_l_l-_f_l_a_g_s starts with "-".  See the _s_h_e_l_l  variable  to
change the default shell.

_1_9._2_4_4.  _s_h_i_f_t-_r_e_g_i_o_n-_l_e_f_t (_N_o_t _B_o_u_n_d)

This shifts the region left by _c-_i_n_d_e_n_t_a_t_i_o_n-_i_n_c_r_e_m_e_n_t OR by  the
numeric  argument, if one is supplied.  If a negative argument is
supplied the region is shifted the other way.

_1_9._2_4_5.  _s_h_i_f_t-_r_e_g_i_o_n-_r_i_g_h_t (_N_o_t _B_o_u_n_d)

This shifts the region right by _c-_i_n_d_e_n_t_a_t_i_o_n-_i_n_c_r_e_m_e_n_t OR by the
numeric  argument, if one is supplied.  If a negative argument is
supplied the region is shifted the other way.

_1_9._2_4_6.  _s_h_o_w-_m_a_t_c_h-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on or off the Show Match minor mode  in  the  selected
buffer.   Without  a  numeric  argument,  the command toggles the
mode; with a zero argument, the mode is turned off; with  a  non-
zero argument, the mode is turned on.  This mode changes "}", ")"



                         March 19, 1996





94                 JOVE Manual for UNIX Users


and "]" so that when they are typed they are inserted  as  usual,
and  then the cursor flashes back to the matching "{", "(" or "["
(depending on what was typed) for about half a second,  and  then
goes back to just after the "}", ")" or "]" that invoked the com-
mand.  This is useful for typing in complicated expressions in  a
program.  You can change how long the cursor sits on the matching
parenthesis by setting the _p_a_r_e_n-_f_l_a_s_h-_d_e_l_a_y variable  in  tenths
of  a second.  If the matching "{", "(" or "[" isn't visible, the
line containing the match is displayed on the message line.

_1_9._2_4_7.  _s_h_r_i_n_k-_w_i_n_d_o_w (_N_o_t _B_o_u_n_d)

This makes the active window one line shorter, if possible.  Win-
dows  must  be  at  least  2 lines high, one for the text and the
other for the mode line.  See also _g_r_o_w-_w_i_n_d_o_w.

_1_9._2_4_8.  _s_o_u_r_c_e (_N_o_t _B_o_u_n_d)

This reads a bunch of JOVE commands from a file.   If  a  numeric
argument  is  supplied  to the _s_o_u_r_c_e command, it will quietly do
nothing if it cannot read the file.

The format of the file is the same as that in the  jjjjoooovvvveeee....rrrrcccc  file,
or  your private ....jjjjoooovvvveeeerrrrcccc in your home directory.  There should be
one command per line and it should be as though you were respond-
ing to an _e_x_e_c_u_t_e-_n_a_m_e_d-_c_o_m_m_a_n_d command while in JOVE.  A command
can be optionally preceded by a numeric argument.  Lines commenc-
ing with a # are treated as comments.  Control characters such as
^R may be represented as themselves, or as "^" followed  by  "R".
ESC should be represented by ^[.

Sometimes it is useful to do different things in  different  cir-
cumstances.   To  make  this  possible, there are two conditional
commands:  _i_f and _i_f_e_n_v.  The _i_f command takes as  an  operand  a
shell  command, which it runs.  If the command succeeds, the com-
mands after the _i_f, until a line containing _e_l_s_e  or  _e_n_d_i_f,  are
performed.  Otherwise, these commands are suppressed and the com-
mands after any _e_l_s_e, up until an _e_n_d_i_f,  are  executed.   Condi-
tionals  nest  in  the  normal  way.   The _i_f_e_n_v command takes as
operands the name of an environment variable and a  pattern.   If
the  environment  variable  is  defined and its value matches the
pattern, the _i_f_e_n_v succeeds.

For example, here are some lines from the file jjjjoooovvvveeee....rrrrcccc.
        bind-to-key pause-jove ^[S
        bind-to-key pause-jove ^[s
        set process-prompt ^[^%$#]*[%$#]
        # source any TERMinal-specific rc file
        1 source jove.rc.$TERM
What they do is to  provide  two  alternative  key  bindings  for
_p_a_u_s_e-_j_o_v_e,  set the variable _p_r_o_c_e_s_s-_p_r_o_m_p_t, and attempt to call
the _s_o_u_r_c_e command on the file  jjjjoooovvvveeee....rrrrcccc....$$$$TTTTEEEERRRRMMMM.   Because  of  the
numeric  argument 1, there will be no complaint if this file can-
not be found.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  95


_1_9._2_4_9.  _s_p_a_c_e-_s_e_n_t_e_n_c_e-_2 (_v_a_r_i_a_b_l_e)

If set _o_n, two spaces are left after each  sentence  by  commands
such  as  _f_i_l_l-_p_a_r_a_g_r_a_p_h;  otherwise,  one  space  is  left.  The
default is _o_n.

_1_9._2_5_0.  _s_p_e_l_l-_b_u_f_f_e_r (_N_o_t _B_o_u_n_d)

This runs the selected buffer through the UNIX _s_p_e_l_l program  and
places the output in buffer "Spell".  Then JOVE lets you edit the
list of words, expecting you to delete the ones  that  you  don't
care  about, i.e., the ones you know are spelled correctly.  Then
the _p_a_r_s_e-_s_p_e_l_l_i_n_g-_e_r_r_o_r_s-_i_n-_b_u_f_f_e_r command comes along and finds
all the misspelled words and sets things up so the error commands
_n_e_x_t-_e_r_r_o_r, _p_r_e_v_i_o_u_s-_e_r_r_o_r and _c_u_r_r_e_n_t-_e_r_r_o_r work.  See also  the
variable _e_r_r_o_r-_w_i_n_d_o_w-_s_i_z_e.

_1_9._2_5_1.  _s_p_l_i_t-_c_u_r_r_e_n_t-_w_i_n_d_o_w (^_X _2)

This splits the active window into two equal parts (providing the
resulting  windows would be big enough) and displays the selected
buffer in both windows.  Use _d_e_l_e_t_e-_o_t_h_e_r-_w_i_n_d_o_w_s to go back to 1
window  mode.   If  a numeric argument is supplied, the window is
split "evenly" that many times (when possible).

_1_9._2_5_2.  _s_t_a_r_t-_r_e_m_e_m_b_e_r_i_n_g (_N_o_t _B_o_u_n_d)

This is just another name for the _b_e_g_i_n-_k_b_d-_m_a_c_r_o command.  It is
included for backward compatibility.

_1_9._2_5_3.  _s_t_o_p-_p_r_o_c_e_s_s (_N_o_t _B_o_u_n_d)

Send the  signal  SIGTSTP  to  the  interactive  process  in  the
selected  buffer.  This is equivalent to sending the "stop" char-
acter (which most people have bound to ^Z) to the process.   This
only  works  if  you are in a buffer bound to an interactive pro-
cess.

_1_9._2_5_4.  _s_t_o_p-_r_e_m_e_m_b_e_r_i_n_g (_N_o_t _B_o_u_n_d)

This is just another name for the _e_n_d-_k_b_d-_m_a_c_r_o command.   It  is
included for backward compatibility.

_1_9._2_5_5.  _s_t_r_i_n_g-_l_e_n_g_t_h (_N_o_t _B_o_u_n_d)

This prints the number of characters in  the  string  that  point
sits  in.   Strings  are surrounded by double quotes.  JOVE knows
that "\007" is considered a single character,  namely  "^G",  and
also  knows  about other common ones, like "\r" (Return) and "\n"
(Linefeed).  This is mostly useful only for C programmers.

_1_9._2_5_6.  _s_u_s_p_e_n_d-_j_o_v_e (_N_o_t _B_o_u_n_d)

This is a synonym for _p_a_u_s_e-_j_o_v_e.



                         March 19, 1996





96                 JOVE Manual for UNIX Users


_1_9._2_5_7.  _s_y_n_c-_f_r_e_q_u_e_n_c_y (_v_a_r_i_a_b_l_e)

The temporary files used by JOVE are forced  out  to  disk  every
_s_y_n_c-_f_r_e_q_u_e_n_c_y  modifications.   The  default is 50, which really
makes good sense.  Unless your system is very unstable, you prob-
ably shouldn't fool with this.

_1_9._2_5_8.  _t_a_b-_w_i_d_t_h (_v_a_r_i_a_b_l_e)

When JOVE displays a Tab character, it moves point forward to the
next  multiple  of  this  variable.   If  the  value is 0, tab is
displayed as ^I, not whitespace.  The default value is 8.

_1_9._2_5_9.  _t_a_g-_f_i_l_e (_v_a_r_i_a_b_l_e)

This is the name of the file in which JOVE  should  look  up  tag
definitions.  The default value is "./tags".

_1_9._2_6_0.  _t_e_x_t-_a_t_t_r_i_b_u_t_e (_v_a_r_i_a_b_l_e)

(IBM PC version only) This specifies the screen attribute (color)
for normal text characters.  The default is 7 (white on black).

_1_9._2_6_1.  _t_e_x_t-_m_o_d_e (_N_o_t _B_o_u_n_d)

This sets the major mode to Text.  This affects what JOVE consid-
ers as characters that make up words.  For instance, Single-quote
is not part of a word in Fundamental mode, but is in Text mode.

_1_9._2_6_2.  _t_m_p-_f_i_l_e-_p_a_t_h_n_a_m_e (_v_a_r_i_a_b_l_e)

This tells JOVE where to put the tmp files, which is  where  JOVE
stores  buffers internally.  The default is in ////ttttmmmmpppp, or as set up
when your system was compiled, but if  you  want  to  store  them
somewhere  else,  you  can  set  this  variable.   If your system
crashes a lot it might be a good idea to  set  this  variable  to
somewhere  other  than  ////ttttmmmmpppp  because  the system removes all the
files in ////ttttmmmmpppp upon reboot, and  so  you  would  not  be  able  to
recover editor buffers using the _j_o_v_e -_r command.

NOTE: In order for this to work correctly you must set this vari-
able  BEFORE JOVE creates the tmp file.  You can set this in your
....jjjjoooovvvveeeerrrrcccc (the closer to the beginning the better), or as  soon  as
you start up JOVE before you read any files.

_1_9._2_6_3.  _t_r_a_n_s_p_o_s_e-_c_h_a_r_a_c_t_e_r_s (^_T)

This switches the character  before  point  with  the  one  after
point,  and  then  moves  forward  one.  This doesn't work at the
beginning of the line, and at the end of the line it switches the
two  characters  before  point.  Since point is moved forward, so
that the character that was before point is still  before  point,
you  can  use  _t_r_a_n_s_p_o_s_e-_c_h_a_r_a_c_t_e_r_s  to drag a character down the
length of a line.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  97


_1_9._2_6_4.  _t_r_a_n_s_p_o_s_e-_l_i_n_e_s (^_X ^_T)

This switches the current line with the one above  it,  and  then
moves  down  one  so  that the line that was above point is still
above point.  This, like _t_r_a_n_s_p_o_s_e-_c_h_a_r_a_c_t_e_r_s,  can  be  used  to
drag a line down a page.

_1_9._2_6_5.  _u_n_b_o_u_n_d (_N_o_t _B_o_u_n_d)

This command acts as if an unbound key sequence were  typed.   In
fact, that is its use: if you wish to unbind a key sequence, sim-
ply bind it to this command.

_1_9._2_6_6.  _u_p_d_a_t_e-_t_i_m_e-_f_r_e_q_u_e_n_c_y (_v_a_r_i_a_b_l_e)

How often the mode line is updated  (and  thus  the  time).   The
default is 30 seconds.

_1_9._2_6_7.  _u_s_e-_i/_d-_c_h_a_r (_v_a_r_i_a_b_l_e)

If your terminal has insert/delete character capability  you  can
tell JOVE not to use it by setting this to _o_f_f.  In my opinion it
is only worth using insert/delete character at  low  baud  rates.
WARNING:  if  you  set this to _o_n when your terminal doesn't have
insert/delete character capability, you will get  weird  (perhaps
fatal) results.

_1_9._2_6_8.  _v_e_r_s_i_o_n (_N_o_t _B_o_u_n_d)

Displays the version number of this JOVE.

_1_9._2_6_9.  _v_i_s_i_b_l_e-_b_e_l_l (_v_a_r_i_a_b_l_e)

If the terminal has a visible bell, use it instead of beeping.

_1_9._2_7_0.  _v_i_s_i_b_l_e-_s_p_a_c_e_s-_i_n-_w_i_n_d_o_w (_N_o_t _B_o_u_n_d)

This displays an underscore character instead of  each  Space  in
the  window  and  displays  a greater-than followed by spaces for
each Tab in the window.  The actual text in  the  buffer  is  not
changed;  only  the screen display is affected.  To turn this off
you run the command again; it toggles.

_1_9._2_7_1.  _v_i_s_i_t-_f_i_l_e (^_X ^_V _o_r ^_X ^_R)

This reads a specified file into the  selected  buffer  replacing
the old text.  If the buffer needs saving JOVE will offer to save
it for you.  Sometimes you use this to start  over,  say  if  you
make  lots  of  changes and then change your mind.  If that's the
case you don't want JOVE to save your buffer and you answer  "NO"
to the question.






                         March 19, 1996





98                 JOVE Manual for UNIX Users


_1_9._2_7_2.  _w_i_n_d_o_w-_f_i_n_d (^_X _4)

This lets you select another buffer in another window three  dif-
ferent  ways.   This waits for another character which can be one
of the following:
        T    Finds a tag in the other window.
        ^T   Finds the tag at point in the other window
        F    Finds a file in the other window.
        B    Selects a buffer in the other window.
This is just a convenient short hand for _s_p_l_i_t-_c_u_r_r_e_n_t-_w_i_n_d_o_w (or
_p_r_e_v_i_o_u_s-_w_i_n_d_o_w if there are already two windows) followed by the
appropriate sequence  for  invoking  each  command.   With  this,
though,  there  isn't  the extra overhead of having to redisplay.
In addition, you don't have  to  decide  whether  to  use  _s_p_l_i_t-
_c_u_r_r_e_n_t-_w_i_n_d_o_w  or  _p_r_e_v_i_o_u_s-_w_i_n_d_o_w  since  _w_i_n_d_o_w-_f_i_n_d  does the
right thing.

_1_9._2_7_3.  _w_o_r_d-_a_b_b_r_e_v-_m_o_d_e (_N_o_t _B_o_u_n_d)

This turns on or off Word  Abbrev  minor  mode  in  the  selected
buffer.   Without  a  numeric  argument,  the command toggles the
mode; with a zero argument, the mode is turned off; with  a  non-
zero  argument, the mode is turned on.  Word Abbrev mode lets you
specify a word (an abbreviation) and a  phrase  with  which  JOVE
should  substitute  the abbreviation.  You can use this to define
words to expand into long phrases, e.g., "jove" can  expand  into
"Jonathan's Own Version of Emacs"; another common use is defining
words that you often misspell in the same way, e.g.,  "thier"  =>
"their"  or  "teh"  =>  "the".   See the information on the _a_u_t_o-
_c_a_s_e-_a_b_b_r_e_v variable.

There are two kinds of abbreviations: mode specific  and  global.
If  you  define  a  Mode specific abbreviation in C mode, it will
expand only in buffers that are in C mode.  This is  so  you  can
have  the  same abbreviation expand to different things depending
on your context.  Global abbreviations expand regardless  of  the
major  mode  of the buffer.  The way it works is this: JOVE looks
first in the mode specific table, and then in the  global  table.
Whichever  it  finds  it  in  first is the one that's used in the
expansion.  If it doesn't find the word  it  is  left  untouched.
JOVE  tries to expand words when you type a punctuation character
or Space or Return.  If you are in Auto Fill mode  the  expansion
will be filled as if you typed it yourself.

_1_9._2_7_4.  _w_r_a_p-_p_r_o_c_e_s_s-_l_i_n_e_s (_v_a_r_i_a_b_l_e)

If this variable is _o_n, the process output that is captured in  a
buffer is wrapped just before the line would have as many charac-
ters as there are columns on the screen.  This  introduces  extra
newlines,  but  it makes the output more readable.  Note that the
folding does not take into account that some characters  (notably
tabs)  occupy more than one column of the display.  The output of
the _f_i_l_t_e_r-_r_e_g_i_o_n command is not processed in  this  way  because
the extra newlines are presumed to be undesired in this case.



                         March 19, 1996





                   JOVE Manual for UNIX Users                  99


_1_9._2_7_5.  _w_r_a_p-_s_e_a_r_c_h (_v_a_r_i_a_b_l_e)

If set, searches will  "wrap  around"  the  ends  of  the  buffer
instead of stopping at the bottom or top.  The default is _o_f_f.

_1_9._2_7_6.  _w_r_i_t_e-_f_i_l_e (^_X ^_W)

This saves the selected buffer to  a  specified  file,  and  then
makes  that  file  the default file name for this buffer.  If you
specify a file that already  exists  you  are  asked  to  confirm
over-writing it.

_1_9._2_7_7.  _w_r_i_t_e-_f_i_l_e_s-_o_n-_m_a_k_e (_v_a_r_i_a_b_l_e)

When set, all modified files will be written out  before  calling
make when the _c_o_m_p_i_l_e-_i_t command is executed.  The default is _o_n.

_1_9._2_7_8.  _w_r_i_t_e-_m_a_c_r_o_s-_t_o-_f_i_l_e (_N_o_t _B_o_u_n_d)

This writes the currently defined macros to a specified file in a
format  appropriate for reading them back in with the _s_o_u_r_c_e com-
mand.  The purpose of this command is to allow you to define mac-
ros  once  and use them in other instances of JOVE.  See also the
_d_e_f_i_n_e-_m_a_c_r_o command.

_1_9._2_7_9.  _w_r_i_t_e-_m_o_d_i_f_i_e_d-_f_i_l_e_s (^_X ^_M)

This saves all the buffers that need saving.   If  you  supply  a
numeric  argument  it  asks,  for each buffer, whether you really
want to save it.

_1_9._2_8_0.  _w_r_i_t_e-_r_e_g_i_o_n (_N_o_t _B_o_u_n_d)

This writes the text in the region to a specified file.   If  the
file already exists you are asked to confirm over-writing it.

_1_9._2_8_1.  _w_r_i_t_e-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e (_N_o_t _B_o_u_n_d)

This writes the currently defined abbreviations  to  a  specified
file.   They  can  be read back in and automatically defined with
_r_e_a_d-_w_o_r_d-_a_b_b_r_e_v-_f_i_l_e.

_1_9._2_8_2.  _x_j-_m_o_u_s_e-_c_o_m_m_a_n_d_s (^_X _m*)

Programs such as XJove and JoveTool generate these commands when-
ever a mouse button is pressed or released, or the mouse is moved
while the button is pressed.  They  are  followed  by  parameters
giving  parameters for the button pressed, the coordinates of the
mouse, etc.  They are not intended for direct use by  the  normal
user.

The individual commands will now be described.





                         March 19, 1996





100                JOVE Manual for UNIX Users


_1_9._2_8_3.  _x_j-_m_o_u_s_e-_c_o_p_y-_c_u_t (^_X _m_8)

Performs a _c_o_p_y-_r_e_g_i_o_n if the CTRL key was down, or a _k_i_l_l-_r_e_g_i_o_n
if both CTRL and SHIFT were down.  This command is normally bound
to the release of button 2.

_1_9._2_8_4.  _x_j-_m_o_u_s_e-_l_i_n_e (^_X _m_7)

Sets the region to be the whole line containing the cursor.  This
command is normally bound to a triple down click of button 2, and
the presumed effects of the  preceding  double  click  are  first
undone.

_1_9._2_8_5.  _x_j-_m_o_u_s_e-_m_a_r_k (^_X _m_5)

Both point and mark are set to the cursor.  This command is  nor-
mally bound to the pressing of button 2.

_1_9._2_8_6.  _x_j-_m_o_u_s_e-_p_o_i_n_t (^_X _m[_0_1_2_4_9])

Point is set to the cursor.  This command is  normally  bound  to
the  single,  double,  and  triple down-click and the dragging of
button 1; also the dragging of button 2.

_1_9._2_8_7.  _x_j-_m_o_u_s_e-_w_o_r_d (^_X _m_6)

Sets the region to be the word (or the  gap  between  two  words)
containing  the cursor.  This command is normally bound to a dou-
ble down click of button 2,  and  the  presumed  effects  of  the
preceding single click are first undone.

_1_9._2_8_8.  _x_j-_m_o_u_s_e-_y_a_n_k (^_X _m_3)

Performs a _y_a_n_k if the CTRL key was down.  This command  is  nor-
mally bound to the release of button 1.

_1_9._2_8_9.  _x_t-_m_o_u_s_e (_v_a_r_i_a_b_l_e)

When set, JOVE sends XTerm escape sequences to enable and disable
the mouse messages at appropriate times.  Warning: due to the way
XTerm encodes mouse events, if _m_e_t_a-_k_e_y  is  set,  mouse  actions
beyond  column  95  or row 95 will be misunderstood; in any case,
mouse actions beyond column 223 or row 223 will be misunderstood.

_1_9._2_9_0.  _x_t-_m_o_u_s_e-_c_o_m_m_a_n_d_s (_E_S_C [ _M*)

Programs such as XTerm generate these commands whenever  a  mouse
button  is  pressed or released.  XTerm does not give the user as
much power as XJove.  They are followed by parameters  specifying
the  button pressed, the coordinates of the mouse, etc.  They are
not intended for direct use by the normal user.  Set the variable
_x_t-_m_o_u_s_e on to enable XTerm mouse mode.

The individual commands will now be described.



                         March 19, 1996





                   JOVE Manual for UNIX Users                 101


_1_9._2_9_1.  _x_t-_m_o_u_s_e-_m_a_r_k (^_X _m_5)

Both point and mark are set to the cursor.  This command is  nor-
mally bound to the pressing of button 2.

_1_9._2_9_2.  _x_t-_m_o_u_s_e-_p_o_i_n_t (^_X _m[_0_1_2_4_9])

Point is set to the cursor.  This command is  normally  bound  to
the down-click of button 1.

_1_9._2_9_3.  _x_t-_m_o_u_s_e-_u_p (^_X _m_6)

As the name implies,  this  command  is  normally  bound  to  the
release  of  any  button (XTerm does not specify which button was
released).  Note that a normally configured XTerm will  not  pass
on  mouse events if the CTRL or SHIFT keys are pressed.  Point is
set to the cursor.  If the most recently pressed button was  but-
ton  1  and  the  CTRL key was down (and not the SHIFT key), this
command performs a _y_a_n_k.  If the most recently pressed button was
button  2  and  the  CTRL  key  was down, this command performs a
_c_o_p_y-_r_e_g_i_o_n.  If the most recently pressed button  was  button  2
and  the  CTRL  and SHIFT keys were down, this command performs a
_k_i_l_l-_r_e_g_i_o_n.

_1_9._2_9_4.  _y_a_n_k (^_Y)

This inserts the text at the front of the kill ring (as set by an
earlier  _c_o_p_y-_r_e_g_i_o_n,  _k_i_l_l-_r_e_g_i_o_n,  etc.) at point.  When you do
multiple kill commands in a row, they are merged so that the _y_a_n_k
command yanks back all of them.

_1_9._2_9_5.  _y_a_n_k-_p_o_p (_E_S_C _Y)

JOVE has a kill ring on which the last sixteen kills are  stored.
This  command yanks back previous texts from the kill ring.  _y_a_n_k
yanks a copy of the text at the front of the ring.  If  you  want
one of the last sixteen kills you then use _y_a_n_k-_p_o_p which rotates
the ring so another different entry is now at the front.  You can
use  _y_a_n_k-_p_o_p  only immediately following a _y_a_n_k or another _y_a_n_k-
_p_o_p.  If you supply a  negative  numeric  argument  the  ring  is
rotated the other way.  If you use this command enough times in a
row you will eventually get back to where you started.















                         March 19, 1996


