/*
 * This file is part of the M-Edit program (Copyright 1996 by Vincenzo Morello)
 * Permission to use is hereby granted for any purpose.
 */

#if !defined UNIX
	#include <sys\stat.h>
	#ifdef _MSC_VER
		#include <stdlib.h>
		#define MAXPATHLEN	_MAX_PATH
		#define MAXFNAMELEN	_MAX_FNAME
	#else
		#include <dir.h>
		#include <values.h>
		#ifdef __GO32__
			#define MAXPATHLEN	260
			#define MAXFNAMELEN	64
		#else
			#define MAXPATHLEN	MAXPATH
			#define MAXFNAMELEN	(MAXFILE+MAXEXT)
		#endif
	#endif
	#define EXT		"*.*"
#else
	#include <sys/stat.h>
	#define MAXPATHLEN	128
	#define MAXFNAMELEN	64
	#define EXT		"*"
#endif

#define MEDIT_TITLE	"MEdit 1.5.1"
#define MEDIT_COPY	"Copyright (C) 1996 V. Morello"
#define MAX_N_WINDOW	8
#define UNDO_DEPTH	10

typedef struct _undo_data {
	char	*oldtext;
	char	*newtext;
	int	start;
	int	oldlen;
	int	newlen;
	struct _undo_data *next;
	struct _undo_data *prev;
} UNDO_DATA;

typedef struct {
	char		filename[MAXFNAMELEN];
	char		pathname[MAXPATHLEN];
	char		*search_text;
	char		*replace_text;
	MOBJECT		curs_x_label;
	MOBJECT		curs_y_label;
	MOBJECT		fname_label;
	MOBJECT		modified_label;
	MOBJECT		edit;
	MOBJECT		menu;
	MOBJECT		options_pd;
	UNDO_DATA	*first_undo;
	UNDO_DATA	*curr_undo;
	PULLDOWN_ITEM	selected_font;
	PULLDOWN_ITEM	auto_indent;
	int		undo_level;
	int		read_only;
	unsigned char	modified;
	unsigned char	ignore_case;
} FILE_DATA;

typedef struct {
	unsigned char font;
	unsigned char bg_r;
	unsigned char bg_g;
	unsigned char bg_b;
	unsigned char fg_r;
	unsigned char fg_g;
	unsigned char fg_b;
} OBJECT_PREFS;

typedef struct {
	OBJECT_PREFS menu;
	OBJECT_PREFS sbar;
	OBJECT_PREFS edit;
	unsigned char auto_indent;
	unsigned char initial_width;
	unsigned char initial_height;
	unsigned char tab_size;
} PREFERENCES;
