$	on error then goto trouble
$	on severe_error then goto trouble
$!
$! Command procedure to build MG on VMS systems.  To use it, issue the
$! command
$!	@[SYS.VMS]MAKE
$!
$! while in the top-level MG directory.
$!
$!* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
$!
$! Define a search path for include files.
$!
$	define c$include [],[.sys.vms],[.sys.default]
$!
$! Define alias for the compilation command.  Use a command file that
$! checks revision dates and only compiles when it has to.
$!
$	ccom := @[.sys.vms]ccom
$!
$! Select compilation options:
$!
$!	PREFIXREGION	-- use a silly hack that I (mpk) like
$!	XKEYS		-- look for a terminal-specific startup file
$!	NO_BACKUP	-- do not include code for making backup files
$!	NO_DIRED	-- DIRED hasn't been implemented yet
$!	REGEX		-- Include the regular expression code
$!
$!	See MGPROG.DOC in the main directory for more info.
$!
$	ccomflags =  "/DEFINE=(""PREFIXREGION"",""DO_METAKEY"",""XKEYS""" + -
	",""NO_BACKUP"",""NO_DIRED"",""REGEX"")"
$!
$! If REGEX is #defined, link in these two object modules.
$!
$	if f$locate("REGEX",ccomflags) .ne. f$length(ccomflags) then -
		regexobj = "[]re_search.obj,[]regex.obj,"
$!
$! Compile the system-independent files
$!
$ ccom basic.c		'ccomflags
$ ccom dir.c		'ccomflags
$ ccom dired.c		'ccomflags
$ ccom file.c		'ccomflags
$ ccom line.c		'ccomflags
$ ccom match.c		'ccomflags
$ ccom paragraph.c	'ccomflags
$ ccom random.c		'ccomflags
$ ccom region.c		'ccomflags
$ ccom search.c		'ccomflags
$ ccom version.c	'ccomflags
$ ccom window.c		'ccomflags
$ ccom word.c		'ccomflags
$ ccom buffer.c		'ccomflags
$ ccom display.c	'ccomflags
$ ccom echo.c		'ccomflags
$ ccom extend.c		'ccomflags
$ ccom help.c		'ccomflags
$ ccom kbd.c		'ccomflags
$ ccom keymap.c		'ccomflags
$ ccom macro.c		'ccomflags
$ ccom main.c		'ccomflags
$ ccom modes.c		'ccomflags
$ ccom regex.c		'ccomflags
$ ccom re_search.c	'ccomflags
$!
$! Use the termcap terminal driver and default ASCII character set info
$!
$ ccom [.sys.default]cinfo.c		'ccomflags
$ ccom [.sys.default]tty.c		'ccomflags
$ ccom [.sys.default]ttykbd.c		'ccomflags
$!
$! Make the termcap library
$!
$ ccom [.termlib]fgetlr
$ ccom [.termlib]tgetent
$ ccom [.termlib]tgetflag
$ ccom [.termlib]tgetnum
$ ccom [.termlib]tgetstr
$ ccom [.termlib]tgoto
$ ccom [.termlib]tputs
$!
$ library/create/object termcap.olb fgetlr.obj,tgetent.obj,-
tgetflag.obj,tgetnum.obj,tgetstr.obj,tgoto.obj,tputs.obj
$ purge/keep=2 termcap.olb
$!
$! VMS-specific files
$!
$ ccom [.sys.vms]fileio.c		'ccomflags
$ ccom [.sys.vms]spawn.c		'ccomflags
$ ccom [.sys.vms]ttyio.c		'ccomflags
$ ccom [.sys.vms]trnlnm.c		'ccomflags
$ ccom [.sys.vms]fparse.c		'ccomflags
$!
$! VAX Macro sources
$!
$	macro [.sys.vms]unixfns.mar
$!
$! Link it all together
$!
$	link /exe=mg  [.sys.vms]mg.opt/opt, 'regexobj' []termcap.olb/lib
$	exit
$!
$! Trouble!
$!
$trouble:
$	write sys$output "%MAKEIT-F-TROUBLE, trouble building MG"
$	exit
