void pascal
/* XTAG:setCPos */
setCPos(row, col)
	int row, col;
{
	rin.h.ah = 2;	/* set cursor position */
	rin.h.bh = 0;	/* page number */
	rin.h.dh = (char)row;
	rin.h.dl = (char)col;
	int86(0x10, &rin, &rout);
}
 
void pascal
/* XTAG:getCPos */
getCPos(row, col)
	int *row, *col;
{
	rin.h.ah = 3;	/* read cursor position */
	rin.h.bh = 0;	/* page number */
	int86(0x10, &rin, &rout);
	*row = (int)rout.h.dh;
	*col = (int)rout.h.dl;
}

void pascal
/* XTAG:putCharToScreen */
putCharToScreen(ch, attribute, row, col)
	char ch;
	int ch, attribute, row, col;
{
	/* first move the cursor to the correct position */
	rin.h.ah = 2;	/* set cursor position */
	rin.h.bh = 0;	/* page number -- seems to be necessary */
	rin.h.dh = (char)row;
	rin.h.dl = (char)col;
	int86(0x10, &rin, &rout);
	/* now write it */
	rin.h.ah = 9;	/* code for write character to screen */
	rin.h.al = ch;
	rin.h.bl = attribute;
	rin.x.cx = dupCount;
	int86(0x10, &rin, &rout);
}

/* 0xB000 for a monochrome adapted, 0xB800 for a color or EGA adapter)
#define DisplayMemoryBase 0xB800

void pascal
/* XTAG:putCharToScreenFaster */
putCharToScreenFaster(ch, attribute, row, col)
	char ch;
	int ch, attribute, row, col;
{
	/* generate the address in the memory buffer */
	/* each row has 80 char/attribute byte pairs = 160 bytes */
	char far *fp = DisplayMemoryBase + (160 * row) + col;
	
	*fp = ch;
}
