#include "pt.h"
#include "stdlib.h"
#include "time.h"

int pascal
/* XTAG:command2 */
command2(fn, c, w)
	int fn;
	unsigned char c;
	register struct window *w;
{
	extern struct window *windowList;
	extern struct window *activeWindow;
	extern unsigned char msgBuffer[];
	extern int debug;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int copyPending, movePending;
	extern struct window *pendWindow;
	extern long pendPosition;
	extern int searchMode;
	extern int topOnFind;
	extern int scrRows, scrCols;
	extern int lastOnTopline;
	extern int menuRow, menuCol;
	extern int passEvhead;
	extern long passCp;
	extern int i43lines;
	extern int mousePresent;
#ifdef OVERLAYS
	extern int quitExecuted;
#endif
	extern time_t timeOfLastSave;
	extern struct openFile *files;

	int row1, col1, row2, col2;
	int n;
	unsigned char *fileName;
	struct window *w2;

switch( fn ) {

case FMOUSECOM1:
case FMOUSECOM2:
	if( w == NULL )
		break;
	mouseCommand(fn, w, passCp, menuRow, menuCol, passEvhead);
	break;

case FSELECT:
	if( w == NULL )
		break;
	if( select(w, passCp, menuRow, menuCol, passEvhead) )
		return 2;
	break;

case FEXTEND:
	if( w == NULL )
		break;
	if( extend(w, passCp, menuRow, menuCol, passEvhead) )
		return 2;
	break;

case FSAVEALL:
	w2 = windowList;
	while( w2 != NULL ) {
		if( files[w2->fileId].isChanged )
			saveFile(w2);
		w2 = w2->nextWindow;
	}
	timeOfLastSave = time(NULL);
	break;

case FHIDE:
	if( w == NULL )
		break;
	hideWindow(w);
	break;

case FRESIZE:
	if( w == NULL )
		break;
	if( getBox(0, 0, &row1, &col1, &row2, &col2, 0) == 2 )
		break;
	if( row1 == row2 && col1 == col2 ) {
		row2 = scrRows-1;
		col2 = scrCols-1;
	}
	if( moveWindow(w, row1, col1, row2, col2) != 0 )
		msg("Window change failed", 1);
	break;

case FREDO:
	if( w == NULL )
		break;
	redo();
	break;

case FUNDO:
	if( w == NULL )
		break;
	undo(1);
	break;

case FUNDOBACK:
	if( w == NULL )
		break;
	undo(0);
	break;

case FCURLEFT:
case FCURRIGHT:
case FCURUP:
case FCURDOWN:
case FBEGINLINE:
case FENDLINE:
case FLEFTMBUTTON:
case FRIGHTMBUTTON:
	cursor(fn, mousePresent);
	/* only move the cursor if the mouse is present */
	break;

case FLOADFILE:
	if( w == NULL )
		doNewWindow(FNEWWINDOW, 0);
	else
		loadWindow(w, fn);
	break;

case FEXECCMD:
case FEXECSHELL:
	execCmd(fn);
	break;

case FCANCEL:
	if( copyPending ) {
		copyPending = 0;
		msg("", 0);
	}
	if( movePending ) {
		movePending = 0;
		msg("", 0);
	}
	break;

case FSEARCH:
	if( w == NULL )
		break;
	if( searchMode == 3 ) {
		w2 = w;	/* start with the current window */
		/* n determines whether to ask */
		n = 0;
		while( w2 != NULL ) {
			if( searchFor(n, w2) )	/* if the string is found */
				break;	/* then drop out of the loop */
			w2 = w2->nextWindow;
			n = 2;	/* so search uses the last string entered */
		}
		while( w2 != NULL && w2 != windowList )
			/* bottom the top window until the window where */
			/* we found the string is the top window */
			doTopWindow(windowList, 2);
	} else
		searchFor(0, w);
	break;

case FREPSEARCH:
	if( w == NULL )
		break;
	if( searchMode == 3 ) {
		w2 = w;	/* start with the current window */
		while( w2 != NULL ) {
			if( searchFor(1, w2) )	/* if the string is found */
				break;	/* then drop out of the loop */
			w2 = w2->nextWindow;
		}
		while( w2 != NULL && w2 != windowList )
			/* bottom the top window until the window where */
			/* we found the string is the top window */
			doTopWindow(windowList, 2);
	} else
		searchFor(1, w);
	break;

case FREPLACE:
	if( w == NULL )
		break;
	replaceText(w);
	break;

case FASCII:
	if( selWindow == NULL )
		break;
	insAscii();
	break;

case FCHARACTER:
	if( selWindow == NULL )
		break;
	insChar(c, 1);
	break;

case FCOPY:
	if( selWindow == NULL )
		break;
	if( copyPending ) {
		copyMove(selWindow, selBegin, selEnd,
			pendWindow, pendPosition, COPY);
		copyPending = 0;
		msg("", 0);
	} else {
		msg("Duplicate mode", 4);
		copyPending = 1;
		pendWindow = selWindow;
		pendPosition = selBegin;
	}
	break;

case FMOVE:
	if( selWindow == NULL )
		break;
	if( movePending ) {
		copyMove(selWindow, selBegin, selEnd,
			pendWindow, pendPosition, MOVE);
		movePending = 0;
		msg("", 0);
	} else {
		msg("Extract mode", 4);
		movePending = 1;
		pendWindow = selWindow;
		pendPosition = selBegin;
	}
	break;

case FDELETE:
	if( selWindow == NULL )
		break;
	deleteChars(selWindow->fileId, UPDATEWINDOWS, 1);
	break;

case FDELNOSCRAP:
	if( selWindow == NULL )
		break;
	deleteChars(selWindow->fileId, UPDATEWINDOWS, 0);
	break;

case FQUITNOSAVE:
	if( quitPoint(fn, 1) ) {
#ifdef OVERLAYS
		quitExecuted = 1;
#endif
		return 1;
	}
	break;

case FQUITASK:
case FQUITSAVE:
	if( quitPoint(fn, 0) ) {
#ifdef OVERLAYS
		quitExecuted = 1;
#endif
		return 1;
	}
	break;

case FDEBUG:
	sprintf(msgBuffer, "%d", debug);
	fileName = getInput("debug=", msgBuffer, 0);
	debug = atoi(fileName);
	break;

case FINFORM:
	doInform();
	break;

case FNEWWINDOW:
	doNewWindow(fn, 0);
	break;

case FWRITEFILE:
	if( w == NULL )
		break;
	writeFile(w);
	break;

case FTOPFILE:
	if( w == NULL )
		break;
	/* remember where we came from */
	w->rowLastline = w->numTopline;
	w->posTopline = 0;
	w->numTopline = 1;
	w->indent = 0;
	redrawWindow(w);
	break;

case FBOTFILE:
	if( w == NULL )
		break;
	bottomFile(w);
	break;

case FREDRAW:
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);
	break;

case FZOOM:
	if( w == NULL )
		break;
	zoomWindow(w);
	break;

case FTOP:
	if( w == NULL )
		break;
	doTopWindow(w, 0);
	break;

case FTOPBOTTOM:
	if( w == NULL )
		break;
	doTopWindow(w, 1);
	break;

case FBOTTOM:
	if( w == NULL )
		break;
	doTopWindow(w, 2);
	break;

case FPGUP:
	if( w == NULL )
		break;
	/* set up the screen map and scroll the window */
	setMap(w->row1, w->col1, w->row2, w->col2, 1, 0x07);
	maskTop(w);
	downScroll(w, w->row2 - w->row1 - 3);
	break;

case FPGDN:
	if( w == NULL )
		break;
	/* set up the screen map and scroll the window */
	setMap(w->row1, w->col1, w->row2, w->col2, 1, 0x07);
	maskTop(w);
	upScroll(w, w->row2 - w->row1 - 3);
	break;

case FGOTO:
	if( w == NULL )
		break;
	doGoto(w, -1);
	break;

case FCLOSEWINDOW:
	if( w == NULL )
		break;
	closeWindow(w, 1, 1);
	break;

case FDONOTHING:
case 0:
	break;

default:
	msg("No action is defined for that key [Alt-h for HELP]", 1);
	break;
}
return 0;
}
