#include "pt.h"
#include "conio.h"

extern union REGS rin, rout;
extern struct SREGS segRegs;
extern unsigned char msgBuffer[];

int pascal CommandToMenuNumber( command )
	int command;
{
	int ret;

	switch( command ) {
		default:      ret = 0;  break;
		case FMENU1:  ret = 1;  break;
		case FMENU2:  ret = 2;  break;
		case FMENU3:  ret = 3;  break;
		case FMENU4:  ret = 4;  break;
		case FMENU5:  ret = 5;  break;
		case FMENU6:  ret = 6;  break;
		case FMENU7:  ret = 7;  break;
		case FMENU8:  ret = 8;  break;
		case FMENU9:  ret = 9;  break;
		case FMENU10: ret = 10; break;
		case FMENU11: ret = 11; break;
		case FMENU12: ret = 12; break;
		case FMENU13: ret = 13; break;
		case FMENU14: ret = 14; break;
		case FMENU15: ret = 15; break;
		case FMENU16: ret = 16; break;
	}
	return ret;
}

int pascal
/* XTAG:FindMenuItem */
FindMenuItem( menuNumber, menuCol )
	int menuNumber, menuCol;
{
	extern struct menuBlock far *menus[];

	int i, n, col1;

	/* figure out which command it is */
	n = menus[menuNumber]->nItems;
	col1 = 0;
	for(i = 1; i < (n-1); i++) {
		col1 += farStrlen(menus[menuNumber]->cmdName[i]);
		if( col1 > menuCol )
			break;
	}
	return menus[menuNumber]->cmdNumber[i];
}

int pascal
/* XTAG:GetTime */
GetTime()
{
	rin.h.ah = 0x2C;
	intdos(&rin, &rout);
	return (rout.h.dh * 100) + rout.h.dl;
}

int pascal
/* XTAG:farStrlen */
farStrlen(fp)
	register unsigned char far *fp;
{
	register int len;

	len = 0;
	while( *fp++ != '\0' )
		++len;
	return len;
}

unsigned char * pascal
/* XTAG:farString */
farString(fp)
	unsigned char far *fp;
{
	unsigned char *p;
	static char buffer[120];

	p = &buffer[0];
	while( (*p++ = *fp++) != '\0' )
		;
	return &buffer[0];
}

void pascal
/* XTAG:waitForEvent */
waitForEvent()
{
	extern struct event events[];

	register unsigned char *p;
	register int evhead;

	while( 1 ) {
		if( isKeystroke() ) {
			(void)getKeystroke(p);
			break;
		}
		if( isMouseEvent(0) ) {
			evhead = getMouseEvent();
			if( events[evhead].buttons != 0 )
				break;
		}
	}
}

unsigned char pascal
/* XTAG:getDefaultDrive */
getDefaultDrive()
{
	rin.h.ah = 0x19;
	intdos(&rin, &rout);
	return rout.h.al;
}

int pascal
/* XTAG:setDefaultDrive */
setDefaultDrive(driveNumber)
	int driveNumber;
{
	rin.h.ah = 0xE;
	rin.h.dl = (char)driveNumber;
	intdos(&rin, &rout);
	/* return the number of physical drives */
	return rout.h.al;
}

int pascal
/* XTAG:isKeystroke */
isKeystroke()
{
	extern int macroState;
	extern int macroIndex;
	extern int macroSize;

	if( macroState == 2 ) {
		/* are there still characters in the macro? */
		if ( macroIndex < macroSize )
			return 1;
		macroState = 0;
	}
	return kbhit();
}

unsigned char pascal
/* XTAG:getKeystroke */
getKeystroke(p)
	unsigned char *p;
{
	extern unsigned char textBuffer[];
	extern int scrRows, scrCols;
	extern int macroIndex;
	extern int macroSize;
	extern int macroState;
	extern unsigned char macroText[];
	extern int debug;

	register unsigned char ch1, ch2;

	/* are we playing back a macro? */
	if( macroState == 2 ) {
		if( macroIndex < macroSize ) {
			ch2 = macroText[macroIndex++];
			ch1 = macroText[macroIndex++];
			*p = ch2;
			return ch1;
		}
		macroState = 0;
	}
	/* else get one from the keyboard */
	rin.h.ah = 0;
	int86(0x16, &rin, &rout);
	ch1 = rout.h.al;
	ch2 = rout.h.ah;
	if( macroState == 1 ) {
		if( macroIndex < 100 ) {
			macroText[macroIndex++] = ch2;
			macroText[macroIndex++] = ch1;
		} else {
			macroState = 0;
			macroSize = macroIndex;
			msg("Macro overflow. Keystroke not recorded.", 3);
			msg("", 0);	/* erase the sticky message */
			msg("End recording keystrokes", 1);
		}
	}
	*p = ch2;
	return ch1;
}

unsigned char pascal
/* XTAG:incon */
incon()
{
	unsigned char dummy;
	
	return getKeystroke(&dummy);
}

unsigned char pascal
/* XTAG:inconkb */
inconkb()
{
	rin.h.ah = 0;
	int86(0x16, &rin, &rout);
	return (unsigned char)rout.h.al;
}

unsigned char pascal
/* XTAG:peekKeystroke */
peekKeystroke(scan)
	unsigned char *scan;
{
	extern int macroIndex;
	extern int macroSize;
	extern int macroState;
	extern int debug;
	extern unsigned char macroText[];

	/* are we playing back a macro? */
	if( macroState == 2 ) {
		if( macroIndex < macroSize ) {
			/* return the char (not the scan code) */
			/* that will be read on the next getKeystroke */
			return macroText[macroIndex+1];
		}
		/* else */
		macroState = 0;
	}
	rin.h.ah = 1;
	int86(0x16, &rin, &rout);
	*scan = (unsigned char)rout.h.ah;
	return (unsigned char)rout.h.al;
}

long pascal
/* XTAG:lseekls */
lseekls(handle, offset, method)
	int handle, method;
	long offset;
{
	long l;

	rin.h.ah = 0x42;
	rin.h.al = (char)method;
	rin.x.bx = handle;
	rin.x.cx = (unsigned)(offset>>16);
	rin.x.dx = (unsigned)offset;
	intdos(&rin, &rout) & 0x1;
	if( rout.x.cflag & 0x1 ) {
		return (long)(-rout.x.ax);
	} else {
		l = (long)(unsigned)rout.x.dx;
		l = (l<<16) + (long)(unsigned)rout.x.ax;
		return l;
	}
}

void pascal
/* XTAG:setvect */
setvect(vectorNumber, segment, offset)
	int vectorNumber, segment, offset;
{
	int saveDS;
	
	rin.h.ah = 0x25;
	rin.h.al = (char)vectorNumber;
	rin.x.dx = offset;
	saveDS = segRegs.ds;
	segRegs.ds = segment;
	intdosx(&rin, &rout, &segRegs);
	segRegs.ds = saveDS;
}

void pascal
/* XTAG:flush */
flush()
{
	unsigned char dummy;

	while( 1 ) {
		/* quit if there is no character waiting to be read */
		if( !kbhit() )
			break;
		/* quit if the character waiting to be read is not a */
		/* backspace*/
		if( peekKeystroke(&dummy) != '\b')
			break;
		incon();	/* read and ignore the backspace */
	}
}

void pascal
/* XTAG:scrollUp */
scrollUp(nLines, row1, col1, row2, col2, attr)
	int nLines, row1, col1, row2, col2, attr;
{
	rin.h.ah = 6;	/* scroll up */
	rin.h.al = (char)nLines;
	rin.h.bh = (char)attr;
	rin.h.bl = 0;
	rin.h.ch = (char)row1;
	rin.h.cl = (char)col1;
	rin.h.dh = (char)row2;
	rin.h.dl = (char)col2;
	int86(0x10, &rin, &rout);
}

int pascal
/* XTAG:allmemls */
allmemls(size, maxPara)
	unsigned int size;
	int *maxPara;
{
	rin.h.ah = 0x48;
	rin.x.bx = (int)size;
	intdos(&rin, &rout);
	if( rout.x.cflag & 1 )
		*maxPara = rout.x.bx;
	else
		*maxPara = -1;
	return rout.x.ax;
}

int pascal
/* XTAG:freemem */
freemem(para)
	int para;
{
	register int ret;
	int saveES;

	if( para == 0 )
		return 0;
	rin.h.ah = 0x49;
	saveES = segRegs.es;
	segRegs.es = para;
	intdosx(&rin, &rout, &segRegs);
	if( rout.x.cflag & 1 )
		ret = rout.x.ax;
	else
		ret = 0;
	segRegs.es = saveES;
	return ret;
}

int pascal
/* XTAG:renamels */
renamels(oldName, newName)
	unsigned char *oldName, *newName;
{
	rin.h.ah = 0x56;
	rin.x.dx = (int)oldName;
	rin.x.di = (int)newName;
	intdosx(&rin, &rout, &segRegs);
	if( rout.x.cflag & 1 )
		return rout.x.ax;
	else
		return 0;
}

int pascal
/* XTAG:creatls */
creatls(name, attr)
	unsigned char *name;
	int attr;
{
	rin.h.ah = 0x3C;	/* create file */
	rin.x.cx = attr;
	rin.x.dx = (int)name;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return -rout.x.ax;
	else
		return rout.x.ax;
}

int pascal
/* XTAG:openls */
openls(name, attr)
	unsigned char *name;
	int attr;
{
	rin.h.ah = 0x3D;	/* open file */
	rin.h.al = (char)attr;
	rin.x.dx = (int)name;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return -rout.x.ax;
	else
		return rout.x.ax;
}

int pascal
/* XTAG:closels */
closels(handle)
	int handle;
{
	rin.h.ah = 0x3E;
	rin.x.bx = handle;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return rout.x.ax;
	else
		return 0;
}

int pascal
/* XTAG:readls */
readls(handle, buffer, nBytes)
	int handle, nBytes;
	unsigned char *buffer;
{
	rin.h.ah = 0x3F;
	rin.x.bx = handle;
	rin.x.cx = nBytes;
	rin.x.dx = (int)buffer;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return -rout.x.ax;
	else
		return rout.x.ax;
}

int pascal
/* XTAG:readFar */
readFar(handle, buffer, nBytes)
	int handle, nBytes;
	unsigned char far *buffer;
{
	int saveDS, ret;

	rin.h.ah = 0x3F;
	rin.x.bx = handle;
	rin.x.cx = nBytes;
	rin.x.dx = FP_OFF(buffer);
	saveDS = segRegs.ds;
	segRegs.ds = FP_SEG(buffer);
	intdosx(&rin, &rout, &segRegs);
	if( rout.x.cflag & 0x1 )
		ret = -rout.x.ax;
	else
		ret = rout.x.ax;
	segRegs.ds = saveDS;
	return ret;
}

int pascal
/* XTAG:writels */
writels(handle, buffer, nBytes)
	int handle, nBytes;
	unsigned char *buffer;
{
	rin.h.ah = 0x40;
	rin.x.bx = handle;
	rin.x.cx = nBytes;
	rin.x.dx = (int)buffer;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return -rout.x.ax;
	else
		return rout.x.ax;
}

int pascal
/* XTAG:writeFar */
writeFar(handle, buffer, nBytes)
	int handle, nBytes;
	unsigned char far *buffer;
{
	register int ret;
	int saveDS;

	rin.h.ah = 0x40;
	rin.x.bx = handle;
	rin.x.cx = nBytes;
	rin.x.dx = (int)FP_OFF(buffer);
	saveDS = segRegs.ds;
	segRegs.ds = (int)FP_SEG(buffer);
	intdosx(&rin, &rout, &segRegs);
	if( rout.x.cflag & 0x1 )
		ret = -rout.x.ax;
	else
		ret = rout.x.ax;
	segRegs.ds = saveDS;
	return ret;
}

int pascal
/* XTAG:delete */
delete(name)
	unsigned char *name;
{
	rin.h.ah = 0x41;
	rin.x.dx = (int)name;
	intdos(&rin, &rout);
	if( rout.x.cflag & 0x1 )
		return rout.x.ax;
	else
		return 0;
}

void pascal
/* XTAG:setCPos */
setCPos(row, col)
	int row, col;
{
	rin.h.ah = 2;	/* set cursor position */
	rin.h.bh = 0;	/* page number */
	rin.h.dh = (char)row;
	rin.h.dl = (char)col;
	int86(0x10, &rin, &rout);
}
 
void pascal
/* XTAG:getCPos */
getCPos(row, col)
	int *row, *col;
{
	rin.h.ah = 3;	/* read cursor position */
	rin.h.bh = 0;	/* page number */
	int86(0x10, &rin, &rout);
	*row = (int)rout.h.dh;
	*col = (int)rout.h.dl;
}

void pascal
/* XTAG:setCType */
setCType(start, stop)
	int start, stop;
{
	rin.h.ah = 1;	/* set cursor start/stop lines */
	rin.h.ch = (char)start;
	rin.h.cl = (char)stop;
	int86(0x10, &rin, &rout);
}
