#include "pt.h"

int pascal
/* XTAG:isMouseEvent */
isMouseEvent(doSimMouse)
	int doSimMouse;
{
	extern int evhead, evtail;
	static int n = 0;

	if( doSimMouse )
		readSimMouse();
	return evhead != evtail;
}

int pascal
/* XTAG:getMouseEvent */
getMouseEvent()
{
	extern int evhead, evtail;
	extern int debug;
	extern struct event events[];
	extern unsigned char msgBuffer[];
	
	if( ++evhead >= NEVENTS )
		evhead = 0;
	return evhead;
}

void pascal
/* XTAG:up2Buttons */
up2Buttons(row, col)
	int *row, *col;
{
	extern union REGS rin, rout;
	extern struct event events[];
	extern int mousePresent;
	
	register int evhead;
	
	while( 1 ) {
		while( !isMouseEvent(1) ) {
			if( mousePresent ) {
				rin.x.ax = 3;
				int86(51, &rin, &rout);
				if( rout.x.bx == 0 ) {
					*row = rout.x.dx>>3;
					*col = rout.x.cx>>3;
					goto allUp;
				}
			}
		}
		evhead = getMouseEvent();
		if( events[evhead].buttons == 0 )
			break;
	}
	*row = events[evhead].vertical>>3;
	*col = events[evhead].horizontal>>3;
allUp:
	;
}

int pascal
/* XTAG:downButtons */
downButtons(row, col)
	int *row, *col;
{
	extern union REGS rin, rout;
	extern int evhead, evtail;
	extern struct event events[];
	extern unsigned char lastIgnored;
	
	lastIgnored = 0;
	while( 1 ) {
		if( lastIgnored == '\033' )	/* an ESCape? */
			return 1;
		if( !isMouseEvent(1) )
			continue;
		evhead = getMouseEvent();
		if( events[evhead].buttons != 0 )
			break;
	}
	*row = events[evhead].vertical>>3;
	*col = events[evhead].horizontal>>3;
	return 0;
}

void pascal
/* XTAG:readSimMouse */
readSimMouse()
{
	extern union REGS rin, rout;
	extern unsigned char lastIgnored;

	int fn;
	unsigned char key, scan;

	/* give user a chance to change things with a keystroke */
	if( isKeystroke() != 0 ) {
		key = getKeystroke(&scan);
		lastIgnored = key;
		fn = translateKey(key, scan);
		cursor(fn, 0);
	}
}

extern long getvect(int);
extern void evinit(void);

void pascal
/* XTAG:initMouse */
initMouse(row, column, videoReset)
	int row, column, videoReset;
{
	extern unsigned char msgBuffer[];
	extern union REGS rin, rout;
	extern int mousePresent;
	extern int mouseHorizontal, mouseVertical;
	extern int i43lines;
	extern int scrRows;
	extern unsigned char saveVideoMode;
	extern unsigned int dispMemory;
	extern int debug;
	extern int mouseSpeed;
	extern int evhead, evtail;
	extern struct event *evaddr, events[];

	int start, stop;

if( videoReset ) {
	/* we need to set the video mode before 43 lines mode */
	rin.h.ah = 0;
	switch( saveVideoMode ) {
#ifdef GENIUS66
		case 8:  rin.h.al = 8; break;
#endif
		case 7:  rin.h.al = 7; break;
		case 4:
		case 3:  rin.h.al = 3; break;
		default: rin.h.al = saveVideoMode; break;
	}
	int86(0x10, &rin, &rout);

	/* use the alt char set for 43 line mode */
	rin.h.ah = 0x11;		/* 43 line mode */
	if( i43lines ) {
		scrRows = 43;
		rin.h.al = 0x12;	/* 8x8 double-dot font */
	} else {
		scrRows = 25;
		rin.h.al = 0x11;	/* 8x14 monochrome font */
	}
	rin.h.bl = 0x0;	/* use block 0 */
	int86(0x10, &rin, &rout);
#ifdef GENIUS66
	/* special case of genius display */
	if( saveVideoMode == 8 )
		scrRows = 66;
#endif
}

	if( dispMemory == 0xB000 ) {	/* monochrome display */
		start = 4;
		stop = 9;
	} else {
		start = 2;
		stop = 5;
#ifdef GENIUS66
		/* this is just a guess as to what it should be */
		start = 3;
		stop = 13;
#endif
	}

	if( getvect(51) == 0L ) {
		mousePresent = 0;
		/* set the hardware cursor */
		setCType(start, stop);
	} else {
		/* reset the mouse */
		rin.x.ax = 0;
		int86(51, &rin, &rout);
		if( rout.x.ax != 0xFFFF ) {
			mousePresent = 0;
			setCType(start, stop);
		} else {
			mousePresent = 1;
			rin.x.ax = 10;
			rin.x.bx = 1;	/* use hardware cursor */
			rin.x.cx = start;
			rin.x.dx = stop;
			int86(51, &rin, &rout);
		}
	}

	if( mousePresent ) {

		/* call mouse driver to allow 200 or 350 lines */
		rin.x.ax = 8;	/* set min/max vertical position */
		rin.x.cx = 0;
		rin.x.dx = (i43lines ? 342 : 192);
			/* 350 - 8 (1 char position) */
			/* any value above 343 allows the cursor to go off */
			/* the bottom of the screen */
#ifdef GENIUS66
		/* special case of genius display */
		if( saveVideoMode == 8 )
			rin.x.dx = 975;
#endif
		int86(51, &rin, &rout);

		/* position mouse at row 5, col 10 */
		rin.x.ax = 4;
		rin.x.cx = 8*column;
		rin.x.dx = 8*row;
		int86(51, &rin, &rout);

		/*  set the mickey/pixel ratio */
		rin.x.ax = 15;
		/* horizontal: mouseSpeed mickeys/8 pixels */
		rin.x.cx = mouseSpeed;
		/* vertical: 2*mouseSpeed mickeys/8 pixels */
		rin.x.dx = 2 * mouseSpeed;
		int86(51, &rin, &rout);

		/* show the mouse cursor */
		rin.x.ax = 1;
		int86(51, &rin, &rout);
		
		/* initialize the mouse interrupt handler */
		evhead = evtail = 0;
		evaddr = &events[0];
		evinit();
	} else {
		setCPos(row, column);
		mouseHorizontal = 8*column;
		mouseVertical = 8*row;
	}
}

void pascal
/* XTAG:termMouse */
termMouse()
{
	extern union REGS rin, rout;
	extern int mousePresent;

	if( mousePresent ) {
		rin.x.ax = 0;
		int86(51, &rin, &rout);
	}
}
