/*
 * Definitions needed to convert the old TDE 4.0 "stroke" macros to the new
 * TDE 5.0 config-style macros.
 *
 * Program Name:  mac2cfg
 * Author:        Jason Hood
 * Date:          August 26, 1998
 */

#define MAX_KEYS           256  /* number of special keys recognized by TDE */
#define STROKE_LIMIT      1024  /* number of key strokes in playback buffer */

/*
 * structure for recording and playing back one keystroke.
 */
typedef struct {
  int key;      /* key assinged to this node, which may be text or function */
  int next;     /* pointer to next node in macro def */
} STROKES;


/*
 * structure for the macro buffer.
 */
typedef struct {
   char sig[8];                         /* signature, easy to find in .exe */
   int  first_stroke[MAX_KEYS];         /* pointer to first key in macro */
   STROKES strokes[STROKE_LIMIT];       /* buffer to hold key strokes */
} MACRO;


/*
 * names of the keys for the configuration file.
 */
char *keys[MAX_KEYS] = {
    "",
    "a+esc",            /*    1  */
    "esc",              /*    2  */
    "s+esc",            /*    3  */
    "c+esc",            /*    4  */
    "",
    "enter",            /*    6  */
    "s+enter",          /*    7  */
    "c+enter",          /*    8  */
    "backspace",        /*    9  */
    "s+backspace",      /*   10  */
    "c+backspace",      /*   11  */
    "tab",              /*   12  */
    "",
    "a+backspace",      /*   14  */
    "s+tab",            /*   15  */
    "a+q",              /*   16  */
    "a+w",              /*   17  */
    "a+e",              /*   18  */
    "a+r",              /*   19  */
    "a+t",              /*   20  */
    "a+y",              /*   21  */
    "a+u",              /*   22  */
    "a+i",              /*   23  */
    "a+o",              /*   24  */
    "a+p",              /*   25  */
    "a+[",              /*   26  */
    "a+]",              /*   27  */
    "a+enter",          /*   28  */
    "greyenter",        /*   29  */
    "a+a",              /*   30  */
    "a+s",              /*   31  */
    "a+d",              /*   32  */
    "a+f",              /*   33  */
    "a+g",              /*   34  */
    "a+h",              /*   35  */
    "a+j",              /*   36  */
    "a+k",              /*   37  */
    "a+l",              /*   38  */
    "a+;",              /*   39  */
    "a+\'",             /*   40  */
    "a+~",              /*   41  */
    "s+greyenter",      /*   42  */
    "c+greyenter",      /*   43  */
    "a+z",              /*   44  */
    "a+x",              /*   45  */
    "a+c",              /*   46  */
    "a+v",              /*   47  */
    "a+b",              /*   48  */
    "a+n",              /*   49  */
    "a+m",              /*   50  */
    "a+<",              /*   51  */
    "a+>",              /*   52  */
    "a+?",              /*   53  */
    "",
    "",
    "",
    "",
    "",
    "f1",               /*   59  */
    "f2",               /*   60  */
    "f3",               /*   61  */
    "f4",               /*   62  */
    "f5",               /*   63  */
    "f6",               /*   64  */
    "f7",               /*   65  */
    "f8",               /*   66  */
    "f9",               /*   67  */
    "f10",              /*   68  */
    "",
    "",
    "home",             /*   71  */
    "up",               /*   72  */
    "pgup",             /*   73  */
    "",
    "left",             /*   75  */
    "center",           /*   76  */
    "right",            /*   77  */
    "",
    "end",              /*   79  */
    "down",             /*   80  */
    "pgdn",             /*   81  */
    "ins",              /*   82  */
    "del",              /*   83  */
    "s+f1",             /*   84  */
    "s+f2",             /*   85  */
    "s+f3",             /*   86  */
    "s+f4",             /*   87  */
    "s+f5",             /*   88  */
    "s+f6",             /*   89  */
    "s+f7",             /*   90  */
    "s+f8",             /*   91  */
    "s+f9",             /*   92  */
    "s+f10",            /*   93  */
    "c+f1",             /*   94  */
    "c+f2",             /*   95  */
    "c+f3",             /*   96  */
    "c+f4",             /*   97  */
    "c+f5",             /*   98  */
    "c+f6",             /*   99  */
    "c+f7",             /*  100  */
    "c+f8",             /*  101  */
    "c+f9",             /*  102  */
    "c+f10",            /*  103  */
    "a+f1",             /*  104  */
    "a+f2",             /*  105  */
    "a+f3",             /*  106  */
    "a+f4",             /*  107  */
    "a+f5",             /*  108  */
    "a+f6",             /*  109  */
    "a+f7",             /*  110  */
    "a+f8",             /*  111  */
    "a+f9",             /*  112  */
    "a+f10",            /*  113  */
    "",
    "c+left",           /*  115  */
    "c+right",          /*  116  */
    "c+end",            /*  117  */
    "c+pgdn",           /*  118  */
    "c+home",           /*  119  */
    "a+1",              /*  120  */
    "a+2",              /*  121  */
    "a+3",              /*  122  */
    "a+4",              /*  123  */
    "a+5",              /*  124  */
    "a+6",              /*  125  */
    "a+7",              /*  126  */
    "a+8",              /*  127  */
    "a+9",              /*  128  */
    "a+0",              /*  129  */
    "a+-",              /*  130  */
    "a+=",              /*  131  */
    "c+pgup",           /*  132  */
    "f11",              /*  133  */
    "f12",              /*  134  */
    "s+f11",            /*  135  */
    "s+f12",            /*  136  */
    "c+f11",            /*  137  */
    "c+f12",            /*  138  */
    "a+f11",            /*  139  */
    "a+f12",            /*  140  */
    "c+up",             /*  141  */
    "c+grey-",          /*  142  */
    "c+center",         /*  143  */
    "c+grey+",          /*  144  */
    "c+down",           /*  145  */
    "c+ins",            /*  146  */
    "c+del",            /*  147  */
    "c+tab",            /*  148  */
    "c+grey/",          /*  149  */
    "c+grey*",          /*  150  */
    "a+greyhome",       /*  151  */
    "a+greyup",         /*  152  */
    "a+greypgup",       /*  153  */
    "",
    "a+greyleft",       /*  155  */
    "",
    "a+greyright",      /*  157  */
    "",
    "a+greyend",        /*  159  */
    "a+greydown",       /*  160  */
    "a+greypgdn",       /*  161  */
    "a+greyins",        /*  162  */
    "a+greydel",        /*  163  */
    "a+grey/",          /*  164  */
    "a+tab",            /*  165  */
    "a+greyenter",      /*  166  */
    "grey-",            /*  167  */
    "grey+",            /*  168  */
    "",
    "s+c+left",         /*  170  */
    "s+c+right",        /*  171  */
    "",
    "",
    "c+@",              /*  174  */
    "c+a",              /*  175  */
    "c+b",              /*  176  */
    "c+c",              /*  177  */
    "c+d",              /*  178  */
    "c+e",              /*  179  */
    "c+f",              /*  180  */
    "c+g",              /*  181  */
    "c+h",              /*  182  */
    "c+i",              /*  183  */
    "c+j",              /*  184  */
    "c+k",              /*  185  */
    "c+l",              /*  186  */
    "c+m",              /*  187  */
    "c+n",              /*  188  */
    "c+o",              /*  189  */
    "c+p",              /*  190  */
    "c+q",              /*  191  */
    "c+r",              /*  192  */
    "c+s",              /*  193  */
    "c+t",              /*  194  */
    "c+u",              /*  195  */
    "c+v",              /*  196  */
    "c+w",              /*  197  */
    "c+x",              /*  198  */
    "c+y",              /*  199  */
    "c+z",              /*  200  */
    "c+[",              /*  201  */
    "c+\\",             /*  202  */
    "c+]",              /*  203  */
    "c+^",              /*  204  */
    "c+_",              /*  205  */
    "s+a+1",            /*  206  */
    "s+a+2",            /*  207  */
    "s+a+3",            /*  208  */
    "s+a+4",            /*  209  */
    "s+a+5",            /*  210  */
    "s+a+6",            /*  211  */
    "s+a+7",            /*  212  */
    "s+a+8",            /*  213  */
    "s+a+9",            /*  214  */
    "s+a+0",            /*  215  */
    "s+a+-",            /*  216  */
    "s+a+=",            /*  217  */
    "s+a+q",            /*  218  */
    "s+a+w",            /*  219  */
    "s+a+e",            /*  220  */
    "s+a+r",            /*  221  */
    "s+a+t",            /*  222  */
    "s+a+y",            /*  223  */
    "s+a+u",            /*  224  */
    "s+a+i",            /*  225  */
    "s+a+o",            /*  226  */
    "s+a+p",            /*  227  */
    "s+a+[",            /*  228  */
    "s+a+]",            /*  229  */
    "",
    "",
    "s+a+a",            /*  232  */
    "s+a+s",            /*  233  */
    "s+a+d",            /*  234  */
    "s+a+f",            /*  235  */
    "s+a+g",            /*  236  */
    "s+a+h",            /*  237  */
    "s+a+j",            /*  238  */
    "s+a+k",            /*  239  */
    "s+a+l",            /*  240  */
    "s+a+;",            /*  241  */
    "s+a+\'",           /*  242  */
    "s+a+~",            /*  243  */
    "s+a+z",            /*  246  */
    "s+a+x",            /*  247  */
    "s+a+c",            /*  248  */
    "s+a+v",            /*  249  */
    "s+a+b",            /*  250  */
    "s+a+n",            /*  251  */
    "s+a+m",            /*  252  */
    "s+a+<",            /*  253  */
    "s+a+>",            /*  254  */
};
