/*
 * This script converts the output from manext to HTML
 *
 * Arguments:
 *           section: one of OVERVIEW,COMMANDS,APPENDIX,GLOSSARY
 *           infile:  file name of .man file
 *           tocfile: file name of Table of Contents output file
 */
trace o
Parse Arg section infile tocfile .
Select
  When section = 'TOCSTART'  Then Call toc 'START'
  When section = 'TOCEND'    Then Call toc 'END'
  When section = 'OVERVIEW'  Then Call overview  infile tocfile 'Overview'
  When section = 'COMM'      Then Call commands  infile tocfile 'Commands'
  When section = 'COMMSET'   Then Call commands  infile tocfile 'SET Commands'
  When section = 'COMMSOS'   Then Call commands  infile tocfile 'SOS Commands'
  When section = 'QUERY'     Then Call query     infile tocfile 'Query and Extract'
  When section = 'GLOSSARY'  Then Call glossary  infile tocfile 'Glossary'
  When section = 'APPENDIX1' Then Call appendix1 infile tocfile 'Appendix 1'
  When section = 'APPENDIX2' Then Call appendix2 infile tocfile 'Appendix 2'
  When section = 'APPENDIX3' Then Call appendix3 infile tocfile 'Appendix 3'
  Otherwise
      Do
        Say 'Error: Invalid section:' section 'specified'
      End
End
Return

/********************************************************************/
overview: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
in_code_section = 'N'
already_read = 'N'
in_list_section = 'N'
first_heading = 'N'
Call heading title
Do While(Lines(infile)>0)
   If already_read = 'N' Then line = Linein(infile)
   already_read = 'N'
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(line,"")'</DT>'
            Say '<HR>'
            Say '<A NAME="'line'"></A>'
            Say '<H2>' line '</H2>'
            line = Linein(infile)
            Say '<HR>'
            first_heading = 'Y'
          End
     When Strip(line) = Copies('-',74) Then Iterate
     When Substr(Strip(line),1,2) = '- ' Then
          Do
            tmp = ''
            If in_list_section = 'Y' Then
              Do
                tmp = Substr(Strip(line),3)
                Do Forever
                   line = Linein(infile)
                   Select
                     When Strip(line) = '' Then 
                          Do
                            Say '<LI>' handle_keywords(tmp,'') '</LI>'
                            Say '</UL>'
                            in_list_section = 'N'
                          End
                     When Substr(Strip(line),1,2) = '- ' Then
                          Do
                            Say '<LI>' handle_keywords(tmp,'') '</LI>'
                            already_read = 'Y'
                          End
                     Otherwise
                          Do
                            tmp = tmp line
                          End
                   End
                   If in_list_section = 'N' | already_read = 'Y' Then Leave
                End
              End
            Else
              Do
                Say '<UL>'
                in_list_section = 'Y'
                already_read = 'Y'
              End
          End
     When Strip(line) = '+'||Copies('-',30) Then
          Do
            If in_code_section = 'Y' Then
               Do
                 Say '<IMG SRC=divbot.gif ALT="----------"><BR>'
                 Say '</BLOCKQUOTE><P>'
                 in_code_section = 'N'
               End
            Else
               Do
                 Say '<BLOCKQUOTE>'
                 Say '<IMG SRC=divtop.gif ALT="----------"><BR>'
                 in_code_section = 'Y'
               End
          End
      Otherwise
          Do
            If first_heading = 'N' Then Iterate
            If in_code_section = 'Y' Then
               Do
                 Say Strip(line) '<BR>'
               End
            Else
               Do
                 tmp = ''
                 If Strip(line) = '' Then Iterate
                 Do Forever
                    tmp = tmp line
                    line = Linein(infile)
                    If Strip(line) = '' Then
                      Do
                        tmp = handle_keywords(tmp,"")
                        Say tmp '<P>'
                        Leave
                      End
                 End
               End
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Say '<P Align="Center"><HR>'
Say 'The HTML version of this manual was inspired by <A HREF = "mailto:judygs@uic.edu">Judith Grobe Sachs </A>'
Say '<P Align="Center"><HR>'
Call footing
Return

/********************************************************************/
commands: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
already_read_line = 'N'
once = 'Y'
Call heading title
Do While(Lines(infile)>0)
   If already_read_line = 'N' Then line = Linein(infile)
   already_read_line = 'N'
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(line,"")'</DT>'
            Say '<P><HR><A NAME="'line'"></A>'
            Say '<H2>' line '</H2>'
            line = Linein(infile)
          End
     When Strip(line) = Copies('-',74) Then
          Say '<HR>'
     When line = '     COMMAND' Then
          Do
            line = Linein(infile)
            Parse var line keyword '-' desc
            keyword = Strip(keyword)
            keyword_words = Words(keyword)
            Say '<A NAME="'Translate(keyword)'"></A>'
            Say '<DL><DT>'
            Say Bold(Translate(keyword)) '-' desc '<BR><BR></DT>'
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DD>'MakeTOC(keyword,desc)'</DD>'
          End
     When line = '     SEE ALSO' Then
          Do
            Say '<DT>' Bold('See Also:') '<BR></DT>'
            line = Linein(infile)
            tmp = ''
            Do Forever
               Parse Var line '<' keyword '>' line
               If keyword = '' Then Leave
               tmp = tmp MakeRef('UPPER',',',keyword)
               If line = '' Then Leave
            End
            tmp = Strip(tmp,'T',',')
            Say '<DD>' tmp '<P></DD>'
          End
     When line = '     STATUS' Then 
          Do
            Say '<DT>' Bold('Status:') '<BR></DT>'
            Do Forever
               line = Linein(infile)
               If line = '' Then Leave
               Say '<DD>' Strip(line) '</DD>'
            End
            Say '</DL><P>'
          End
     When line = '     SYNTAX' Then
          Do
            Say '<DT>' Bold('Syntax:') '<BR></DT>'
            syntax_words = ''
            Do Forever
               line = Linein(infile)
               If line = '' Then Leave
               pre = Subword(line,1,keyword_words)
               post = Subword(line,keyword_words+1)
               Say '<DD>' Strip(pre) Italic(strip(post)) '<P></DD>'
               syntax_words = syntax_words Translate(post,"     ","/|[].")
            End
          End
     When line = '     COMPATIBILITY' Then
          Do
            Say '<DT>' Bold('Compatibility:') '<BR></DT>'
            first = 'Y'
            Do Forever
               line = Linein(infile)
               If line = '' Then Leave
               If first = 'Y' Then
                 Do
                   Say '<DD>' handle_keywords(Strip(line),'')
                   first = 'N'
                 End
               Else
                   Say '</DD><DD>' handle_keywords(Strip(line),'')
            End
            Say '<P></DD>'
          End
     When line = '     DEFAULT' Then
          Do
            Say '<DT>' Bold('Default:') '<BR></DT>'
            Do Forever
               line = Linein(infile)
               If line = '' Then Leave
               Parse Var line pre '<' keyword '>' post
               If keyword \= '' Then line = pre MakeRef('UPPER',,keyword) post
               Say '<DD>' Strip(line) '<P></DD>'
            End
          End
     When line = '     DESCRIPTION' Then
          Do
            Say '<DT>' Bold('Description:') '<BR></DT>'
            tmp = ''
            Do Forever
               line = Linein(infile)
               If Strip(line) = '' Then
                 Do
                   tmp = handle_keywords(tmp,syntax_words)
                   Say '<DD>' Strip(tmp) '<P></DD>'
                   If Substr(tmp,Length(tmp),1) = ':' Then 
                      Do
                        first = 'Y'
                        Do Forever
                           line = Strip(Linein(infile))
                           If line = '' Then Leave
                           If first = 'Y' Then
                             Do
                              Say '<DD>' handle_keywords(line,syntax_keywords)
                              first = 'N'
                             End
                           Else
                              Say '</DD><DD>' handle_keywords(line,syntax_keywords)
                        End
                        Say '<P></DD>'
                      End
                   tmp = ''
                   Iterate
                 End
               If line = '     COMPATIBILITY' Then 
                 Do
                   already_read_line = 'Y'
                   Leave
                 End
               If Pos('<>',line) \= 0 Then
                 Do
                   Parse Var line pre '<>' post
                   line = pre||'&lt;&gt;'||post
                 End
               tmp = tmp line
            End
          End
     Otherwise Nop
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
glossary: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
already_read_line = 'N'
first_time = 'Y'
Call heading title
Do While(Lines(infile)>0)
   If already_read_line = 'N' Then line = Linein(infile)
   already_read_line = 'N'
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(line,"")'</DT>'
            Say '<HR><A NAME="'line'"></A>'
            Say '<H2>' line '</H2>'
            Say '<HR><P>'
            Say '<DL>'
            line = Linein(infile)
          End
     When Strip(line) = '' Then Nop
     When Strip(line) = Copies('-',74) Then Say '</DL><HR>'
     When Substr(line,1,15) = Copies(' ',15) Then
          Do
            tmp = Strip(line)
            Do Forever
               line = Strip(Linein(infile))
               If line = '' Then Leave
               tmp = tmp line
            End
            tmp = handle_keywords(tmp,'')
            Say '<DD>' Strip(tmp) '<P></DD>'
          End
     Otherwise
          Do
            line = Strip(line)
            Say '<DT><A NAME="'Translate(line)'">' Bold(line) '</A></DT>'
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DD>'MakeTOC(line,"")'</DD>'
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
query: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
already_read_line = 'N'
once = 'Y'
in_table = 'N'
first_time = 'Y'
Call heading title
Do While(Lines(infile)>0)
   If already_read_line = 'N' Then line = Linein(infile)
   already_read_line = 'N'
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(line,"")'</DT>'
            If first_time = 'N' Then Say '</DL>'
            first_time = 'N'
            Say '<A NAME="'Translate(line)'"></A>'
            Say '<HR><H2>' line '</H2>'
            Say '<HR><DL>'
            line = Linein(infile)
          End
     When Strip(line) = '' & in_table = 'Y' Then
          Do
            in_table = 'N'
            Say '</TABLE><P></DD>'
          End
     When Strip(line) = '' Then Nop
     When Strip(line) = Copies('-',74) Then
          Do
            Say '</DL>'
            Say '<HR>'
          End
     When Substr(line,26,3) = ' - ' Then
          Do
            If in_table = 'N' Then
              Do
                Say '<DD><TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>'
                in_table = 'Y'
              End
            Parse Var line col1 '-' col2
            Say '<TR><TD>'||Strip(col1)||'</TD><TD>-</TD><TD>'||handle_keywords(Strip(col2),'')||'</TD></TR>'
          End
     When Substr(line,1,15) = Copies(' ',15) Then
          Do
            Say '<DD>' Strip(line) '</DD>'
          End
     When Substr(line,1,14) = Copies(' ',14) Then
          Do
            Say '<DD>'
            Say '<IMG SRC=divtop.gif ALT="----------"><BR>'
            Say Strip(line) '<BR>'
            Do Forever
              line = Linein(infile)
              If Strip(line) = '' Then Leave
              Say Strip(line) '<BR>'
            End
            Say '<IMG SRC=divbot.gif ALT="----------"><BR>'
            Say '<P></DD>'
          End
     When Substr(line,1,10) = Copies(' ',10) Then
          Do
            tmp = line
            Do Forever
               line = Strip(Linein(infile))
               Select
                 When Substr(line,1,1) = '(' Then
                      Do
                        tmp = handle_keywords(tmp,'')
                        Say '<DD>' Strip(tmp) '</DD>'
                        Say '<DD>' line '<P></DD>'
                        Leave
                      End
                 When line = '' Then 
                      Do
                        tmp = handle_keywords(tmp,'')
                        Say '<DD>' Strip(tmp) '<P></DD>'
                        Leave
                      End
                 Otherwise
                      Do
                        tmp = tmp line
                      End
               End
            End
          End
     Otherwise
          Do
            pre = Subword(line,1,1)
            post = Subword(line,2)
            Say '<DT>'
            If post = '' Then Say Bold(Strip(pre)) '<BR>'
            Else Say Bold(Strip(pre)) Italic(strip(post)) '<BR>'
            Say '</DT>'
            syntax_words = Translate(post,"     ","/|[].")
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
appendix1: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
in_env = 'N'
Call heading title
Do While(Lines(infile)>0)
   line = Linein(infile)
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            Parse Var line head '-' tail
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(Strip(head),tail)'</DT>'
            Say '<A NAME="'Strip(head)'"></A>'
            Say '<H2>' line '</H2>'
            Say '<HR>'
            line = Linein(infile)
          End
     When Strip(line) = Copies('-',74) Then Say '<HR>'
     When Substr(line,1,10) = '      THE_' Then
          Do
            Parse Var line env '-' rem
            If in_env = 'N' Then Say '<DL>'
            in_env = 'Y'
            rem = handle_keywords(rem,'')
            Say '<DT><B>'env'</B></DT>'
            Say '<DD>' rem '<P></DD>'
          End
     When Strip(line) = '' & in_env = 'Y' Then 
          Do
            Say '</DL>'
            in_env = 'N'
          End
     When Strip(line) = '' Then Nop
     Otherwise
          Do
            tmp = Strip(line)
            Do Forever
               line = Strip(linein(infile))
               If line = '' Then Leave
               tmp = tmp line
            End
          tmp = handle_keywords(tmp,'')
          Say tmp '<P>'
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
appendix2: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
in_table = 'N'
Call heading title
Do While(Lines(infile)>0)
   line = Linein(infile)
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            Parse Var line head '-' tail
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(Strip(head),tail)'</DT>'
            Say '<A NAME="'Strip(head)'"></A>'
            Say '<H2>' line '</H2>'
            Say '<HR>'
            line = Linein(infile)
          End
     When Strip(line) = Copies('-',74) Then Say '<HR>'
     When Substr(Strip(line),1,1) = '-' Then
          Do
            line = Linein(infile)
            Say '<B>' Strip(line) '</B><P>'
            line = Linein(infile)
          End
     When Substr(Strip(line),1,5) = '+----' & Length(Strip(line)) = 31 Then
          Do
            Say '<BLOCKQUOTE>'
            Say '<IMG SRC=divtop.gif ALT="----------"><BR>'
            Do Forever
              line = Strip(Linein(infile))
              If Substr(line,1,5) = '+----' Then Leave
              If Pos('<',line) \= 0 Then
                Do
                  Parse Var line pre '<Key>' rem
                  Say '&lt;Key&gt;'||rem '<BR>'
                End
              Else
                Say line '<BR>'
            End
            Say '<IMG SRC=divbot.gif ALT="----------"><BR>'
            Say '</BLOCKQUOTE><P>'
          End
     When Substr(Strip(line),1,5) = '+----' Then
          Do
            columns = Words(Translate(line,' ','-')) - 1
            If columns = 1 Then 
              Do
                align1 = '<CENTER>'
                align2 = '</CENTER>'
              End
            Else 
              Do
                align1 = ''
                align2 = ''
              End
            Say '<CENTER><TABLE BORDER=1 CELLSPACING=1 CELLPADDING=2>'
            line = Strip(Linein(infile))
            line = Strip(Strip(line,,'|'))
            tmp = '<TR>'
            Do i = 1 To columns
               Parse Var line col '|' line
               If col = '' Then col = '<BR>'
               tmp = tmp'<TH>'Strip(col)'</TH>'
            End
            Say tmp'</TR>'
            line = Linein(infile) /* remove heading underline */
            col. = ''
            trace o
            Do Forever
               line = Strip(Linein(infile))
               If line = '' | Translate(line,'  ','+-') = '' Then Leave
               line = Strip(Strip(line,,'|'))
               If columns = 1 & line = '|' Then col.1 = col.1||'|'||'<BR>'
               Else
                 Do i = 1 To columns
                   Parse Var line col '|' line
                   col.i = col.i||Strip(col)||'<BR>'
                 End
            End
            tmp = '<TR>'
            Do i = 1 To columns
               tmp = tmp'<TD>'||align1||col.i||align2||'</TD>'
            End
            Say tmp'</TR></TABLE></CENTER><P>'
            trace o
          End
     When Strip(line) = '' Then Nop
     When Substr(line,1,7) = Copies(' ',7) Then 
          Do
            Say '<DD>'Strip(line)'</DD>'
          End
     Otherwise
          Do
            tmp = Strip(line)
            Do Forever
               line = Strip(linein(infile))
               If line = '' Then Leave
               tmp = tmp line
            End
          tmp = handle_keywords(tmp,'')
          Say tmp '<P>'
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
appendix3: Procedure
Parse arg infile tocfile title
toc. = ''
toc_idx = 0
in_table = 'N'
Call heading title
Do While(Lines(infile)>0)
   line = Linein(infile)
   Select
     When Strip(line) = Copies('=',72) Then
          Do
            line = Strip(Linein(infile))
            Parse Var line head '-' tail
            toc_idx = toc_idx + 1
            toc.toc_idx = '<DT>'MakeTOC(Strip(head),tail)'</DT>'
            Say '<A NAME="'Strip(head)'"></A>'
            Say '<H2>' line '</H2>'
            Say '<HR>'
            line = Linein(infile)
          End
     When Strip(line) = Copies('-',74) Then Say '<HR>'
     When Substr(line,1,7) = '     --' Then
          Do
            line = Strip(Linein(infile))
            Say '<B>'line'</B><P>'
            line = Linein(infile)
          End
     When Strip(line) = '' & in_table = 'Y' Then
          Do
            in_table = 'N'
            Say '</TABLE></CENTER><P>'
          End
     When Strip(line) = Copies('-',74) Then
          Do
            Say '<HR>'
          End
     When Substr(line,1,7) = '     - ' Then
          Do
            If in_table = 'N' Then
              Do
                Say '<CENTER><TABLE BORDER=1 CELLSPACING=1 CELLPADDING=1>'
                in_table = 'Y'
              End
            Parse Var line '-' col1 col2 col3 col4 33 rem
            If col4 = '' Then col4 = '<BR>'
            rem = handle_keywords(rem,'')
            Say '<TR><TD>'Strip(col1)'</TD><TD>'Strip(col2)'</TD><TD>'Strip(col3)'</TD><TD>'Strip(col4)'</TD><TD>'Strip(rem)'</TD></TR>'
          End
     When Strip(line) = '' Then Nop
     Otherwise
          Do
            tmp = Strip(line)
            Do Forever
               line = Strip(linein(infile))
               If line = '' Then Leave
               tmp = tmp line
            End
          tmp = handle_keywords(tmp,'')
          Say tmp '<P>'
          End
   End
End
Do i = 1 To toc_idx
   Call Lineout tocfile, toc.i
End
Call footing
Return

/********************************************************************/
toc: Procedure
Parse arg action
If action = 'START' Then 
  Do
    Call heading 'Table of Contents'
    Say '<HR><CENTER><H1>The Hessling Editor</H1> </CENTER>'
    Say '<HR><CENTER><H1>Version 2.2</H1> </CENTER><P>'
    Say '<A NAME="TOC"></A>'
    Say '<HR><CENTER><H2>TABLE OF CONTENTS</H2> </CENTER><HR><DL>'
  End
Else
  Do
    Say '</DL><HR>'
    Call footing 'TOC'
  End
Return

/********************************************************************/
Bold: Procedure
Parse Arg line
Return '<B>'line'</B>'

/********************************************************************/
Italic: Procedure
Parse Arg line
Return '<I>'line'</I>'

/********************************************************************/
MakeTOC: Procedure Expose infile
Parse Arg keyword,desc
Parse Var infile base '.' .
name = Translate(keyword)
Return '<A HREF = "'base'.htm#'name'">' keyword '</A>' desc '<BR>'

/********************************************************************/
MakeRef: Procedure
Parse Arg trans,extra,keyword
Select
  When Words(keyword) > 1 & Translate(Word(keyword,1)) = 'SET' Then filename = 'commset.htm'
  When Words(keyword) > 1 & Translate(Word(keyword,1)) = 'SOS' Then filename = 'commsos.htm'
  When keyword \= Translate(keyword) Then filename = 'glossary.htm'
  Otherwise 
       Do
         if keyword = 'REXX' Then filename = 'glossary.htm'
         else filename = 'comm.htm'
       End
End
If trans = 'UPPER' Then name = Strip(Translate(keyword),,"'")
Else name = Strip(keyword,,"'")
Return '<A HREF = "'filename'#'name'">'||keyword||'</A>'extra

/********************************************************************/
heading: Procedure
Parse Arg title
Say '<!DOCTYPE HTML PUBLIC "-//WebTechs//DTD Mozilla HTML 2.0//EN">'
Say '<HTML>'
Say '<HEAD><TITLE>THE Reference -' title '</TITLE></HEAD>'
Say '<BODY BGCOLOR="#F1EDD1" LINK = "#0000FF" VLINK = "#FF0022" ALINK = "#808000">'
Say '<CENTER> <img WIDTH="64" HEIGHT="64" HSPACE="20" SRC="the64.gif" ALT="THE"> </CENTER>'
Return

/********************************************************************/
footing: Procedure
Parse Arg src .
Say '<ADDRESS>'
Say 'The Hessling Editor is Copyright &copy; <A HREF = "http://www.gu.edu.au/gwis/the/markh.htm">Mark Hessling</A>, 1990-1996'
Say '&lt;<A HREF = "mailto:M.Hessling@qut.edu.au">M.Hessling@qut.edu.au</A>&gt;'
Say '<BR>Generated on:' Date()
Say '</ADDRESS><HR>'
If src \= 'TOC' Then Say 'Return to <A HREF = "index.htm#TOC"> Table of Contents </A><BR>'
Say '</BODY> </HTML>'
Return

/********************************************************************/
handle_keywords: Procedure
Parse Arg line,syntax_words
tmp = ''
trace o
Do Forever    /* handle links */
   Parse Var line pre '<' keyword '>' line
   Select
     When keyword = '' Then tmp = tmp pre
     Otherwise tmp = tmp Strip(pre) MakeRef('UPPER',,keyword)
   End
   If line = '' Then Leave
End
line = tmp
tmp = ''
Do Forever              /* handle arguments */
   Parse Var line pre "'" keyword "'" line
   Select
     When keyword = '' Then tmp = tmp pre
     Otherwise 
       Do
         If Words(syntax_words) \= 0 & Wordpos(keyword,syntax_words) = 0 Then
            tmp = tmp pre "'"keyword"'"
         Else
            Do
              If pre = '' Then
                 tmp = tmp pre Italic(keyword)
              Else
                 Do
                   strip_pre = Strip(pre)
                   If Substr(strip_pre,Length(strip_pre)) = "#" Then
                      tmp = tmp pre || keyword
                   Else
                      tmp = tmp pre Italic(keyword)
                 End
            End
       End
   End
   If line = '' Then Leave
End
trace o
Return tmp
