Program OberonError;

(* Error filter for Oberon-M compiler *)
(* This is an ALPHA version of the error filter.  I wrote this as an    *)
(* experiment.  Refinements and enhancements are most likely necessary! *)
(* This filter should probably be written in Oberon, but I've only      *)
(* played with the compiler for a couple of hours.                      *)
(*                                                                      *)
(* I would appreciate receiving a copy of this script that has been     *)
(* rewritten in Oberon.                                                 *)

(* The command line for this program as entered with                    *)
(* UINST should be: %1 %2                                               *)

Var
  Source  : Text;
  Line    : String;
  Work    : String;
  ErrLine : String;
  Row,Col : String;
  Index   : Integer;

Begin
  Assign(Source,ParamStr(1));
  Reset(Source);
  While Not Eof(Source) Do
  Begin
    ReadLn(Source,Line);

(* This filter only catches syntax errors, other errors will slip so *)
(* by be sure to make the necessary changes before relying on it!    *)

    If Pos('Syntax error',Line) = 1 Then
    Begin
      Index := 1;
      While Not (Line[Index] In['0'..'9']) Do Inc(Index);
      While Line[Index] In['0'..'9'] Do Inc(Index);
      ErrLine := Copy(Line,1,Pred(Index)) + ': ';
      Delete(Line,1,Index);  { start to end of line number }
      Delete(Line,1,12);     { additional garbage          }
      Index := Pos(' ',Line);
      Row := Copy(Line,1,Pred(Index));
      Delete(Line,1,Length(Row)+1);
      Index := Pos(' ',Line);
      Delete(Line,1,Index);
      Col := Line;
      ReadLn(Source,Line);

 (* The Oberon compiler doesn't include the source file name in the    *)
 (* error messages, so we pass it as the second command line parameter *)
 (* from UNITY.                                                        *)

      WriteLn(ParamStr(2),', ', Row,', ',Col,', ',ErrLine+Line);
    End;
  End;
  Close(Source);
End.
