unit header;
{
Written for JugglePro on March 16, 1993
The following data is global.
}

Interface

uses graph;

type
  mainopt =            {define a main menu type}
    record
      title:string;
      x,y:byte;        {screen position}
      nopt:byte;       {number of options in menu}
      options:array [1..11] of string[20];
      optlist:string[15];    {shortcuts to options}
    end;
  pattern = array[1..800] of integer;

var
  ipt,pt: palettetype;     {interface and viewer palettes}
  savedexitproc: pointer;  {needed in case of error for customexit}
  mainopts: array [1..7] of mainopt;  {7 main menus}
  maxheight,height,cx,cy,maximumx,maximumy,xorigin,yorigin,zorigin:integer;
  h,l,m,pw0,pwf,w,oldw,opt,oldopt,startup,endup,txt1,colr1,colr2,colr3:byte;
  ch: char;
  moveflag,endflg,select,asyncflag,holdflag,memoryflg: boolean;
  rh,rt:pattern;
  ohpx,ohpy,ohpz:array [1..3,1..20] of integer;
  hpx,hpy,hpz:array [1..3,1..400] of integer;
  dwell:array [1..20] of real;
  permrule:array [1..20] of byte;
  gx,gy,gz,da,cda,sda,lens,xscale,yscale,zscale:real;
  n,smoothe,ti,nt:integer;
  mask:array [1..8] of array [1..260] of byte;
  ball:array [0..15,1..8] of array [1..260] of byte;
  seql,scroll,hact,hedit:byte;
  vi,vj:array [1..255] of byte;
  hilite:array [1..40,1..100] of boolean;
  path,switches,genfile:string;
  gn,gl,gmaxt,graphmode,graphdriver,aswitch,firstthrow:integer;
  buffer:array [1..25] of string;
  demo:array [1..1024] of char;
  demolen,demoptr,dly:integer;
  demoflag,makedemo:boolean;
  errmsg:string;

Implementation

begin
  graphdriver:=detect;    {initialize hi-res graphics mode}
  initgraph(graphdriver,graphmode,'graph');
  getpalette(pt);         {get default palette}
  ipt:=pt;
  maximumx:=getmaxx;      {find maximum coordinates}
  maximumy:=getmaxy;
  cx:=getmaxx div 2;      {center of screen}
  cy:=getmaxy div 2;
  maxheight:=getmaxy-25;  {maximum height allowable in viewer}
  height:=maxheight;      {user-changeable height set to maxheight}
  xscale:=getmaxx/639;    {scaling values for hand file transformations}
  yscale:=maxheight/399;
  zscale:=(maxheight+6)/399;
  xorigin:=cx;            {cartesian origin of JugglePro 3-d viewscreen}
  zorigin:=0;             {x=horizontal, z=up, y=into screen}
  yorigin:=cy;
  da:=pi/20;
  cda:=cos(da);
  sda:=sin(da);
  lens:=2*cy;
  if getmaxcolor>1 then   {set up colors for interface}
    begin
      txt1:=yellow;        {default palette colors}
      colr1:=blue;
      colr2:=magenta;
      colr3:=cyan;
    end
  else
    begin
      txt1:=3;
      colr1:=0;
      colr2:=1;
      colr3:=2;
    end;
  errmsg:='';
  memoryflg:=false;
end.